/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.OntAnnotationImpl;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.model.OntAnnotation;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.Models;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.rdf.model.impl.PropertyImpl;
import org.apache.jena.rdf.model.impl.StatementImpl;
import org.apache.jena.util.iterator.ExtendedIterator;

public class OntStatementImpl
extends StatementImpl
implements OntStatement {
    public OntStatementImpl(Statement statement) throws ClassCastException, NullPointerException {
        this(statement.getSubject(), statement.getPredicate(), statement.getObject(), (OntModel)statement.getModel());
    }

    public OntStatementImpl(Resource subject, Property predicate, RDFNode object, OntModel model) {
        super(subject, predicate, object, (ModelCom)model);
    }

    public static OntStatementImpl createOntStatementImpl(Triple t, OntGraphModelImpl m) {
        return OntStatementImpl.createOntStatementImpl((Resource)OntStatementImpl.createSubject(t.getSubject(), (EnhGraph)m), t.getPredicate(), t.getObject(), m);
    }

    public static OntStatementImpl createOntStatementImpl(Resource s, Node p, Node o, OntGraphModelImpl m) {
        return OntStatementImpl.createOntStatementImpl(s, OntStatementImpl.createProperty(p, (EnhGraph)m), o, m);
    }

    public static OntStatementImpl createOntStatementImpl(Resource s, Property p, Node o, OntGraphModelImpl m) {
        return OntStatementImpl.createOntStatementImpl(s, p, OntStatementImpl.createObject(o, (EnhGraph)m), m);
    }

    public static OntStatementImpl createOntStatementImpl(Resource s, Property p, RDFNode o, OntGraphModelImpl m) {
        return new OntStatementImpl(s, p, o, m);
    }

    static OntObject createSubject(Node n, EnhGraph g) {
        return OntObjectImpl.wrapAsOntObject(n, g);
    }

    static Property createProperty(Node n, EnhGraph g) {
        return new PropertyImpl(n, g);
    }

    public static RDFNode createObject(Node n, EnhGraph g) {
        return n.isLiteral() ? new LiteralImpl(n, g) : OntObjectImpl.wrapAsOntObject(n, g);
    }

    public static OntStatementImpl createNotAnnotatedOntStatementImpl(Resource s, Property p, RDFNode o, final OntGraphModelImpl m) {
        return new OntStatementImpl(s, p, o, m){

            @Override
            public OntStatement addAnnotation(OntAnnotationProperty property, RDFNode value) {
                throw new OntJenaException.Unsupported("Sub-annotations are not supported (attempt to annotate " + Models.toString(this) + " with predicate " + m.shortForm(property.getURI()) + " and value " + value + ")");
            }
        };
    }

    public static ExtendedIterator<Resource> listAnnotationResources(OntGraphModelImpl m, OntStatementImpl s) {
        return m.listAnnotations(s.getAnnotationResourceType(), s.subject, s.predicate, s.object);
    }

    protected static Resource getAnnotationRootType(Resource s) {
        Model m = s.getModel();
        if (s.isAnon() && OntAnnotationImpl.ROOT_TYPES.stream().anyMatch(t -> m.contains(s, RDF.type, (RDFNode)t))) {
            return OWL.Annotation;
        }
        return OWL.Axiom;
    }

    protected int getCharacteristics() {
        return OntGraphModelImpl.getSpliteratorCharacteristics((Graph)this.getModel().getGraph());
    }

    @Override
    public OntGraphModelImpl getModel() {
        return (OntGraphModelImpl)super.getModel();
    }

    public boolean isRootStatement() {
        return false;
    }

    public OntStatement asRootStatement() {
        return this.isRootStatement() ? this : new OntStatementImpl(this.getSubject(), this.getPredicate(), this.getObject(), this.getModel()){

            @Override
            public boolean isRootStatement() {
                return true;
            }
        };
    }

    @Override
    public boolean isLocal() {
        return this.getModel().independent() || this.getModel().isLocal(this);
    }

    public boolean isAnnotationRootStatement() {
        return this.subject.isAnon() && RDF.type.equals(this.predicate) && (OWL.Axiom.equals((Object)this.object) || OWL.Annotation.equals((Object)this.object));
    }

    @Override
    public OntObject getSubject() {
        return this.subject instanceof OntObject ? (OntObject)this.subject : (OntObject)this.subject.as(OntObject.class);
    }

    public Node getSubjectNode() {
        return this.subject.asNode();
    }

    public <N extends Resource> N getSubject(Class<N> type) {
        return (N)((Resource)this.subject.as(type));
    }

    @Override
    public boolean belongsToAnnotation() {
        return this.subject.canAs(OntAnnotation.class);
    }

    @Override
    public OntStatement addAnnotation(OntAnnotationProperty property, RDFNode value) {
        OntJenaException.notNull(property, "Null property.");
        OntJenaException.notNull(value, "Null value.");
        if (this.isRootStatement()) {
            OntStatementImpl res = this.getModel().createStatement(this.getSubject(), property, value);
            this.model.add((Statement)res);
            return res;
        }
        return this.asAnnotationResource().orElseGet(() -> OntAnnotationImpl.createAnnotation(this.getModel(), this, this.getAnnotationResourceType())).addAnnotation(property, value);
    }

    @Override
    public Stream<OntStatement> annotations() {
        return Iter.asStream(this.listAnnotations(), this.getCharacteristics());
    }

    @Override
    public boolean hasAnnotations() {
        return Iter.findFirst(this.listAnnotations()).isPresent();
    }

    public ExtendedIterator<OntStatement> listAnnotations() {
        ExtendedIterator res = Iter.flatMap(this.listAnnotationResources(), a -> ((OntAnnotationImpl)a).listAssertions());
        if (this.isRootStatement()) {
            return this.listSubjectAssertions().andThen(res);
        }
        return res;
    }

    protected ExtendedIterator<OntStatement> listSubjectAssertions() {
        return ((OntObjectImpl)this.getSubject()).listAssertions();
    }

    @Override
    public OntStatementImpl clearAnnotations() {
        Iter.peek(this.listAnnotations(), OntStatement::clearAnnotations).toSet().forEach(a -> this.deleteAnnotation((OntAnnotationProperty)a.getPredicate().as(OntAnnotationProperty.class), a.getObject()));
        return this;
    }

    @Override
    public OntStatementImpl deleteAnnotation(OntAnnotationProperty property, RDFNode value) {
        Set candidates;
        OntJenaException.notNull(property, "Null property.");
        OntJenaException.notNull(value, "Null value.");
        OntGraphModelImpl model = this.getModel();
        if (this.isRootStatement()) {
            Set<OntStatement> assertions = model.statements(this.getSubject(), property, value).collect(Collectors.toSet());
            if (this.isAnnotationRootStatement()) {
                throw new OntJenaException("Direct removing assertions from Annotation resource is prohibited");
            }
            assertions.forEach(model::remove);
        }
        if ((candidates = this.annotationResources().flatMap(OntAnnotation::assertions).filter(s -> Objects.equals(property, s.getPredicate())).filter(s -> Objects.equals(value, s.getObject())).collect(Collectors.toSet())).isEmpty()) {
            return this;
        }
        Set<OntStatement> delete = candidates.stream().filter(s -> !s.hasAnnotations()).collect(Collectors.toSet());
        if (delete.isEmpty()) {
            throw new OntJenaException("Can't delete [*, " + property + ", " + value + "]: candidates have their own annotations which should be deleted first.");
        }
        delete.forEach(model::remove);
        Set<OntAnnotation> empty = this.annotationResources().filter(f -> Objects.equals(f.listProperties().toSet().size(), OntAnnotationImpl.SPEC.size())).collect(Collectors.toSet());
        empty.forEach(a -> {
            model.removeAll((Resource)a, null, null);
            model.getNodeCache().remove((Object)a.asNode());
        });
        return this;
    }

    @Override
    public Stream<OntAnnotation> annotationResources() {
        return Iter.asStream(this.listAnnotationResources(), this.getCharacteristics());
    }

    @Override
    public List<OntAnnotation> getAnnotationList() {
        List<OntAnnotation> res = this.getAnnotationResourcesAsList();
        res.sort(OntAnnotationImpl.DEFAULT_ANNOTATION_COMPARATOR);
        return res;
    }

    protected List<OntAnnotation> getAnnotationResourcesAsList() {
        return this.listAnnotationResources().toList();
    }

    protected Resource getAnnotationResourceType() {
        return OntStatementImpl.getAnnotationRootType(this.subject);
    }

    public ExtendedIterator<OntAnnotation> listAnnotationResources() {
        return OntStatementImpl.listAnnotationResources(this.getModel(), this).mapWith(this::wrapAsOntAnnotation);
    }

    public boolean belongsToOWLAnnotation() {
        return this.subject.hasProperty(RDF.type, (RDFNode)OWL.Annotation);
    }

    public boolean belongsToOWLAxiom() {
        return this.subject.hasProperty(RDF.type, (RDFNode)OWL.Axiom);
    }

    public boolean hasAnnotatedProperty(Property property) {
        return this.subject.hasProperty(OWL.annotatedProperty, (RDFNode)property);
    }

    public boolean hasAnnotatedTarget(RDFNode object) {
        return this.subject.hasProperty(OWL.annotatedTarget, object);
    }

    public ExtendedIterator<OntStatement> listSplitStatements() {
        List<OntAnnotation> res = this.getAnnotationList();
        if (res.size() < 2) {
            return Iter.of(this);
        }
        if (this.isRootStatement()) {
            OntStatementImpl first = this.createRootStatement(res.remove(0));
            return Iter.of(first).andThen((Iterator)Iter.create(res).mapWith(OntAnnotation::getBase));
        }
        return Iter.create(res).mapWith(OntAnnotation::getBase);
    }

    protected OntStatementImpl createRootStatement(final OntAnnotation resource) {
        return new OntStatementImpl(this){

            @Override
            public boolean isRootStatement() {
                return true;
            }

            @Override
            public List<OntAnnotation> getAnnotationList() {
                return Collections.singletonList(resource);
            }

            @Override
            public ExtendedIterator<OntAnnotation> listAnnotationResources() {
                return Iter.of(resource);
            }
        };
    }

    protected OntStatementImpl createBaseStatement(final OntAnnotationImpl resource) {
        return new OntStatementImpl(this){

            @Override
            public ExtendedIterator<OntStatement> listAnnotations() {
                return resource.listAssertions();
            }

            @Override
            public List<OntAnnotation> getAnnotationList() {
                return Collections.singletonList(resource);
            }

            @Override
            public ExtendedIterator<OntAnnotation> listAnnotationResources() {
                return Iter.of(resource);
            }
        };
    }

    protected OntAnnotationImpl wrapAsOntAnnotation(Resource annotation) {
        return new OntAnnotationImpl(annotation.asNode(), (EnhGraph)this.getModel()){

            @Override
            public OntStatement getBase() {
                return OntStatementImpl.this.createBaseStatement(this);
            }
        };
    }
}

