/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.Factories;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.OntListImpl;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.PersonalityModel;
import com.github.owlcs.ontapi.jena.impl.conf.BaseFactoryImpl;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.OntFilter;
import com.github.owlcs.ontapi.jena.impl.conf.OntFinder;
import com.github.owlcs.ontapi.jena.impl.conf.OntMaker;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntProperty;
import com.github.owlcs.ontapi.jena.model.OntSWRL;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.SWRL;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.enhanced.UnsupportedPolymorphismException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.RDFListImpl;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.apache.jena.vocabulary.RDF;

public class OntSWRLImpl
extends OntObjectImpl
implements OntSWRL {
    private static final OntFilter VARIABLE_FILTER = OntFilter.URI.and(new OntFilter.HasType(SWRL.Variable));
    private static final OntFilter BUILTIN_FILTER = (n, g) -> {
        if (!n.isURI()) {
            return false;
        }
        OntPersonality p = PersonalityModel.asPersonalityModel(g).getOntPersonality();
        if (p.getBuiltins().get(OntSWRL.Builtin.class).contains(n)) {
            return true;
        }
        return Iter.findFirst(g.asGraph().find(n, RDF.Nodes.type, SWRL.Builtin.asNode())).isPresent();
    };
    public static ObjectFactory variableSWRLFactory = Factories.createCommon(new OntMaker.WithType(VariableImpl.class, SWRL.Variable), (OntFinder)new OntFinder.ByType(SWRL.Variable), VARIABLE_FILTER, new OntFilter[0]);
    public static ObjectFactory builtinWRLFactory = Factories.createCommon(new OntMaker.WithType(BuiltinImpl.class, SWRL.Builtin), (OntFinder)new OntFinder.ByType(SWRL.Builtin), BUILTIN_FILTER, new OntFilter[0]);
    public static ObjectFactory dArgSWRLFactory = Factories.createCommon(DArgImpl.class, OntFinder.ANY_SUBJECT_AND_OBJECT, VARIABLE_FILTER.or((arg_0, arg_1) -> ((Implementation)LiteralImpl.factory).canWrap(arg_0, arg_1)), new OntFilter[0]);
    public static ObjectFactory iArgSWRLFactory = Factories.createCommon(IArgImpl.class, OntFinder.ANY_SUBJECT_AND_OBJECT, VARIABLE_FILTER.or((n, g) -> PersonalityModel.canAs(OntIndividual.class, n, g)), new OntFilter[0]);
    public static ObjectFactory abstractArgSWRLFactory = Factories.createFrom(OntFinder.ANY_SUBJECT_AND_OBJECT, OntSWRL.DArg.class, OntSWRL.IArg.class);
    public static ObjectFactory builtInAtomSWRLFactory = OntSWRLImpl.makeAtomFactory(BuiltInAtomImpl.class, SWRL.BuiltinAtom);
    public static ObjectFactory classAtomSWRLFactory = OntSWRLImpl.makeAtomFactory(OntClassAtomImpl.class, SWRL.ClassAtom);
    public static ObjectFactory dataRangeAtomSWRLFactory = OntSWRLImpl.makeAtomFactory(DataRangeAtomImpl.class, SWRL.DataRangeAtom);
    public static ObjectFactory dataValuedAtomSWRLFactory = OntSWRLImpl.makeAtomFactory(DataPropertyAtomImpl.class, SWRL.DatavaluedPropertyAtom);
    public static ObjectFactory individualAtomSWRLFactory = OntSWRLImpl.makeAtomFactory(ObjectPropertyAtomImpl.class, SWRL.IndividualPropertyAtom);
    public static ObjectFactory differentIndividualsAtomSWRLFactory = OntSWRLImpl.makeAtomFactory(DifferentIndividualsAtomImpl.class, SWRL.DifferentIndividualsAtom);
    public static ObjectFactory sameIndividualsAtomSWRLFactory = OntSWRLImpl.makeAtomFactory(SameIndividualsAtomImpl.class, SWRL.SameIndividualAtom);
    public static ObjectFactory abstractAtomSWRLFactory = Factories.createFrom(OntFinder.TYPED, OntSWRL.Atom.WithBuiltin.class, OntSWRL.Atom.WithClass.class, OntSWRL.Atom.WithDataRange.class, OntSWRL.Atom.WithDataProperty.class, OntSWRL.Atom.WithObjectProperty.class, OntSWRL.Atom.WithDifferentIndividuals.class, OntSWRL.Atom.WithSameIndividuals.class);
    public static ObjectFactory abstractBinarySWRLFactory = Factories.createFrom(OntFinder.TYPED, OntSWRL.Atom.WithDataProperty.class, OntSWRL.Atom.WithObjectProperty.class, OntSWRL.Atom.WithDifferentIndividuals.class, OntSWRL.Atom.WithSameIndividuals.class);
    public static ObjectFactory abstractUnarySWRLFactory = Factories.createFrom(OntFinder.TYPED, OntSWRL.Atom.WithClass.class, OntSWRL.Atom.WithDataRange.class);
    public static ObjectFactory abstractSWRLFactory = Factories.createFrom(OntFinder.TYPED, OntSWRL.Atom.WithBuiltin.class, OntSWRL.Atom.WithClass.class, OntSWRL.Atom.WithDataRange.class, OntSWRL.Atom.WithDataProperty.class, OntSWRL.Atom.WithObjectProperty.class, OntSWRL.Atom.WithDifferentIndividuals.class, OntSWRL.Atom.WithSameIndividuals.class, OntSWRL.Builtin.class, OntSWRL.Variable.class, OntSWRL.Imp.class);
    public static ObjectFactory impSWRLFactory = new SWRLImplFactory();

    private static ObjectFactory makeAtomFactory(Class<? extends AtomImpl<?>> view, Resource type) {
        return Factories.createCommon(new OntMaker.Default(view), (OntFinder)new OntFinder.ByType(type), OntFilter.BLANK.and(new OntFilter.HasType(type)), new OntFilter[0]);
    }

    public OntSWRLImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public static OntSWRL.Builtin fetchBuiltinEntity(OntGraphModelImpl model, String uri) {
        OntSWRL.Builtin res = model.findNodeAs(NodeFactory.createURI((String)OntJenaException.notNull(uri, "Null uri.")), OntSWRL.Builtin.class);
        if (res == null) {
            res = OntSWRLImpl.createBuiltinEntity(model, uri);
        }
        return res;
    }

    public static OntSWRL.Builtin createBuiltinEntity(OntGraphModelImpl model, String uri) {
        return model.createOntObject(OntSWRL.Builtin.class, Objects.requireNonNull(uri));
    }

    public static OntSWRL.Variable createVariable(OntGraphModelImpl model, String uri) {
        return model.createOntObject(OntSWRL.Variable.class, uri);
    }

    public static OntSWRL.Atom.WithBuiltin createBuiltInAtom(OntGraphModelImpl model, Resource predicate, Collection<OntSWRL.DArg> arguments) {
        OntSWRL.Builtin property = OntSWRLImpl.fetchBuiltinEntity(model, predicate.getURI());
        OntObject res = (OntObject)model.createResource(SWRL.BuiltinAtom).addProperty(SWRL.builtin, (RDFNode)property).as(OntObject.class);
        OntListImpl.create(model, res, SWRL.arguments, null, OntSWRL.DArg.class, Iter.create(arguments));
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.WithBuiltin.class);
    }

    public static OntSWRL.Atom.WithClass createClassAtom(OntGraphModelImpl model, OntClass clazz, OntSWRL.IArg arg) {
        OntJenaException.notNull(clazz, "Null class");
        OntJenaException.notNull(arg, "Null i-arg");
        Resource res = model.createResource(SWRL.ClassAtom).addProperty(SWRL.classPredicate, (RDFNode)clazz).addProperty(SWRL.argument1, (RDFNode)arg);
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.WithClass.class);
    }

    public static OntSWRL.Atom.WithDataRange createDataRangeAtom(OntGraphModelImpl model, OntDataRange range, OntSWRL.DArg arg) {
        OntJenaException.notNull(range, "Null data range");
        OntJenaException.notNull(arg, "Null d-arg");
        Resource res = model.createResource(SWRL.DataRangeAtom).addProperty(SWRL.dataRange, (RDFNode)range).addProperty(SWRL.argument1, (RDFNode)arg);
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.WithDataRange.class);
    }

    public static OntSWRL.Atom.WithDataProperty createDataPropertyAtom(OntGraphModelImpl model, OntDataProperty dataProperty, OntSWRL.IArg firstArg, OntSWRL.DArg secondArg) {
        OntJenaException.notNull(dataProperty, "Null data property");
        OntJenaException.notNull(firstArg, "Null first i-arg");
        OntJenaException.notNull(secondArg, "Null second d-arg");
        Resource res = model.createResource(SWRL.DatavaluedPropertyAtom).addProperty(SWRL.propertyPredicate, (RDFNode)dataProperty).addProperty(SWRL.argument1, (RDFNode)firstArg).addProperty(SWRL.argument2, (RDFNode)secondArg);
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.WithDataProperty.class);
    }

    public static OntSWRL.Atom.WithObjectProperty createObjectPropertyAtom(OntGraphModelImpl model, OntObjectProperty objectProperty, OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        OntJenaException.notNull(objectProperty, "Null object property");
        OntJenaException.notNull(firstArg, "Null first i-arg");
        OntJenaException.notNull(secondArg, "Null second i-arg");
        Resource res = model.createResource(SWRL.IndividualPropertyAtom).addProperty(SWRL.propertyPredicate, (RDFNode)objectProperty).addProperty(SWRL.argument1, (RDFNode)firstArg).addProperty(SWRL.argument2, (RDFNode)secondArg);
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.WithObjectProperty.class);
    }

    public static OntSWRL.Atom.WithDifferentIndividuals createDifferentIndividualsAtom(OntGraphModelImpl model, OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        OntJenaException.notNull(firstArg, "Null first i-arg");
        OntJenaException.notNull(secondArg, "Null second i-arg");
        Resource res = model.createResource(SWRL.DifferentIndividualsAtom).addProperty(SWRL.argument1, (RDFNode)firstArg).addProperty(SWRL.argument2, (RDFNode)secondArg);
        model.fetchOntEntity(OntObjectProperty.Named.class, OWL.differentFrom.getURI());
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.WithDifferentIndividuals.class);
    }

    public static OntSWRL.Atom.WithSameIndividuals createSameIndividualsAtom(OntGraphModelImpl model, OntSWRL.IArg firstArg, OntSWRL.IArg secondArg) {
        OntJenaException.notNull(firstArg, "Null first i-arg");
        OntJenaException.notNull(secondArg, "Null second i-arg");
        Resource res = model.createResource(SWRL.SameIndividualAtom).addProperty(SWRL.argument1, (RDFNode)firstArg).addProperty(SWRL.argument2, (RDFNode)secondArg);
        model.fetchOntEntity(OntObjectProperty.Named.class, OWL.sameAs.getURI());
        return model.getNodeAs(res.asNode(), OntSWRL.Atom.WithSameIndividuals.class);
    }

    public static OntSWRL.Imp createImp(OntGraphModelImpl model, Collection<OntSWRL.Atom<? extends OntObject>> head, Collection<OntSWRL.Atom<? extends OntObject>> body) {
        OntJenaException.notNull(head, "Null head");
        OntJenaException.notNull(body, "Null body");
        OntObject res = (OntObject)model.createResource(SWRL.Imp).as(OntObject.class);
        OntListImpl.create(model, res, SWRL.head, SWRL.AtomList, OntSWRL.Atom.class, Iter.create(head));
        OntListImpl.create(model, res, SWRL.body, SWRL.AtomList, OntSWRL.Atom.class, Iter.create(body));
        return model.getNodeAs(res.asNode(), OntSWRL.Imp.class);
    }

    public static class SWRLImplFactory
    extends BaseFactoryImpl {
        private static final Node IMP = SWRL.Imp.asNode();
        private static final Node BODY = SWRL.body.asNode();
        private static final Node HEAD = SWRL.head.asNode();
        private static final Node LIST = SWRL.AtomList.asNode();
        private static final Implementation LIST_FACTORY = RDFListImpl.factory;

        @Override
        public ExtendedIterator<EnhNode> iterator(EnhGraph eg) {
            return eg.asGraph().find(Node.ANY, RDF.Nodes.type, IMP).filterKeep(t -> this.hasAtomList(HEAD, t.getSubject(), eg) && this.hasAtomList(BODY, t.getSubject(), eg)).mapWith(t -> this.createInstance(t.getSubject(), eg));
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            return eg.asGraph().contains(node, RDF.Nodes.type, IMP) && this.hasAtomList(HEAD, node, eg) && this.hasAtomList(BODY, node, eg);
        }

        @Override
        public EnhNode createInstance(Node node, EnhGraph eg) {
            return new ImpImpl(node, eg);
        }

        private boolean hasAtomList(Node p, Node node, EnhGraph eg) {
            return Iter.findFirst(eg.asGraph().find(node, p, Node.ANY).filterKeep(t -> this.isAtomList(t.getObject(), eg))).isPresent();
        }

        private boolean isAtomList(Node n, EnhGraph eg) {
            if (RDF.Nodes.nil.equals((Object)n)) {
                return true;
            }
            return eg.asGraph().contains(n, RDF.Nodes.type, LIST) && LIST_FACTORY.canWrap(n, eg);
        }
    }

    public static class ImpImpl
    extends OntSWRLImpl
    implements OntSWRL.Imp {
        public ImpImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        public OntListImpl<OntSWRL.Atom> getHeadList() {
            return this.getList(SWRL.head);
        }

        public OntListImpl<OntSWRL.Atom> getBodyList() {
            return this.getList(SWRL.body);
        }

        protected OntListImpl<OntSWRL.Atom> getList(Property predicate) {
            RDFList list = this.getRequiredObject(predicate, RDFList.class);
            return OntListImpl.asOntList(list, this.getModel(), this, predicate, SWRL.AtomList, OntSWRL.Atom.class);
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iter.concat(super.listSpec(), ((OntListImpl)this.getHeadList()).listContent(), ((OntListImpl)this.getBodyList()).listContent());
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return ImpImpl.getRequiredRootStatement(this, SWRL.Imp);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Imp.class;
        }
    }

    public static class SameIndividualsAtomImpl
    extends IndividualsAtomImpl
    implements OntSWRL.Atom.WithSameIndividuals {
        public SameIndividualsAtomImpl(Node n, EnhGraph m) {
            super(n, m, OWL.sameAs);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.SameIndividualAtom;
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Atom.WithSameIndividuals.class;
        }
    }

    public static class DifferentIndividualsAtomImpl
    extends IndividualsAtomImpl
    implements OntSWRL.Atom.WithDifferentIndividuals {
        public DifferentIndividualsAtomImpl(Node n, EnhGraph m) {
            super(n, m, OWL.differentFrom);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.DifferentIndividualsAtom;
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Atom.WithDifferentIndividuals.class;
        }
    }

    public static abstract class IndividualsAtomImpl
    extends BinaryImpl<OntObjectProperty.Named, OntSWRL.IArg, OntSWRL.IArg> {
        public IndividualsAtomImpl(Node n, EnhGraph m, Property predicate) {
            super(n, m, predicate, OntObjectProperty.Named.class, OntSWRL.IArg.class, OntSWRL.IArg.class);
        }

        @Override
        public OntObjectProperty.Named getPredicate() {
            return (OntObjectProperty.Named)this.getModel().fetchOntEntity(OntObjectProperty.Named.class, this.predicate.getURI());
        }

        @Override
        protected ExtendedIterator<OntStatement> listPredicateSpec() {
            OntStatement s = this.getPredicate().getMainStatement();
            return s == null ? NullIterator.instance() : Iter.of(s);
        }
    }

    public static class ObjectPropertyAtomImpl
    extends PropertyAtomImpl<OntObjectProperty, OntSWRL.IArg>
    implements OntSWRL.Atom.WithObjectProperty {
        public ObjectPropertyAtomImpl(Node n, EnhGraph m) {
            super(n, m, OntObjectProperty.class, OntSWRL.IArg.class);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.IndividualPropertyAtom;
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Atom.WithObjectProperty.class;
        }
    }

    public static class DataPropertyAtomImpl
    extends PropertyAtomImpl<OntDataProperty, OntSWRL.DArg>
    implements OntSWRL.Atom.WithDataProperty {
        public DataPropertyAtomImpl(Node n, EnhGraph m) {
            super(n, m, OntDataProperty.class, OntSWRL.DArg.class);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.DatavaluedPropertyAtom;
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Atom.WithDataProperty.class;
        }
    }

    public static abstract class PropertyAtomImpl<P extends OntProperty, A extends OntSWRL.Arg>
    extends BinaryImpl<P, OntSWRL.IArg, A> {
        PropertyAtomImpl(Node n, EnhGraph m, Class<P> objectType, Class<A> secondArgType) {
            super(n, m, SWRL.propertyPredicate, objectType, OntSWRL.IArg.class, secondArgType);
        }
    }

    public static abstract class BinaryImpl<O extends OntObject, F extends OntSWRL.Arg, S extends OntSWRL.Arg>
    extends AtomImpl<O>
    implements OntSWRL.Atom.Binary<O, F, S> {
        protected final Property predicate;
        private final Class<O> objectType;
        private final Class<F> firstArgType;
        private final Class<S> secondArgType;

        BinaryImpl(Node n, EnhGraph m, Property predicate, Class<O> objectType, Class<F> firstArgType, Class<S> secondArgType) {
            super(n, m);
            this.predicate = predicate;
            this.objectType = objectType;
            this.firstArgType = firstArgType;
            this.secondArgType = secondArgType;
        }

        @Override
        public O getPredicate() {
            return (O)((OntObject)this.getRequiredObject(this.predicate, this.objectType));
        }

        @Override
        public F getFirstArg() {
            return (F)((OntSWRL.Arg)this.getRequiredObject(SWRL.argument1, this.firstArgType));
        }

        @Override
        public S getSecondArg() {
            return (S)((OntSWRL.Arg)this.getRequiredObject(SWRL.argument2, this.secondArgType));
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iter.concat(super.listSpec(), this.listPredicateSpec(), this.listRequired(SWRL.argument1, SWRL.argument2));
        }

        protected ExtendedIterator<OntStatement> listPredicateSpec() {
            return this.listRequired(this.predicate);
        }
    }

    public static class DataRangeAtomImpl
    extends UnaryImpl<OntDataRange, OntSWRL.DArg>
    implements OntSWRL.Atom.WithDataRange {
        public DataRangeAtomImpl(Node n, EnhGraph m) {
            super(n, m, SWRL.dataRange, OntDataRange.class, OntSWRL.DArg.class);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.DataRangeAtom;
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Atom.WithDataRange.class;
        }
    }

    public static class OntClassAtomImpl
    extends UnaryImpl<OntClass, OntSWRL.IArg>
    implements OntSWRL.Atom.WithClass {
        public OntClassAtomImpl(Node n, EnhGraph m) {
            super(n, m, SWRL.classPredicate, OntClass.class, OntSWRL.IArg.class);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.ClassAtom;
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Atom.WithClass.class;
        }
    }

    public static abstract class UnaryImpl<O extends OntObject, A extends OntSWRL.Arg>
    extends AtomImpl<O>
    implements OntSWRL.Atom.Unary<O, A> {
        private final Property predicate;
        private final Class<O> objectView;
        private final Class<A> argView;

        UnaryImpl(Node n, EnhGraph m, Property predicate, Class<O> objectView, Class<A> argView) {
            super(n, m);
            this.predicate = predicate;
            this.objectView = objectView;
            this.argView = argView;
        }

        @Override
        public A getArg() {
            return (A)((OntSWRL.Arg)this.getRequiredObject(SWRL.argument1, this.argView));
        }

        @Override
        public O getPredicate() {
            return (O)((OntObject)this.getRequiredObject(this.predicate, this.objectView));
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iter.concat(super.listSpec(), this.listRequired(this.predicate, SWRL.argument1));
        }
    }

    public static class BuiltInAtomImpl
    extends AtomImpl<OntSWRL.Builtin>
    implements OntSWRL.Atom.WithBuiltin {
        public BuiltInAtomImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Resource getResourceType() {
            return SWRL.BuiltinAtom;
        }

        @Override
        public OntSWRL.Builtin getPredicate() {
            return this.getRequiredObject(SWRL.builtin, OntSWRL.Builtin.class);
        }

        public OntListImpl<OntSWRL.DArg> getArgList() {
            return OntListImpl.asOntList(this.getRequiredObject(SWRL.arguments, RDFList.class), this.getModel(), this, SWRL.arguments, null, OntSWRL.DArg.class);
        }

        public ExtendedIterator<OntStatement> listPredicateStatements() {
            OntStatement p = this.getRequiredProperty(SWRL.builtin);
            OntStatement b = this.getPredicate().getMainStatement();
            return b == null ? Iter.of(p) : Iter.of(new OntStatement[]{p, b});
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return Iter.concat(super.listSpec(), this.listPredicateStatements(), ((OntListImpl)this.getArgList()).listContent());
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Atom.WithBuiltin.class;
        }
    }

    public static abstract class AtomImpl<P extends OntObject>
    extends OntSWRLImpl
    implements OntSWRL.Atom<P> {
        public AtomImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Optional<OntStatement> findRootStatement() {
            return AtomImpl.getRequiredRootStatement(this, this.getResourceType());
        }

        public abstract Resource getResourceType();
    }

    public static class IArgImpl
    extends OntObjectImpl
    implements OntSWRL.IArg {
        public IArgImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.IArg.class;
        }
    }

    public static class DArgImpl
    extends OntObjectImpl
    implements OntSWRL.DArg {
        public DArgImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.DArg.class;
        }

        public Literal asLiteral() throws UnsupportedPolymorphismException {
            return (Literal)this.as(Literal.class);
        }

        @Override
        public ExtendedIterator<OntStatement> listSpec() {
            return this.node.isLiteral() ? NullIterator.instance() : ((VariableImpl)this.as(OntSWRL.Variable.class)).listSpec();
        }
    }

    public static class VariableImpl
    extends OntSWRLImpl
    implements OntSWRL.Variable {
        public VariableImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Variable.class;
        }
    }

    public static class BuiltinImpl
    extends OntSWRLImpl
    implements OntSWRL.Builtin {
        public BuiltinImpl(Node n, EnhGraph m) {
            super(n, m);
        }

        @Override
        public Class<? extends OntObject> getActualClass() {
            return OntSWRL.Builtin.class;
        }
    }
}

