/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena.impl;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.Factories;
import com.github.owlcs.ontapi.jena.impl.OntOPEImpl;
import com.github.owlcs.ontapi.jena.impl.OntObjectImpl;
import com.github.owlcs.ontapi.jena.impl.WrappedFactoryImpl;
import com.github.owlcs.ontapi.jena.impl.conf.BaseFactoryImpl;
import com.github.owlcs.ontapi.jena.impl.conf.ObjectFactory;
import com.github.owlcs.ontapi.jena.impl.conf.OntFinder;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntProperty;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;

public abstract class OntPEImpl
extends OntObjectImpl
implements OntProperty {
    public static final OntFinder NAMED_PROPERTY_FINDER = Factories.createFinder(OWL.AnnotationProperty, OWL.ObjectProperty, OWL.DatatypeProperty);
    public static ObjectFactory inversePropertyFactory = OntPEImpl.createAnonymousObjectPropertyFactory();
    public static ObjectFactory abstractNamedPropertyFactory = Factories.createFrom(NAMED_PROPERTY_FINDER, OntObjectProperty.Named.class, OntDataProperty.class, OntAnnotationProperty.class);
    public static ObjectFactory abstractOPEFactory = OntPEImpl.createObjectPropertyExpressionFactory();
    public static ObjectFactory abstractDOPFactory = OntPEImpl.createDataOrObjectPropertyFactory();
    public static ObjectFactory abstractPEFactory = OntPEImpl.createPropertyExpressionFactory();

    public OntPEImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public static ObjectFactory createObjectPropertyExpressionFactory() {
        return new HasAnonymous(){
            private final ObjectFactory named = WrappedFactoryImpl.of(OntObjectProperty.Named.class);

            @Override
            public ExtendedIterator<EnhNode> iterator(EnhGraph eg) {
                ExtendedIterator res = eg.asGraph().find(Node.ANY, RDF.Nodes.type, OWL.ObjectProperty.asNode()).filterKeep(t -> t.getSubject().isURI()).mapWith(t -> this.named.createInstance(t.getSubject(), eg));
                return Iter.concat(res, this.anonymous.iterator(eg));
            }

            @Override
            public boolean canWrap(Node node, EnhGraph eg) {
                if (node.isURI()) {
                    return this.named.canWrap(node, eg);
                }
                return this.anonymous.canWrap(node, eg);
            }

            @Override
            public EnhNode createInstance(Node node, EnhGraph eg) {
                if (node.isURI()) {
                    return this.named.createInstance(node, eg);
                }
                return this.anonymous.createInstance(node, eg);
            }

            @Override
            public EnhNode wrap(Node node, EnhGraph eg) {
                if (node.isURI()) {
                    return this.named.wrap(node, eg);
                }
                if (node.isBlank()) {
                    return this.anonymous.wrap(node, eg);
                }
                throw new OntJenaException.Conversion("Can't convert node " + node + " to Object Property Expression.");
            }
        };
    }

    public static ObjectFactory createDataOrObjectPropertyFactory() {
        return new PropertiesFactory().add(OWL.ObjectProperty, OntObjectProperty.Named.class).add(OWL.DatatypeProperty, OntDataProperty.class);
    }

    public static ObjectFactory createPropertyExpressionFactory() {
        return new PropertiesFactory().add(OWL.ObjectProperty, OntObjectProperty.Named.class).add(OWL.DatatypeProperty, OntDataProperty.class).add(OWL.AnnotationProperty, OntAnnotationProperty.class);
    }

    public static ObjectFactory createAnonymousObjectPropertyFactory() {
        return new AnonymousObjectPropertyFactory();
    }

    @Override
    public Property asProperty() {
        if (!this.isURIResource()) {
            throw new OntJenaException.IllegalState();
        }
        return (Property)this.as(Property.class);
    }

    public static class AnonymousObjectPropertyFactory
    extends BaseFactoryImpl {
        private static final Node OWL_INVERSE_OF = OWL.inverseOf.asNode();
        protected final ObjectFactory named = WrappedFactoryImpl.of(OntObjectProperty.Named.class);

        @Override
        public ExtendedIterator<EnhNode> iterator(EnhGraph eg) {
            return this.triples(Node.ANY, eg).filterKeep(x -> x.getSubject().isBlank()).mapWith(x -> this.createInstance(x.getSubject(), eg));
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            return node.isBlank() && Iter.findFirst(this.triples(node, eg)).isPresent();
        }

        @Override
        public EnhNode createInstance(Node node, EnhGraph eg) {
            return new OntOPEImpl.InversePropertyImpl(node, eg);
        }

        private ExtendedIterator<Triple> triples(Node node, EnhGraph eg) {
            return eg.asGraph().find(node, OWL_INVERSE_OF, Node.ANY).filterKeep(x -> this.named.canWrap(x.getObject(), eg));
        }
    }

    protected static abstract class HasAnonymous
    extends BaseFactoryImpl {
        protected final ObjectFactory anonymous = WrappedFactoryImpl.of(OntObjectProperty.Inverse.class);

        protected HasAnonymous() {
        }
    }

    protected static class PropertiesFactory
    extends HasAnonymous {
        final List<Factory> factories = new ArrayList<Factory>();

        protected PropertiesFactory() {
        }

        PropertiesFactory add(Resource declaration, Class<? extends OntProperty> type) {
            this.factories.add(new Factory(declaration.asNode(), type));
            return this;
        }

        @Override
        public ExtendedIterator<EnhNode> iterator(EnhGraph eg) {
            Graph g = eg.asGraph();
            ExtendedIterator res = Iter.distinct(Iter.flatMap(Iter.create(this.factories), f -> g.find(Node.ANY, RDF.Nodes.type, ((Factory)f).nt).mapWith(t -> PropertiesFactory.safeWrap(t.getSubject(), eg, ((Factory)f).f)).filterDrop(Objects::isNull)));
            return Iter.concat(res, this.anonymous.iterator(eg));
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            if (!node.isURI()) {
                return this.anonymous.canWrap(node, eg);
            }
            for (Factory f : this.factories) {
                if (!f.f.canWrap(node, eg)) continue;
                return true;
            }
            return false;
        }

        @Override
        public EnhNode createInstance(Node node, EnhGraph eg) {
            if (!node.isURI()) {
                return this.anonymous.createInstance(node, eg);
            }
            for (Factory f : this.factories) {
                EnhNode res = PropertiesFactory.safeWrap(node, eg, f.f);
                if (res == null) continue;
                return res;
            }
            return null;
        }

        @Override
        public EnhNode wrap(Node node, EnhGraph eg) {
            if (node.isBlank()) {
                return this.anonymous.wrap(node, eg);
            }
            OntJenaException.Conversion ex = new OntJenaException.Conversion("Can't convert node " + node + " to Property Expression");
            if (!node.isURI()) {
                throw ex;
            }
            for (Factory f : this.factories) {
                try {
                    return f.f.wrap(node, eg);
                }
                catch (OntJenaException.Conversion c) {
                    ex.addSuppressed((Throwable)((Object)c));
                }
            }
            throw ex;
        }

        private static class Factory {
            private final Node nt;
            private final ObjectFactory f;

            private Factory(Node nodeType, Class<? extends OntProperty> classType) {
                this.nt = Objects.requireNonNull(nodeType);
                this.f = WrappedFactoryImpl.of(classType);
            }
        }
    }
}

