/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.jena;

import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import com.github.owlcs.ontapi.jena.vocabulary.SWRL;
import com.github.owlcs.ontapi.jena.vocabulary.SWRLB;
import com.github.owlcs.ontapi.jena.vocabulary.XSD;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.datatypes.BaseDatatype;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.vocabulary.DC;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.SKOS;

public interface OntVocabulary {
    public Set<? extends Resource> get(String var1);

    default public <X extends Resource> Set<X> get(Resource uri) {
        return this.get(uri.getURI());
    }

    default public Set<Property> getBuiltinAnnotationProperties() {
        return this.get(OWL.AnnotationProperty);
    }

    default public Set<Property> getBuiltinDatatypeProperties() {
        return this.get(OWL.DatatypeProperty);
    }

    default public Set<Property> getBuiltinObjectProperties() {
        return this.get(OWL.ObjectProperty);
    }

    default public Set<Resource> getBuiltinDatatypes() {
        return this.get(RDFS.Datatype);
    }

    default public Set<Resource> getBuiltinClasses() {
        return this.get(OWL.Class);
    }

    default public Set<Resource> getBuiltinSWRLs() {
        return this.get(SWRL.Builtin);
    }

    default public Set<Resource> getSystemResources() {
        return this.get(RDFS.Resource);
    }

    default public Set<Property> getSystemProperties() {
        return this.get(RDF.Property);
    }

    default public Set<Resource> getSystemALL() {
        return Stream.of(this.getSystemProperties(), this.getSystemResources()).flatMap(Collection::stream).collect(Iter.toUnmodifiableSet());
    }

    default public Set<Property> getBuiltinOWLProperties() {
        return Stream.of(this.getBuiltinAnnotationProperties(), this.getBuiltinDatatypeProperties(), this.getBuiltinObjectProperties()).flatMap(Collection::stream).collect(Iter.toUnmodifiableSet());
    }

    default public Set<Resource> getBuiltinOWLEntities() {
        return Stream.of(this.getBuiltinClasses(), this.getBuiltinDatatypes(), this.getBuiltinOWLProperties()).flatMap(Collection::stream).collect(Iter.toUnmodifiableSet());
    }

    public static class Factory {
        public static final OntVocabulary DUMMY = new Impl(Collections.emptyMap());
        public static final OntVocabulary OWL_VOCABULARY = new OWLImpl();
        public static final OntVocabulary DC_VOCABULARY = new DCImpl();
        public static final OntVocabulary SKOS_VOCABULARY = new SKOSImpl();
        public static final OntVocabulary SWRL_VOCABULARY = new SWRLImpl();
        public static final OntVocabulary DEFAULT_VOCABULARY;
        protected static OntVocabulary def;

        public static OntVocabulary get() {
            return def;
        }

        public static OntVocabulary set(OntVocabulary vocabulary) {
            OntVocabulary prev = Factory.get();
            def = Objects.requireNonNull(vocabulary, "Null vocabulary specified.");
            return prev;
        }

        public static OntVocabulary create(OntVocabulary ... vocabularies) {
            return new Impl(Arrays.stream(vocabularies).map(Factory::asMap).flatMap(x -> x.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> {
                HashSet res = new HashSet(a);
                res.addAll(b);
                return res;
            })));
        }

        public static OntVocabulary create(Resource key, Resource ... values) {
            return Factory.create(key, (Collection<? extends Resource>)Arrays.stream(values).collect(Iter.toUnmodifiableSet()));
        }

        public static OntVocabulary create(Resource key, Collection<? extends Resource> values) {
            return Factory.create(Objects.requireNonNull(key).getURI(), values);
        }

        public static OntVocabulary create(String key, Collection<? extends Resource> values) {
            HashMap<String, Set<? extends Resource>> map = new HashMap<String, Set<? extends Resource>>();
            map.put(Objects.requireNonNull(key), Factory.toUnmodifiableSet(Objects.requireNonNull(values)));
            return new Impl(map);
        }

        public static OntVocabulary create(Class<?> ... schemas) {
            return new Impl(Factory.getConstants(Property.class, schemas), Factory.getConstants(Resource.class, schemas));
        }

        private static Stream<Field> directFields(Class<?> vocabulary, Class<?> type) {
            return Arrays.stream(vocabulary.getDeclaredFields()).filter(x -> Modifier.isPublic(x.getModifiers())).filter(x -> Modifier.isStatic(x.getModifiers())).filter(x -> type.equals(x.getType()));
        }

        private static Stream<Field> fields(Class<?> vocabulary, Class<?> type) {
            Stream<Field> res = Factory.directFields(vocabulary, type);
            return vocabulary.getSuperclass() != null ? Stream.concat(res, Factory.fields(vocabulary.getSuperclass(), type)) : res;
        }

        private static <T> Stream<T> constants(Class<?> vocabulary, Class<T> type) {
            return Factory.fields(vocabulary, type).map(x -> Factory.getValue(x, type)).filter(Objects::nonNull);
        }

        private static <T> T getValue(Field field, Class<T> type) {
            try {
                return type.cast(field.get(null));
            }
            catch (IllegalAccessException e) {
                throw new OntJenaException.IllegalState("Unable to get an object of the type " + type.getSimpleName() + " from the field " + field.getName(), e);
            }
        }

        protected static <T> Set<T> getConstants(Class<? extends T> type, Class<?> ... vocabularies) {
            return Arrays.stream(vocabularies).map(x -> Factory.constants(x, type)).flatMap(Function.identity()).collect(Iter.toUnmodifiableSet());
        }

        private static Map<String, Set<? extends Resource>> asMap(OntVocabulary voc) {
            if (voc instanceof Impl) {
                return ((Impl)voc).map;
            }
            HashMap<String, Set<? extends Resource>> res = new HashMap<String, Set<? extends Resource>>();
            Stream.of(OWL.AnnotationProperty, OWL.DatatypeProperty, OWL.ObjectProperty, RDFS.Datatype, OWL.Class, SWRL.Builtin, RDF.Property, RDFS.Resource).forEach(x -> res.put(x.getURI(), voc.get((Resource)x)));
            return res;
        }

        private static <X> Set<X> toUnmodifiableSet(Collection<X> input) {
            if (input instanceof Set && input.getClass().getName().equals("java.util.Collections$UnmodifiableSet")) {
                return (Set)input;
            }
            return input.stream().peek(Objects::requireNonNull).collect(Iter.toUnmodifiableSet());
        }

        static {
            def = DEFAULT_VOCABULARY = Factory.create(OWL_VOCABULARY, DC_VOCABULARY, SKOS_VOCABULARY, SWRL_VOCABULARY);
        }

        protected static class Impl
        implements OntVocabulary {
            private final Map<String, Set<? extends Resource>> map;

            private Impl(Set<Property> properties, Set<Resource> resources) {
                this(null, null, null, null, null, null, properties, resources);
            }

            protected Impl(final Set<Property> annotationProperties, final Set<Property> dataProperties, final Set<Property> objectProperties, final Set<Resource> classes, final Set<Resource> datatypes, final Set<Resource> swrlBuiltins, final Set<Property> allProperties, final Set<Resource> allResources) {
                this((Map<String, Set<? extends Resource>>)new HashMap<String, Set<? extends Resource>>(){
                    {
                        this.put(OWL.AnnotationProperty, annotationProperties);
                        this.put(OWL.DatatypeProperty, dataProperties);
                        this.put(OWL.ObjectProperty, objectProperties);
                        this.put(OWL.Class, classes);
                        this.put(RDFS.Datatype, datatypes);
                        this.put(SWRL.Builtin, swrlBuiltins);
                        this.put(RDF.Property, allProperties);
                        this.put(RDFS.Resource, allResources);
                    }

                    @Override
                    private void put(Resource k, Set<? extends Resource> v) {
                        if (v == null) {
                            return;
                        }
                        this.put(k.getURI(), v);
                    }
                });
            }

            protected Impl(Map<String, Set<? extends Resource>> map) {
                this.map = Objects.requireNonNull(map);
            }

            @Override
            public Set<? extends Resource> get(String key) {
                return this.map.getOrDefault(key, Collections.emptySet());
            }
        }

        protected static class SWRLImpl
        extends Impl {
            private static final Class<?>[] VOCABULARIES = new Class[]{SWRL.class, SWRLB.class};
            public static final Set<Resource> BUILTINS = Factory.getConstants(Property.class, SWRLB.class);
            public static final Set<Property> PROPERTIES = Factory.getConstants(Property.class, VOCABULARIES);
            public static final Set<Resource> RESOURCES = Factory.getConstants(Resource.class, VOCABULARIES);

            protected SWRLImpl() {
                super(null, null, null, null, null, BUILTINS, PROPERTIES, RESOURCES);
            }
        }

        protected static class SKOSImpl
        extends Impl {
            public static final Set<Property> ANNOTATION_PROPERTIES = Stream.of(SKOS.altLabel, SKOS.changeNote, SKOS.definition, SKOS.editorialNote, SKOS.example, SKOS.hiddenLabel, SKOS.historyNote, SKOS.note, SKOS.prefLabel, SKOS.scopeNote).collect(Iter.toUnmodifiableSet());
            public static final Set<Property> OBJECT_PROPERTIES = Stream.of(SKOS.broadMatch, SKOS.broader, SKOS.broaderTransitive, SKOS.closeMatch, SKOS.exactMatch, SKOS.hasTopConcept, SKOS.inScheme, SKOS.mappingRelation, SKOS.member, SKOS.memberList, SKOS.narrowMatch, SKOS.narrower, SKOS.narrowerTransitive, SKOS.related, SKOS.relatedMatch, SKOS.semanticRelation, SKOS.topConceptOf).collect(Iter.toUnmodifiableSet());
            public static final Set<Resource> CLASSES = Stream.of(SKOS.Collection, SKOS.Concept, SKOS.ConceptScheme, SKOS.OrderedCollection).collect(Iter.toUnmodifiableSet());
            public static final Set<Property> PROPERTIES = Factory.getConstants(Property.class, SKOS.class);
            public static final Set<Resource> RESOURCES = Factory.getConstants(Resource.class, SKOS.class);

            protected SKOSImpl() {
                super(ANNOTATION_PROPERTIES, null, OBJECT_PROPERTIES, CLASSES, null, null, PROPERTIES, RESOURCES);
            }
        }

        protected static class DCImpl
        extends Impl {
            public static final Set<Property> ALL_PROPERTIES = Factory.getConstants(Property.class, DC.class);

            protected DCImpl() {
                super(ALL_PROPERTIES, null, null, null, null, null, ALL_PROPERTIES, null);
            }
        }

        protected static class OWLImpl
        extends Impl {
            private static final Class<?>[] VOCABULARIES = new Class[]{XSD.class, RDF.class, RDFS.class, OWL.class};
            public static final Set<Resource> OWL2_DATATYPES = Stream.of(RDF.xmlLiteral, RDF.PlainLiteral, RDF.langString, RDFS.Literal, OWL.real, OWL.rational, XSD.xstring, XSD.normalizedString, XSD.token, XSD.language, XSD.Name, XSD.NCName, XSD.NMTOKEN, XSD.decimal, XSD.integer, XSD.xdouble, XSD.xfloat, XSD.xboolean, XSD.nonNegativeInteger, XSD.nonPositiveInteger, XSD.positiveInteger, XSD.negativeInteger, XSD.xlong, XSD.xint, XSD.xshort, XSD.xbyte, XSD.unsignedLong, XSD.unsignedInt, XSD.unsignedShort, XSD.unsignedByte, XSD.hexBinary, XSD.base64Binary, XSD.anyURI, XSD.dateTime, XSD.dateTimeStamp).collect(Iter.toUnmodifiableSet());
            public static final Set<RDFDatatype> JENA_RDF_DATATYPE_SET = OWLImpl.initBuiltInRDFDatatypes(TypeMapper.getInstance());
            public static final Set<Resource> DATATYPES = JENA_RDF_DATATYPE_SET.stream().map(RDFDatatype::getURI).map(ResourceFactory::createResource).collect(Iter.toUnmodifiableSet());
            public static final Set<Resource> CLASSES = Stream.of(OWL.Nothing, OWL.Thing).collect(Iter.toUnmodifiableSet());
            public static final Set<Property> ANNOTATION_PROPERTIES = Stream.of(RDFS.label, RDFS.comment, RDFS.seeAlso, RDFS.isDefinedBy, OWL.versionInfo, OWL.backwardCompatibleWith, OWL.priorVersion, OWL.incompatibleWith, OWL.deprecated).collect(Iter.toUnmodifiableSet());
            public static final Set<Property> DATA_PROPERTIES = Stream.of(OWL.topDataProperty, OWL.bottomDataProperty).collect(Iter.toUnmodifiableSet());
            public static final Set<Property> OBJECT_PROPERTIES = Stream.of(OWL.topObjectProperty, OWL.bottomObjectProperty).collect(Iter.toUnmodifiableSet());
            public static final Set<Property> PROPERTIES = Factory.getConstants(Property.class, VOCABULARIES);
            public static final Set<Resource> RESOURCES = Factory.getConstants(Resource.class, VOCABULARIES);

            protected OWLImpl() {
                super(ANNOTATION_PROPERTIES, DATA_PROPERTIES, OBJECT_PROPERTIES, CLASSES, DATATYPES, null, PROPERTIES, RESOURCES);
            }

            private static Set<RDFDatatype> initBuiltInRDFDatatypes(TypeMapper types) {
                Stream.of(OWL.real, OWL.rational).forEach(d -> types.registerDatatype((RDFDatatype)new BaseDatatype(d.getURI())));
                OWL2_DATATYPES.forEach(iri -> types.getSafeTypeByName(iri.getURI()));
                HashSet res = new HashSet();
                types.listTypes().forEachRemaining(res::add);
                return Collections.unmodifiableSet(res);
            }
        }
    }
}

