/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.objects;

import com.github.owlcs.ontapi.AsNode;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.AsRDFNode;
import com.github.owlcs.ontapi.internal.objects.ONTObjectImpl;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.semanticweb.owlapi.model.OWLObject;

public abstract class ONTResourceImpl
extends ONTObjectImpl
implements OWLObject,
AsNode,
AsRDFNode {
    protected final Object node;

    protected ONTResourceImpl(Object n, Supplier<OntModel> m) {
        super(m);
        this.node = Objects.requireNonNull(n);
    }

    protected BlankNodeId getBlankNodeId() {
        throw new OntApiException.IllegalState();
    }

    protected String getURI() {
        throw new OntApiException.IllegalState();
    }

    protected LiteralLabel getLiteralLabel() {
        throw new OntApiException.IllegalState();
    }

    @Override
    public abstract Node asNode();

    public abstract OntObject asRDFNode();

    protected <X extends OntObject> X as(Class<X> type) {
        return (X)((OntObject)this.getPersonalityModel().getNodeAs(this.asNode(), type));
    }

    public Stream<Triple> triples() {
        return this.asRDFNode().spec().map(FrontsTriple::asTriple);
    }

    protected boolean sameAs(ONTResourceImpl other) {
        if (this.notSame(other)) {
            return false;
        }
        return this.node.equals(other.node);
    }
}

