/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.objects;

import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.objects.ONTComposite;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;

@ParametersAreNonnullByDefault
public abstract class ONTCollectors {
    public static OWLObjectVisitorEx<Set<OWLClass>> forClasses(Set<OWLClass> res) {
        return new SetCollector<OWLClass>(res){

            @Override
            protected boolean testComponent(ONTComposite x) {
                return x.canContainNamedClasses() || x.isNamedClass();
            }

            public Set<OWLClass> visit(OWLClass x) {
                this.res.add(x);
                return this.res;
            }
        };
    }

    public static OWLObjectVisitorEx<Boolean> forClass(final OWLClass clazz) {
        return new ContainsCollector(){

            @Override
            protected boolean testComponent(ONTComposite x) {
                return x.canContainNamedClasses() || x.isNamedClass();
            }

            public Boolean visit(OWLClass x) {
                return clazz.equals(x);
            }
        };
    }

    public static OWLObjectVisitorEx<Set<OWLAnonymousIndividual>> forAnonymousIndividuals(Set<OWLAnonymousIndividual> res) {
        return new SetCollector<OWLAnonymousIndividual>(res){

            @Override
            protected boolean testComponent(ONTComposite x) {
                return x.canContainAnonymousIndividuals() || x.isAnonymousIndividual();
            }

            public Set<OWLAnonymousIndividual> visit(OWLAnonymousIndividual x) {
                this.res.add(x);
                return this.res;
            }
        };
    }

    public static OWLObjectVisitorEx<Set<OWLNamedIndividual>> forNamedIndividuals(Set<OWLNamedIndividual> res) {
        return new SetCollector<OWLNamedIndividual>(res){

            @Override
            protected boolean testComponent(ONTComposite x) {
                return x.canContainNamedIndividuals() || x.isNamedIndividual();
            }

            public Set<OWLNamedIndividual> visit(OWLNamedIndividual x) {
                this.res.add(x);
                return this.res;
            }
        };
    }

    public static OWLObjectVisitorEx<Boolean> forNamedIndividual(final OWLNamedIndividual individual) {
        return new ContainsCollector(){

            @Override
            protected boolean testComponent(ONTComposite x) {
                return x.canContainNamedIndividuals() || x.isNamedIndividual();
            }

            public Boolean visit(OWLNamedIndividual x) {
                return individual.equals(x);
            }
        };
    }

    public static OWLObjectVisitorEx<Set<OWLDatatype>> forDatatypes(Set<OWLDatatype> res) {
        return new SetCollector<OWLDatatype>(res){

            @Override
            protected boolean testComponent(ONTComposite x) {
                return x.canContainDatatypes() || x.isDatatype();
            }

            public Set<OWLDatatype> visit(OWLDatatype x) {
                this.res.add(x);
                return this.res;
            }
        };
    }

    public static OWLObjectVisitorEx<Boolean> forDatatype(final OWLDatatype datatype) {
        return new ContainsCollector(){

            @Override
            protected boolean testComponent(ONTComposite x) {
                return x.canContainDatatypes() || x.isDatatype();
            }

            public Boolean visit(OWLDatatype x) {
                return datatype.equals(x);
            }
        };
    }

    public static OWLObjectVisitorEx<Set<OWLObjectProperty>> forObjectProperties(Set<OWLObjectProperty> res) {
        return new SetCollector<OWLObjectProperty>(res){

            @Override
            protected boolean testComponent(ONTComposite x) {
                return x.canContainObjectProperties() || x.isObjectProperty();
            }

            public Set<OWLObjectProperty> visit(OWLObjectProperty x) {
                this.res.add(x);
                return this.res;
            }
        };
    }

    public static OWLObjectVisitorEx<Boolean> forObjectProperty(final OWLObjectProperty property) {
        return new ContainsCollector(){

            @Override
            protected boolean testComponent(ONTComposite x) {
                return x.canContainObjectProperties() || x.isObjectProperty();
            }

            public Boolean visit(OWLObjectProperty x) {
                return property.equals(x);
            }
        };
    }

    public static OWLObjectVisitorEx<Set<OWLDataProperty>> forDataProperties(Set<OWLDataProperty> res) {
        return new SetCollector<OWLDataProperty>(res){

            @Override
            protected boolean testComponent(ONTComposite x) {
                return x.canContainDataProperties() || x.isDataProperty();
            }

            public Set<OWLDataProperty> visit(OWLDataProperty x) {
                this.res.add(x);
                return this.res;
            }
        };
    }

    public static OWLObjectVisitorEx<Boolean> forDataProperty(final OWLDataProperty property) {
        return new ContainsCollector(){

            @Override
            protected boolean testComponent(ONTComposite x) {
                return x.canContainDataProperties() || x.isDataProperty();
            }

            public Boolean visit(OWLDataProperty x) {
                return property.equals(x);
            }
        };
    }

    public static OWLObjectVisitorEx<Set<OWLAnnotationProperty>> forAnnotationProperties(Set<OWLAnnotationProperty> res) {
        return new SetCollector<OWLAnnotationProperty>(res){

            @Override
            protected boolean testComponent(ONTComposite x) {
                return x.canContainAnnotationProperties() || x.isAnnotationProperty();
            }

            public Set<OWLAnnotationProperty> visit(OWLAnnotationProperty x) {
                this.res.add(x);
                return this.res;
            }
        };
    }

    public static OWLObjectVisitorEx<Boolean> forAnnotationProperty(final OWLAnnotationProperty property) {
        return new ContainsCollector(){

            @Override
            protected boolean testComponent(ONTComposite x) {
                return x.canContainAnnotationProperties() || x.isAnnotationProperty();
            }

            public Boolean visit(OWLAnnotationProperty x) {
                return property.equals(x);
            }
        };
    }

    public static OWLObjectVisitorEx<Set<OWLClassExpression>> forClassExpressions(Set<OWLClassExpression> res) {
        return new ForClassExpressions(res);
    }

    public static OWLObjectVisitorEx<Set<OWLEntity>> forEntities(Set<OWLEntity> res) {
        return new ForEntities(res);
    }

    protected static class ForClassExpressions
    extends SetCollector<OWLClassExpression> {
        protected ForClassExpressions(Set<OWLClassExpression> res) {
            super(res);
        }

        @Override
        protected boolean testComponent(ONTComposite x) {
            return x.canContainClassExpressions() || x.isClassExpression();
        }

        public Set<OWLClassExpression> visit(OWLClass ce) {
            this.res.add(ce);
            return this.res;
        }

        public Set<OWLClassExpression> visit(OWLObjectIntersectionOf ce) {
            this.res.add(ce);
            return this.doDefault(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectUnionOf ce) {
            this.res.add(ce);
            return this.doDefault(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectOneOf ce) {
            this.res.add(ce);
            return this.res;
        }

        public Set<OWLClassExpression> visit(OWLObjectComplementOf ce) {
            this.res.add(ce);
            return this.doDefault(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectHasSelf ce) {
            this.res.add(ce);
            return this.res;
        }

        public Set<OWLClassExpression> visit(OWLObjectSomeValuesFrom ce) {
            this.res.add(ce);
            return this.doDefault(ce);
        }

        public Set<OWLClassExpression> visit(OWLDataSomeValuesFrom ce) {
            this.res.add(ce);
            return this.res;
        }

        public Set<OWLClassExpression> visit(OWLObjectAllValuesFrom ce) {
            this.res.add(ce);
            return this.doDefault(ce);
        }

        public Set<OWLClassExpression> visit(OWLDataAllValuesFrom ce) {
            this.res.add(ce);
            return this.res;
        }

        public Set<OWLClassExpression> visit(OWLObjectHasValue ce) {
            this.res.add(ce);
            return this.res;
        }

        public Set<OWLClassExpression> visit(OWLDataHasValue ce) {
            this.res.add(ce);
            return this.res;
        }

        public Set<OWLClassExpression> visit(OWLObjectMinCardinality ce) {
            this.res.add(ce);
            return this.doDefault(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectExactCardinality ce) {
            this.res.add(ce);
            return this.doDefault(ce);
        }

        public Set<OWLClassExpression> visit(OWLObjectMaxCardinality ce) {
            this.res.add(ce);
            return this.doDefault(ce);
        }

        public Set<OWLClassExpression> visit(OWLDataMinCardinality ce) {
            this.res.add(ce);
            return this.res;
        }

        public Set<OWLClassExpression> visit(OWLDataExactCardinality ce) {
            this.res.add(ce);
            return this.res;
        }

        public Set<OWLClassExpression> visit(OWLDataMaxCardinality ce) {
            this.res.add(ce);
            return this.res;
        }
    }

    protected static class ForEntities
    extends SetCollector<OWLEntity> {
        protected ForEntities(Set<OWLEntity> res) {
            super(res);
        }

        public Set<OWLEntity> visit(OWLClass clazz) {
            this.res.add(clazz);
            return this.res;
        }

        public Set<OWLEntity> visit(OWLNamedIndividual individual) {
            this.res.add(individual);
            return this.res;
        }

        public Set<OWLEntity> visit(OWLDatatype datatype) {
            this.res.add(datatype);
            return this.res;
        }

        public Set<OWLEntity> visit(OWLObjectProperty property) {
            this.res.add(property);
            return this.res;
        }

        public Set<OWLEntity> visit(OWLDataProperty property) {
            this.res.add(property);
            return this.res;
        }

        public Set<OWLEntity> visit(OWLAnnotationProperty property) {
            this.res.add(property);
            return this.res;
        }
    }

    public static abstract class ONTCollector<X>
    implements OWLObjectVisitorEx<X> {
        protected boolean testComponent(ONTComposite x) {
            return true;
        }

        protected Stream<ONTObject<? extends OWLObject>> components(Object o) {
            return ((ONTComposite)o).objects();
        }
    }

    public static abstract class ContainsCollector
    extends ONTCollector<Boolean> {
        public Boolean doDefault(Object object) {
            return this.components(object).anyMatch(x -> this.testComponent((ONTComposite)((Object)x)) && (Boolean)x.getOWLObject().accept((OWLObjectVisitorEx)this) != false);
        }
    }

    public static abstract class SetCollector<X extends OWLObject>
    extends ONTCollector<Set<X>> {
        protected final Set<X> res;

        public SetCollector(Set<X> res) {
            this.res = Objects.requireNonNull(res);
        }

        public Set<X> doDefault(Object object) {
            this.components(object).forEach(x -> {
                if (this.testComponent((ONTComposite)((Object)x))) {
                    x.getOWLObject().accept((OWLObjectVisitorEx)this);
                }
            });
            return this.res;
        }
    }
}

