/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.objects;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.objects.ModelObject;
import com.github.owlcs.ontapi.internal.objects.ONTDatatypeImpl;
import com.github.owlcs.ontapi.internal.objects.ONTExpressionImpl;
import com.github.owlcs.ontapi.internal.objects.ONTObjectImpl;
import com.github.owlcs.ontapi.internal.objects.WithContent;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.owlapi.objects.OWLLiteralImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.RDFNode;
import org.semanticweb.owlapi.model.HasComponents;
import org.semanticweb.owlapi.model.HasOperands;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;

public abstract class ONTAnonymousDataRangeImpl<ONT extends OntDataRange, OWL extends OWLDataRange>
extends ONTExpressionImpl<ONT>
implements OWLDataRange,
ModelObject<OWL> {
    protected ONTAnonymousDataRangeImpl(BlankNodeId id, Supplier<OntModel> m) {
        super(id, m);
    }

    public static ONTAnonymousDataRangeImpl create(OntDataRange dr, InternalObjectFactory factory, Supplier<OntModel> model) {
        Class<OntDataRange> type = OntModels.getOntType(dr);
        BlankNodeId id = dr.asNode().getBlankNodeId();
        ONTAnonymousDataRangeImpl<?, ?> res = ONTAnonymousDataRangeImpl.create(id, type, model);
        res.putContent(res.initContent(dr, factory));
        return res;
    }

    public static ONTAnonymousDataRangeImpl<?, ?> create(BlankNodeId id, Class<? extends OntDataRange> type, Supplier<OntModel> model) {
        if (OntDataRange.UnionOf.class == type) {
            return new UF(id, model);
        }
        if (OntDataRange.IntersectionOf.class == type) {
            return new IF(id, model);
        }
        if (OntDataRange.OneOf.class == type) {
            return new OF(id, model);
        }
        if (OntDataRange.Restriction.class == type) {
            return new R(id, model);
        }
        if (OntDataRange.ComplementOf.class == type) {
            return new CF(id, model);
        }
        throw new OntApiException.IllegalState();
    }

    @Override
    public OWL getOWLObject() {
        return (OWL)this;
    }

    @Override
    public boolean canContainNamedClasses() {
        return false;
    }

    @Override
    public boolean canContainNamedIndividuals() {
        return false;
    }

    @Override
    public boolean canContainDataProperties() {
        return false;
    }

    @Override
    public boolean canContainObjectProperties() {
        return false;
    }

    @Override
    public boolean canContainAnnotationProperties() {
        return false;
    }

    @Override
    public boolean canContainClassExpressions() {
        return false;
    }

    @Override
    public boolean canContainAnonymousIndividuals() {
        return false;
    }

    protected static abstract class WithMembers<ONT_M extends RDFNode, ONT_D extends OntDataRange.ComponentsDR<ONT_M>, OWL_M extends OWLObject, OWL_D extends OWLDataRange>
    extends ONTAnonymousDataRangeImpl<ONT_D, OWL_D>
    implements HasOperands<OWL_M>,
    HasComponents {
        protected WithMembers(BlankNodeId id, Supplier<OntModel> m) {
            super(id, m);
        }

        protected abstract ONTObject<? extends OWL_M> map(ONT_M var1, InternalObjectFactory var2);

        protected abstract Object toContentItem(ONTObject<? extends OWL_M> var1);

        protected abstract ONTObject<? extends OWL_M> fromContentItem(Object var1, InternalObjectFactory var2);

        public Stream<OWL_M> operands() {
            return this.members().map(ONTObject::getOWLObject);
        }

        public List<OWL_M> getOperandsAsList() {
            return this.operands().collect(Collectors.toList());
        }

        protected Stream<ONTObject<? extends OWL_M>> members() {
            return this.objects(this.getObjectFactory());
        }

        protected Stream<OWL_M> factoryObjects() {
            return this.operands().map(ONTObjectImpl::eraseModel);
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            return this.objects(this.getObjectFactory());
        }

        protected Stream<?> objects(InternalObjectFactory factory) {
            return Arrays.stream(this.getContent()).map(x -> this.fromContentItem(x, factory));
        }

        @Override
        protected Object[] collectContent(ONT_D dr, InternalObjectFactory factory) {
            Set<ONTObject<OWL_M>> operands = this.operands(dr, factory);
            Object[] res = new Object[operands.size()];
            int index = 0;
            for (ONTObject<OWL_M> op : operands) {
                res[index++] = this.toContentItem(op);
            }
            return res;
        }

        @Override
        protected Object[] initContent(ONT_D dr, InternalObjectFactory factory) {
            Set<ONTObject<OWL_M>> operands = this.operands(dr, factory);
            Object[] res = new Object[operands.size()];
            int index = 0;
            int hash = 1;
            for (ONTObject<OWL_M> op : operands) {
                res[index++] = this.toContentItem(op);
                hash = WithContent.hashIteration(hash, op.hashCode());
            }
            this.hashCode = OWLObject.hashIteration((int)this.hashIndex(), (int)hash);
            return res;
        }

        protected Set<ONTObject<? extends OWL_M>> operands(ONT_D dr, InternalObjectFactory factory) {
            Set<ONTObject<? extends OWL_M>> res = WithMembers.createContentSet();
            OntModels.listMembers(dr.getList()).forEachRemaining(e -> res.add(this.map(e, factory)));
            return res;
        }
    }

    protected static abstract class WithDRMembers<ONT extends OntDataRange.ComponentsDR<OntDataRange>, OWL extends OWLDataRange>
    extends WithMembers<OntDataRange, ONT, OWLDataRange, OWL> {
        protected WithDRMembers(BlankNodeId id, Supplier<OntModel> m) {
            super(id, m);
        }

        @Override
        protected ONTObject<? extends OWLDataRange> map(OntDataRange dr, InternalObjectFactory factory) {
            return factory.getDatatype(dr);
        }

        @Override
        protected Object toContentItem(ONTObject<? extends OWLDataRange> dr) {
            OWLDataRange res = dr.getOWLObject();
            return res.isOWLDatatype() ? res.asOWLDatatype().toStringID() : dr;
        }

        @Override
        protected ONTObject<? extends OWLDataRange> fromContentItem(Object item, InternalObjectFactory factory) {
            return this.toDR(item, factory);
        }
    }

    public static class CF
    extends ONTAnonymousDataRangeImpl<OntDataRange.ComplementOf, OWLDataComplementOf>
    implements OWLDataComplementOf {
        public CF(BlankNodeId id, Supplier<OntModel> m) {
            super(id, m);
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            return Stream.of(this.getONTDataRange());
        }

        @Override
        public OntDataRange.ComplementOf asRDFNode() {
            return this.as(OntDataRange.ComplementOf.class);
        }

        public OWLDataRange getDataRange() {
            return this.getONTDataRange().getOWLObject();
        }

        public ONTObject<? extends OWLDataRange> getONTDataRange() {
            return this.toDR(this.getContent()[0], this.getObjectFactory());
        }

        @Override
        protected Object[] collectContent(OntDataRange.ComplementOf dr, InternalObjectFactory factory) {
            return new Object[]{CF.toContentItem((OntDataRange)dr.getValue(), factory)};
        }

        @Override
        protected Object[] initContent(OntDataRange.ComplementOf dr, InternalObjectFactory factory) {
            OntDataRange value = (OntDataRange)dr.getValue();
            Object item = factory.getDatatype(value);
            this.hashCode = OWLObject.hashIteration((int)this.hashIndex(), (int)item.hashCode());
            if (value.isURIResource()) {
                item = value.getURI();
            }
            return new Object[]{item};
        }

        @Override
        public OWLDataComplementOf eraseModel() {
            return this.getDataFactory().getOWLDataComplementOf(CF.eraseModel(this.getDataRange()));
        }
    }

    public static class R
    extends ONTAnonymousDataRangeImpl<OntDataRange.Restriction, OWLDatatypeRestriction>
    implements OWLDatatypeRestriction {
        protected R(BlankNodeId id, Supplier<OntModel> m) {
            super(id, m);
        }

        @Override
        public OntDataRange.Restriction asRDFNode() {
            return this.as(OntDataRange.Restriction.class);
        }

        public OWLDatatype getDatatype() {
            return this.getONTDatatype().getOWLObject();
        }

        public ONTObject<OWLDatatype> getONTDatatype() {
            return this.findONTDatatype(this.getObjectFactory());
        }

        protected ONTObject<OWLDatatype> findONTDatatype(InternalObjectFactory factory) {
            return this.toDatatype(this.getContent()[0], factory);
        }

        private ONTObject<OWLDatatype> toDatatype(Object item, InternalObjectFactory factory) {
            return ONTDatatypeImpl.find((String)item, factory, this.model);
        }

        public Stream<OWLFacetRestriction> facetRestrictions() {
            return Arrays.stream(this.getContent()).skip(1L).map(x -> (OWLFacetRestriction)((ONTObject)x).getOWLObject());
        }

        protected Stream<OWLFacetRestriction> factoryObjects() {
            return this.facetRestrictions().map(ONTObjectImpl::eraseModel);
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            return this.objects(this.getObjectFactory());
        }

        protected Stream<?> objects(InternalObjectFactory factory) {
            return Stream.concat(Stream.of(this.toDatatype(this.getContent()[0], factory)), Arrays.stream(this.getContent()).skip(1L));
        }

        @Override
        protected Object[] collectContent(OntDataRange.Restriction dr, InternalObjectFactory factory) {
            Set<ONTObject<OWLFacetRestriction>> members = this.facetRestrictions(dr, factory);
            Object[] res = new Object[members.size() + 1];
            OntDataRange.Named dt = (OntDataRange.Named)dr.getValue();
            res[0] = dt.getURI();
            int index = 1;
            for (ONTObject<OWLFacetRestriction> op : members) {
                res[index++] = op;
            }
            return res;
        }

        @Override
        protected Object[] initContent(OntDataRange.Restriction dr, InternalObjectFactory factory) {
            Set<ONTObject<OWLFacetRestriction>> members = this.facetRestrictions(dr, factory);
            Object[] res = new Object[members.size() + 1];
            OntDataRange.Named dt = (OntDataRange.Named)dr.getValue();
            res[0] = dt.getURI();
            int hash = OWLObject.hashIteration((int)this.hashIndex(), (int)factory.getDatatype(dt).hashCode());
            int index = 1;
            int h = 1;
            for (ONTObject<OWLFacetRestriction> op : members) {
                res[index++] = op;
                h = WithContent.hashIteration(h, op.hashCode());
            }
            this.hashCode = OWLObject.hashIteration((int)hash, (int)h);
            return res;
        }

        protected Set<ONTObject<OWLFacetRestriction>> facetRestrictions(OntDataRange.Restriction dr, InternalObjectFactory factory) {
            Set<ONTObject<OWLFacetRestriction>> res = R.createContentSet();
            OntModels.listMembers(dr.getList()).mapWith(factory::getFacetRestriction).forEachRemaining(res::add);
            return res;
        }

        @Override
        public OWLDatatypeRestriction eraseModel() {
            return this.getDataFactory().getOWLDatatypeRestriction(R.eraseModel(this.getDatatype()), this.factoryObjects().collect(Collectors.toList()));
        }
    }

    public static class OF
    extends WithMembers<Literal, OntDataRange.OneOf, OWLLiteral, OWLDataOneOf>
    implements OWLDataOneOf {
        protected OF(BlankNodeId id, Supplier<OntModel> m) {
            super(id, m);
        }

        @Override
        public OntDataRange.OneOf asRDFNode() {
            return this.as(OntDataRange.OneOf.class);
        }

        @Override
        protected ONTObject<? extends OWLLiteral> map(Literal literal, InternalObjectFactory factory) {
            return factory.getLiteral(literal);
        }

        public Stream<OWLLiteral> values() {
            return this.operands();
        }

        @Override
        protected Object toContentItem(ONTObject<? extends OWLLiteral> literal) {
            return ((OWLLiteralImpl)((Object)literal)).getLiteralLabel();
        }

        @Override
        protected ONTObject<? extends OWLLiteral> fromContentItem(Object item, InternalObjectFactory factory) {
            return this.toLiteral(item, factory);
        }

        @Override
        public OWLDataOneOf eraseModel() {
            return this.getDataFactory().getOWLDataOneOf(this.factoryObjects());
        }
    }

    public static class IF
    extends WithDRMembers<OntDataRange.IntersectionOf, OWLDataIntersectionOf>
    implements OWLDataIntersectionOf {
        protected IF(BlankNodeId id, Supplier<OntModel> m) {
            super(id, m);
        }

        @Override
        public OntDataRange.IntersectionOf asRDFNode() {
            return this.as(OntDataRange.IntersectionOf.class);
        }

        @Override
        public OWLDataIntersectionOf eraseModel() {
            return this.getDataFactory().getOWLDataIntersectionOf(this.factoryObjects());
        }
    }

    public static class UF
    extends WithDRMembers<OntDataRange.UnionOf, OWLDataUnionOf>
    implements OWLDataUnionOf {
        protected UF(BlankNodeId id, Supplier<OntModel> m) {
            super(id, m);
        }

        @Override
        public OntDataRange.UnionOf asRDFNode() {
            return this.as(OntDataRange.UnionOf.class);
        }

        @Override
        public OWLDataUnionOf eraseModel() {
            return this.getDataFactory().getOWLDataUnionOf(this.factoryObjects());
        }
    }
}

