/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.objects;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.objects.ModelObject;
import com.github.owlcs.ontapi.internal.objects.ONTExpressionImpl;
import com.github.owlcs.ontapi.internal.objects.ONTObjectImpl;
import com.github.owlcs.ontapi.internal.objects.WithContent;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.owlapi.OWLObjectImpl;
import com.github.owlcs.ontapi.owlapi.objects.OWLAnonymousIndividualImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Literal;
import org.semanticweb.owlapi.model.HasComponents;
import org.semanticweb.owlapi.model.HasOperands;
import org.semanticweb.owlapi.model.OWLAnonymousClassExpression;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLRestriction;
import org.semanticweb.owlapi.util.NNF;

public abstract class ONTAnonymousClassExpressionImpl<ONT extends OntClass, OWL extends OWLAnonymousClassExpression>
extends ONTExpressionImpl<ONT>
implements OWLAnonymousClassExpression,
ModelObject<OWL> {
    protected ONTAnonymousClassExpressionImpl(BlankNodeId n, Supplier<OntModel> m) {
        super(n, m);
    }

    public static ONTAnonymousClassExpressionImpl create(OntClass ce, InternalObjectFactory factory, Supplier<OntModel> model) {
        Class<OntClass> type = OntModels.getOntType(ce);
        BlankNodeId id = ce.asNode().getBlankNodeId();
        ONTAnonymousClassExpressionImpl<?, ?> res = ONTAnonymousClassExpressionImpl.create(id, type, model);
        res.putContent(res.initContent(ce, factory));
        return res;
    }

    public static ONTAnonymousClassExpressionImpl<?, ?> create(BlankNodeId id, Class<? extends OntClass> type, Supplier<OntModel> model) {
        if (OntClass.ObjectSomeValuesFrom.class == type) {
            return new OSVF(id, model);
        }
        if (OntClass.DataSomeValuesFrom.class == type) {
            return new DSVF(id, model);
        }
        if (OntClass.ObjectAllValuesFrom.class == type) {
            return new OAVF(id, model);
        }
        if (OntClass.DataAllValuesFrom.class == type) {
            return new DAVF(id, model);
        }
        if (OntClass.ObjectHasValue.class == type) {
            return new OHV(id, model);
        }
        if (OntClass.DataHasValue.class == type) {
            return new DHV(id, model);
        }
        if (OntClass.HasSelf.class == type) {
            return new OHS(id, model);
        }
        if (OntClass.ObjectCardinality.class == type) {
            return new OEC(id, model);
        }
        if (OntClass.DataCardinality.class == type) {
            return new DEC(id, model);
        }
        if (OntClass.ObjectMinCardinality.class == type) {
            return new OMIC(id, model);
        }
        if (OntClass.DataMinCardinality.class == type) {
            return new DMIC(id, model);
        }
        if (OntClass.ObjectMaxCardinality.class == type) {
            return new OMAC(id, model);
        }
        if (OntClass.DataMaxCardinality.class == type) {
            return new DMAC(id, model);
        }
        if (OntClass.UnionOf.class == type) {
            return new UF(id, model);
        }
        if (OntClass.IntersectionOf.class == type) {
            return new IF(id, model);
        }
        if (OntClass.OneOf.class == type) {
            return new OF(id, model);
        }
        if (OntClass.ComplementOf.class == type) {
            return new CF(id, model);
        }
        if (OntClass.NaryDataSomeValuesFrom.class == type) {
            return new NDSVF(id, model);
        }
        if (OntClass.NaryDataAllValuesFrom.class == type) {
            return new NDAVF(id, model);
        }
        throw new OntApiException.IllegalState();
    }

    @Override
    public OWL getOWLObject() {
        return (OWL)this;
    }

    public boolean isOWLThing() {
        return false;
    }

    public boolean isOWLNothing() {
        return false;
    }

    @Override
    public boolean isClassExpression() {
        return true;
    }

    public OWLClassExpression getNNF() {
        return (OWLClassExpression)((OWLAnonymousClassExpression)this.eraseModel()).accept(this.getNNFClassVisitor());
    }

    public OWLClassExpression getComplementNNF() {
        return (OWLClassExpression)this.getObjectComplementOf().accept(this.getNNFClassVisitor());
    }

    protected OWLClassExpressionVisitorEx<OWLClassExpression> getNNFClassVisitor() {
        return new NNF((OWLDataFactory)this.getDataFactory()).getClassVisitor();
    }

    public OWLObjectComplementOf getObjectComplementOf() {
        return this.getDataFactory().getOWLObjectComplementOf((OWLClassExpression)this.eraseModel());
    }

    public Set<OWLClassExpression> asConjunctSet() {
        return ONTAnonymousClassExpressionImpl.createSet(this);
    }

    public Stream<OWLClassExpression> conjunctSet() {
        return Stream.of(this);
    }

    public boolean containsConjunct(@Nullable OWLClassExpression ce) {
        return this.equals(ce);
    }

    public Set<OWLClassExpression> asDisjunctSet() {
        return ONTAnonymousClassExpressionImpl.createSet(this);
    }

    public Stream<OWLClassExpression> disjunctSet() {
        return Stream.of(this);
    }

    @Override
    public boolean canContainAnnotationProperties() {
        return false;
    }

    protected static abstract class Simple<ONT extends OntClass, OWL extends OWLAnonymousClassExpression>
    extends ONTAnonymousClassExpressionImpl<ONT, OWL> {
        protected Simple(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        Object[] initContent(Node p, Object first) {
            this.hashCode = OWLObject.hashIteration((int)this.hashIndex(), (int)first.hashCode());
            return new Object[]{this.toFirstContentItem(p, first)};
        }

        Object toFirstContentItem(Node node, Object expr) {
            return node.isURI() ? node.getURI() : expr;
        }
    }

    protected static abstract class Restriction<ONT extends OntClass, OWL extends OWLAnonymousClassExpression>
    extends Simple<ONT, OWL> {
        protected Restriction(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        Object[] initContent(Node p, Node v, Object first, int c, Object last) {
            int res = OWLObject.hashIteration((int)this.hashIndex(), (int)first.hashCode());
            res = OWLObject.hashIteration((int)res, (int)c);
            this.hashCode = res = OWLObject.hashIteration((int)res, (int)last.hashCode());
            return new Object[]{this.toFirstContentItem(p, first), c, this.toLastContentItem(v, last)};
        }

        Object[] initContent(Node p, Node v, Object first, Object last) {
            int res = OWLObject.hashIteration((int)this.hashIndex(), (int)first.hashCode());
            this.hashCode = res = OWLObject.hashIteration((int)res, (int)last.hashCode());
            return new Object[]{this.toFirstContentItem(p, first), this.toLastContentItem(v, last)};
        }

        Object toLastContentItem(Node node, Object expr) {
            return node.isURI() ? node.getURI() : expr;
        }
    }

    protected static abstract class WithObjectProperty<ONT extends OntClass.RestrictionCE<OntObjectProperty>, OWL extends OWLRestriction>
    extends Restriction<ONT, OWL> {
        protected WithObjectProperty(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            return Stream.of(this.getONTObjectPropertyExpression());
        }

        public OWLObjectPropertyExpression getProperty() {
            return this.getONTObjectPropertyExpression().getOWLObject();
        }

        public ONTObject<? extends OWLObjectPropertyExpression> getONTObjectPropertyExpression() {
            return this.findOPE(this.getObjectFactory());
        }

        protected ONTObject<? extends OWLObjectPropertyExpression> findOPE(InternalObjectFactory factory) {
            return this.toOPE(this.getContent()[0], factory);
        }

        @Override
        protected Object[] collectContent(ONT ce, InternalObjectFactory factory) {
            return new Object[]{WithObjectProperty.toContentItem((OntObjectProperty)ce.getProperty(), factory)};
        }

        @Override
        protected Object[] initContent(ONT ce, InternalObjectFactory factory) {
            OntObjectProperty p = (OntObjectProperty)ce.getProperty();
            return this.initContent(p.asNode(), factory.getProperty(p));
        }
    }

    protected static abstract class WithClassAndObjectProperty<ONT extends OntClass.ComponentRestrictionCE<OntClass, OntObjectProperty>, OWL extends OWLRestriction>
    extends WithObjectProperty<ONT, OWL> {
        protected WithClassAndObjectProperty(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        public OWLClassExpression getFiller() {
            return this.getONTClassExpression().getOWLObject();
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            InternalObjectFactory factory = this.getObjectFactory();
            return Stream.of(this.findOPE(factory), this.findCE(factory));
        }

        public ONTObject<? extends OWLClassExpression> getONTClassExpression() {
            return this.findCE(this.getObjectFactory());
        }

        protected ONTObject<? extends OWLClassExpression> findCE(InternalObjectFactory factory) {
            Object[] array = this.getContent();
            return this.toCE(array[array.length - 1], factory);
        }

        @Override
        protected Object[] collectContent(ONT ce, InternalObjectFactory factory) {
            return new Object[]{WithClassAndObjectProperty.toContentItem((OntObjectProperty)ce.getProperty(), factory), WithClassAndObjectProperty.toContentItem((OntClass)ce.getValue(), factory)};
        }

        @Override
        protected Object[] initContent(ONT ce, InternalObjectFactory factory) {
            OntObjectProperty p = (OntObjectProperty)ce.getProperty();
            OntClass v = (OntClass)ce.getValue();
            return this.initContent(p.asNode(), v.asNode(), factory.getProperty(p), factory.getClass(v));
        }

        protected abstract OWL fromFactory(OWLObjectPropertyExpression var1, OWLClassExpression var2);

        @Override
        public OWL eraseModel() {
            return this.fromFactory(WithClassAndObjectProperty.eraseModel(this.getProperty()), WithClassAndObjectProperty.eraseModel(this.getFiller()));
        }
    }

    protected static abstract class WithClassAndObjectPropertyAndCardinality<ONT extends OntClass.CardinalityRestrictionCE<OntClass, OntObjectProperty>, OWL extends OWLRestriction>
    extends WithClassAndObjectProperty<ONT, OWL> {
        protected WithClassAndObjectPropertyAndCardinality(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        public int getCardinality() {
            return (Integer)this.getContent()[1];
        }

        @Override
        protected Object[] collectContent(ONT ce, InternalObjectFactory factory) {
            return new Object[]{WithClassAndObjectPropertyAndCardinality.toContentItem((OntObjectProperty)ce.getProperty(), factory), ce.getCardinality(), WithClassAndObjectPropertyAndCardinality.toContentItem((OntClass)ce.getValue(), factory)};
        }

        @Override
        protected Object[] initContent(ONT ce, InternalObjectFactory factory) {
            OntObjectProperty p = (OntObjectProperty)ce.getProperty();
            OntClass v = (OntClass)ce.getValue();
            int c = ce.getCardinality();
            return this.initContent(p.asNode(), v.asNode(), factory.getProperty(p), c, factory.getClass(v));
        }
    }

    protected static abstract class WithDataProperty<ONT extends OntClass.RestrictionCE<OntDataProperty>, OWL extends OWLRestriction>
    extends Restriction<ONT, OWL> {
        protected WithDataProperty(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        public OWLDataProperty getProperty() {
            return this.getONTDataProperty().getOWLObject();
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            return Stream.of(this.getONTDataProperty());
        }

        public ONTObject<OWLDataProperty> getONTDataProperty() {
            return this.findNDP(this.getObjectFactory());
        }

        protected ONTObject<OWLDataProperty> findNDP(InternalObjectFactory factory) {
            return this.toNDP(this.getContent()[0], factory);
        }

        @Override
        protected Object[] collectContent(ONT ce, InternalObjectFactory factory) {
            return new Object[]{WithDataProperty.toContentItem((OntDataProperty)ce.getProperty())};
        }

        @Override
        protected Object[] initContent(ONT ce, InternalObjectFactory factory) {
            OntDataProperty p = (OntDataProperty)ce.getProperty();
            return this.initContent(p.asNode(), factory.getProperty(p));
        }

        @Override
        public boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public boolean canContainNamedIndividuals() {
            return false;
        }

        @Override
        public boolean canContainObjectProperties() {
            return false;
        }

        @Override
        public Set<OWLClassExpression> getClassExpressionSet() {
            return WithDataProperty.createSet(this);
        }

        @Override
        public boolean canContainAnonymousIndividuals() {
            return false;
        }
    }

    protected static abstract class WithDataRangeAndDataProperty<ONT extends OntClass.RestrictionCE<OntDataProperty>, OWL extends OWLRestriction>
    extends WithDataProperty<ONT, OWL> {
        protected WithDataRangeAndDataProperty(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        public OWLDataRange getFiller() {
            return this.getONTDataRange().getOWLObject();
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            InternalObjectFactory factory = this.getObjectFactory();
            return Stream.of(this.findNDP(factory), this.findDR(factory));
        }

        public ONTObject<? extends OWLDataRange> getONTDataRange() {
            return this.findDR(this.getObjectFactory());
        }

        protected ONTObject<? extends OWLDataRange> findDR(InternalObjectFactory factory) {
            Object[] array = this.getContent();
            return this.toDR(array[array.length - 1], factory);
        }

        @Override
        protected Object[] collectContent(ONT ce, InternalObjectFactory factory) {
            return new Object[]{WithDataRangeAndDataProperty.toContentItem((OntDataProperty)ce.getProperty()), WithDataRangeAndDataProperty.toContentItem(this.getValue(ce), factory)};
        }

        protected abstract OntDataRange getValue(ONT var1);

        @Override
        protected Object[] initContent(ONT ce, InternalObjectFactory factory) {
            OntDataProperty p = (OntDataProperty)ce.getProperty();
            OntDataRange v = this.getValue(ce);
            return this.initContent(p.asNode(), v.asNode(), factory.getProperty(p), factory.getDatatype(v));
        }

        protected abstract OWL fromFactory(OWLDataProperty var1, OWLDataRange var2);

        @Override
        public OWL eraseModel() {
            return this.fromFactory(WithDataRangeAndDataProperty.eraseModel(this.getProperty()), WithDataRangeAndDataProperty.eraseModel(this.getFiller()));
        }
    }

    protected static abstract class WithDataRangeAndDataPropertyUnary<ONT extends OntClass.ComponentRestrictionCE<OntDataRange, OntDataProperty>, OWL extends OWLRestriction>
    extends WithDataRangeAndDataProperty<ONT, OWL> {
        protected WithDataRangeAndDataPropertyUnary(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        protected OntDataRange getValue(ONT ce) {
            return (OntDataRange)ce.getValue();
        }
    }

    protected static abstract class WithDataRangeAndDataPropertyNary<ONT extends OntClass.NaryRestrictionCE<OntDataRange, OntDataProperty>, OWL extends OWLRestriction>
    extends WithDataRangeAndDataProperty<ONT, OWL> {
        protected WithDataRangeAndDataPropertyNary(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        protected OntDataRange getValue(ONT ce) {
            return (OntDataRange)ce.getValue();
        }
    }

    protected static abstract class WithDataRangeAndDataPropertyAndCardinality<ONT extends OntClass.CardinalityRestrictionCE<OntDataRange, OntDataProperty>, OWL extends OWLRestriction>
    extends WithDataRangeAndDataPropertyUnary<ONT, OWL> {
        protected WithDataRangeAndDataPropertyAndCardinality(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        public int getCardinality() {
            return (Integer)this.getContent()[1];
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            return Stream.of(this.getONTDataProperty(), this.getONTDataRange());
        }

        @Override
        protected Object[] collectContent(ONT ce, InternalObjectFactory factory) {
            return new Object[]{WithDataRangeAndDataPropertyAndCardinality.toContentItem((OntDataProperty)ce.getProperty()), ce.getCardinality(), WithDataRangeAndDataPropertyAndCardinality.toContentItem((OntDataRange)ce.getValue(), factory)};
        }

        @Override
        protected Object[] initContent(ONT ce, InternalObjectFactory factory) {
            OntDataProperty p = (OntDataProperty)ce.getProperty();
            OntDataRange v = (OntDataRange)ce.getValue();
            int c = ce.getCardinality();
            return this.initContent(p.asNode(), v.asNode(), factory.getProperty(p), c, factory.getDatatype(v));
        }
    }

    protected static abstract class WithMembers<ONT_M extends OntObject, ONT_C extends OntClass.ComponentsCE<ONT_M>, OWL_M extends OWLObject, OWL_C extends OWLAnonymousClassExpression>
    extends ONTAnonymousClassExpressionImpl<ONT_C, OWL_C>
    implements HasOperands<OWL_M>,
    HasComponents {
        protected WithMembers(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        protected abstract ONTObject<? extends OWL_M> map(ONT_M var1, InternalObjectFactory var2);

        protected abstract Object toContentItem(ONTObject<? extends OWL_M> var1);

        protected abstract ONTObject<? extends OWL_M> fromContentItem(Object var1, InternalObjectFactory var2);

        public Stream<OWL_M> operands() {
            return this.members().map(ONTObject::getOWLObject);
        }

        protected Stream<OWL_M> factoryObjects() {
            return this.operands().map(ONTObjectImpl::eraseModel);
        }

        public List<OWL_M> getOperandsAsList() {
            return this.operands().collect(Collectors.toList());
        }

        protected Stream<ONTObject<? extends OWL_M>> members() {
            return this.objects(this.getObjectFactory());
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            return this.objects(this.getObjectFactory());
        }

        protected Stream<?> objects(InternalObjectFactory factory) {
            return Arrays.stream(this.getContent()).map(x -> this.fromContentItem(x, factory));
        }

        @Override
        protected Object[] collectContent(ONT_C ce, InternalObjectFactory factory) {
            Set<ONTObject<OWL_M>> operands = this.operands(ce, factory);
            Object[] res = new Object[operands.size()];
            int index = 0;
            for (ONTObject<OWL_M> op : operands) {
                res[index++] = this.toContentItem(op);
            }
            return res;
        }

        @Override
        protected Object[] initContent(ONT_C ce, InternalObjectFactory factory) {
            Set<ONTObject<OWL_M>> operands = this.operands(ce, factory);
            Object[] res = new Object[operands.size()];
            int index = 0;
            int hash = 1;
            for (ONTObject<OWL_M> op : operands) {
                res[index++] = this.toContentItem(op);
                hash = WithContent.hashIteration(hash, op.hashCode());
            }
            this.hashCode = OWLObject.hashIteration((int)this.hashIndex(), (int)hash);
            return res;
        }

        protected Set<ONTObject<? extends OWL_M>> operands(ONT_C ce, InternalObjectFactory factory) {
            Set<ONTObject<? extends OWL_M>> res = WithMembers.createContentSet();
            OntModels.listMembers(ce.getList()).forEachRemaining(e -> res.add(this.map(e, factory)));
            return res;
        }
    }

    protected static abstract class WithClassMembers<ONT extends OntClass.ComponentsCE<OntClass>, OWL extends OWLAnonymousClassExpression>
    extends WithMembers<OntClass, ONT, OWLClassExpression, OWL> {
        protected WithClassMembers(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        protected Object toContentItem(ONTObject<? extends OWLClassExpression> ce) {
            OWLClassExpression res = ce.getOWLObject();
            return res.isOWLClass() ? res.asOWLClass().toStringID() : ce;
        }

        @Override
        protected ONTObject<? extends OWLClassExpression> fromContentItem(Object item, InternalObjectFactory factory) {
            return this.toCE(item, factory);
        }

        @Override
        protected ONTObject<? extends OWLClassExpression> map(OntClass member, InternalObjectFactory factory) {
            return factory.getClass(member);
        }
    }

    public static class CF
    extends Simple<OntClass.ComplementOf, OWLObjectComplementOf>
    implements OWLObjectComplementOf {
        public CF(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        public boolean isClassExpressionLiteral() {
            return this.getONTClassExpression().getOWLObject().isOWLClass();
        }

        @Override
        public OntClass.ComplementOf asRDFNode() {
            return this.as(OntClass.ComplementOf.class);
        }

        public OWLClassExpression getOperand() {
            return this.getONTClassExpression().getOWLObject();
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            return Stream.of(this.getONTClassExpression());
        }

        protected ONTObject<? extends OWLClassExpression> getONTClassExpression() {
            return this.findCE(this.getObjectFactory());
        }

        protected ONTObject<? extends OWLClassExpression> findCE(InternalObjectFactory factory) {
            return this.toCE(this.getContent()[0], factory);
        }

        @Override
        protected Object[] collectContent(OntClass.ComplementOf ce, InternalObjectFactory factory) {
            return new Object[]{CF.toContentItem((OntClass)ce.getValue(), factory)};
        }

        @Override
        protected Object[] initContent(OntClass.ComplementOf ce, InternalObjectFactory factory) {
            OntClass c = (OntClass)ce.getValue();
            return this.initContent(c.asNode(), factory.getClass(c));
        }

        @Override
        public OWLObjectComplementOf eraseModel() {
            return this.getDataFactory().getOWLObjectComplementOf(CF.eraseModel(this.getOperand()));
        }
    }

    public static class OF
    extends WithMembers<OntIndividual, OntClass.OneOf, OWLIndividual, OWLObjectOneOf>
    implements OWLObjectOneOf {
        public OF(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        protected ONTObject<? extends OWLIndividual> map(OntIndividual member, InternalObjectFactory factory) {
            return factory.getIndividual(member);
        }

        @Override
        protected Object toContentItem(ONTObject<? extends OWLIndividual> individual) {
            if (!individual.getOWLObject().isOWLNamedIndividual()) {
                return ((OWLAnonymousIndividualImpl)((Object)individual)).getBlankNodeId();
            }
            return individual.getOWLObject().asOWLNamedIndividual().toStringID();
        }

        @Override
        protected ONTObject<? extends OWLIndividual> fromContentItem(Object item, InternalObjectFactory factory) {
            return this.toIndividual(item, factory);
        }

        @Override
        public OntClass.OneOf asRDFNode() {
            return this.as(OntClass.OneOf.class);
        }

        public Stream<OWLIndividual> individuals() {
            return this.operands();
        }

        public OWLClassExpression asObjectUnionOf() {
            Collection values = this.factoryObjects().collect(Collectors.toSet());
            DataFactory df = this.getDataFactory();
            if (values.size() == 1) {
                return df.getOWLObjectOneOf(values);
            }
            return df.getOWLObjectUnionOf(values.stream().map(xva$0 -> df.getOWLObjectOneOf(new OWLIndividual[]{xva$0})));
        }

        @Override
        public OWLObjectOneOf eraseModel() {
            return this.getDataFactory().getOWLObjectOneOf(this.factoryObjects());
        }

        @Override
        public boolean containsNamedIndividual(OWLNamedIndividual individual) {
            return this.namedIndividuals().anyMatch(individual::equals);
        }

        @Override
        public Set<OWLEntity> getSignatureSet() {
            return this.namedIndividuals().collect(Collectors.toCollection(OWLObjectImpl::createSortedSet));
        }

        @Override
        public Set<OWLNamedIndividual> getNamedIndividualSet() {
            return this.namedIndividuals().collect(Collectors.toCollection(OWLObjectImpl::createSortedSet));
        }

        @Override
        public Set<OWLAnonymousIndividual> getAnonymousIndividualSet() {
            return this.objectIndividuals().map(x -> ((OWLIndividual)x.getOWLObject()).isOWLNamedIndividual() ? null : ((OWLIndividual)x.getOWLObject()).asOWLAnonymousIndividual()).filter(Objects::nonNull).collect(Collectors.toCollection(OWLObjectImpl::createSortedSet));
        }

        protected Stream<OWLNamedIndividual> namedIndividuals() {
            return this.objectIndividuals().map(x -> ((OWLIndividual)x.getOWLObject()).isOWLNamedIndividual() ? ((OWLIndividual)x.getOWLObject()).asOWLNamedIndividual() : null).filter(Objects::nonNull);
        }

        protected Stream<ONTObject<? extends OWLIndividual>> objectIndividuals() {
            return this.objects(this.getObjectFactory());
        }

        @Override
        public Set<OWLClassExpression> getClassExpressionSet() {
            return OF.createSet(this);
        }

        @Override
        public boolean canContainDataProperties() {
            return false;
        }

        @Override
        public boolean canContainObjectProperties() {
            return false;
        }

        @Override
        public boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public boolean canContainDatatypes() {
            return false;
        }
    }

    public static class IF
    extends WithClassMembers<OntClass.IntersectionOf, OWLObjectIntersectionOf>
    implements OWLObjectIntersectionOf {
        public IF(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntClass.IntersectionOf asRDFNode() {
            return this.as(OntClass.IntersectionOf.class);
        }

        @Override
        public Set<OWLClassExpression> asConjunctSet() {
            Set<OWLClassExpression> res = IF.createSortedSet();
            this.members().forEach(x -> res.addAll(((OWLClassExpression)x.getOWLObject()).asConjunctSet()));
            return res;
        }

        @Override
        public Stream<OWLClassExpression> conjunctSet() {
            return this.asConjunctSet().stream();
        }

        @Override
        public boolean containsConjunct(@Nullable OWLClassExpression ce) {
            return this.asConjunctSet().contains(ce);
        }

        @Override
        public OWLObjectIntersectionOf eraseModel() {
            return this.getDataFactory().getOWLObjectIntersectionOf(this.factoryObjects());
        }
    }

    public static class UF
    extends WithClassMembers<OntClass.UnionOf, OWLObjectUnionOf>
    implements OWLObjectUnionOf {
        public UF(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntClass.UnionOf asRDFNode() {
            return this.as(OntClass.UnionOf.class);
        }

        @Override
        public Set<OWLClassExpression> asDisjunctSet() {
            Set<OWLClassExpression> res = UF.createSortedSet();
            this.members().forEach(x -> res.addAll(((OWLClassExpression)x.getOWLObject()).asDisjunctSet()));
            return res;
        }

        @Override
        public Stream<OWLClassExpression> disjunctSet() {
            return this.asDisjunctSet().stream();
        }

        @Override
        public OWLObjectUnionOf eraseModel() {
            return this.getDataFactory().getOWLObjectUnionOf(this.factoryObjects());
        }
    }

    public static class DMAC
    extends WithDataRangeAndDataPropertyAndCardinality<OntClass.DataMaxCardinality, OWLDataMaxCardinality>
    implements OWLDataMaxCardinality {
        public DMAC(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntClass.DataMaxCardinality asRDFNode() {
            return this.as(OntClass.DataMaxCardinality.class);
        }

        @Override
        protected OWLDataMaxCardinality fromFactory(OWLDataProperty p, OWLDataRange d) {
            return this.getDataFactory().getOWLDataMaxCardinality(this.getCardinality(), (OWLDataPropertyExpression)p, d);
        }
    }

    public static class OMAC
    extends WithClassAndObjectPropertyAndCardinality<OntClass.ObjectMaxCardinality, OWLObjectMaxCardinality>
    implements OWLObjectMaxCardinality {
        public OMAC(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntClass.ObjectMaxCardinality asRDFNode() {
            return this.as(OntClass.ObjectMaxCardinality.class);
        }

        @Override
        public OWLObjectMaxCardinality fromFactory(OWLObjectPropertyExpression p, OWLClassExpression c) {
            return this.getDataFactory().getOWLObjectMaxCardinality(this.getCardinality(), p, c);
        }
    }

    public static class DMIC
    extends WithDataRangeAndDataPropertyAndCardinality<OntClass.DataMinCardinality, OWLDataMinCardinality>
    implements OWLDataMinCardinality {
        public DMIC(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntClass.DataMinCardinality asRDFNode() {
            return this.as(OntClass.DataMinCardinality.class);
        }

        @Override
        protected OWLDataMinCardinality fromFactory(OWLDataProperty p, OWLDataRange d) {
            return this.getDataFactory().getOWLDataMinCardinality(this.getCardinality(), (OWLDataPropertyExpression)p, d);
        }
    }

    public static class OMIC
    extends WithClassAndObjectPropertyAndCardinality<OntClass.ObjectMinCardinality, OWLObjectMinCardinality>
    implements OWLObjectMinCardinality {
        public OMIC(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntClass.ObjectMinCardinality asRDFNode() {
            return this.as(OntClass.ObjectMinCardinality.class);
        }

        @Override
        public OWLObjectMinCardinality fromFactory(OWLObjectPropertyExpression p, OWLClassExpression c) {
            return this.getDataFactory().getOWLObjectMinCardinality(this.getCardinality(), p, c);
        }
    }

    public static class DEC
    extends WithDataRangeAndDataPropertyAndCardinality<OntClass.DataCardinality, OWLDataExactCardinality>
    implements OWLDataExactCardinality {
        public DEC(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntClass.DataCardinality asRDFNode() {
            return this.as(OntClass.DataCardinality.class);
        }

        public OWLObjectIntersectionOf asIntersectionOfMinMax() {
            DataFactory df = this.getDataFactory();
            OWLDataProperty p = DEC.eraseModel(this.getProperty());
            OWLDataRange c = DEC.eraseModel(this.getFiller());
            int q = this.getCardinality();
            return df.getOWLObjectIntersectionOf(new OWLClassExpression[]{df.getOWLDataMinCardinality(q, (OWLDataPropertyExpression)p, c), df.getOWLDataMaxCardinality(q, (OWLDataPropertyExpression)p, c)});
        }

        @Override
        protected OWLDataExactCardinality fromFactory(OWLDataProperty p, OWLDataRange d) {
            return this.getDataFactory().getOWLDataExactCardinality(this.getCardinality(), (OWLDataPropertyExpression)p, d);
        }
    }

    public static class OEC
    extends WithClassAndObjectPropertyAndCardinality<OntClass.ObjectCardinality, OWLObjectExactCardinality>
    implements OWLObjectExactCardinality {
        public OEC(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntClass.ObjectCardinality asRDFNode() {
            return this.as(OntClass.ObjectCardinality.class);
        }

        public OWLObjectIntersectionOf asIntersectionOfMinMax() {
            DataFactory df = this.getDataFactory();
            OWLObjectPropertyExpression p = OEC.eraseModel(this.getProperty());
            OWLClassExpression c = OEC.eraseModel(this.getFiller());
            int q = this.getCardinality();
            return df.getOWLObjectIntersectionOf(new OWLClassExpression[]{df.getOWLObjectMinCardinality(q, p, c), df.getOWLObjectMaxCardinality(q, p, c)});
        }

        @Override
        public OWLObjectExactCardinality fromFactory(OWLObjectPropertyExpression p, OWLClassExpression c) {
            return this.getDataFactory().getOWLObjectExactCardinality(this.getCardinality(), p, c);
        }
    }

    public static class OHS
    extends WithObjectProperty<OntClass.HasSelf, OWLObjectHasSelf>
    implements OWLObjectHasSelf {
        protected OHS(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntClass.HasSelf asRDFNode() {
            return this.as(OntClass.HasSelf.class);
        }

        @Override
        public boolean containsObjectProperty(OWLObjectProperty property) {
            return this.getNamedProperty().equals(property);
        }

        @Override
        public Set<OWLEntity> getSignatureSet() {
            return OHS.createSet(this.getNamedProperty());
        }

        @Override
        public Set<OWLObjectProperty> getObjectPropertySet() {
            return OHS.createSet(this.getNamedProperty());
        }

        protected OWLObjectProperty getNamedProperty() {
            return this.getProperty().getNamedProperty();
        }

        @Override
        public boolean canContainNamedIndividuals() {
            return false;
        }

        @Override
        public boolean canContainAnonymousIndividuals() {
            return false;
        }

        @Override
        public Set<OWLClassExpression> getClassExpressionSet() {
            return OHS.createSet(this);
        }

        @Override
        public boolean canContainDataProperties() {
            return false;
        }

        @Override
        public boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public boolean canContainDatatypes() {
            return false;
        }

        @Override
        public OWLObjectHasSelf eraseModel() {
            return this.getDataFactory().getOWLObjectHasSelf(OHS.eraseModel(this.getProperty()));
        }
    }

    public static class DHV
    extends WithDataProperty<OntClass.DataHasValue, OWLDataHasValue>
    implements OWLDataHasValue {
        protected DHV(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntClass.DataHasValue asRDFNode() {
            return this.as(OntClass.DataHasValue.class);
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            InternalObjectFactory factory = this.getObjectFactory();
            return Stream.of(this.findNDP(factory), this.findLiteral(factory));
        }

        public OWLDataSomeValuesFrom asSomeValuesFrom() {
            DataFactory df = this.getDataFactory();
            return df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)DHV.eraseModel(this.getProperty()), (OWLDataRange)df.getOWLDataOneOf(new OWLLiteral[]{DHV.eraseModel(this.getFiller())}));
        }

        public OWLLiteral getFiller() {
            return this.getONTLiteral().getOWLObject();
        }

        public ONTObject<OWLLiteral> getONTLiteral() {
            return this.findLiteral(this.getObjectFactory());
        }

        protected ONTObject<OWLLiteral> findLiteral(InternalObjectFactory factory) {
            return this.toLiteral(this.getContent()[1], factory);
        }

        @Override
        protected Object[] collectContent(OntClass.DataHasValue ce, InternalObjectFactory factory) {
            return new Object[]{DHV.toContentItem((OntDataProperty)ce.getProperty()), DHV.toContentItem((Literal)ce.getValue())};
        }

        @Override
        protected Object[] initContent(OntClass.DataHasValue ce, InternalObjectFactory factory) {
            OntDataProperty p = (OntDataProperty)ce.getProperty();
            Literal v = (Literal)ce.getValue();
            return this.initContent(p.asNode(), v.asNode(), factory.getProperty(p), factory.getLiteral(v));
        }

        @Override
        Object toLastContentItem(Node node, Object expr) {
            return node.getLiteral();
        }

        @Override
        public OWLDataHasValue eraseModel() {
            return this.getDataFactory().getOWLDataHasValue((OWLDataPropertyExpression)DHV.eraseModel(this.getProperty()), DHV.eraseModel(this.getFiller()));
        }
    }

    public static class OHV
    extends WithObjectProperty<OntClass.ObjectHasValue, OWLObjectHasValue>
    implements OWLObjectHasValue {
        protected OHV(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntClass.ObjectHasValue asRDFNode() {
            return this.as(OntClass.ObjectHasValue.class);
        }

        @Override
        public Stream<ONTObject<? extends OWLObject>> objects() {
            InternalObjectFactory factory = this.getObjectFactory();
            return Stream.of(this.findOPE(factory), this.findIndividual(factory));
        }

        public OWLObjectSomeValuesFrom asSomeValuesFrom() {
            DataFactory df = this.getDataFactory();
            return df.getOWLObjectSomeValuesFrom(OHV.eraseModel(this.getProperty()), (OWLClassExpression)df.getOWLObjectOneOf(new OWLIndividual[]{OHV.eraseModel(this.getFiller())}));
        }

        public OWLIndividual getFiller() {
            return this.getONTIndividual().getOWLObject();
        }

        public ONTObject<? extends OWLIndividual> getONTIndividual() {
            return this.findIndividual(this.getObjectFactory());
        }

        protected ONTObject<? extends OWLIndividual> findIndividual(InternalObjectFactory factory) {
            return this.toIndividual(this.getContent()[1], factory);
        }

        @Override
        protected Object[] collectContent(OntClass.ObjectHasValue ce, InternalObjectFactory factory) {
            return new Object[]{OHV.toContentItem((OntObjectProperty)ce.getProperty(), factory), OHV.toContentItem((OntIndividual)ce.getValue())};
        }

        @Override
        protected Object[] initContent(OntClass.ObjectHasValue ce, InternalObjectFactory factory) {
            OntObjectProperty p = (OntObjectProperty)ce.getProperty();
            OntIndividual v = (OntIndividual)ce.getValue();
            return this.initContent(p.asNode(), v.asNode(), factory.getProperty(p), factory.getIndividual(v));
        }

        @Override
        Object toLastContentItem(Node node, Object expr) {
            return node.isURI() ? node.getURI() : node.getBlankNodeId();
        }

        @Override
        public boolean containsObjectProperty(OWLObjectProperty property) {
            return this.getNamedProperty().equals(property);
        }

        @Override
        public boolean containsNamedIndividual(OWLNamedIndividual individual) {
            OWLIndividual i = this.getFiller();
            return i.isOWLNamedIndividual() && individual.equals(i);
        }

        @Override
        public Set<OWLEntity> getSignatureSet() {
            Set<OWLEntity> res = OHV.createSortedSet();
            res.add((OWLEntity)this.getNamedProperty());
            OWLIndividual i = this.getFiller();
            if (i.isOWLNamedIndividual()) {
                res.add((OWLEntity)i.asOWLNamedIndividual());
            }
            return res;
        }

        @Override
        public Set<OWLObjectProperty> getObjectPropertySet() {
            return OHV.createSet(this.getNamedProperty());
        }

        protected OWLObjectProperty getNamedProperty() {
            return this.getProperty().getNamedProperty();
        }

        @Override
        public Set<OWLNamedIndividual> getNamedIndividualSet() {
            OWLIndividual i = this.getFiller();
            return i.isOWLNamedIndividual() ? OHV.createSet(i.asOWLNamedIndividual()) : OHV.createSet();
        }

        @Override
        public Set<OWLAnonymousIndividual> getAnonymousIndividualSet() {
            OWLIndividual i = this.getFiller();
            return i.isOWLNamedIndividual() ? OHV.createSet() : OHV.createSet(i.asOWLAnonymousIndividual());
        }

        @Override
        public Set<OWLClassExpression> getClassExpressionSet() {
            return OHV.createSet(this);
        }

        @Override
        public boolean canContainDataProperties() {
            return false;
        }

        @Override
        public boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public boolean canContainDatatypes() {
            return false;
        }

        @Override
        public OWLObjectHasValue eraseModel() {
            return this.getDataFactory().getOWLObjectHasValue(OHV.eraseModel(this.getProperty()), OHV.eraseModel(this.getFiller()));
        }
    }

    public static class NDAVF
    extends WithDataRangeAndDataPropertyNary<OntClass.NaryDataAllValuesFrom, OWLDataAllValuesFrom>
    implements OWLDataAllValuesFrom {
        public NDAVF(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntClass.NaryDataAllValuesFrom asRDFNode() {
            return this.as(OntClass.NaryDataAllValuesFrom.class);
        }

        @Override
        protected OWLDataAllValuesFrom fromFactory(OWLDataProperty p, OWLDataRange d) {
            return this.getDataFactory().getOWLDataAllValuesFrom((OWLDataPropertyExpression)p, d);
        }
    }

    public static class NDSVF
    extends WithDataRangeAndDataPropertyNary<OntClass.NaryDataSomeValuesFrom, OWLDataSomeValuesFrom>
    implements OWLDataSomeValuesFrom {
        public NDSVF(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntClass.NaryDataSomeValuesFrom asRDFNode() {
            return this.as(OntClass.NaryDataSomeValuesFrom.class);
        }

        @Override
        protected OWLDataSomeValuesFrom fromFactory(OWLDataProperty p, OWLDataRange d) {
            return this.getDataFactory().getOWLDataSomeValuesFrom((OWLDataPropertyExpression)p, d);
        }
    }

    public static class DAVF
    extends WithDataRangeAndDataPropertyUnary<OntClass.DataAllValuesFrom, OWLDataAllValuesFrom>
    implements OWLDataAllValuesFrom {
        public DAVF(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntClass.DataAllValuesFrom asRDFNode() {
            return this.as(OntClass.DataAllValuesFrom.class);
        }

        @Override
        protected OWLDataAllValuesFrom fromFactory(OWLDataProperty p, OWLDataRange d) {
            return this.getDataFactory().getOWLDataAllValuesFrom((OWLDataPropertyExpression)p, d);
        }
    }

    public static class DSVF
    extends WithDataRangeAndDataPropertyUnary<OntClass.DataSomeValuesFrom, OWLDataSomeValuesFrom>
    implements OWLDataSomeValuesFrom {
        public DSVF(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntClass.DataSomeValuesFrom asRDFNode() {
            return this.as(OntClass.DataSomeValuesFrom.class);
        }

        @Override
        protected OWLDataSomeValuesFrom fromFactory(OWLDataProperty p, OWLDataRange d) {
            return this.getDataFactory().getOWLDataSomeValuesFrom((OWLDataPropertyExpression)p, d);
        }
    }

    public static class OAVF
    extends WithClassAndObjectProperty<OntClass.ObjectAllValuesFrom, OWLObjectAllValuesFrom>
    implements OWLObjectAllValuesFrom {
        public OAVF(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntClass.ObjectAllValuesFrom asRDFNode() {
            return this.as(OntClass.ObjectAllValuesFrom.class);
        }

        @Override
        protected OWLObjectAllValuesFrom fromFactory(OWLObjectPropertyExpression p, OWLClassExpression c) {
            return this.getDataFactory().getOWLObjectAllValuesFrom(p, c);
        }
    }

    public static class OSVF
    extends WithClassAndObjectProperty<OntClass.ObjectSomeValuesFrom, OWLObjectSomeValuesFrom>
    implements OWLObjectSomeValuesFrom {
        public OSVF(BlankNodeId n, Supplier<OntModel> m) {
            super(n, m);
        }

        @Override
        public OntClass.ObjectSomeValuesFrom asRDFNode() {
            return this.as(OntClass.ObjectSomeValuesFrom.class);
        }

        @Override
        protected OWLObjectSomeValuesFrom fromFactory(OWLObjectPropertyExpression p, OWLClassExpression c) {
            return this.getDataFactory().getOWLObjectSomeValuesFrom(p, c);
        }
    }
}

