/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.axioms.WithTriple;
import com.github.owlcs.ontapi.internal.objects.ONTAnnotationImpl;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.WithContent;
import com.github.owlcs.ontapi.internal.objects.WithoutAnnotations;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.owlapi.OWLObjectImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Triple;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;

interface WithTwoObjects<S extends OWLObject, O extends OWLObject>
extends WithTriple {
    public ONTObject<? extends S> getURISubject(InternalObjectFactory var1);

    public ONTObject<? extends O> getURIObject(InternalObjectFactory var1);

    public ONTObject<? extends S> subjectFromStatement(OntStatement var1, InternalObjectFactory var2);

    public ONTObject<? extends O> objectFromStatement(OntStatement var1, InternalObjectFactory var2);

    public ONTObject<? extends S> getONTSubject(InternalObjectFactory var1);

    public ONTObject<? extends O> getONTObject(InternalObjectFactory var1);

    default public ONTObject<? extends S> getONTSubject() {
        return this.getONTSubject(this.getObjectFactory());
    }

    default public ONTObject<? extends O> getONTObject() {
        return this.getONTObject(this.getObjectFactory());
    }

    @Override
    default public Set<? extends OWLObject> getOWLComponentsAsSet(InternalObjectFactory factory) {
        Set res = OWLObjectImpl.createSortedSet();
        res.add(this.getONTSubject(factory).getOWLObject());
        res.add(this.getONTObject(factory).getOWLObject());
        return res;
    }

    public static <R extends ONTObject & WithTwoObjects> R create(OntStatement statement, Supplier<OntModel> model, BiFunction<Triple, Supplier<OntModel>, ? extends R> simple, BiFunction<Triple, Supplier<OntModel>, ? extends R> complex, ObjIntConsumer<OWLAxiom> setHash, InternalObjectFactory factory, InternalConfig config) {
        ONTObject s = (ONTObject)simple.apply(statement.asTriple(), model);
        Object[] content = Complex.initContent((WithTwoObjects)((Object)s), statement, setHash, factory, config);
        if (content == null) {
            return (R)s;
        }
        ONTObject c = (ONTObject)complex.apply(statement.asTriple(), model);
        setHash.accept((OWLAxiom)c, s.hashCode());
        ((WithContent)((Object)c)).putContent(content);
        return (R)c;
    }

    public static interface UnaryWithContent<A extends OWLAxiom, X extends OWLObject>
    extends Unary<X>,
    Complex<A, X, X> {
    }

    public static interface UnarySimple<X extends OWLObject>
    extends Unary<X>,
    Simple<X, X> {
    }

    public static interface Unary<X extends OWLObject>
    extends WithTwoObjects<X, X> {
        public ONTObject<? extends X> findByURI(String var1, InternalObjectFactory var2);

        @Override
        default public ONTObject<? extends X> getURISubject(InternalObjectFactory factory) {
            return this.findByURI(this.getSubjectURI(), factory);
        }

        @Override
        default public ONTObject<? extends X> getURIObject(InternalObjectFactory factory) {
            return this.findByURI(this.getObjectURI(), factory);
        }
    }

    public static interface Complex<A extends OWLAxiom, S extends OWLObject, O extends OWLObject>
    extends WithTwoObjects<S, O>,
    WithContent<A> {
        public static Object[] initContent(WithTwoObjects axiom, OntStatement statement, ObjIntConsumer<OWLAxiom> setHash, InternalObjectFactory factory, InternalConfig config) {
            Collection<ONTObject<OWLAnnotation>> annotations = ONTAxiomImpl.collectAnnotations(statement, factory, config);
            int size = annotations.size();
            ONTObject subject = null;
            int hash = axiom.hashIndex();
            if (statement.getSubject().isURIResource()) {
                hash = OWLObject.hashIteration((int)hash, (int)axiom.getURISubject(factory).hashCode());
            } else {
                ++size;
                subject = axiom.subjectFromStatement(statement, factory);
                hash = OWLObject.hashIteration((int)hash, (int)subject.hashCode());
            }
            ONTObject object = null;
            if (statement.getObject().isURIResource()) {
                hash = OWLObject.hashIteration((int)hash, (int)axiom.getURIObject(factory).hashCode());
            } else {
                ++size;
                object = axiom.objectFromStatement(statement, factory);
                hash = OWLObject.hashIteration((int)hash, (int)object.hashCode());
            }
            if (size == 0) {
                setHash.accept(axiom, OWLObject.hashIteration((int)hash, (int)1));
                return null;
            }
            int h = 1;
            Object[] res = new Object[size];
            int index = 0;
            if (subject != null) {
                res[index++] = subject;
            }
            if (object != null) {
                res[index++] = object;
            }
            for (ONTObject<OWLAnnotation> a : annotations) {
                res[index++] = a;
                h = WithContent.hashIteration(h, a.hashCode());
            }
            setHash.accept(axiom, OWLObject.hashIteration((int)hash, (int)h));
            return res;
        }

        @Override
        default public Object[] collectContent() {
            OntStatement statement = this.asStatement();
            InternalObjectFactory factory = this.getObjectFactory();
            ArrayList res = new ArrayList(2);
            if (!statement.getSubject().isURIResource()) {
                res.add(this.subjectFromStatement(statement, factory));
            }
            if (!statement.getObject().isURIResource()) {
                res.add(this.objectFromStatement(statement, factory));
            }
            res.addAll(ONTAxiomImpl.collectAnnotations(statement, factory, this.getConfig()));
            return res.toArray();
        }

        @Override
        default public ONTObject<? extends S> getONTSubject(InternalObjectFactory factory) {
            return this.findONTSubject(this.getContent(), factory);
        }

        @Override
        default public ONTObject<? extends O> getONTObject(InternalObjectFactory factory) {
            return this.findONTObject(this.getContent(), factory);
        }

        default public ONTObject<? extends S> findONTSubject(Object[] content, InternalObjectFactory factory) {
            return this.hasURISubject() ? this.getURISubject(factory) : (ONTObject)content[0];
        }

        default public ONTObject<? extends O> findONTObject(Object[] content, InternalObjectFactory factory) {
            return this.hasURIObject() ? this.getURIObject(factory) : (ONTObject)content[this.hasURISubject() ? 0 : 1];
        }

        default public int getAnnotationStartIndex() {
            return this.hasURISubject() ? (this.hasURIObject() ? 0 : 1) : (this.hasURIObject() ? 1 : 2);
        }

        @Override
        default public Stream<ONTObject<? extends OWLObject>> objects() {
            Object[] content = this.getContent();
            Stream<ONTObject<Object>> objects = null;
            Stream<Object> res = Arrays.stream(content);
            if (this.hasURISubject()) {
                InternalObjectFactory factory = this.getObjectFactory();
                objects = this.hasURIObject() ? Stream.of(this.getURISubject(factory), this.getURIObject(factory)) : Stream.of(this.getURISubject(factory));
            } else if (this.hasURIObject()) {
                objects = Stream.of(this.getURIObject(this.getObjectFactory()));
            }
            res = objects != null ? Stream.concat(objects, res) : res;
            return res;
        }

        @Override
        default public Set<? extends OWLObject> getOWLComponentsAsSet(InternalObjectFactory factory) {
            Object[] content = this.getContent();
            Set res = OWLObjectImpl.createSortedSet();
            res.add(this.findONTSubject(content, factory).getOWLObject());
            res.add(this.findONTObject(content, factory).getOWLObject());
            return res;
        }

        @Override
        default public boolean isAnnotated() {
            return ONTAnnotationImpl.hasAnnotations(this.getContent());
        }

        @Override
        default public Stream<OWLAnnotation> annotations() {
            return ONTAnnotationImpl.contentAsStream(this.getContent(), this.getAnnotationStartIndex());
        }

        @Override
        default public List<OWLAnnotation> annotationsAsList() {
            return ONTAnnotationImpl.contentAsList(this.getContent(), this.getAnnotationStartIndex());
        }
    }

    public static interface Simple<S extends OWLObject, O extends OWLObject>
    extends WithTwoObjects<S, O>,
    WithoutAnnotations {
        @Override
        default public boolean isAnnotated() {
            return false;
        }

        @Override
        default public Stream<ONTObject<? extends OWLObject>> objects() {
            InternalObjectFactory factory = this.getObjectFactory();
            return Stream.of(this.getONTSubject(factory), this.getONTObject(factory));
        }

        @Override
        default public ONTObject<? extends S> getONTSubject(InternalObjectFactory factory) {
            return this.getURISubject(factory);
        }

        @Override
        default public ONTObject<? extends O> getONTObject(InternalObjectFactory factory) {
            return this.getURIObject(factory);
        }
    }
}

