/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.axioms.WithTriple;
import com.github.owlcs.ontapi.internal.objects.ONTAnnotationImpl;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.internal.objects.ONTObjectImpl;
import com.github.owlcs.ontapi.internal.objects.WithContent;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.owlapi.OWLObjectImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.ObjIntConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.HasHashIndex;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

interface WithList<A extends OWLAxiom, E extends OWLObject>
extends WithTriple,
WithContent<A> {
    public ExtendedIterator<ONTObject<? extends E>> listONTComponents(OntStatement var1, InternalObjectFactory var2);

    public Stream<ONTObject<? extends OWLObject>> objects(InternalObjectFactory var1);

    public ONTObject fromContentItem(Object var1, InternalObjectFactory var2);

    @Override
    default public boolean isAnnotated() {
        return ONTAnnotationImpl.hasAnnotations(this.getContent());
    }

    @Override
    default public Stream<OWLAnnotation> annotations() {
        Stream<OWLAnnotation> res = Arrays.stream(this.getContent()).map(WithList::toOWLAnnotation).filter(Objects::nonNull);
        return res;
    }

    @Override
    default public List<OWLAnnotation> annotationsAsList() {
        return this.annotations().collect(Collectors.toList());
    }

    default public Object toContentItem(ONTObject x) {
        return x instanceof OWLEntity ? ONTEntityImpl.getURI((OWLEntity)x) : x;
    }

    public static OWLAnnotation toOWLAnnotation(Object x) {
        Object res;
        if (x instanceof OWLAnnotation) {
            return (OWLAnnotation)x;
        }
        if (x instanceof ONTObject && (res = ((ONTObject)x).getOWLObject()) instanceof OWLAnnotation) {
            return (OWLAnnotation)res;
        }
        return null;
    }

    public static interface Sorted<A extends OWLAxiom, S extends OWLObject, E extends OWLObject>
    extends WithSubject<A, S, E> {
        public static <R extends ONTObject & Sorted> R create(OntStatement statement, Supplier<OntModel> model, BiFunction<Triple, Supplier<OntModel>, ? extends R> getAxiom, ObjIntConsumer<OWLAxiom> setHash, InternalObjectFactory factory, InternalConfig config) {
            ONTObject res = (ONTObject)getAxiom.apply(statement.asTriple(), model);
            ONTObject s = ((WithSubject)((Object)res)).fetchONTSubject(statement, factory);
            int hash = OWLObject.hashIteration((int)((HasHashIndex)res).hashIndex(), (int)s.hashCode());
            Set components = ((Sorted)((Object)res)).fetchONTComponents(statement, factory);
            Collection<ONTObject<OWLAnnotation>> annotations = ONTAxiomImpl.collectAnnotations(statement, factory, config);
            Object[] content = new Object[1 + components.size() + annotations.size()];
            int index = 0;
            content[index++] = ((WithList)((Object)res)).toContentItem(s);
            int h = 1;
            for (ONTObject oNTObject : components) {
                h = WithContent.hashIteration(h, oNTObject.hashCode());
                content[index++] = ((WithList)((Object)res)).toContentItem(oNTObject);
            }
            hash = OWLObject.hashIteration((int)hash, (int)h);
            h = 1;
            for (ONTObject<Object> oNTObject : annotations) {
                h = WithContent.hashIteration(h, oNTObject.hashCode());
                content[index++] = oNTObject;
            }
            hash = OWLObject.hashIteration((int)hash, (int)h);
            setHash.accept((OWLAxiom)res, hash);
            ((WithContent)((Object)res)).putContent(content);
            return (R)res;
        }

        default public Set<ONTObject<? extends E>> fetchONTComponents(OntStatement statement, InternalObjectFactory factory) {
            return Iter.addAll(this.listONTComponents(statement, factory), ONTObjectImpl.createContentSet());
        }

        @Override
        default public Object[] collectContent() {
            OntStatement statement = this.asStatement();
            InternalObjectFactory factory = this.getObjectFactory();
            InternalConfig config = this.getConfig();
            ArrayList<Object> content = new ArrayList<Object>();
            content.add(this.toContentItem(this.fetchONTSubject(statement, factory)));
            for (ONTObject<E> x : this.fetchONTComponents(statement, factory)) {
                content.add(this.toContentItem(x));
            }
            content.addAll(ONTAxiomImpl.collectAnnotations(statement, factory, config));
            return content.toArray();
        }
    }

    public static interface Sequent<A extends OWLAxiom, S extends OWLObject, E extends OWLObject>
    extends WithSubject<A, S, E> {
        public static <R extends ONTObject & Sequent> R create(OntStatement statement, Supplier<OntModel> model, BiFunction<Triple, Supplier<OntModel>, ? extends R> getAxiom, ObjIntConsumer<OWLAxiom> setHash, InternalObjectFactory factory, InternalConfig config) {
            ONTObject res = (ONTObject)getAxiom.apply(statement.asTriple(), model);
            ArrayList<Object> content = new ArrayList<Object>();
            ONTObject s = ((WithSubject)((Object)res)).fetchONTSubject(statement, factory);
            content.add(((WithList)((Object)res)).toContentItem(s));
            ExtendedIterator it = ((WithList)((Object)res)).listONTComponents(statement, factory);
            int h = 1;
            while (it.hasNext()) {
                ONTObject e = (ONTObject)it.next();
                h = WithContent.hashIteration(h, e.hashCode());
                content.add(((WithList)((Object)res)).toContentItem(e));
            }
            int hash = OWLObject.hashIteration((int)((HasHashIndex)res).hashIndex(), (int)h);
            hash = OWLObject.hashIteration((int)hash, (int)s.hashCode());
            h = 1;
            for (ONTObject<OWLAnnotation> a : ONTAxiomImpl.collectAnnotations(statement, factory, config)) {
                content.add(a);
                h = WithContent.hashIteration(h, a.hashCode());
            }
            hash = OWLObject.hashIteration((int)hash, (int)h);
            setHash.accept((OWLAxiom)res, hash);
            ((WithContent)((Object)res)).putContent(content.toArray());
            return (R)res;
        }

        @Override
        default public Object[] collectContent() {
            OntStatement statement = this.asStatement();
            InternalObjectFactory factory = this.getObjectFactory();
            InternalConfig config = this.getConfig();
            ArrayList<Object> content = new ArrayList<Object>();
            content.add(this.toContentItem(this.fetchONTSubject(statement, factory)));
            ExtendedIterator<ONTObject<ONTObject>> it = this.listONTComponents(statement, factory);
            it.forEachRemaining(x -> content.add(this.toContentItem((ONTObject)x)));
            content.addAll(ONTAxiomImpl.collectAnnotations(statement, factory, config));
            return content.toArray();
        }
    }

    public static interface WithSubject<A extends OWLAxiom, S extends OWLObject, E extends OWLObject>
    extends WithList<A, E> {
        public ONTObject<? extends S> findSubjectByURI(String var1, InternalObjectFactory var2);

        public ONTObject<? extends S> fetchONTSubject(OntStatement var1, InternalObjectFactory var2);

        default public ONTObject<? extends S> getONTSubject() {
            return this.findONTSubject(this.getObjectFactory());
        }

        default public ONTObject<? extends S> findONTSubject(InternalObjectFactory factory) {
            return this.findONTSubject(this.getContent()[0], factory);
        }

        @Override
        default public Stream<ONTObject<? extends OWLObject>> objects() {
            return this.objects(this.getObjectFactory());
        }

        @Override
        default public Stream<ONTObject<? extends OWLObject>> objects(InternalObjectFactory factory) {
            return this.objects(this.getContent(), factory);
        }

        default public Stream<ONTObject<? extends OWLObject>> objects(Object[] content, InternalObjectFactory factory) {
            ONTObject<S> s = this.findONTSubject(content[0], factory);
            Stream<Object> res = Stream.concat(Stream.of(s), Arrays.stream(content).skip(1L));
            return res.map(x -> this.fromContentItem(x, factory));
        }

        default public ONTObject<? extends S> findONTSubject(Object content, InternalObjectFactory factory) {
            return content instanceof String ? this.findSubjectByURI((String)content, factory) : (ONTObject<S>)content;
        }

        default public Stream<ONTObject<? extends E>> members() {
            return this.members(this.getContent(), this.getObjectFactory());
        }

        default public Stream<ONTObject<? extends E>> members(Object[] content, InternalObjectFactory factory) {
            Stream<ONTObject<? extends E>> res = Arrays.stream(content).skip(1L).map(x -> this.fromContentItem(x, factory)).filter(x -> WithList.toOWLAnnotation(x) == null);
            return res;
        }

        @Override
        default public Set<? extends OWLObject> getOWLComponentsAsSet(InternalObjectFactory factory) {
            Set res = OWLObjectImpl.createSortedSet();
            this.objects(this.getContent(), factory).map(ONTObject::getOWLObject).filter(x -> !(x instanceof OWLAnnotation)).forEach(res::add);
            return res;
        }
    }
}

