/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.axioms.AbstractPropertyTypeTranslator;
import com.github.owlcs.ontapi.internal.axioms.WithOneObject;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Resource;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class FunctionalObjectPropertyTranslator
extends AbstractPropertyTypeTranslator<OWLFunctionalObjectPropertyAxiom, OntObjectProperty> {
    @Override
    Resource getType() {
        return OWL.FunctionalProperty;
    }

    @Override
    Class<OntObjectProperty> getView() {
        return OntObjectProperty.class;
    }

    @Override
    public ONTObject<OWLFunctionalObjectPropertyAxiom> toAxiomImpl(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
        return AxiomImpl.create(statement, model, factory, config);
    }

    @Override
    public ONTObject<OWLFunctionalObjectPropertyAxiom> toAxiomWrap(OntStatement statement, InternalObjectFactory factory, InternalConfig config) {
        ONTObject<? extends OWLObjectPropertyExpression> p = factory.getProperty((OntObjectProperty)this.getSubject(statement));
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        OWLFunctionalObjectPropertyAxiom res = factory.getOWLDataFactory().getOWLFunctionalObjectPropertyAxiom(p.getOWLObject(), ONTObject.toSet(annotations));
        return ONTWrapperImpl.create(res, statement).append(annotations).append(p);
    }

    public static abstract class AxiomImpl
    extends AbstractPropertyTypeTranslator.ObjectAxiomImpl<OWLFunctionalObjectPropertyAxiom>
    implements OWLFunctionalObjectPropertyAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        public static AxiomImpl create(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
            return (AxiomImpl)WithOneObject.create(statement, model, SimpleImpl.FACTORY, ComplexImpl.FACTORY, SET_HASH_CODE, factory, config);
        }

        public OWLSubClassOfAxiom asOWLSubClassOfAxiom() {
            DataFactory df = this.getDataFactory();
            OWLClass thing = df.getOWLThing();
            return df.getOWLSubClassOfAxiom((OWLClassExpression)thing, (OWLClassExpression)df.getOWLObjectMaxCardinality(1, (OWLObjectPropertyExpression)AxiomImpl.eraseModel(this.getProperty()), (OWLClassExpression)thing));
        }

        @Override
        protected OWLFunctionalObjectPropertyAxiom createAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)AxiomImpl.eraseModel(this.getProperty()), annotations);
        }

        public static class ComplexImpl
        extends AxiomImpl
        implements WithOneObject.Complex<ComplexImpl, OWLObjectPropertyExpression> {
            private static final BiFunction<Triple, Supplier<OntModel>, ComplexImpl> FACTORY = ComplexImpl::new;
            protected final InternalCache.Loading<ComplexImpl, Object[]> content = this.createContentCache();

            public ComplexImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public InternalCache.Loading<ComplexImpl, Object[]> getContentCache() {
                return this.content;
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return other instanceof ComplexImpl && Arrays.equals(this.getContent(), ((ComplexImpl)other).getContent());
            }

            @Override
            public ONTObject<OWLFunctionalObjectPropertyAxiom> merge(final ONTObject<OWLFunctionalObjectPropertyAxiom> other) {
                if (this == other) {
                    return this;
                }
                if (other instanceof AxiomImpl && this.sameTriple((AxiomImpl)other)) {
                    return this;
                }
                ComplexImpl res = new ComplexImpl(this.asTriple(), this.model){

                    @Override
                    public Stream<Triple> triples() {
                        return Stream.concat(this.triples(), other.triples());
                    }
                };
                if (this.hasContent()) {
                    res.putContent(this.getContent());
                }
                res.hashCode = this.hashCode;
                return res;
            }
        }

        public static class SimpleImpl
        extends AxiomImpl
        implements WithOneObject.Simple<OWLObjectPropertyExpression> {
            private static final BiFunction<Triple, Supplier<OntModel>, SimpleImpl> FACTORY = SimpleImpl::new;

            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public Set<OWLObjectProperty> getObjectPropertySet() {
                return this.getComponentsAsPropertySet();
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                return this.getComponentsAsEntitySet();
            }

            @Override
            public boolean containsObjectProperty(OWLObjectProperty property) {
                return this.hasSubject(property);
            }
        }
    }
}

