/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.axioms.AbstractPropertyTypeTranslator;
import com.github.owlcs.ontapi.internal.axioms.WithOneObject;
import com.github.owlcs.ontapi.internal.objects.ONTDataPropertyImpl;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Resource;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class FunctionalDataPropertyTranslator
extends AbstractPropertyTypeTranslator<OWLFunctionalDataPropertyAxiom, OntDataProperty> {
    @Override
    Resource getType() {
        return OWL.FunctionalProperty;
    }

    @Override
    Class<OntDataProperty> getView() {
        return OntDataProperty.class;
    }

    @Override
    public ONTObject<OWLFunctionalDataPropertyAxiom> toAxiomImpl(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
        return AxiomImpl.create(statement, model, factory, config);
    }

    @Override
    public ONTObject<OWLFunctionalDataPropertyAxiom> toAxiomWrap(OntStatement statement, InternalObjectFactory factory, InternalConfig config) {
        ONTObject<OWLDataProperty> p = factory.getProperty((OntDataProperty)this.getSubject(statement));
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        OWLFunctionalDataPropertyAxiom res = factory.getOWLDataFactory().getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)p.getOWLObject(), ONTObject.toSet(annotations));
        return ONTWrapperImpl.create(res, statement).append(annotations).append(p);
    }

    public static abstract class AxiomImpl
    extends AbstractPropertyTypeTranslator.UnaryAxiomImpl<OWLFunctionalDataPropertyAxiom, OWLDataPropertyExpression>
    implements OWLFunctionalDataPropertyAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        public static AxiomImpl create(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
            return (AxiomImpl)WithOneObject.create(statement, model, SimpleImpl.FACTORY, ComplexImpl.FACTORY, SET_HASH_CODE, factory, config);
        }

        @Override
        protected final boolean sameContent(ONTStatementImpl other) {
            return false;
        }

        public OWLSubClassOfAxiom asOWLSubClassOfAxiom() {
            DataFactory df = this.getDataFactory();
            return df.getOWLSubClassOfAxiom((OWLClassExpression)df.getOWLThing(), (OWLClassExpression)df.getOWLDataMaxCardinality(1, (OWLDataPropertyExpression)AxiomImpl.eraseModel(this.getProperty()), (OWLDataRange)df.getTopDatatype()));
        }

        @Override
        protected OWLFunctionalDataPropertyAxiom createAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLFunctionalDataPropertyAxiom((OWLDataPropertyExpression)AxiomImpl.eraseModel(this.getProperty()), annotations);
        }

        @Override
        public ONTObject<? extends OWLDataPropertyExpression> findURISubject(InternalObjectFactory factory) {
            return ONTDataPropertyImpl.find((String)this.subject, factory, this.model);
        }

        @Override
        public ONTObject<? extends OWLDataPropertyExpression> fetchONTSubject(OntStatement statement, InternalObjectFactory factory) {
            return factory.getProperty(statement.getSubject(OntDataProperty.class));
        }

        @Override
        public boolean canContainObjectProperties() {
            return false;
        }

        public static class ComplexImpl
        extends AxiomImpl
        implements WithOneObject.Complex<ComplexImpl, OWLDataPropertyExpression> {
            private static final BiFunction<Triple, Supplier<OntModel>, ComplexImpl> FACTORY = ComplexImpl::new;
            protected final InternalCache.Loading<ComplexImpl, Object[]> content = this.createContentCache();

            protected ComplexImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public InternalCache.Loading<ComplexImpl, Object[]> getContentCache() {
                return this.content;
            }
        }

        public static class SimpleImpl
        extends AxiomImpl
        implements WithOneObject.Simple<OWLDataPropertyExpression> {
            private static final BiFunction<Triple, Supplier<OntModel>, SimpleImpl> FACTORY = SimpleImpl::new;

            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public Set<OWLDataProperty> getDataPropertySet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public boolean containsDataProperty(OWLDataProperty property) {
                return this.subject.equals(ONTEntityImpl.getURI((OWLEntity)property));
            }
        }
    }
}

