/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.axioms.AbstractNaryTranslator;
import com.github.owlcs.ontapi.internal.axioms.AbstractTwoWayNaryTranslator;
import com.github.owlcs.ontapi.internal.axioms.WithManyObjects;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDisjoint;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;

public class DisjointDataPropertiesTranslator
extends AbstractTwoWayNaryTranslator<OWLDisjointDataPropertiesAxiom, OWLDataPropertyExpression, OntDataProperty> {
    private static final Property PREDICATE = OWL.propertyDisjointWith;

    @Override
    Property getPredicate() {
        return PREDICATE;
    }

    @Override
    Class<OntDataProperty> getView() {
        return OntDataProperty.class;
    }

    @Override
    Resource getMembersType() {
        return OWL.AllDisjointProperties;
    }

    @Override
    Property getMembersPredicate() {
        return OWL.members;
    }

    @Override
    Class<OntDisjoint.DataProperties> getDisjointView() {
        return OntDisjoint.DataProperties.class;
    }

    @Override
    public ONTObject<OWLDisjointDataPropertiesAxiom> toAxiomImpl(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
        return AxiomImpl.create(statement, model, factory, config);
    }

    @Override
    public ONTObject<OWLDisjointDataPropertiesAxiom> toAxiomWrap(OntStatement statement, InternalObjectFactory factory, InternalConfig config) {
        return this.makeAxiom(statement, factory.getAnnotations(statement, config), factory::getProperty, (members, annotations) -> factory.getOWLDataFactory().getOWLDisjointDataPropertiesAxiom(ONTObject.toSet(members), ONTObject.toSet(annotations)));
    }

    public static abstract class AxiomImpl
    extends AbstractNaryTranslator.DataPropertyNaryAxiomImpl<OWLDisjointDataPropertiesAxiom>
    implements OWLDisjointDataPropertiesAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            this(AxiomImpl.strip(t.getSubject()), t.getPredicate().getURI(), AxiomImpl.strip(t.getObject()), m);
        }

        protected AxiomImpl(Object s, String p, Object o, Supplier<OntModel> m) {
            super(s, p, o, m);
        }

        public static AxiomImpl create(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
            if (PREDICATE.equals(statement.getPredicate())) {
                return (AxiomImpl)WithManyObjects.create(statement, model, SimpleImpl.FACTORY, ComplexImpl.FACTORY, SET_HASH_CODE, factory, config);
            }
            return (AxiomImpl)WithManyObjects.create(statement, model, ComplexImpl.FACTORY, SET_HASH_CODE, factory, config);
        }

        @Override
        public ExtendedIterator<ONTObject<? extends OWLDataPropertyExpression>> listONTComponents(OntStatement statement, InternalObjectFactory factory) {
            if (PREDICATE.equals(statement.getPredicate())) {
                return super.listONTComponents(statement, factory);
            }
            return OntModels.listMembers(statement.getSubject(OntDisjoint.DataProperties.class).getList()).mapWith(factory::getProperty);
        }

        @Override
        protected OWLDisjointDataPropertiesAxiom createAxiom(Collection<OWLDataPropertyExpression> members, Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLDisjointDataPropertiesAxiom(members, annotations == null ? NO_ANNOTATIONS : annotations);
        }

        public static class ComplexImpl
        extends AxiomImpl
        implements WithManyObjects.Complex<ComplexImpl, OWLDataPropertyExpression> {
            private static final BiFunction<Triple, Supplier<OntModel>, ComplexImpl> FACTORY = ComplexImpl::new;
            protected final InternalCache.Loading<ComplexImpl, Object[]> content = this.createContentCache();

            public ComplexImpl(Triple t, Supplier<OntModel> m) {
                this(ComplexImpl.strip(t.getSubject()), t.getPredicate().getURI(), ComplexImpl.strip(t.getObject()), m);
            }

            protected ComplexImpl(Object s, String p, Object o, Supplier<OntModel> m) {
                super(s, p, o, m);
            }

            @Override
            protected long count() {
                return this.isSimple() ? 2L : this.members().count();
            }

            boolean isSimple() {
                return this.predicate.equals(PREDICATE.getURI());
            }

            protected OntDisjoint.DataProperties asResource() {
                return this.getPersonalityModel().getNodeAs(this.getSubjectNode(), OntDisjoint.DataProperties.class);
            }

            @Override
            public Stream<Triple> triples() {
                if (this.isSimple()) {
                    return super.triples();
                }
                return Stream.concat(this.asResource().spec().map(FrontsTriple::asTriple), this.objects().flatMap(ONTObject::triples));
            }

            @Override
            public OntStatement asStatement() {
                if (this.isSimple()) {
                    return super.asStatement();
                }
                return this.asResource().getMainStatement();
            }

            @Override
            public InternalCache.Loading<ComplexImpl, Object[]> getContentCache() {
                return this.content;
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return this.testSameContent(other);
            }

            protected ComplexImpl makeCopyWith(final ONTObject<OWLDisjointDataPropertiesAxiom> other) {
                ComplexImpl res = new ComplexImpl(this.subject, this.predicate, this.object, this.model){

                    @Override
                    public Stream<Triple> triples() {
                        return Stream.concat(this.triples(), other.triples());
                    }
                };
                if (this.hasContent()) {
                    res.putContent(this.getContent());
                }
                return res;
            }
        }

        protected static class SimpleImpl
        extends AxiomImpl
        implements WithManyObjects.Simple<OWLDataPropertyExpression> {
            private static final BiFunction<Triple, Supplier<OntModel>, SimpleImpl> FACTORY = SimpleImpl::new;

            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            protected SimpleImpl(Object s, String p, Object o, Supplier<OntModel> m) {
                super(s, p, o, m);
            }

            @Override
            protected long count() {
                return 2L;
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return other instanceof SimpleImpl && this.isReverseTriple((SimpleImpl)other);
            }

            protected AxiomImpl makeCopyWith(final ONTObject<OWLDisjointDataPropertiesAxiom> other) {
                if (other instanceof SimpleImpl) {
                    final Triple t = ((SimpleImpl)other).asTriple();
                    return new SimpleImpl(this.subject, this.predicate, this.object, this.model){

                        @Override
                        public Stream<Triple> triples() {
                            return Stream.concat(this.triples(), Stream.of(t));
                        }
                    };
                }
                return new SimpleImpl(this.subject, this.predicate, this.object, this.model){

                    @Override
                    public Stream<Triple> triples() {
                        return Stream.concat(this.triples(), other.triples());
                    }
                };
            }

            @Override
            public Set<OWLDataProperty> getDataPropertySet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                return this.getOWLComponentsAsSet();
            }

            @Override
            public boolean containsDataProperty(OWLDataProperty property) {
                return this.hasURIResource(ONTEntityImpl.getURI((OWLEntity)property));
            }
        }
    }
}

