/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.objects.ONTAnnotationImpl;
import com.github.owlcs.ontapi.internal.objects.ONTAnonymousIndividualImpl;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTClassImpl;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.internal.objects.ONTNamedIndividualImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.internal.objects.WithContent;
import com.github.owlcs.ontapi.internal.objects.WithoutAnnotations;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;

public class ClassAssertionTranslator
extends AxiomTranslator<OWLClassAssertionAxiom> {
    @Override
    public void write(OWLClassAssertionAxiom axiom, OntModel model) {
        OntClass ce = WriteHelper.addClassExpression(model, axiom.getClassExpression());
        OWLIndividual individual = axiom.getIndividual();
        OntIndividual subject = individual.isAnonymous() ? (OntObject)WriteHelper.toResource((OWLObject)individual).inModel((Model)model).as(OntObject.class) : WriteHelper.addIndividual(model, individual);
        OntStatement statement = subject.addStatement(RDF.type, (RDFNode)ce);
        WriteHelper.addAnnotations(statement, (Collection<OWLAnnotation>)axiom.annotationsAsList());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, InternalConfig config) {
        Set<Node> forbidden = ClassAssertionTranslator.getSystemResources(model);
        return model.getBaseGraph().find(Node.ANY, RDF.Nodes.type, Node.ANY).filterDrop(t -> forbidden.contains(t.getObject())).mapWith(model::asStatement).filterKeep(this::filterSO);
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return statement.isDeclaration() && this.filterSO(statement);
    }

    protected boolean filterSO(OntStatement statement) {
        return this.isClass(statement.getObject()) && this.isIndividual((RDFNode)statement.getSubject());
    }

    protected boolean isClass(RDFNode n) {
        return n.canAs(OntClass.class);
    }

    protected boolean isIndividual(RDFNode n) {
        return n.canAs(OntIndividual.class);
    }

    @Override
    public ONTObject<OWLClassAssertionAxiom> toAxiomImpl(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
        return AxiomImpl.create(statement, model, factory, config);
    }

    @Override
    public ONTObject<OWLClassAssertionAxiom> toAxiomWrap(OntStatement statement, InternalObjectFactory factory, InternalConfig config) {
        ONTObject<? extends OWLIndividual> i = factory.getIndividual(statement.getSubject(OntIndividual.class));
        ONTObject<? extends OWLClassExpression> ce = factory.getClass(statement.getObject(OntClass.class));
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        OWLClassAssertionAxiom res = factory.getOWLDataFactory().getOWLClassAssertionAxiom(ce.getOWLObject(), i.getOWLObject(), ONTObject.toSet(annotations));
        return ONTWrapperImpl.create(res, statement).append(annotations).append(i).append(ce);
    }

    public static abstract class AxiomImpl
    extends ONTAxiomImpl<OWLClassAssertionAxiom>
    implements OWLClassAssertionAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        protected AxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        public static AxiomImpl create(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
            SimpleImpl s = new SimpleImpl(statement.asTriple(), model);
            Object[] content = ComplexImpl.initContent(s, statement, factory, config);
            if (content == null) {
                return s;
            }
            ComplexImpl c = new ComplexImpl(statement.asTriple(), model);
            c.hashCode = s.hashCode;
            c.putContent(content);
            return c;
        }

        public OWLIndividual getIndividual() {
            return this.getONTSubject(this.getObjectFactory()).getOWLObject();
        }

        public OWLClassExpression getClassExpression() {
            return this.getONTObject(this.getObjectFactory()).getOWLObject();
        }

        public ONTObject<? extends OWLIndividual> getONTSubject(InternalObjectFactory factory) {
            return this.hasURISubject() ? ONTNamedIndividualImpl.find(this.getSubjectURI(), factory, this.model) : ONTAnonymousIndividualImpl.find(this.getSubjectBlankNodeId(), factory, this.model);
        }

        public ONTObject<? extends OWLIndividual> getONTSubject() {
            return this.getONTSubject(this.getObjectFactory());
        }

        public ONTObject<? extends OWLClassExpression> getONTObject() {
            return this.getONTObject(this.getObjectFactory());
        }

        public abstract ONTObject<? extends OWLClassExpression> getONTObject(InternalObjectFactory var1);

        @Override
        protected OWLClassAssertionAxiom createAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLClassAssertionAxiom(AxiomImpl.eraseModel(this.getClassExpression()), AxiomImpl.eraseModel(this.getIndividual()), annotations);
        }

        public OWLSubClassOfAxiom asOWLSubClassOfAxiom() {
            DataFactory df = this.getDataFactory();
            return df.getOWLSubClassOfAxiom((OWLClassExpression)df.getOWLObjectOneOf(new OWLIndividual[]{AxiomImpl.eraseModel(this.getIndividual())}), AxiomImpl.eraseModel(this.getClassExpression()));
        }

        @Override
        public final boolean canContainAnnotationProperties() {
            return this.isAnnotated();
        }

        public static class ComplexImpl
        extends AxiomImpl
        implements WithContent<ComplexImpl> {
            protected final InternalCache.Loading<ComplexImpl, Object[]> content = this.createContentCache();

            public ComplexImpl(Triple t, Supplier<OntModel> m) {
                this(ComplexImpl.strip(t.getSubject()), t.getPredicate().getURI(), ComplexImpl.strip(t.getObject()), m);
            }

            protected ComplexImpl(Object s, String p, Object o, Supplier<OntModel> m) {
                super(s, p, o, m);
            }

            static Object[] initContent(AxiomImpl axiom, OntStatement statement, InternalObjectFactory factory, InternalConfig config) {
                Collection<ONTObject<OWLAnnotation>> annotations = ONTAxiomImpl.collectAnnotations(statement, factory, config);
                int size = annotations.size();
                int hash = OWLObject.hashIteration((int)axiom.hashIndex(), (int)axiom.getONTSubject(factory).hashCode());
                ONTObject<? extends OWLClassExpression> object = null;
                if (statement.getObject().isURIResource()) {
                    hash = OWLObject.hashIteration((int)hash, (int)ONTClassImpl.find(statement.getObject().asNode().getURI(), factory, axiom.model).hashCode());
                } else {
                    ++size;
                    object = factory.getClass(statement.getObject(OntClass.class));
                    hash = OWLObject.hashIteration((int)hash, (int)object.hashCode());
                }
                if (size == 0) {
                    axiom.hashCode = OWLObject.hashIteration((int)hash, (int)1);
                    return null;
                }
                int h = 1;
                Object[] res = new Object[size];
                int index = 0;
                if (object != null) {
                    res[index++] = object;
                }
                for (ONTObject<OWLAnnotation> a : annotations) {
                    res[index++] = a;
                    h = WithContent.hashIteration(h, a.hashCode());
                }
                axiom.hashCode = OWLObject.hashIteration((int)hash, (int)h);
                return res;
            }

            @Override
            public Object[] collectContent() {
                OntStatement statement = this.asStatement();
                InternalObjectFactory factory = this.getObjectFactory();
                ArrayList<ONTObject<Object>> res = new ArrayList<ONTObject<Object>>(1);
                if (!statement.getObject().isURIResource()) {
                    res.add(factory.getClass(statement.getObject(OntClass.class)));
                }
                res.addAll(ONTAxiomImpl.collectAnnotations(statement, factory, this.getConfig()));
                return res.toArray();
            }

            @Override
            public InternalCache.Loading<ComplexImpl, Object[]> getContentCache() {
                return this.content;
            }

            @Override
            public ONTObject<? extends OWLClassExpression> getONTObject(InternalObjectFactory factory) {
                return this.getONTObject(this.getContent(), factory);
            }

            protected ONTObject<? extends OWLClassExpression> getONTObject(Object[] content, InternalObjectFactory factory) {
                return this.hasURIObject() ? ONTClassImpl.find(this.getObjectURI(), factory, this.model) : (ONTObject<OWLClass>)content[0];
            }

            @Override
            public Stream<ONTObject<? extends OWLObject>> objects() {
                Object[] content = this.getContent();
                InternalObjectFactory f = this.getObjectFactory();
                Stream<Object> res = Arrays.stream(content);
                Stream<ONTObject<Object>> objects = this.hasURIObject() ? Stream.of(this.getONTSubject(f), this.getONTObject(content, f)) : Stream.of(this.getONTSubject(f));
                res = Stream.concat(objects, res);
                return res;
            }

            @Override
            public boolean isAnnotated() {
                int content = this.getContent().length;
                return content > (this.hasURIObject() ? 0 : 1);
            }

            @Override
            public Stream<OWLAnnotation> annotations() {
                return ONTAnnotationImpl.contentAsStream(this.getContent(), this.hasURIObject() ? 0 : 1);
            }

            @Override
            public List<OWLAnnotation> annotationsAsList() {
                return ONTAnnotationImpl.contentAsList(this.getContent(), this.hasURIObject() ? 0 : 1);
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return other instanceof ComplexImpl && Arrays.equals(this.getContent(), ((ComplexImpl)other).getContent());
            }

            @Override
            public ONTObject<OWLClassAssertionAxiom> merge(final ONTObject<OWLClassAssertionAxiom> other) {
                if (this == other) {
                    return this;
                }
                if (other instanceof AxiomImpl && this.sameTriple((AxiomImpl)other)) {
                    return this;
                }
                ComplexImpl res = new ComplexImpl(this.subject, this.predicate, this.object, this.model){

                    @Override
                    public Stream<Triple> triples() {
                        return Stream.concat(this.triples(), other.triples());
                    }
                };
                if (this.hasContent()) {
                    res.putContent(this.getContent());
                }
                res.hashCode = this.hashCode;
                return res;
            }
        }

        public static class SimpleImpl
        extends AxiomImpl
        implements WithoutAnnotations {
            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public boolean isAnnotated() {
                return false;
            }

            @Override
            public ONTObject<? extends OWLClassExpression> getONTObject(InternalObjectFactory factory) {
                return ONTClassImpl.find(this.getObjectURI(), factory, this.model);
            }

            @Override
            public Set<OWLNamedIndividual> getNamedIndividualSet() {
                return this.hasURISubject() ? SimpleImpl.createSet(this.getONTSubject().getOWLObject().asOWLNamedIndividual()) : SimpleImpl.createSet();
            }

            @Override
            public Set<OWLAnonymousIndividual> getAnonymousIndividualSet() {
                return this.hasURISubject() ? SimpleImpl.createSet() : SimpleImpl.createSet(this.getONTSubject().getOWLObject().asOWLAnonymousIndividual());
            }

            @Override
            public Set<OWLClass> getNamedClassSet() {
                return SimpleImpl.createSet(this.getONTObject().getOWLObject().asOWLClass());
            }

            @Override
            public Set<OWLClassExpression> getClassExpressionSet() {
                return SimpleImpl.createSet(this.getONTObject().getOWLObject());
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                InternalObjectFactory f = this.getObjectFactory();
                Set<OWLEntity> res = SimpleImpl.createSortedSet();
                res.add((OWLEntity)this.getONTObject(f).getOWLObject().asOWLClass());
                if (this.hasURISubject()) {
                    res.add((OWLEntity)this.getONTSubject(f).getOWLObject().asOWLNamedIndividual());
                }
                return res;
            }

            @Override
            public Stream<ONTObject<? extends OWLObject>> objects() {
                InternalObjectFactory f = this.getObjectFactory();
                return Stream.of(this.getONTSubject(f), this.getONTObject(f));
            }

            @Override
            public boolean containsNamedIndividual(OWLNamedIndividual individual) {
                return this.hasURISubject() && this.getSubjectURI().equals(ONTEntityImpl.getURI((OWLEntity)individual));
            }

            @Override
            public boolean containsNamedClass(OWLClass clazz) {
                return this.getObjectURI().equals(ONTEntityImpl.getURI((OWLEntity)clazz));
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return false;
            }

            @Override
            public boolean canContainDatatypes() {
                return false;
            }

            @Override
            public boolean canContainAnonymousIndividuals() {
                return false;
            }

            @Override
            public boolean canContainObjectProperties() {
                return false;
            }

            @Override
            public boolean canContainDataProperties() {
                return false;
            }
        }
    }
}

