/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.ReadHelper;
import com.github.owlcs.ontapi.internal.axioms.AbstractPropertyRangeTranslator;
import com.github.owlcs.ontapi.internal.axioms.WithTwoObjects;
import com.github.owlcs.ontapi.internal.objects.ONTAnnotationPropertyImpl;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;

public class AnnotationPropertyRangeTranslator
extends AbstractPropertyRangeTranslator<OWLAnnotationPropertyRangeAxiom, OntAnnotationProperty> {
    @Override
    Class<OntAnnotationProperty> getView() {
        return OntAnnotationProperty.class;
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, InternalConfig config) {
        if (!config.isLoadAnnotationAxioms()) {
            return NullIterator.instance();
        }
        return super.listStatements(model, config);
    }

    @Override
    public boolean filter(OntStatement statement, InternalConfig config) {
        return super.filter(statement, config) && statement.getObject().isURIResource() && ReadHelper.testAnnotationAxiomOverlaps(statement, config, (AxiomType<? extends OWLObjectPropertyAxiom>)AxiomType.OBJECT_PROPERTY_RANGE, (AxiomType<? extends OWLDataPropertyAxiom>)AxiomType.DATA_PROPERTY_RANGE);
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return config.isLoadAnnotationAxioms() && super.testStatement(statement, config);
    }

    @Override
    public ONTObject<OWLAnnotationPropertyRangeAxiom> toAxiomImpl(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
        return AxiomImpl.create(statement, model, factory, config);
    }

    @Override
    public ONTObject<OWLAnnotationPropertyRangeAxiom> toAxiomWrap(OntStatement statement, InternalObjectFactory factory, InternalConfig config) {
        ONTObject<OWLAnnotationProperty> p = factory.getProperty(statement.getSubject(this.getView()));
        ONTObject<IRI> d = factory.getIRI(statement.getResource().getURI());
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        OWLAnnotationPropertyRangeAxiom res = factory.getOWLDataFactory().getOWLAnnotationPropertyRangeAxiom(p.getOWLObject(), d.getOWLObject(), ONTObject.toSet(annotations));
        return ONTWrapperImpl.create(res, statement).append(annotations).append(p).append(d);
    }

    public static abstract class AxiomImpl
    extends AbstractPropertyRangeTranslator.RangeAxiomImpl<OWLAnnotationPropertyRangeAxiom, OWLAnnotationProperty, IRI>
    implements OWLAnnotationPropertyRangeAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        public static AxiomImpl create(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
            return (AxiomImpl)WithTwoObjects.create(statement, model, SimpleImpl.FACTORY, WithAnnotationsImpl.FACTORY, SET_HASH_CODE, factory, config);
        }

        @Override
        public ONTObject<? extends OWLAnnotationProperty> getURISubject(InternalObjectFactory factory) {
            return ONTAnnotationPropertyImpl.find(this.getSubjectURI(), factory, this.model);
        }

        @Override
        public ONTObject<? extends IRI> getURIObject(InternalObjectFactory factory) {
            return factory.getIRI(this.getObjectURI());
        }

        @Override
        public ONTObject<? extends OWLAnnotationProperty> subjectFromStatement(OntStatement statement, InternalObjectFactory factory) {
            return factory.getProperty(statement.getSubject(OntAnnotationProperty.class));
        }

        @Override
        public ONTObject<? extends IRI> objectFromStatement(OntStatement statement, InternalObjectFactory factory) {
            return factory.getIRI(statement.getObject().asNode().getURI());
        }

        @Override
        protected OWLAnnotationPropertyRangeAxiom createAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLAnnotationPropertyRangeAxiom((OWLAnnotationProperty)AxiomImpl.eraseModel(this.getProperty()), (IRI)this.getRange(), annotations);
        }

        @Override
        public final boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public final boolean canContainNamedIndividuals() {
            return false;
        }

        @Override
        public final boolean canContainObjectProperties() {
            return false;
        }

        @Override
        public final boolean canContainDataProperties() {
            return false;
        }

        @Override
        public final boolean canContainClassExpressions() {
            return false;
        }

        public static class WithAnnotationsImpl
        extends AxiomImpl
        implements WithTwoObjects.Complex<WithAnnotationsImpl, OWLAnnotationProperty, IRI> {
            private static final BiFunction<Triple, Supplier<OntModel>, WithAnnotationsImpl> FACTORY = WithAnnotationsImpl::new;
            protected final InternalCache.Loading<WithAnnotationsImpl, Object[]> content = this.createContentCache();

            public WithAnnotationsImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public InternalCache.Loading<WithAnnotationsImpl, Object[]> getContentCache() {
                return this.content;
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return other instanceof WithAnnotationsImpl && Arrays.equals(this.getContent(), ((WithAnnotationsImpl)other).getContent());
            }
        }

        public static class SimpleImpl
        extends AxiomImpl
        implements WithTwoObjects.Simple<OWLAnnotationProperty, IRI> {
            private static final BiFunction<Triple, Supplier<OntModel>, SimpleImpl> FACTORY = SimpleImpl::new;

            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public Set<OWLAnnotationProperty> getAnnotationPropertySet() {
                return SimpleImpl.createSet(this.getONTSubject().getOWLObject());
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                return SimpleImpl.createSet(this.getONTSubject().getOWLObject());
            }

            @Override
            public boolean containsAnnotationProperty(OWLAnnotationProperty property) {
                return this.getSubjectURI().equals(ONTEntityImpl.getURI((OWLEntity)property));
            }

            @Override
            protected boolean sameContent(ONTStatementImpl other) {
                return false;
            }

            @Override
            public boolean canContainDatatypes() {
                return false;
            }

            @Override
            public boolean canContainAnonymousIndividuals() {
                return false;
            }
        }
    }
}

