/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.ReadHelper;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.AbstractPropertyAssertionTranslator;
import com.github.owlcs.ontapi.internal.axioms.WithAssertion;
import com.github.owlcs.ontapi.internal.objects.ONTAnnotationImpl;
import com.github.owlcs.ontapi.internal.objects.ONTLiteralImpl;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntID;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import java.util.Collection;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Triple;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.NullIterator;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyExpression;

public class AnnotationAssertionTranslator
extends AbstractPropertyAssertionTranslator<OWLAnnotationProperty, OWLAnnotationAssertionAxiom> {
    @Override
    public void write(OWLAnnotationAssertionAxiom axiom, OntModel model) {
        WriteHelper.writeAssertionTriple(model, axiom.getSubject(), (OWLPropertyExpression)axiom.getProperty(), (OWLObject)axiom.getValue(), axiom.annotationsAsList());
    }

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, InternalConfig config) {
        if (!config.isLoadAnnotationAxioms()) {
            return NullIterator.instance();
        }
        OntID id = model.getID();
        return this.listStatements(model).filterKeep(s -> !id.equals(s.getSubject()) && this.filter((OntStatement)s, config));
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        if (!config.isLoadAnnotationAxioms()) {
            return false;
        }
        if (statement.getSubject().canAs(OntID.class)) {
            return false;
        }
        return this.filter(statement, config);
    }

    public boolean filter(OntStatement s, InternalConfig c) {
        return ReadHelper.isAnnotationAssertionStatement(s, c) && ReadHelper.isEntityOrAnonymousIndividual(s.getSubject());
    }

    @Override
    public ONTObject<OWLAnnotationAssertionAxiom> toAxiomImpl(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
        return AxiomImpl.create(statement, model, factory, config);
    }

    @Override
    public ONTObject<OWLAnnotationAssertionAxiom> toAxiomWrap(OntStatement statement, InternalObjectFactory factory, InternalConfig config) {
        ONTObject<? extends OWLAnnotationSubject> s = factory.getSubject(statement.getSubject(OntObject.class));
        ONTObject<OWLAnnotationProperty> p = factory.getProperty((OntAnnotationProperty)statement.getPredicate().as(OntAnnotationProperty.class));
        ONTObject<? extends OWLAnnotationValue> v = factory.getValue(statement.getObject());
        Collection<ONTObject<OWLAnnotation>> annotations = factory.getAnnotations(statement, config);
        OWLAnnotationAssertionAxiom res = factory.getOWLDataFactory().getOWLAnnotationAssertionAxiom(p.getOWLObject(), s.getOWLObject(), v.getOWLObject(), ONTObject.toSet(annotations));
        return ONTWrapperImpl.create(res, statement).append(annotations).append(s).append(p).append(v);
    }

    public static abstract class AxiomImpl
    extends AbstractPropertyAssertionTranslator.AssertionImpl<OWLAnnotationAssertionAxiom, OWLAnnotationSubject, OWLAnnotationProperty, OWLAnnotationValue>
    implements OWLAnnotationAssertionAxiom {
        protected AxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        public static AxiomImpl create(OntStatement statement, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
            return (AxiomImpl)WithAssertion.create(statement, model, SimpleImpl.FACTORY, WithAnnotationsImpl.FACTORY, SET_HASH_CODE, factory, config);
        }

        @Override
        public ONTObject<? extends OWLAnnotationSubject> findONTSubject(InternalObjectFactory factory) {
            return ONTAnnotationImpl.findONTSubject(this, factory);
        }

        @Override
        public ONTObject<? extends OWLAnnotationValue> findONTObject(InternalObjectFactory factory) {
            return ONTAnnotationImpl.findONTObject(this, factory);
        }

        @Override
        public ONTObject<? extends OWLAnnotationProperty> findONTPredicate(InternalObjectFactory factory) {
            return ONTAnnotationImpl.findONTPredicate(this, factory);
        }

        public OWLAnnotation getAnnotation() {
            return this.getDataFactory().getOWLAnnotation((OWLAnnotationProperty)this.getFPredicate(), (OWLAnnotationValue)this.getFObject());
        }

        public boolean isDeprecatedIRIAssertion() {
            return ONTAnnotationImpl.isDeprecated(this.predicate, this.object);
        }

        @Override
        protected OWLAnnotationAssertionAxiom createAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
            return this.getDataFactory().getOWLAnnotationAssertionAxiom((OWLAnnotationProperty)this.getFPredicate(), (OWLAnnotationSubject)this.getFSubject(), (OWLAnnotationValue)this.getFObject(), annotations);
        }

        @Override
        public boolean canContainNamedIndividuals() {
            return false;
        }

        @Override
        public boolean canContainDataProperties() {
            return false;
        }

        @Override
        public boolean canContainObjectProperties() {
            return false;
        }

        public static class WithAnnotationsImpl
        extends AxiomImpl
        implements WithAssertion.WithAnnotations<WithAnnotationsImpl, OWLAnnotationSubject, OWLAnnotationProperty, OWLAnnotationValue> {
            private static final BiFunction<Triple, Supplier<OntModel>, WithAnnotationsImpl> FACTORY = WithAnnotationsImpl::new;
            protected final InternalCache.Loading<WithAnnotationsImpl, Object[]> content = this.createContentCache();

            public WithAnnotationsImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public InternalCache.Loading<WithAnnotationsImpl, Object[]> getContentCache() {
                return this.content;
            }
        }

        public static class SimpleImpl
        extends AxiomImpl
        implements WithAssertion.Simple<OWLAnnotationSubject, OWLAnnotationProperty, OWLAnnotationValue> {
            private static final BiFunction<Triple, Supplier<OntModel>, SimpleImpl> FACTORY = SimpleImpl::new;

            protected SimpleImpl(Triple t, Supplier<OntModel> m) {
                super(t, m);
            }

            @Override
            public boolean containsDatatype(OWLDatatype datatype) {
                return this.object instanceof LiteralLabel && this.findLiteral(this.getObjectFactory()).containsEntityInSignature((OWLEntity)datatype);
            }

            @Override
            public boolean containsAnnotationProperty(OWLAnnotationProperty property) {
                return ((OWLAnnotationProperty)this.getONTPredicate().getOWLObject()).equals(property);
            }

            @Override
            public Set<OWLAnonymousIndividual> getAnonymousIndividualSet() {
                Set<OWLAnonymousIndividual> res = SimpleImpl.createSortedSet();
                InternalObjectFactory factory = null;
                if (this.subject instanceof BlankNodeId) {
                    factory = this.getObjectFactory();
                    res.add(this.findAnonymousSubject(factory));
                }
                if (this.object instanceof BlankNodeId) {
                    res.add(this.findAnonymousObject(factory == null ? this.getObjectFactory() : factory));
                }
                return res;
            }

            @Override
            public Set<OWLAnnotationProperty> getAnnotationPropertySet() {
                return SimpleImpl.createSet(this.getProperty());
            }

            @Override
            public Set<OWLDatatype> getDatatypeSet() {
                return this.object instanceof LiteralLabel ? SimpleImpl.createSet(this.findLiteral(this.getObjectFactory()).getDatatype()) : SimpleImpl.createSet();
            }

            @Override
            public Set<OWLEntity> getSignatureSet() {
                Set<OWLEntity> res = SimpleImpl.createSortedSet();
                InternalObjectFactory factory = this.getObjectFactory();
                res.add((OWLEntity)this.findONTPredicate(factory).getOWLObject());
                if (this.object instanceof LiteralLabel) {
                    res.add((OWLEntity)this.findLiteral(factory).getDatatype());
                }
                return res;
            }

            protected OWLLiteral findLiteral(InternalObjectFactory factory) {
                return ONTLiteralImpl.find((LiteralLabel)this.object, factory, this.model).getOWLObject();
            }

            private OWLAnonymousIndividual findAnonymousSubject(InternalObjectFactory factory) {
                return this.findAnonymousIndividual((BlankNodeId)this.subject, factory).getOWLObject();
            }

            private OWLAnonymousIndividual findAnonymousObject(InternalObjectFactory factory) {
                return this.findAnonymousIndividual((BlankNodeId)this.object, factory).getOWLObject();
            }
        }
    }
}

