/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.WithTwoObjects;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.semanticweb.owlapi.model.HasProperty;
import org.semanticweb.owlapi.model.HasRange;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyExpression;

public abstract class AbstractPropertyRangeTranslator<Axiom extends OWLAxiom & HasProperty<?>, P extends OntProperty>
extends AxiomTranslator<Axiom> {
    @Override
    public void write(Axiom axiom, OntModel graph) {
        WriteHelper.writeTriple(graph, ((HasProperty)axiom).getProperty(), RDFS.range, ((HasRange)axiom).getRange(), (Collection<OWLAnnotation>)axiom.annotationsAsList());
    }

    abstract Class<P> getView();

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, InternalConfig config) {
        return OntModels.listLocalStatements(model, null, RDFS.range, null).filterKeep(s -> this.filter((OntStatement)s, config));
    }

    protected boolean filter(OntStatement statement, InternalConfig config) {
        return statement.getSubject().canAs(this.getView());
    }

    @Override
    public boolean testStatement(OntStatement statement, InternalConfig config) {
        return RDFS.range.equals(statement.getPredicate()) && this.filter(statement, config);
    }

    protected static abstract class RangeAxiomImpl<A extends OWLAxiom & HasProperty<P>, P extends OWLPropertyExpression, R extends OWLObject>
    extends ONTAxiomImpl<A>
    implements WithTwoObjects<P, R> {
        protected RangeAxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        protected RangeAxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        public P getProperty() {
            return (P)((OWLPropertyExpression)this.getONTSubject().getOWLObject());
        }

        public R getRange() {
            return (R)this.getONTObject().getOWLObject();
        }
    }
}

