/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntEntity;
import com.github.owlcs.ontapi.jena.model.OntFacetRestriction;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntSWRL;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.owlapi.objects.OWLAnonymousIndividualImpl;
import com.github.owlcs.ontapi.owlapi.objects.OWLLiteralImpl;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.impl.LiteralImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.vocabulary.RDFS;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.DataRangeType;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationObject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.SWRLArgument;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObject;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.vocab.OWLFacet;

public class WriteHelper {
    public static RDFNode toRDFNode(OWLObject object) {
        if (object instanceof OWLLiteral) {
            return WriteHelper.toLiteral((OWLLiteral)object);
        }
        return WriteHelper.toResource(object);
    }

    public static Optional<Resource> resource(OWLObject o) throws OntApiException {
        return o == null ? Optional.empty() : Optional.of(WriteHelper.toResource(o));
    }

    public static Resource toResource(OWLObject object) throws OntApiException {
        if (object instanceof OWLIndividual) {
            return WriteHelper.toResource((OWLIndividual)object);
        }
        return WriteHelper.toResource(WriteHelper.toIRI(object));
    }

    private static Resource toResource(OWLIndividual individual) {
        return individual.isAnonymous() ? WriteHelper.toResource(individual.asOWLAnonymousIndividual()) : WriteHelper.toResource(individual.asOWLNamedIndividual().getIRI());
    }

    public static Resource toResource(OWLAnonymousIndividual individual) {
        return new ResourceImpl(WriteHelper.toBlankNode(individual), null);
    }

    public static Node toBlankNode(OWLAnonymousIndividual individual) {
        BlankNodeId id = OWLAnonymousIndividualImpl.asONT(individual).getBlankNodeId();
        return NodeFactory.createBlankNode((BlankNodeId)id);
    }

    private static Resource toResource(IRI iri) {
        return ResourceFactory.createResource((String)OntApiException.notNull(iri, "Null iri").getIRIString());
    }

    public static Property toProperty(OWLPropertyExpression object) {
        return WriteHelper.toProperty(WriteHelper.toIRI(object));
    }

    private static Property toProperty(IRI iri) {
        return ResourceFactory.createProperty((String)OntApiException.notNull(iri, "Null iri").getIRIString());
    }

    public static Literal toLiteral(OWLLiteral literal) {
        return new LiteralImpl(WriteHelper.toLiteralNode(literal), null);
    }

    public static Node toLiteralNode(OWLLiteral literal) {
        LiteralLabel lab = OWLLiteralImpl.asONT(literal).getLiteralLabel();
        return NodeFactory.createLiteral((LiteralLabel)lab);
    }

    public static Resource getRDFType(OWLEntity entity) {
        if (entity.isOWLClass()) {
            return OWL.Class;
        }
        if (entity.isOWLDataProperty()) {
            return OWL.DatatypeProperty;
        }
        if (entity.isOWLObjectProperty()) {
            return OWL.ObjectProperty;
        }
        if (entity.isOWLNamedIndividual()) {
            return OWL.NamedIndividual;
        }
        if (entity.isOWLAnnotationProperty()) {
            return OWL.AnnotationProperty;
        }
        if (entity.isOWLDatatype()) {
            return RDFS.Datatype;
        }
        throw new OntApiException("Unsupported " + entity);
    }

    public static Class<? extends OntEntity> getEntityType(OWLEntity entity) {
        if (entity.isOWLClass()) {
            return OntClass.Named.class;
        }
        if (entity.isOWLDataProperty()) {
            return OntDataProperty.class;
        }
        if (entity.isOWLObjectProperty()) {
            return OntObjectProperty.Named.class;
        }
        if (entity.isOWLNamedIndividual()) {
            return OntIndividual.Named.class;
        }
        if (entity.isOWLAnnotationProperty()) {
            return OntAnnotationProperty.class;
        }
        if (entity.isOWLDatatype()) {
            return OntDataRange.Named.class;
        }
        throw new OntApiException("Unsupported " + entity);
    }

    public static Class<? extends OntFacetRestriction> getFRType(OWLFacet facet) {
        switch (facet) {
            case LENGTH: {
                return OntFacetRestriction.Length.class;
            }
            case MIN_LENGTH: {
                return OntFacetRestriction.MinLength.class;
            }
            case MAX_LENGTH: {
                return OntFacetRestriction.MaxLength.class;
            }
            case MIN_INCLUSIVE: {
                return OntFacetRestriction.MinInclusive.class;
            }
            case MAX_INCLUSIVE: {
                return OntFacetRestriction.MaxInclusive.class;
            }
            case MIN_EXCLUSIVE: {
                return OntFacetRestriction.MinExclusive.class;
            }
            case MAX_EXCLUSIVE: {
                return OntFacetRestriction.MaxExclusive.class;
            }
            case PATTERN: {
                return OntFacetRestriction.Pattern.class;
            }
            case FRACTION_DIGITS: {
                return OntFacetRestriction.FractionDigits.class;
            }
            case TOTAL_DIGITS: {
                return OntFacetRestriction.TotalDigits.class;
            }
            case LANG_RANGE: {
                return OntFacetRestriction.LangRange.class;
            }
        }
        throw new OntApiException.IllegalArgument("Unsupported " + facet);
    }

    public static void writeAssertionTriple(OntModel model, OWLObject subject, OWLPropertyExpression property, OWLObject object, Collection<OWLAnnotation> annotations) {
        OntObject s = (OntObject)WriteHelper.addRDFNode(model, subject).as(OntObject.class);
        Property p = (Property)WriteHelper.addRDFNode(model, (OWLObject)property).as(Property.class);
        RDFNode o = WriteHelper.addRDFNode(model, object);
        WriteHelper.addAnnotations(s.addStatement(p, o), annotations);
    }

    public static void writeDeclarationTriple(OntModel model, OWLEntity subject, Property predicate, RDFNode object, Collection<OWLAnnotation> annotations) {
        WriteHelper.addAnnotations(((OntEntity)WriteHelper.toResource((OWLObject)subject).inModel((Model)model).addProperty(predicate, object).as(WriteHelper.getEntityType(subject))).getMainStatement(), annotations);
    }

    public static void writeTriple(OntModel model, OWLObject subject, Property predicate, OWLObject object, Collection<OWLAnnotation> annotations) {
        WriteHelper.writeTriple(model, subject, predicate, WriteHelper.addRDFNode(model, object), annotations);
    }

    public static void writeTriple(OntModel model, OWLObject subject, Property predicate, RDFNode object, Collection<OWLAnnotation> annotations) {
        OntObject s = (OntObject)WriteHelper.addRDFNode(model, subject).as(OntObject.class);
        WriteHelper.addAnnotations(s.addStatement(predicate, object), annotations);
    }

    public static void writeList(OntModel model, OWLObject subject, Property predicate, Collection<? extends OWLObject> objects, Collection<OWLAnnotation> annotations) {
        OntObject s = (OntObject)WriteHelper.addRDFNode(model, subject).as(OntObject.class);
        WriteHelper.addAnnotations(s.addStatement(predicate, (RDFNode)WriteHelper.addRDFList(model, objects)), annotations);
    }

    public static RDFList addRDFList(OntModel model, Collection<? extends OWLObject> objects) {
        return model.createList(objects.stream().map(o -> WriteHelper.addRDFNode(model, o)).iterator());
    }

    public static OntAnnotationProperty addAnnotationProperty(OntModel model, OWLEntity entity) {
        String uri = entity.getIRI().getIRIString();
        return WriteHelper.fetchOntEntity(model, OntAnnotationProperty.class, uri);
    }

    public static OntObjectProperty addObjectProperty(OntModel model, OWLObjectPropertyExpression ope) {
        if (!ope.isOWLObjectProperty()) {
            return WriteHelper.addInverseOf(model, (OWLObjectInverseOf)ope);
        }
        return WriteHelper.fetchOntEntity(model, OntObjectProperty.Named.class, ope.getNamedProperty().getIRI().getIRIString());
    }

    public static OntDataProperty addDataProperty(OntModel model, OWLDataPropertyExpression dpe) {
        if (!dpe.isOWLDataProperty()) {
            throw new OntApiException("Unsupported " + dpe);
        }
        String uri = dpe.asOWLDataProperty().getIRI().getIRIString();
        return WriteHelper.fetchOntEntity(model, OntDataProperty.class, uri);
    }

    public static OntEntity addOntEntity(OntModel model, OWLEntity entity) {
        Class<? extends OntEntity> view = WriteHelper.getEntityType(entity);
        String uri = entity.getIRI().getIRIString();
        return WriteHelper.fetchOntEntity(model, view, uri);
    }

    public static OntObjectProperty.Inverse addInverseOf(OntModel model, OWLObjectInverseOf io) {
        String uri = io.getInverseProperty().getNamedProperty().getIRI().getIRIString();
        return WriteHelper.fetchOntEntity(model, OntObjectProperty.Named.class, uri).createInverse();
    }

    public static OntFacetRestriction addFacetRestriction(OntModel model, OWLFacetRestriction fr) {
        return model.createFacetRestriction(WriteHelper.getFRType(fr.getFacet()), WriteHelper.addLiteral(model, fr.getFacetValue()));
    }

    public static OntClass addClassExpression(OntModel model, OWLClassExpression ce) {
        if (ce.isOWLClass()) {
            return (OntClass)WriteHelper.addOntEntity(model, (OWLEntity)ce.asOWLClass()).as(OntClass.Named.class);
        }
        ClassExpressionType type = ce.getClassExpressionType();
        CETranslator cet = OntApiException.notNull(CETranslator.valueOf(type), "Unsupported class-expression " + ce + "/" + type);
        return (OntClass)((CETranslator.Translator)cet.translator).add(model, ce).as(OntClass.class);
    }

    public static OntDataRange addDataRange(OntModel model, OWLDataRange dr) {
        if (dr.isOWLDatatype()) {
            return (OntDataRange)WriteHelper.addOntEntity(model, (OWLEntity)dr.asOWLDatatype()).as(OntDataRange.Named.class);
        }
        DataRangeType type = dr.getDataRangeType();
        DRTranslator drt = OntApiException.notNull(DRTranslator.valueOf(type), "Unsupported data-range expression " + dr + "/" + type);
        return (OntDataRange)((DRTranslator.Translator)drt.translator).add(model, dr).as(OntDataRange.class);
    }

    public static OntIndividual.Anonymous getAnonymousIndividual(OntModel model, OWLAnonymousIndividual ai) {
        Resource res = WriteHelper.toResource(OntApiException.notNull(ai, "Null anonymous individual.")).inModel((Model)model);
        if (!res.canAs(OntIndividual.Anonymous.class)) {
            return OntModels.asAnonymousIndividual((RDFNode)res);
        }
        return (OntIndividual.Anonymous)res.as(OntIndividual.Anonymous.class);
    }

    public static OntIndividual addIndividual(OntModel model, OWLIndividual i) {
        if (i.isAnonymous()) {
            return WriteHelper.getAnonymousIndividual(model, i.asOWLAnonymousIndividual());
        }
        String uri = i.asOWLNamedIndividual().getIRI().getIRIString();
        return WriteHelper.fetchOntEntity(model, OntIndividual.Named.class, uri);
    }

    public static <E extends OntEntity> E fetchOntEntity(OntModel model, Class<E> type, String uri) {
        E res = model.getOntEntity(type, uri);
        if (res == null || !res.isBuiltIn()) {
            res = model.createOntEntity(type, uri);
        }
        return res;
    }

    public static RDFNode addRDFNode(OntModel model, OWLObject o) {
        if (o instanceof OWLEntity) {
            return WriteHelper.addOntEntity(model, (OWLEntity)o);
        }
        if (o instanceof OWLLiteral) {
            return WriteHelper.addLiteral(model, (OWLLiteral)o);
        }
        if (o instanceof OWLObjectInverseOf) {
            return WriteHelper.addInverseOf(model, (OWLObjectInverseOf)o);
        }
        if (o instanceof OWLFacetRestriction) {
            return WriteHelper.addFacetRestriction(model, (OWLFacetRestriction)o);
        }
        if (o instanceof OWLClassExpression) {
            return WriteHelper.addClassExpression(model, (OWLClassExpression)o);
        }
        if (o instanceof OWLDataRange) {
            return WriteHelper.addDataRange(model, (OWLDataRange)o);
        }
        if (o instanceof OWLAnonymousIndividual) {
            return WriteHelper.getAnonymousIndividual(model, (OWLAnonymousIndividual)o);
        }
        if (o instanceof SWRLObject) {
            return WriteHelper.addSWRLObject(model, (SWRLObject)o);
        }
        return WriteHelper.toRDFNode(o).inModel((Model)model);
    }

    public static OntSWRL.Variable addSWRLVariable(OntModel model, SWRLVariable var) {
        return model.createSWRLVariable(var.getIRI().getIRIString());
    }

    public static OntSWRL.Atom<?> addSWRLAtom(OntModel model, SWRLAtom atom) {
        SWRLAtomTranslator swrlt = OntApiException.notNull(SWRLAtomTranslator.valueOf(atom), "Unsupported swrl-atom " + atom);
        return (OntSWRL.Atom)((SWRLAtomTranslator.Translator)swrlt.translator).add(model, atom).as(OntSWRL.Atom.class);
    }

    public static RDFNode addSWRLObject(OntModel model, SWRLObject o) {
        if (o instanceof SWRLAtom) {
            return WriteHelper.addSWRLAtom(model, (SWRLAtom)o);
        }
        if (o instanceof SWRLArgument) {
            if (o instanceof SWRLVariable) {
                return WriteHelper.addSWRLVariable(model, (SWRLVariable)o);
            }
            if (o instanceof SWRLLiteralArgument) {
                return WriteHelper.addRDFNode(model, (OWLObject)((SWRLLiteralArgument)o).getLiteral());
            }
            if (o instanceof SWRLIndividualArgument) {
                return WriteHelper.addRDFNode(model, (OWLObject)((SWRLIndividualArgument)o).getIndividual());
            }
        }
        throw new OntApiException("Unsupported SWRL-Object: " + o);
    }

    public static void addAnnotations(OntStatement statement, Collection<OWLAnnotation> annotations) {
        annotations.forEach(a -> {
            OntStatement st = statement.addAnnotation(WriteHelper.addAnnotationProperty(statement.getModel(), (OWLEntity)a.getProperty()), WriteHelper.addRDFNode(statement.getModel(), (OWLObject)a.getValue()));
            WriteHelper.addAnnotations(st, (Collection<OWLAnnotation>)a.annotationsAsList());
        });
    }

    public static void addAnnotations(OntObject object, Collection<OWLAnnotation> annotations) {
        WriteHelper.addAnnotations(OntApiException.notNull(object.getMainStatement(), "Can't determine the root statement for " + object), annotations);
    }

    public static IRI toIRI(OWLObject object) {
        if (OntApiException.notNull(object, "Null owl-object specified.").isIRI()) {
            return (IRI)object;
        }
        if (object instanceof HasIRI) {
            return ((HasIRI)object).getIRI();
        }
        if (object instanceof OWLAnnotationObject) {
            return (IRI)((OWLAnnotationObject)object).asIRI().orElseThrow(() -> new OntApiException("Not iri: " + object));
        }
        if (object instanceof OWLClassExpression) {
            return WriteHelper.toIRI((OWLClassExpression)object);
        }
        if (object instanceof OWLPropertyExpression) {
            return WriteHelper.toIRI((OWLPropertyExpression)object);
        }
        throw new OntApiException("Unsupported owl-object: " + object);
    }

    private static IRI toIRI(OWLClassExpression expression) {
        OWLClass res = null;
        if (ClassExpressionType.OWL_CLASS.equals((Object)expression.getClassExpressionType())) {
            res = (OWLClass)expression;
        }
        return ((HasIRI)OntApiException.notNull(res, "Unsupported class-expression: " + expression)).getIRI();
    }

    private static IRI toIRI(OWLPropertyExpression expression) {
        if (expression.isOWLDataProperty()) {
            return expression.asOWLDataProperty().getIRI();
        }
        if (expression.isOWLObjectProperty()) {
            return expression.asOWLObjectProperty().getIRI();
        }
        if (expression.isOWLAnnotationProperty()) {
            return expression.asOWLAnnotationProperty().getIRI();
        }
        throw new OntApiException("Unsupported property-expression: " + expression);
    }

    public static Literal addLiteral(OntModel model, OWLLiteral literal) {
        WriteHelper.addDataRange(model, (OWLDataRange)literal.getDatatype()).as(OntDataRange.Named.class);
        return model.asRDFNode(WriteHelper.toLiteralNode(literal)).asLiteral();
    }

    private static enum CETranslator {
        OBJECT_MAX_CARDINALITY(ClassExpressionType.OBJECT_MAX_CARDINALITY, (Translator<? extends OWLClassExpression, ? extends OntClass>)new Translator<OWLObjectMaxCardinality, OntClass.ObjectMaxCardinality>(){

            @Override
            OntClass.ObjectMaxCardinality translate(OntModel model, OWLObjectMaxCardinality expression) {
                OntObjectProperty p = WriteHelper.addObjectProperty(model, expression.getProperty());
                OntClass c = expression.getFiller() == null ? null : (OntClass)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntClass.class);
                return model.createObjectMaxCardinality(p, expression.getCardinality(), c);
            }
        }),
        DATA_MAX_CARDINALITY(ClassExpressionType.DATA_MAX_CARDINALITY, (Translator<? extends OWLClassExpression, ? extends OntClass>)new Translator<OWLDataMaxCardinality, OntClass.DataMaxCardinality>(){

            @Override
            OntClass.DataMaxCardinality translate(OntModel model, OWLDataMaxCardinality expression) {
                OntDataProperty p = WriteHelper.addDataProperty(model, expression.getProperty());
                OntDataRange d = expression.getFiller() == null ? null : (OntDataRange)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntDataRange.class);
                return model.createDataMaxCardinality(p, expression.getCardinality(), d);
            }
        }),
        OBJECT_MIN_CARDINALITY(ClassExpressionType.OBJECT_MIN_CARDINALITY, (Translator<? extends OWLClassExpression, ? extends OntClass>)new Translator<OWLObjectMinCardinality, OntClass.ObjectMinCardinality>(){

            @Override
            OntClass.ObjectMinCardinality translate(OntModel model, OWLObjectMinCardinality expression) {
                OntObjectProperty p = WriteHelper.addObjectProperty(model, expression.getProperty());
                OntClass c = expression.getFiller() == null ? null : (OntClass)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntClass.class);
                return model.createObjectMinCardinality(p, expression.getCardinality(), c);
            }
        }),
        DATA_MIN_CARDINALITY(ClassExpressionType.DATA_MIN_CARDINALITY, (Translator<? extends OWLClassExpression, ? extends OntClass>)new Translator<OWLDataMinCardinality, OntClass.DataMinCardinality>(){

            @Override
            OntClass.DataMinCardinality translate(OntModel model, OWLDataMinCardinality expression) {
                OntDataProperty p = WriteHelper.addDataProperty(model, expression.getProperty());
                OntDataRange d = expression.getFiller() == null ? null : (OntDataRange)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntDataRange.class);
                return model.createDataMinCardinality(p, expression.getCardinality(), d);
            }
        }),
        OBJECT_EXACT_CARDINALITY(ClassExpressionType.OBJECT_EXACT_CARDINALITY, (Translator<? extends OWLClassExpression, ? extends OntClass>)new Translator<OWLObjectExactCardinality, OntClass.ObjectCardinality>(){

            @Override
            OntClass.ObjectCardinality translate(OntModel model, OWLObjectExactCardinality expression) {
                OntObjectProperty p = WriteHelper.addObjectProperty(model, expression.getProperty());
                OntClass c = expression.getFiller() == null ? null : (OntClass)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntClass.class);
                return model.createObjectCardinality(p, expression.getCardinality(), c);
            }
        }),
        DATA_EXACT_CARDINALITY(ClassExpressionType.DATA_EXACT_CARDINALITY, (Translator<? extends OWLClassExpression, ? extends OntClass>)new Translator<OWLDataExactCardinality, OntClass.DataCardinality>(){

            @Override
            OntClass.DataCardinality translate(OntModel model, OWLDataExactCardinality expression) {
                OntDataProperty p = WriteHelper.addDataProperty(model, expression.getProperty());
                OntDataRange d = expression.getFiller() == null ? null : (OntDataRange)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntDataRange.class);
                return model.createDataCardinality(p, expression.getCardinality(), d);
            }
        }),
        OBJECT_ALL_VALUES_FROM(ClassExpressionType.OBJECT_ALL_VALUES_FROM, (Translator<? extends OWLClassExpression, ? extends OntClass>)new Translator<OWLObjectAllValuesFrom, OntClass.ObjectAllValuesFrom>(){

            @Override
            OntClass.ObjectAllValuesFrom translate(OntModel model, OWLObjectAllValuesFrom expression) {
                OntObjectProperty p = WriteHelper.addObjectProperty(model, expression.getProperty());
                OntClass c = (OntClass)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntClass.class);
                return model.createObjectAllValuesFrom(p, c);
            }
        }),
        DATA_ALL_VALUES_FROM(ClassExpressionType.DATA_ALL_VALUES_FROM, (Translator<? extends OWLClassExpression, ? extends OntClass>)new Translator<OWLDataAllValuesFrom, OntClass.DataAllValuesFrom>(){

            @Override
            OntClass.DataAllValuesFrom translate(OntModel model, OWLDataAllValuesFrom expression) {
                OntDataProperty p = WriteHelper.addDataProperty(model, expression.getProperty());
                OntDataRange d = (OntDataRange)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntDataRange.class);
                return model.createDataAllValuesFrom(p, d);
            }
        }),
        OBJECT_SOME_VALUES_FROM(ClassExpressionType.OBJECT_SOME_VALUES_FROM, (Translator<? extends OWLClassExpression, ? extends OntClass>)new Translator<OWLObjectSomeValuesFrom, OntClass.ObjectSomeValuesFrom>(){

            @Override
            OntClass.ObjectSomeValuesFrom translate(OntModel model, OWLObjectSomeValuesFrom expression) {
                OntObjectProperty p = WriteHelper.addObjectProperty(model, expression.getProperty());
                OntClass c = (OntClass)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntClass.class);
                return model.createObjectSomeValuesFrom(p, c);
            }
        }),
        DATA_SOME_VALUES_FROM(ClassExpressionType.DATA_SOME_VALUES_FROM, (Translator<? extends OWLClassExpression, ? extends OntClass>)new Translator<OWLDataSomeValuesFrom, OntClass.DataSomeValuesFrom>(){

            @Override
            OntClass.DataSomeValuesFrom translate(OntModel model, OWLDataSomeValuesFrom expression) {
                OntDataProperty p = WriteHelper.addDataProperty(model, expression.getProperty());
                OntDataRange d = (OntDataRange)WriteHelper.addRDFNode(model, expression.getFiller()).as(OntDataRange.class);
                return model.createDataSomeValuesFrom(p, d);
            }
        }),
        OBJECT_HAS_VALUE(ClassExpressionType.OBJECT_HAS_VALUE, (Translator<? extends OWLClassExpression, ? extends OntClass>)new Translator<OWLObjectHasValue, OntClass.ObjectHasValue>(){

            @Override
            OntClass.ObjectHasValue translate(OntModel model, OWLObjectHasValue expression) {
                OntObjectProperty p = WriteHelper.addObjectProperty(model, expression.getProperty());
                OntIndividual i = WriteHelper.addIndividual(model, (OWLIndividual)expression.getFiller());
                return model.createObjectHasValue(p, i);
            }
        }),
        DATA_HAS_VALUE(ClassExpressionType.DATA_HAS_VALUE, (Translator<? extends OWLClassExpression, ? extends OntClass>)new Translator<OWLDataHasValue, OntClass.DataHasValue>(){

            @Override
            OntClass.DataHasValue translate(OntModel model, OWLDataHasValue expression) {
                OntDataProperty p = WriteHelper.addDataProperty(model, expression.getProperty());
                Literal l = WriteHelper.addLiteral(model, (OWLLiteral)expression.getFiller());
                return model.createDataHasValue(p, l);
            }
        }),
        HAS_SELF(ClassExpressionType.OBJECT_HAS_SELF, (Translator<? extends OWLClassExpression, ? extends OntClass>)new Translator<OWLObjectHasSelf, OntClass.HasSelf>(){

            @Override
            OntClass.HasSelf translate(OntModel model, OWLObjectHasSelf expression) {
                return model.createHasSelf(WriteHelper.addObjectProperty(model, expression.getProperty()));
            }
        }),
        UNION_OF(ClassExpressionType.OBJECT_UNION_OF, (Translator<? extends OWLClassExpression, ? extends OntClass>)new Translator<OWLObjectUnionOf, OntClass.UnionOf>(){

            @Override
            OntClass.UnionOf translate(OntModel model, OWLObjectUnionOf expression) {
                return model.createObjectUnionOf(expression.operands().map(ce -> (OntClass)WriteHelper.addRDFNode(model, (OWLObject)ce).as(OntClass.class)).collect(Collectors.toList()));
            }
        }),
        INTERSECTION_OF(ClassExpressionType.OBJECT_INTERSECTION_OF, (Translator<? extends OWLClassExpression, ? extends OntClass>)new Translator<OWLObjectIntersectionOf, OntClass.IntersectionOf>(){

            @Override
            OntClass.IntersectionOf translate(OntModel model, OWLObjectIntersectionOf expression) {
                return model.createObjectIntersectionOf(expression.operands().map(ce -> (OntClass)WriteHelper.addRDFNode(model, (OWLObject)ce).as(OntClass.class)).collect(Collectors.toList()));
            }
        }),
        ONE_OF(ClassExpressionType.OBJECT_ONE_OF, (Translator<? extends OWLClassExpression, ? extends OntClass>)new Translator<OWLObjectOneOf, OntClass.OneOf>(){

            @Override
            OntClass.OneOf translate(OntModel model, OWLObjectOneOf expression) {
                return model.createObjectOneOf(expression.operands().map(i -> WriteHelper.addIndividual(model, i)).collect(Collectors.toList()));
            }
        }),
        COMPLEMENT_OF(ClassExpressionType.OBJECT_COMPLEMENT_OF, (Translator<? extends OWLClassExpression, ? extends OntClass>)new Translator<OWLObjectComplementOf, OntClass.ComplementOf>(){

            @Override
            OntClass.ComplementOf translate(OntModel model, OWLObjectComplementOf expression) {
                return model.createObjectComplementOf((OntClass)WriteHelper.addRDFNode(model, (OWLObject)expression.getOperand()).as(OntClass.class));
            }
        });

        private final ClassExpressionType type;
        private final Translator<? extends OWLClassExpression, ? extends OntClass> translator;

        private CETranslator(ClassExpressionType type, Translator<? extends OWLClassExpression, ? extends OntClass> translator) {
            this.type = type;
            this.translator = translator;
        }

        public static CETranslator valueOf(ClassExpressionType type) {
            for (CETranslator t : CETranslator.values()) {
                if (!t.type.equals((Object)type)) continue;
                return t;
            }
            return null;
        }

        private static abstract class Translator<FROM extends OWLClassExpression, TO extends OntClass> {
            private Translator() {
            }

            private Resource add(OntModel model, OWLClassExpression expression) {
                return this.translate(model, expression);
            }

            abstract TO translate(OntModel var1, FROM var2);
        }
    }

    private static enum DRTranslator {
        ONE_OF(DataRangeType.DATA_ONE_OF, (Translator<? extends OWLDataRange, ? extends OntDataRange>)new Translator<OWLDataOneOf, OntDataRange.OneOf>(){

            @Override
            OntDataRange.OneOf translate(OntModel model, OWLDataOneOf expression) {
                return model.createDataOneOf(expression.values().map(l -> WriteHelper.addLiteral(model, l)).collect(Collectors.toList()));
            }
        }),
        RESTRICTION(DataRangeType.DATATYPE_RESTRICTION, (Translator<? extends OWLDataRange, ? extends OntDataRange>)new Translator<OWLDatatypeRestriction, OntDataRange.Restriction>(){

            @Override
            OntDataRange.Restriction translate(OntModel model, OWLDatatypeRestriction expression) {
                return model.createDataRestriction((OntDataRange.Named)WriteHelper.addRDFNode(model, (OWLObject)expression.getDatatype()).as(OntDataRange.Named.class), expression.facetRestrictions().map(f -> WriteHelper.addFacetRestriction(model, f)).collect(Collectors.toList()));
            }
        }),
        COMPLEMENT_OF(DataRangeType.DATA_COMPLEMENT_OF, (Translator<? extends OWLDataRange, ? extends OntDataRange>)new Translator<OWLDataComplementOf, OntDataRange.ComplementOf>(){

            @Override
            OntDataRange.ComplementOf translate(OntModel model, OWLDataComplementOf expression) {
                return model.createDataComplementOf((OntDataRange)WriteHelper.addRDFNode(model, (OWLObject)expression.getDataRange()).as(OntDataRange.class));
            }
        }),
        UNION_OF(DataRangeType.DATA_UNION_OF, (Translator<? extends OWLDataRange, ? extends OntDataRange>)new Translator<OWLDataUnionOf, OntDataRange.UnionOf>(){

            @Override
            OntDataRange.UnionOf translate(OntModel model, OWLDataUnionOf expression) {
                return model.createDataUnionOf(expression.operands().map(dr -> (OntDataRange)WriteHelper.addRDFNode(model, (OWLObject)dr).as(OntDataRange.class)).collect(Collectors.toList()));
            }
        }),
        INTERSECTION_OF(DataRangeType.DATA_INTERSECTION_OF, (Translator<? extends OWLDataRange, ? extends OntDataRange>)new Translator<OWLDataIntersectionOf, OntDataRange.IntersectionOf>(){

            @Override
            OntDataRange.IntersectionOf translate(OntModel model, OWLDataIntersectionOf expression) {
                return model.createDataIntersectionOf(expression.operands().map(dr -> (OntDataRange)WriteHelper.addRDFNode(model, (OWLObject)dr).as(OntDataRange.class)).collect(Collectors.toList()));
            }
        });

        private final DataRangeType type;
        private final Translator<? extends OWLDataRange, ? extends OntDataRange> translator;

        private DRTranslator(DataRangeType type, Translator<? extends OWLDataRange, ? extends OntDataRange> translator) {
            this.translator = translator;
            this.type = type;
        }

        public static DRTranslator valueOf(DataRangeType type) {
            for (DRTranslator t : DRTranslator.values()) {
                if (!t.type.equals((Object)type)) continue;
                return t;
            }
            return null;
        }

        private static abstract class Translator<FROM extends OWLDataRange, TO extends OntDataRange> {
            private Translator() {
            }

            private Resource add(OntModel model, OWLDataRange expression) {
                return this.translate(model, expression);
            }

            abstract TO translate(OntModel var1, FROM var2);
        }
    }

    private static enum SWRLAtomTranslator {
        BUILT_IN(SWRLBuiltInAtom.class, new Translator<SWRLBuiltInAtom, OntSWRL.Atom.WithBuiltin>(){

            @Override
            OntSWRL.Atom.WithBuiltin translate(OntModel model, SWRLBuiltInAtom atom) {
                return model.createBuiltInSWRLAtom(model.createResource(atom.getPredicate().getIRIString()), atom.arguments().map(a -> (OntSWRL.DArg)WriteHelper.addSWRLObject(model, (SWRLObject)a).as(OntSWRL.DArg.class)).collect(Collectors.toList()));
            }
        }),
        OWL_CLASS(SWRLClassAtom.class, new Translator<SWRLClassAtom, OntSWRL.Atom.WithClass>(){

            @Override
            OntSWRL.Atom.WithClass translate(OntModel model, SWRLClassAtom atom) {
                return model.createClassSWRLAtom(WriteHelper.addClassExpression(model, atom.getPredicate()), (OntSWRL.IArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getArgument()).as(OntSWRL.IArg.class));
            }
        }),
        DATA_PROPERTY(SWRLDataPropertyAtom.class, new Translator<SWRLDataPropertyAtom, OntSWRL.Atom.WithDataProperty>(){

            @Override
            OntSWRL.Atom.WithDataProperty translate(OntModel model, SWRLDataPropertyAtom atom) {
                return model.createDataPropertySWRLAtom(WriteHelper.addDataProperty(model, atom.getPredicate()), (OntSWRL.IArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getFirstArgument()).as(OntSWRL.IArg.class), (OntSWRL.DArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getSecondArgument()).as(OntSWRL.DArg.class));
            }
        }),
        DATA_RANGE(SWRLDataRangeAtom.class, new Translator<SWRLDataRangeAtom, OntSWRL.Atom.WithDataRange>(){

            @Override
            OntSWRL.Atom.WithDataRange translate(OntModel model, SWRLDataRangeAtom atom) {
                return model.createDataRangeSWRLAtom(WriteHelper.addDataRange(model, atom.getPredicate()), (OntSWRL.DArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getArgument()).as(OntSWRL.DArg.class));
            }
        }),
        DIFFERENT_INDIVIDUALS(SWRLDifferentIndividualsAtom.class, new Translator<SWRLDifferentIndividualsAtom, OntSWRL.Atom.WithDifferentIndividuals>(){

            @Override
            OntSWRL.Atom.WithDifferentIndividuals translate(OntModel model, SWRLDifferentIndividualsAtom atom) {
                return model.createDifferentIndividualsSWRLAtom((OntSWRL.IArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getFirstArgument()).as(OntSWRL.IArg.class), (OntSWRL.IArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getSecondArgument()).as(OntSWRL.IArg.class));
            }
        }),
        OBJECT_PROPERTY(SWRLObjectPropertyAtom.class, new Translator<SWRLObjectPropertyAtom, OntSWRL.Atom.WithObjectProperty>(){

            @Override
            OntSWRL.Atom.WithObjectProperty translate(OntModel model, SWRLObjectPropertyAtom atom) {
                return model.createObjectPropertySWRLAtom(WriteHelper.addObjectProperty(model, atom.getPredicate()), (OntSWRL.IArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getFirstArgument()).as(OntSWRL.IArg.class), (OntSWRL.IArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getSecondArgument()).as(OntSWRL.IArg.class));
            }
        }),
        SAME_INDIVIDUALS(SWRLSameIndividualAtom.class, new Translator<SWRLSameIndividualAtom, OntSWRL.Atom.WithSameIndividuals>(){

            @Override
            OntSWRL.Atom.WithSameIndividuals translate(OntModel model, SWRLSameIndividualAtom atom) {
                return model.createSameIndividualsSWRLAtom((OntSWRL.IArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getFirstArgument()).as(OntSWRL.IArg.class), (OntSWRL.IArg)WriteHelper.addSWRLObject(model, (SWRLObject)atom.getSecondArgument()).as(OntSWRL.IArg.class));
            }
        });

        private final Translator<? extends SWRLAtom, ? extends OntSWRL.Atom<?>> translator;
        private final Class<? extends SWRLAtom> type;

        private SWRLAtomTranslator(Class<? extends SWRLAtom> type, Translator<? extends SWRLAtom, ? extends OntSWRL.Atom<?>> translator) {
            this.translator = translator;
            this.type = type;
        }

        private static SWRLAtomTranslator valueOf(SWRLAtom atom) {
            for (SWRLAtomTranslator t : SWRLAtomTranslator.values()) {
                if (!t.type.isInstance(atom)) continue;
                return t;
            }
            return null;
        }

        private static abstract class Translator<FROM extends SWRLAtom, TO extends OntSWRL.Atom<?>> {
            private Translator() {
            }

            private Resource add(OntModel model, SWRLAtom atom) {
                return this.translate(model, atom);
            }

            abstract TO translate(OntModel var1, FROM var2);
        }
    }
}

