/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.internal.ReadHelper;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntFacetRestriction;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntSWRL;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import java.util.HashSet;
import java.util.Objects;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Resource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLVariable;

public class SimpleObjectFactory
implements InternalObjectFactory {
    protected final DataFactory factory;

    public SimpleObjectFactory(DataFactory factory) {
        this.factory = Objects.requireNonNull(factory);
    }

    protected IRI toIRI(Resource r) {
        return this.toIRI(r.getURI());
    }

    @Override
    public ONTObject<? extends OWLClassExpression> getClass(OntClass ce) {
        return ReadHelper.calcClassExpression(ce, this, new HashSet<Resource>());
    }

    @Override
    public ONTObject<? extends OWLDataRange> getDatatype(OntDataRange dr) {
        return ReadHelper.calcDataRange(dr, this, new HashSet<Resource>());
    }

    @Override
    public ONTObject<OWLFacetRestriction> getFacetRestriction(OntFacetRestriction fr) {
        return ReadHelper.getFacetRestriction(fr, this);
    }

    @Override
    public ONTObject<OWLClass> getClass(OntClass.Named ce) {
        IRI iri = this.toIRI(OntApiException.notNull(ce, "Null class."));
        return ONTWrapperImpl.create(this.getOWLDataFactory().getOWLClass(iri), ce);
    }

    @Override
    public ONTObject<OWLDatatype> getDatatype(OntDataRange.Named dr) {
        IRI iri = this.toIRI(OntApiException.notNull(dr, "Null datatype."));
        return ONTWrapperImpl.create(this.getOWLDataFactory().getOWLDatatype(iri), dr);
    }

    @Override
    public ONTObject<OWLObjectProperty> getProperty(OntObjectProperty.Named nop) {
        IRI iri = this.toIRI(OntApiException.notNull(nop, "Null object property."));
        return ONTWrapperImpl.create(this.getOWLDataFactory().getOWLObjectProperty(iri), nop);
    }

    @Override
    public ONTObject<OWLAnnotationProperty> getProperty(OntAnnotationProperty nap) {
        IRI iri = this.toIRI(OntApiException.notNull(nap, "Null annotation property."));
        return ONTWrapperImpl.create(this.getOWLDataFactory().getOWLAnnotationProperty(iri), nap);
    }

    @Override
    public ONTObject<OWLDataProperty> getProperty(OntDataProperty ndp) {
        IRI iri = this.toIRI(OntApiException.notNull(ndp, "Null data property."));
        return ONTWrapperImpl.create(this.getOWLDataFactory().getOWLDataProperty(iri), ndp);
    }

    @Override
    public ONTObject<OWLNamedIndividual> getIndividual(OntIndividual.Named i) {
        IRI iri = this.toIRI(OntApiException.notNull(i, "Null individual."));
        return ONTWrapperImpl.create(this.getOWLDataFactory().getOWLNamedIndividual(iri), i);
    }

    @Override
    public ONTObject<OWLAnonymousIndividual> getIndividual(OntIndividual.Anonymous i) {
        return ONTWrapperImpl.create(this.getOWLDataFactory().getOWLAnonymousIndividual(i.asNode().getBlankNodeId()), i);
    }

    @Override
    public ONTObject<? extends OWLObjectPropertyExpression> getProperty(OntObjectProperty.Inverse iop) {
        OWLObjectProperty op = this.getOWLDataFactory().getOWLObjectProperty(this.toIRI(iop.getDirect()));
        return ONTWrapperImpl.create(op.getInverseProperty(), iop);
    }

    @Override
    public ONTObject<OWLLiteral> getLiteral(Literal literal) {
        DataFactory df = this.getOWLDataFactory();
        OWLLiteral owl = df.getOWLLiteral(literal.asNode().getLiteral());
        ONTWrapperImpl<OWLLiteral> res = ONTWrapperImpl.create(owl);
        OntModel m = (OntModel)literal.getModel();
        OntDataRange.Named jdt = m.getDatatype(literal);
        if (!jdt.isBuiltIn()) {
            return res.append(this.getDatatype(jdt));
        }
        return res;
    }

    @Override
    public ONTObject<OWLAnnotation> getAnnotation(OntStatement s) {
        return ReadHelper.getAnnotation(s, this);
    }

    @Override
    public ONTObject<SWRLVariable> getSWRLVariable(OntSWRL.Variable var) {
        return ReadHelper.getSWRLVariable(var, this);
    }

    @Override
    public ONTObject<? extends SWRLAtom> getSWRLAtom(OntSWRL.Atom<?> atom) {
        return ReadHelper.calcSWRLAtom(atom, this);
    }

    @Override
    public ONTObject<? extends SWRLIArgument> getSWRLArgument(OntSWRL.IArg arg) {
        return ReadHelper.getSWRLIndividualArg(arg, this);
    }

    @Override
    public ONTObject<? extends SWRLDArgument> getSWRLArgument(OntSWRL.DArg arg) {
        return ReadHelper.getSWRLLiteralArg(arg, this);
    }

    @Override
    public ONTObject<IRI> getIRI(String uri) {
        return ONTWrapperImpl.create(this.toIRI(uri));
    }

    @Override
    public DataFactory getOWLDataFactory() {
        return this.factory;
    }
}

