/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.AxiomParserProvider;
import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.OWLComponentType;
import com.github.owlcs.ontapi.internal.ReadHelper;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;

public enum OWLContentType {
    ANNOTATION(null, false, new OWLComponentType[]{OWLComponentType.ANNOTATION_PROPERTY, OWLComponentType.LITERAL, OWLComponentType.ANONYMOUS_INDIVIDUAL, OWLComponentType.IRI}){

        @Override
        public boolean isAxiom() {
            return false;
        }

        @Override
        boolean hasAnnotations(OWLObject container) {
            return ((HasAnnotations)container).annotations().findFirst().isPresent();
        }

        @Override
        ExtendedIterator<? extends ONTObject<? extends OWLObject>> read(Supplier<OntModel> m, InternalObjectFactory f, InternalConfig c) {
            return ReadHelper.listOWLAnnotations(m.get().getID(), f);
        }

        @Override
        Optional<? extends ONTObject<? extends OWLObject>> find(Supplier<OntModel> m, InternalObjectFactory f, InternalConfig c, OWLObject key) {
            return Iter.findFirst(this.read(m, f, c).filterKeep(x -> x.getOWLObject().equals(key)));
        }

        @Override
        boolean has(Supplier<OntModel> m, InternalObjectFactory f, InternalConfig c, OWLObject key) {
            return this.find(m, f, c, key).isPresent();
        }

        @Override
        void write(OntModel m, OWLObject v) {
            WriteHelper.addAnnotations(m.getID(), Collections.singleton((OWLAnnotation)v));
        }
    }
    ,
    DECLARATION((AxiomType<? extends OWLAxiom>)AxiomType.DECLARATION, true, OWLComponentType.ENTITY),
    EQUIVALENT_CLASSES((AxiomType<? extends OWLAxiom>)AxiomType.EQUIVALENT_CLASSES, OWLComponentType.CLASS_EXPRESSION),
    SUBCLASS_OF((AxiomType<? extends OWLAxiom>)AxiomType.SUBCLASS_OF, OWLComponentType.CLASS_EXPRESSION),
    DISJOINT_CLASSES((AxiomType<? extends OWLAxiom>)AxiomType.DISJOINT_CLASSES, OWLComponentType.CLASS_EXPRESSION),
    DISJOINT_UNION((AxiomType<? extends OWLAxiom>)AxiomType.DISJOINT_UNION, OWLComponentType.CLASS, OWLComponentType.CLASS_EXPRESSION),
    CLASS_ASSERTION((AxiomType<? extends OWLAxiom>)AxiomType.CLASS_ASSERTION, OWLComponentType.INDIVIDUAL, OWLComponentType.CLASS_EXPRESSION),
    SAME_INDIVIDUAL((AxiomType<? extends OWLAxiom>)AxiomType.SAME_INDIVIDUAL, OWLComponentType.INDIVIDUAL),
    DIFFERENT_INDIVIDUALS((AxiomType<? extends OWLAxiom>)AxiomType.DIFFERENT_INDIVIDUALS, OWLComponentType.INDIVIDUAL),
    OBJECT_PROPERTY_ASSERTION((AxiomType<? extends OWLAxiom>)AxiomType.OBJECT_PROPERTY_ASSERTION, true, OWLComponentType.NAMED_OBJECT_PROPERTY, OWLComponentType.INDIVIDUAL),
    NEGATIVE_OBJECT_PROPERTY_ASSERTION((AxiomType<? extends OWLAxiom>)AxiomType.NEGATIVE_OBJECT_PROPERTY_ASSERTION, OWLComponentType.OBJECT_PROPERTY_EXPRESSION, OWLComponentType.INDIVIDUAL),
    DATA_PROPERTY_ASSERTION((AxiomType<? extends OWLAxiom>)AxiomType.DATA_PROPERTY_ASSERTION, true, OWLComponentType.DATATYPE_PROPERTY, OWLComponentType.LITERAL, OWLComponentType.INDIVIDUAL),
    NEGATIVE_DATA_PROPERTY_ASSERTION((AxiomType<? extends OWLAxiom>)AxiomType.NEGATIVE_DATA_PROPERTY_ASSERTION, OWLComponentType.DATATYPE_PROPERTY, OWLComponentType.INDIVIDUAL, OWLComponentType.LITERAL),
    EQUIVALENT_OBJECT_PROPERTIES((AxiomType<? extends OWLAxiom>)AxiomType.EQUIVALENT_OBJECT_PROPERTIES, OWLComponentType.OBJECT_PROPERTY_EXPRESSION),
    SUB_OBJECT_PROPERTY((AxiomType<? extends OWLAxiom>)AxiomType.SUB_OBJECT_PROPERTY, OWLComponentType.OBJECT_PROPERTY_EXPRESSION),
    INVERSE_OBJECT_PROPERTIES((AxiomType<? extends OWLAxiom>)AxiomType.INVERSE_OBJECT_PROPERTIES, OWLComponentType.OBJECT_PROPERTY_EXPRESSION),
    FUNCTIONAL_OBJECT_PROPERTY((AxiomType<? extends OWLAxiom>)AxiomType.FUNCTIONAL_OBJECT_PROPERTY, OWLComponentType.OBJECT_PROPERTY_EXPRESSION),
    INVERSE_FUNCTIONAL_OBJECT_PROPERTY((AxiomType<? extends OWLAxiom>)AxiomType.INVERSE_FUNCTIONAL_OBJECT_PROPERTY, OWLComponentType.OBJECT_PROPERTY_EXPRESSION),
    SYMMETRIC_OBJECT_PROPERTY((AxiomType<? extends OWLAxiom>)AxiomType.SYMMETRIC_OBJECT_PROPERTY, OWLComponentType.OBJECT_PROPERTY_EXPRESSION),
    ASYMMETRIC_OBJECT_PROPERTY((AxiomType<? extends OWLAxiom>)AxiomType.ASYMMETRIC_OBJECT_PROPERTY, OWLComponentType.OBJECT_PROPERTY_EXPRESSION),
    TRANSITIVE_OBJECT_PROPERTY((AxiomType<? extends OWLAxiom>)AxiomType.TRANSITIVE_OBJECT_PROPERTY, OWLComponentType.OBJECT_PROPERTY_EXPRESSION),
    REFLEXIVE_OBJECT_PROPERTY((AxiomType<? extends OWLAxiom>)AxiomType.REFLEXIVE_OBJECT_PROPERTY, OWLComponentType.OBJECT_PROPERTY_EXPRESSION),
    IRREFLEXIVE_OBJECT_PROPERTY((AxiomType<? extends OWLAxiom>)AxiomType.IRREFLEXIVE_OBJECT_PROPERTY, OWLComponentType.OBJECT_PROPERTY_EXPRESSION),
    OBJECT_PROPERTY_DOMAIN((AxiomType<? extends OWLAxiom>)AxiomType.OBJECT_PROPERTY_DOMAIN, OWLComponentType.OBJECT_PROPERTY_EXPRESSION, OWLComponentType.CLASS_EXPRESSION),
    OBJECT_PROPERTY_RANGE((AxiomType<? extends OWLAxiom>)AxiomType.OBJECT_PROPERTY_RANGE, OWLComponentType.OBJECT_PROPERTY_EXPRESSION, OWLComponentType.CLASS_EXPRESSION),
    DISJOINT_OBJECT_PROPERTIES((AxiomType<? extends OWLAxiom>)AxiomType.DISJOINT_OBJECT_PROPERTIES, OWLComponentType.OBJECT_PROPERTY_EXPRESSION),
    SUB_PROPERTY_CHAIN_OF((AxiomType<? extends OWLAxiom>)AxiomType.SUB_PROPERTY_CHAIN_OF, OWLComponentType.OBJECT_PROPERTY_EXPRESSION),
    EQUIVALENT_DATA_PROPERTIES((AxiomType<? extends OWLAxiom>)AxiomType.EQUIVALENT_DATA_PROPERTIES, OWLComponentType.DATATYPE_PROPERTY),
    SUB_DATA_PROPERTY((AxiomType<? extends OWLAxiom>)AxiomType.SUB_DATA_PROPERTY, true, OWLComponentType.DATATYPE_PROPERTY),
    FUNCTIONAL_DATA_PROPERTY((AxiomType<? extends OWLAxiom>)AxiomType.FUNCTIONAL_DATA_PROPERTY, true, OWLComponentType.DATATYPE_PROPERTY),
    DATA_PROPERTY_DOMAIN((AxiomType<? extends OWLAxiom>)AxiomType.DATA_PROPERTY_DOMAIN, OWLComponentType.DATATYPE_PROPERTY, OWLComponentType.CLASS_EXPRESSION),
    DATA_PROPERTY_RANGE((AxiomType<? extends OWLAxiom>)AxiomType.DATA_PROPERTY_RANGE, OWLComponentType.DATATYPE_PROPERTY, OWLComponentType.DATA_RANGE),
    DISJOINT_DATA_PROPERTIES((AxiomType<? extends OWLAxiom>)AxiomType.DISJOINT_DATA_PROPERTIES, OWLComponentType.DATATYPE_PROPERTY),
    HAS_KEY((AxiomType<? extends OWLAxiom>)AxiomType.HAS_KEY, OWLComponentType.CLASS_EXPRESSION, OWLComponentType.DATATYPE_PROPERTY, OWLComponentType.OBJECT_PROPERTY_EXPRESSION),
    SWRL_RULE((AxiomType<? extends OWLAxiom>)AxiomType.SWRL_RULE, OWLComponentType.SWRL_ATOM),
    ANNOTATION_ASSERTION((AxiomType<? extends OWLAxiom>)AxiomType.ANNOTATION_ASSERTION, true, OWLComponentType.ANNOTATION_PROPERTY, OWLComponentType.LITERAL, OWLComponentType.ANONYMOUS_INDIVIDUAL, OWLComponentType.IRI),
    SUB_ANNOTATION_PROPERTY_OF((AxiomType<? extends OWLAxiom>)AxiomType.SUB_ANNOTATION_PROPERTY_OF, true, OWLComponentType.ANNOTATION_PROPERTY),
    ANNOTATION_PROPERTY_RANGE((AxiomType<? extends OWLAxiom>)AxiomType.ANNOTATION_PROPERTY_RANGE, true, OWLComponentType.ANNOTATION_PROPERTY, OWLComponentType.IRI),
    ANNOTATION_PROPERTY_DOMAIN((AxiomType<? extends OWLAxiom>)AxiomType.ANNOTATION_PROPERTY_DOMAIN, true, OWLComponentType.ANNOTATION_PROPERTY, OWLComponentType.IRI),
    DATATYPE_DEFINITION((AxiomType<? extends OWLAxiom>)AxiomType.DATATYPE_DEFINITION, OWLComponentType.DATATYPE, OWLComponentType.DATA_RANGE);

    private static final Set<OWLContentType> ALL_AXIOMS;
    private static final Set<OWLContentType> LOGICAL_AXIOMS;
    private final AxiomType<OWLAxiom> type;
    private final boolean distinct;
    private final Set<OWLComponentType> components;

    private OWLContentType(AxiomType<? extends OWLAxiom> type, OWLComponentType ... types) {
        this(type, false, types);
    }

    private OWLContentType(AxiomType<? extends OWLAxiom> type, boolean distinct, OWLComponentType ... types) {
        this.type = type;
        this.distinct = distinct;
        this.components = OWLComponentType.toSet(types);
    }

    public static OWLContentType get(AxiomType<?> type) throws IndexOutOfBoundsException {
        return OWLContentType.values()[type.getIndex() + 1];
    }

    public static OWLContentType get(Class<? extends OWLAxiom> type) {
        OWLContentType[] array = OWLContentType.values();
        for (int i = 1; i < array.length; ++i) {
            OWLContentType res = array[i];
            if (type != res.type.getActualClass()) continue;
            return res;
        }
        throw new OntApiException.IllegalState();
    }

    public static Stream<OWLContentType> all() {
        return Arrays.stream(OWLContentType.values());
    }

    static ExtendedIterator<OWLContentType> listAll() {
        return Iter.of(OWLContentType.values());
    }

    public static Stream<OWLContentType> axioms() {
        return ALL_AXIOMS.stream();
    }

    public static Stream<OWLContentType> logical() {
        return LOGICAL_AXIOMS.stream();
    }

    public static Stream<OWLContentType> axioms(Iterable<AxiomType<?>> types) {
        Stream<Object> res = types instanceof Collection ? ((Collection)types).stream() : StreamSupport.stream(types.spliterator(), false);
        return res.map(OWLContentType::get);
    }

    public boolean isAxiom() {
        return true;
    }

    boolean hasAnnotations(OWLObject container) {
        return ((OWLAxiom)container).isAnnotated();
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public boolean hasComponent(OWLComponentType container) {
        return this.components.contains((Object)container);
    }

    public AxiomType<OWLAxiom> getAxiomType() {
        return this.type;
    }

    ExtendedIterator<? extends ONTObject<? extends OWLObject>> read(Supplier<OntModel> m, InternalObjectFactory f, InternalConfig c) {
        return this.getRawTranslator().listAxioms(m, f, c);
    }

    Optional<? extends ONTObject<? extends OWLObject>> find(Supplier<OntModel> m, InternalObjectFactory f, InternalConfig c, OWLObject key) {
        OWLAxiom k = (OWLAxiom)key;
        return this.getRawTranslator().findAxiom(m, f, c, k);
    }

    boolean has(Supplier<OntModel> m, InternalObjectFactory f, InternalConfig c, OWLObject key) {
        OWLAxiom k = (OWLAxiom)key;
        return this.getRawTranslator().containsAxiom(m, f, c, k);
    }

    void write(OntModel m, OWLObject value) {
        this.getRawTranslator().write((OWLAxiom)value, m);
    }

    private AxiomTranslator<OWLAxiom> getRawTranslator() {
        return AxiomParserProvider.get(this.type);
    }

    <X extends AxiomTranslator<? extends OWLAxiom>> X getTranslator() {
        return (X)this.getRawTranslator();
    }

    static {
        EnumSet<OWLContentType> axioms = EnumSet.noneOf(OWLContentType.class);
        EnumSet<OWLContentType> logical = EnumSet.noneOf(OWLContentType.class);
        OWLContentType[] array = OWLContentType.values();
        for (int i = 1; i < array.length; ++i) {
            OWLContentType x = array[i];
            axioms.add(x);
            if (!x.type.isLogical()) continue;
            logical.add(x);
        }
        ALL_AXIOMS = axioms;
        LOGICAL_AXIOMS = logical;
    }
}

