/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.objects.ONTAnnotationImpl;
import com.github.owlcs.ontapi.internal.objects.ONTAnnotationPropertyImpl;
import com.github.owlcs.ontapi.internal.objects.ONTAnonymousClassExpressionImpl;
import com.github.owlcs.ontapi.internal.objects.ONTAnonymousDataRangeImpl;
import com.github.owlcs.ontapi.internal.objects.ONTAnonymousIndividualImpl;
import com.github.owlcs.ontapi.internal.objects.ONTClassImpl;
import com.github.owlcs.ontapi.internal.objects.ONTDataPropertyImpl;
import com.github.owlcs.ontapi.internal.objects.ONTDatatypeImpl;
import com.github.owlcs.ontapi.internal.objects.ONTFacetRestrictionImpl;
import com.github.owlcs.ontapi.internal.objects.ONTIRI;
import com.github.owlcs.ontapi.internal.objects.ONTLiteralImpl;
import com.github.owlcs.ontapi.internal.objects.ONTNamedIndividualImpl;
import com.github.owlcs.ontapi.internal.objects.ONTObjectInverseOfImpl;
import com.github.owlcs.ontapi.internal.objects.ONTObjectPropertyImpl;
import com.github.owlcs.ontapi.internal.objects.ONTSWRLAtomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTSWRLIndividualImpl;
import com.github.owlcs.ontapi.internal.objects.ONTSWRLLiteralImpl;
import com.github.owlcs.ontapi.internal.objects.ONTSWRLVariable;
import com.github.owlcs.ontapi.jena.impl.Entities;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntFacetRestriction;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntSWRL;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.rdf.model.Literal;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLVariable;

public class ModelObjectFactory
implements InternalObjectFactory {
    protected final Supplier<OntModel> model;
    protected final DataFactory factory;

    public ModelObjectFactory(DataFactory factory, Supplier<OntModel> model) {
        this.factory = Objects.requireNonNull(factory);
        this.model = Objects.requireNonNull(model);
    }

    @Override
    public DataFactory getOWLDataFactory() {
        return this.factory;
    }

    @Override
    public ONTObject<OWLAnnotation> getAnnotation(OntStatement s) {
        return ONTAnnotationImpl.create(s, this, this.model);
    }

    @Override
    public ONTObject<? extends OWLClassExpression> getClass(OntClass ce) {
        if (ce.isURIResource()) {
            return this.getClass((OntClass.Named)ce);
        }
        return ONTAnonymousClassExpressionImpl.create(ce, this, this.model);
    }

    @Override
    public ONTObject<? extends OWLDataRange> getDatatype(OntDataRange dr) {
        if (dr.isURIResource()) {
            return this.getDatatype((OntDataRange.Named)dr);
        }
        return ONTAnonymousDataRangeImpl.create(dr, this, this.model);
    }

    public ONTObject<OWLObjectInverseOf> getProperty(OntObjectProperty.Inverse iop) {
        return ONTObjectInverseOfImpl.create(iop, this, this.model);
    }

    @Override
    public ONTObject<OWLFacetRestriction> getFacetRestriction(OntFacetRestriction fr) {
        return ONTFacetRestrictionImpl.create(fr, this, this.model);
    }

    @Override
    public ONTObject<OWLClass> getClass(OntClass.Named ce) {
        return this.getClass(ce.getURI());
    }

    @Override
    public ONTObject<OWLAnonymousIndividual> getIndividual(OntIndividual.Anonymous i) {
        return this.getAnonymousIndividual(i.asNode().getBlankNodeId());
    }

    @Override
    public ONTObject<OWLNamedIndividual> getIndividual(OntIndividual.Named i) {
        return this.getNamedIndividual(i.getURI());
    }

    @Override
    public ONTObject<OWLDatatype> getDatatype(OntDataRange.Named dt) {
        return this.getDatatype(dt.getURI());
    }

    @Override
    public ONTObject<OWLAnnotationProperty> getProperty(OntAnnotationProperty p) {
        return this.getAnnotationProperty(p.getURI());
    }

    @Override
    public ONTObject<OWLObjectProperty> getProperty(OntObjectProperty.Named p) {
        return this.getObjectProperty(p.getURI());
    }

    @Override
    public ONTObject<OWLDataProperty> getProperty(OntDataProperty p) {
        return this.getDataProperty(p.getURI());
    }

    @Override
    public ONTObject<SWRLVariable> getSWRLVariable(OntSWRL.Variable v) {
        return this.getSWRLVariable(v.getURI());
    }

    @Override
    public ONTObject<? extends SWRLIArgument> getSWRLArgument(OntSWRL.IArg arg) {
        if (arg.isAnon()) {
            return this.getSWRLArgument(arg.asNode().getBlankNodeId());
        }
        if (arg.canAs(OntSWRL.Variable.class)) {
            return this.getSWRLVariable((OntSWRL.Variable)arg.as(OntSWRL.Variable.class));
        }
        return this.getSWRLArgument(arg.asNode().getURI());
    }

    @Override
    public ONTObject<? extends SWRLDArgument> getSWRLArgument(OntSWRL.DArg arg) {
        return arg.isLiteral() ? this.getSWRLArgument(arg.asNode().getLiteral()) : this.getSWRLVariable((OntSWRL.Variable)arg.as(OntSWRL.Variable.class));
    }

    @Override
    public ONTObject<? extends SWRLAtom> getSWRLAtom(OntSWRL.Atom<?> atom) {
        return ONTSWRLAtomImpl.create(atom, this, this.model);
    }

    @Override
    public ONTObject<OWLLiteral> getLiteral(Literal literal) {
        return this.getLiteral(literal.asNode().getLiteral());
    }

    @Override
    public ONTObject<IRI> getIRI(String uri) {
        return ONTIRI.create(uri);
    }

    @Override
    public IRI toIRI(String uri) {
        return ONTIRI.create(uri);
    }

    public ONTObject<OWLClass> getClass(String uri) {
        return new ONTClassImpl(uri, this.model);
    }

    public ONTObject<OWLAnonymousIndividual> getAnonymousIndividual(BlankNodeId id) {
        return new ONTAnonymousIndividualImpl(id, this.model);
    }

    public ONTObject<OWLNamedIndividual> getNamedIndividual(String uri) {
        return new ONTNamedIndividualImpl(uri, this.model);
    }

    public ONTObject<OWLDatatype> getDatatype(String uri) {
        return new ONTDatatypeImpl(uri, this.model);
    }

    public ONTObject<OWLAnnotationProperty> getAnnotationProperty(String uri) {
        return new ONTAnnotationPropertyImpl(uri, this.model);
    }

    public ONTObject<OWLObjectProperty> getObjectProperty(String uri) {
        return new ONTObjectPropertyImpl(uri, this.model);
    }

    public ONTObject<OWLDataProperty> getDataProperty(String uri) {
        return new ONTDataPropertyImpl(uri, this.model);
    }

    public ONTObject<OWLLiteral> getLiteral(LiteralLabel label) {
        return new ONTLiteralImpl(label, this.model);
    }

    public ONTObject<SWRLVariable> getSWRLVariable(String uri) {
        return new ONTSWRLVariable(uri, this.model);
    }

    public ONTObject<? extends OWLEntity> getEntity(String uri, Entities type) {
        switch (type) {
            case CLASS: {
                return this.getClass(uri);
            }
            case DATATYPE: {
                return this.getDatatype(uri);
            }
            case INDIVIDUAL: {
                return this.getNamedIndividual(uri);
            }
            case OBJECT_PROPERTY: {
                return this.getObjectProperty(uri);
            }
            case DATA_PROPERTY: {
                return this.getDataProperty(uri);
            }
            case ANNOTATION_PROPERTY: {
                return this.getAnnotationProperty(uri);
            }
        }
        throw new OntApiException.IllegalArgument("Unsupported type " + (Object)((Object)type));
    }

    @Override
    public ONTObject<? extends OWLObjectPropertyExpression> getProperty(OntObjectProperty property) {
        if (OntApiException.notNull(property, "Null object property.").isAnon()) {
            return this.getProperty((OntObjectProperty.Inverse)property);
        }
        return this.getObjectProperty(property.asNode().getURI());
    }

    @Override
    public ONTObject<? extends OWLIndividual> getIndividual(OntIndividual individual) {
        return this.getIndividual(OntApiException.notNull(individual, "Null individual").asNode());
    }

    public ONTObject<? extends OWLIndividual> getIndividual(Node node) {
        if (node.isBlank()) {
            return this.getAnonymousIndividual(node.getBlankNodeId());
        }
        return this.getNamedIndividual(node.getURI());
    }

    public ONTObject<? extends SWRLDArgument> getSWRLArgument(LiteralLabel label) {
        return new ONTSWRLLiteralImpl(label, this.model);
    }

    public ONTObject<? extends SWRLIArgument> getSWRLArgument(String uri) {
        return new ONTSWRLIndividualImpl(uri, this.model);
    }

    public ONTObject<? extends SWRLIArgument> getSWRLArgument(BlankNodeId id) {
        return new ONTSWRLIndividualImpl(id, this.model);
    }
}

