/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.ID;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.CacheObjectFactory;
import com.github.owlcs.ontapi.internal.CacheObjectMapImpl;
import com.github.owlcs.ontapi.internal.DirectObjectMapImpl;
import com.github.owlcs.ontapi.internal.HasConfig;
import com.github.owlcs.ontapi.internal.HasObjectFactory;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.OWLComponentType;
import com.github.owlcs.ontapi.internal.OWLContentType;
import com.github.owlcs.ontapi.internal.OWLTriples;
import com.github.owlcs.ontapi.internal.ObjectMap;
import com.github.owlcs.ontapi.internal.SearchModel;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.AnnotationAssertionTranslator;
import com.github.owlcs.ontapi.internal.axioms.DeclarationTranslator;
import com.github.owlcs.ontapi.internal.axioms.EquivalentClassesTranslator;
import com.github.owlcs.ontapi.internal.axioms.SubClassOfTranslator;
import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.UnionGraph;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntEntity;
import com.github.owlcs.ontapi.jena.model.OntID;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.mem.GraphMem;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.Lock;
import org.apache.jena.sparql.util.graph.GraphListenerBase;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasOntologyID;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalModel
extends OntGraphModelImpl
implements OntModel,
HasOntologyID,
HasObjectFactory,
HasConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(InternalModel.class);
    protected volatile ID cachedID;
    private final InternalCache.Loading<InternalModel, InternalConfig> config;
    protected final InternalCache.Loading<InternalModel, InternalObjectFactory> objectFactory;
    protected final InternalCache.Loading<InternalModel, OntGraphModelImpl> searchModel;
    protected final InternalCache.Loading<InternalModel, Map<OWLContentType, ObjectMap<? extends OWLObject>>> content;
    protected final InternalCache.Loading<InternalModel, Map<OWLComponentType, ObjectMap<OWLObject>>> components;
    protected final DirectListener directListener;

    public InternalModel(Graph base, OntPersonality personality, InternalConfig config, DataFactory dataFactory, Map<Class<? extends OWLPrimitive>, InternalCache<?, ?>> fromManager) {
        super(base, personality);
        Objects.requireNonNull(dataFactory);
        Objects.requireNonNull(config);
        this.config = InternalCache.createSingleton(x -> config.snapshot());
        this.objectFactory = InternalCache.createSoftSingleton(x -> this.createObjectFactory(dataFactory, fromManager));
        this.searchModel = InternalCache.createSoftSingleton(x -> this.createSearchModel());
        this.content = InternalCache.createSingleton(x -> this.createContentStore());
        this.components = InternalCache.createSingleton(x -> this.createComponentStore());
        this.directListener = this.createDirectListener();
        this.enableDirectListening();
    }

    public ID getOntologyID() {
        if (this.cachedID != null && this.getBaseGraph().contains(this.cachedID.asNode(), RDF.Nodes.type, OWL.Ontology.asNode())) {
            return this.cachedID;
        }
        this.cachedID = new ID(this.getID());
        return this.cachedID;
    }

    public void setOntologyID(OWLOntologyID id) throws IllegalArgumentException {
        this.cachedID = null;
        try {
            this.disableDirectListening();
            this.getHeaderCache().clear();
            if (Objects.requireNonNull(id, "Null id").isAnonymous()) {
                OntID res = id instanceof ID ? this.getNodeAs(InternalModel.createOntologyID((Model)this, ((ID)id).asNode()).asNode(), OntID.class) : this.setID(null);
                res.setVersionIRI(null);
            } else {
                this.setID(id.getOntologyIRI().map(IRI::getIRIString).orElseThrow(IllegalArgumentException::new)).setVersionIRI(id.getVersionIRI().map(IRI::getIRIString).orElse(null));
            }
        }
        finally {
            this.enableDirectListening();
        }
        if (id instanceof ID) {
            this.cachedID = (ID)id;
        }
    }

    @Override
    public InternalConfig getConfig() {
        return this.config.get(this);
    }

    @Override
    public InternalObjectFactory getObjectFactory() {
        return this.objectFactory.get(this);
    }

    protected InternalObjectFactory createObjectFactory(DataFactory df, Map<Class<? extends OWLPrimitive>, InternalCache<?, ?>> external) {
        InternalConfig conf = this.getConfig();
        Supplier<OntModel> model = this::getSearchModel;
        if (!conf.useLoadObjectsCache()) {
            return new ModelObjectFactory(df, model);
        }
        long size = conf.getLoadObjectsCacheSize();
        boolean parallel = conf.parallel();
        Map<Class<? extends OWLPrimitive>, InternalCache<?, ?>> map = external == null ? Collections.emptyMap() : external;
        return new CacheObjectFactory(df, model, map, () -> InternalCache.createBounded(parallel, size));
    }

    public OntGraphModelImpl getSearchModel() {
        return this.searchModel.get(this);
    }

    protected OntGraphModelImpl createSearchModel() {
        if (!this.getConfig().useLoadNodesCache()) {
            return this;
        }
        return new SearchModel((Graph)this.getGraph(), this.getOntPersonality(), this.getConfig()){

            @Override
            public String toString() {
                return String.format("[SearchModel]%s", this.getID());
            }

            @Override
            public InternalObjectFactory getObjectFactory() {
                return InternalModel.this.getObjectFactory();
            }
        };
    }

    @Override
    public <N extends RDFNode> N fetchNodeAs(Node node, Class<N> type) {
        try {
            return super.fetchNodeAs(node, type);
        }
        catch (OntJenaException e) {
            return (N)((RDFNode)SearchModel.handleFetchNodeAsException(e, node, type, this, this.getConfig()));
        }
    }

    protected DirectListener createDirectListener() {
        return new DirectListener();
    }

    protected void disableDirectListening() {
        this.getGraph().getEventManager().unregister((GraphListener)this.directListener);
    }

    protected void enableDirectListening() {
        this.getGraph().getEventManager().register((GraphListener)this.directListener);
    }

    public Lock getLock() {
        throw new OntApiException.Unsupported();
    }

    public void enterCriticalSection(boolean requestReadLock) {
        throw new OntApiException.Unsupported();
    }

    public void leaveCriticalSection() {
        throw new OntApiException.Unsupported();
    }

    public Stream<OWLImportsDeclaration> listOWLImportDeclarations() {
        InternalObjectFactory of = this.getObjectFactory();
        DataFactory df = this.getDataFactory();
        return this.reduce(this.getID().imports().map(of::toIRI).map(arg_0 -> ((DataFactory)df).getOWLImportsDeclaration(arg_0)));
    }

    public boolean isOntologyEmpty() {
        Graph bg = this.getBaseGraph();
        if (bg instanceof GraphMem) {
            if (bg.isEmpty()) {
                return true;
            }
            if (bg.size() == 1 && bg.contains(Node.ANY, RDF.type.asNode(), OWL.Ontology.asNode())) {
                return true;
            }
        }
        if (!this.components.isEmpty()) {
            return false;
        }
        return !Stream.concat(this.listOWLAnnotations(), this.listOWLAxioms()).findFirst().isPresent();
    }

    public Stream<OWLEntity> listOWLEntities(IRI iri) {
        if (iri == null) {
            return Stream.empty();
        }
        OntEntity e = this.getOntEntity(OntEntity.class, iri.getIRIString());
        if (e == null) {
            return Stream.empty();
        }
        ArrayList<ONTObject<Object>> res = new ArrayList<ONTObject<Object>>();
        InternalObjectFactory df = this.getObjectFactory();
        if (e.canAs(OntClass.Named.class)) {
            res.add(df.getClass((OntClass.Named)e.as(OntClass.Named.class)));
        }
        if (e.canAs(OntDataRange.Named.class)) {
            res.add(df.getDatatype((OntDataRange.Named)e.as(OntDataRange.Named.class)));
        }
        if (e.canAs(OntAnnotationProperty.class)) {
            res.add(df.getProperty((OntAnnotationProperty)e.as(OntAnnotationProperty.class)));
        }
        if (e.canAs(OntDataProperty.class)) {
            res.add(df.getProperty((OntDataProperty)e.as(OntDataProperty.class)));
        }
        if (e.canAs(OntObjectProperty.Named.class)) {
            res.add(df.getProperty((OntObjectProperty.Named)e.as(OntObjectProperty.Named.class)));
        }
        if (e.canAs(OntIndividual.Named.class)) {
            res.add(df.getIndividual((OntIndividual.Named)e.as(OntIndividual.Named.class)));
        }
        return res.stream().map(ONTObject::getOWLObject);
    }

    public boolean containsOWLDeclaration(OWLEntity e) {
        return this.listOWLAxioms(OWLDeclarationAxiom.class).anyMatch(x -> x.getEntity().equals(e));
    }

    public Stream<OWLAnonymousIndividual> listOWLAnonymousIndividuals() {
        return this.listComponents(OWLComponentType.ANONYMOUS_INDIVIDUAL);
    }

    public Stream<OWLNamedIndividual> listOWLNamedIndividuals() {
        return this.listComponents(OWLComponentType.NAMED_INDIVIDUAL);
    }

    public Stream<OWLClass> listOWLClasses() {
        return this.listComponents(OWLComponentType.CLASS);
    }

    public Stream<OWLDataProperty> listOWLDataProperties() {
        return this.listComponents(OWLComponentType.DATATYPE_PROPERTY);
    }

    public Stream<OWLObjectProperty> listOWLObjectProperties() {
        return this.listComponents(OWLComponentType.NAMED_OBJECT_PROPERTY);
    }

    public Stream<OWLAnnotationProperty> listOWLAnnotationProperties() {
        return this.listComponents(OWLComponentType.ANNOTATION_PROPERTY);
    }

    public Stream<OWLDatatype> listOWLDatatypes() {
        return this.listComponents(OWLComponentType.DATATYPE);
    }

    public boolean containsOWLEntity(OWLDatatype d) {
        return this.containsComponent(OWLComponentType.DATATYPE, (OWLObject)d);
    }

    public boolean containsOWLEntity(OWLClass c) {
        return this.containsComponent(OWLComponentType.CLASS, (OWLObject)c);
    }

    public boolean containsOWLEntity(OWLNamedIndividual i) {
        return this.containsComponent(OWLComponentType.NAMED_INDIVIDUAL, (OWLObject)i);
    }

    public boolean containsOWLEntity(OWLDataProperty p) {
        return this.containsComponent(OWLComponentType.DATATYPE_PROPERTY, (OWLObject)p);
    }

    public boolean containsOWLEntity(OWLObjectProperty p) {
        return this.containsComponent(OWLComponentType.NAMED_OBJECT_PROPERTY, (OWLObject)p);
    }

    public boolean containsOWLEntity(OWLAnnotationProperty p) {
        return this.containsComponent(OWLComponentType.ANNOTATION_PROPERTY, (OWLObject)p);
    }

    public Stream<OWLAnnotation> listOWLAnnotations() {
        return this.getHeaderCache().keys();
    }

    public Stream<OWLDeclarationAxiom> listOWLDeclarationAxioms(OWLEntity e) {
        if (!this.getConfig().isAllowReadDeclarations()) {
            return Stream.empty();
        }
        if (this.hasManuallyAddedAxioms()) {
            return this.listOWLAxioms(OWLDeclarationAxiom.class).filter(a -> e.equals(a.getEntity()));
        }
        DeclarationTranslator t = (DeclarationTranslator)OWLContentType.DECLARATION.getTranslator();
        OntEntity res = this.getSearchModel().findNodeAs(WriteHelper.toResource((OWLObject)e).asNode(), WriteHelper.getEntityType(e));
        if (res == null) {
            return Stream.empty();
        }
        InternalObjectFactory df = this.getObjectFactory();
        OntStatement s = res.getMainStatement();
        return s == null ? Stream.empty() : Stream.of(t.toAxiomImpl(s, this::getSearchModel, df, this.getConfig()).getOWLObject());
    }

    public Stream<OWLAnnotationAssertionAxiom> listOWLAnnotationAssertionAxioms(OWLAnnotationSubject s) {
        if (!this.getConfig().isLoadAnnotationAxioms()) {
            return Stream.empty();
        }
        if (this.hasManuallyAddedAxioms()) {
            return this.listOWLAxioms(OWLAnnotationAssertionAxiom.class).filter(a -> s.equals(a.getSubject()));
        }
        InternalObjectFactory df = this.getObjectFactory();
        AnnotationAssertionTranslator t = (AnnotationAssertionTranslator)OWLContentType.ANNOTATION_ASSERTION.getTranslator();
        ExtendedIterator res = this.getSearchModel().listLocalStatements(WriteHelper.toResource((OWLObject)s), null, null).filterKeep(x -> t.testStatement((OntStatement)x, this.getConfig()));
        return this.reduce(Iter.asStream(t.translate((ExtendedIterator<OntStatement>)res, this::getSearchModel, df, this.getConfig()).mapWith(ONTObject::getOWLObject)));
    }

    public Stream<OWLSubClassOfAxiom> listOWLSubClassOfAxioms(OWLClass sub) {
        if (this.hasManuallyAddedAxioms()) {
            return this.listOWLAxioms(OWLSubClassOfAxiom.class).filter(a -> Objects.equals(a.getSubClass(), sub));
        }
        InternalObjectFactory df = this.getObjectFactory();
        SubClassOfTranslator t = (SubClassOfTranslator)OWLContentType.SUBCLASS_OF.getTranslator();
        ExtendedIterator res = this.getSearchModel().listLocalStatements(WriteHelper.toResource((OWLObject)sub), RDFS.subClassOf, null).filterKeep(t::filter);
        return this.reduce(Iter.asStream(t.translate((ExtendedIterator<OntStatement>)res, this::getSearchModel, df, this.getConfig()).mapWith(ONTObject::getOWLObject)));
    }

    public Stream<OWLEquivalentClassesAxiom> listOWLEquivalentClassesAxioms(OWLClass c) {
        if (this.hasManuallyAddedAxioms()) {
            return this.listOWLAxioms(OWLEquivalentClassesAxiom.class).filter(a -> a.operands().anyMatch(c::equals));
        }
        InternalObjectFactory df = this.getObjectFactory();
        OntGraphModelImpl m = this.getSearchModel();
        EquivalentClassesTranslator t = (EquivalentClassesTranslator)OWLContentType.EQUIVALENT_CLASSES.getTranslator();
        Resource r = WriteHelper.toResource((OWLObject)c);
        ExtendedIterator res = m.listLocalStatements(r, OWL.equivalentClass, null).andThen(m.listLocalStatements(null, OWL.equivalentClass, (RDFNode)r)).filterKeep(s -> t.testStatement((OntStatement)s, this.getConfig()));
        return this.reduce(Iter.asStream(t.translate((ExtendedIterator<OntStatement>)res, this::getSearchModel, df, this.getConfig()).mapWith(ONTObject::getOWLObject)));
    }

    public Stream<OWLAxiom> listOWLAxioms() {
        return this.flatMap(this.filteredAxiomsCaches(OWLContentType.axioms()), ObjectMap::keys);
    }

    public Stream<OWLLogicalAxiom> listOWLLogicalAxioms() {
        return this.flatMap(this.filteredAxiomsCaches(OWLContentType.logical()), m -> m.keys());
    }

    public Stream<OWLAxiom> listOWLAxioms(Iterable<AxiomType<?>> filter) {
        return this.flatMap(this.filteredAxiomsCaches(OWLContentType.axioms(filter)), ObjectMap::keys);
    }

    public Stream<OWLAxiom> listOWLAxioms(OWLPrimitive primitive) {
        OWLComponentType filter = OWLComponentType.get((OWLObject)primitive);
        if (OWLContentType.ANNOTATION.hasComponent(filter)) {
            return this.reduce(OWLContentType.axioms().flatMap(k -> {
                ObjectMap axioms = this.getContentCache((OWLContentType)((Object)k));
                Predicate<OWLAxiom> p = k.hasComponent(filter) ? a -> true : k::hasAnnotations;
                return axioms.keys().filter(x -> p.test((OWLAxiom)x) && filter.contains((OWLObject)x, (OWLObject)primitive));
            }));
        }
        return this.flatMap(this.filteredAxiomsCaches(OWLContentType.axioms().filter(x -> x.hasComponent(filter))), k -> k.keys().filter(x -> filter.contains((OWLObject)x, (OWLObject)primitive)));
    }

    public <A extends OWLAxiom> Stream<A> listOWLAxioms(Class<A> type) {
        return this.getAxiomsCache(OWLContentType.get(type)).keys();
    }

    public <A extends OWLAxiom> Stream<A> listOWLAxioms(Class<A> type, OWLObject object) {
        OWLContentType key = OWLContentType.get(type);
        OWLComponentType filter = OWLComponentType.get(object);
        if (!OWLContentType.ANNOTATION.hasComponent(filter) && !key.hasComponent(filter)) {
            return Stream.empty();
        }
        return this.getAxiomsCache(key).keys().filter(x -> filter.contains((OWLObject)x, object));
    }

    public <A extends OWLAxiom> Stream<A> listOWLAxioms(AxiomType<A> type) {
        return this.getAxiomsCache(OWLContentType.get(type)).keys();
    }

    public long getOWLAxiomCount() {
        return this.getContentStore().entrySet().stream().filter(x -> ((OWLContentType)((Object)((Object)x.getKey()))).isAxiom()).mapToLong(x -> ((ObjectMap)x.getValue()).count()).sum();
    }

    protected <R> Stream<R> reduce(Stream<R> stream) {
        InternalConfig conf = this.getConfig();
        if (!conf.parallel() || !conf.useContentCache()) {
            return stream;
        }
        ArrayList res = new ArrayList(1024);
        stream.collect(Collectors.toCollection(() -> res));
        res.trimToSize();
        return res.stream();
    }

    protected <R, X> Stream<R> flatMap(Stream<X> stream, Function<X, Stream<? extends R>> map) {
        InternalConfig conf = this.getConfig();
        if (!conf.parallel() || !conf.useContentCache()) {
            return stream.flatMap(map);
        }
        return stream.map(map).collect(Collectors.toList()).stream().flatMap(Function.identity());
    }

    public boolean contains(OWLAxiom a) {
        return this.getAxiomsCache(OWLContentType.get(a.getAxiomType())).contains(a);
    }

    public boolean contains(OWLAnnotation a) {
        return this.getHeaderCache().contains(a);
    }

    public boolean add(OWLAxiom axiom) {
        return this.add(OWLContentType.get(axiom.getAxiomType()), (OWLObject)axiom);
    }

    public boolean add(OWLAnnotation annotation) {
        return this.add(OWLContentType.ANNOTATION, (OWLObject)annotation);
    }

    public boolean remove(OWLAxiom axiom) {
        return this.remove(OWLContentType.get(axiom.getAxiomType()), (OWLObject)axiom);
    }

    public boolean remove(OWLAnnotation annotation) {
        return this.remove(OWLContentType.ANNOTATION, (OWLObject)annotation);
    }

    protected boolean add(OWLContentType key, OWLObject container) throws OntApiException {
        OWLTriples.Listener listener = OWLTriples.createListener();
        UnionGraph.OntEventManager evm = this.getGraph().getEventManager();
        ObjectMap<OWLObject> map = this.getContentCache(key);
        map.load();
        try {
            this.disableDirectListening();
            evm.register((GraphListener)listener);
            key.write(this, container);
        }
        catch (Exception e) {
            listener.getTriples().forEach(this::delete);
            if (e instanceof OntApiException) {
                throw e;
            }
            throw new OntApiException(String.format("OWLObject: %s, message: '%s'", container, e.getMessage()), e);
        }
        finally {
            evm.unregister((GraphListener)listener);
            this.enableDirectListening();
        }
        OWLTriples<OWLObject> value = listener.toObject(container);
        if (value.isDefinitelyEmpty()) {
            LOGGER.warn("Attempt to add empty OWL object: {}", (Object)container);
            return false;
        }
        map.add(value);
        this.cacheComponents(container);
        this.clearOtherCaches();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remove(OWLContentType key, OWLObject container) {
        try {
            this.disableDirectListening();
            ObjectMap<OWLObject> map = this.getContentCache(key);
            ONTObject<OWLObject> value = map.get(container);
            if (value == null) {
                boolean bl = false;
                return bl;
            }
            map.remove(container);
            container = value.getOWLObject();
            OntModel m = this.toModel(value);
            Set<Triple> used = this.getUsedTriples(m, container);
            this.clearComponents(container);
            Graph g = m.getBaseGraph();
            long size = g.size();
            g.find().filterDrop(used::contains).forEachRemaining(this::delete);
            boolean res = size != (long)g.size();
            this.clearOtherCaches();
            boolean bl = res;
            return bl;
        }
        finally {
            this.enableDirectListening();
        }
    }

    protected Set<Triple> getUsedTriples(OntModel model, OWLObject container) {
        InternalObjectFactory f = HasObjectFactory.getObjectFactory(model);
        InternalConfig c = HasConfig.getConfig(model);
        HashSet<Triple> res = new HashSet<Triple>();
        Iter.flatMap(OWLContentType.listAll(), type -> type.read(() -> model, f, c).filterKeep(x -> {
            Object obj = x.getOWLObject();
            if (type != OWLContentType.DECLARATION && container.equals(obj)) {
                return false;
            }
            if (this.getContentCache((OWLContentType)((Object)type)).contains(obj)) {
                return true;
            }
            if (type == OWLContentType.DECLARATION) {
                OWLEntity entity = ((OWLDeclarationAxiom)obj).getEntity();
                return this.findUsedContentContainer((OWLObject)entity, new OWLObject[]{obj}).isPresent();
            }
            return false;
        })).forEachRemaining(x -> x.triples().forEach(res::add));
        OWLComponentType.sharedComponents().forEach(type -> {
            HashSet candidates = new HashSet();
            HashSet triples = new HashSet();
            type.select(model, f).forEach(x -> {
                candidates.add(x.getOWLObject());
                x.triples().forEach(triples::add);
            });
            if (candidates.isEmpty()) {
                return;
            }
            this.selectContentContainers((OWLComponentType)((Object)type)).forEach(x -> {
                Object obj = x.getOWLObject();
                if (container.equals(obj)) {
                    return;
                }
                if (!type.containsAny((OWLObject)obj, candidates)) {
                    return;
                }
                x.triples().filter(triples::contains).forEach(res::add);
            });
        });
        return res;
    }

    protected Optional<OWLObject> findUsedContentContainer(OWLObject entity, OWLObject ... excludes) {
        OWLComponentType type = OWLComponentType.get(entity);
        Stream<OWLObject> res = this.selectContentObjects(type);
        if (excludes.length != 0) {
            Set<OWLObject> ignore = excludes.length == 1 ? Collections.singleton(excludes[0]) : new HashSet<OWLObject>(Arrays.asList(excludes));
            res = res.filter(x -> !ignore.contains(x));
        }
        return res.filter(x -> type.contains((OWLObject)x, entity)).findFirst();
    }

    protected OntModel toModel(final ONTObject<? extends OWLObject> o) {
        Graph g = o.toGraph();
        if (LOGGER.isDebugEnabled()) {
            g.getPrefixMapping().setNsPrefixes(this.getNsPrefixMap());
        }
        UnionGraph u = new UnionGraph(g, false);
        u.addGraph((Graph)this.getGraph());
        class ObjectModel
        extends OntGraphModelImpl
        implements HasConfig,
        HasObjectFactory {
            public ObjectModel(Graph g) {
                super(g, InternalModel.this.getOntPersonality());
            }

            @Override
            public OntID getID() {
                return (OntID)InternalModel.this.getID().inModel(this).as(OntID.class);
            }

            @Override
            public String toString() {
                return String.format("ModelFor{%s}", o.getOWLObject());
            }

            @Override
            public InternalConfig getConfig() {
                return InternalModel.this.getConfig();
            }

            @Override
            public InternalObjectFactory getObjectFactory() {
                return new ModelObjectFactory(InternalModel.this.getDataFactory(), () -> this);
            }
        }
        return new ObjectModel((Graph)u);
    }

    protected void delete(Triple triple) {
        this.getNodeCache().remove((Object)triple.getSubject());
        this.getBaseGraph().delete(triple);
    }

    @Override
    public InternalModel removeAll() {
        this.clearCache();
        this.getNodeCache().clear();
        super.removeAll();
        return this;
    }

    public void clearCacheIfNeeded() {
        if (this.hasManuallyAddedAxioms()) {
            this.clearCache();
        }
    }

    public boolean hasManuallyAddedAxioms() {
        return this.getContentStore().values().stream().anyMatch(ObjectMap::hasNew);
    }

    public void clearCache() {
        this.cachedID = null;
        this.content.clear();
        this.config.clear();
        this.clearComponentsCaches();
    }

    protected void clearComponentsCaches() {
        this.components.clear();
        this.clearOtherCaches();
    }

    protected void clearOtherCaches() {
        this.objectFactory.clear();
        this.searchModel.clear();
    }

    @Override
    public String toString() {
        return String.format("[%s]%s", this.getClass().getSimpleName(), this.getID());
    }

    protected <K extends Enum<K>, V> Map<K, V> createMapStore(Class<K> type, Stream<K> keys, Function<K, V> loader) {
        EnumMap res = new EnumMap(type);
        keys.forEach(k -> res.put((Object)k, loader.apply(k)));
        return res;
    }

    protected <O extends OWLObject> Stream<O> listComponents(OWLComponentType type) {
        return this.getComponentCache(type).keys();
    }

    protected boolean containsComponent(OWLComponentType type, OWLObject o) {
        return this.getComponentCache(type).contains(o);
    }

    protected <O extends OWLObject> ObjectMap<O> getComponentCache(OWLComponentType type) {
        return Objects.requireNonNull(this.components.get(this).get((Object)type), "Nothing found. Type: " + (Object)((Object)type));
    }

    protected ObjectMap<OWLObject> createComponentObjectMap(OWLComponentType key) {
        InternalObjectFactory df = this.getObjectFactory();
        OntGraphModelImpl m = this.getSearchModel();
        Supplier loader = () -> this.selectContentObjects(key).flatMap(x -> key.select((OWLObject)x, m, df)).iterator();
        InternalConfig conf = this.getConfig();
        if (!conf.useComponentCache()) {
            return new DirectObjectMapImpl<OWLObject>(loader);
        }
        boolean parallel = conf.parallel();
        boolean fastIterator = conf.useIteratorCache();
        return new CacheObjectMapImpl<OWLObject>(loader, false, parallel, fastIterator);
    }

    protected Map<OWLComponentType, ObjectMap<OWLObject>> createComponentStore() {
        return this.createMapStore(OWLComponentType.class, OWLComponentType.keys(), this::createComponentObjectMap);
    }

    protected Stream<ONTObject<OWLObject>> selectContentContainers(OWLComponentType type) {
        return this.selectContent(type, k -> this.getContentCache((OWLContentType)((Object)k)).values(), (k, x) -> k.hasAnnotations((OWLObject)x.getOWLObject()));
    }

    protected Stream<OWLObject> selectContentObjects(OWLComponentType type) {
        return this.selectContent(type, k -> this.getContentCache((OWLContentType)((Object)k)).keys(), OWLContentType::hasAnnotations);
    }

    protected <R> Stream<R> selectContent(OWLComponentType type, Function<OWLContentType, Stream<R>> toStream, BiPredicate<OWLContentType, R> withAnnotations) {
        if (!OWLContentType.ANNOTATION.hasComponent(type)) {
            return OWLContentType.all().filter(k -> k.hasComponent(type)).flatMap(toStream);
        }
        return OWLContentType.all().flatMap(k -> {
            if (k.hasComponent(type)) {
                return (Stream)toStream.apply((OWLContentType)((Object)k));
            }
            return ((Stream)toStream.apply((OWLContentType)((Object)k))).filter(x -> withAnnotations.test((OWLContentType)((Object)k), (Object)x));
        });
    }

    protected void clearComponents(OWLObject container) {
        if (this.components.isEmpty()) {
            return;
        }
        Map<OWLComponentType, ObjectMap<OWLObject>> cache = this.components.get(this);
        OWLComponentType.keys().forEach(type -> {
            ObjectMap map = (ObjectMap)cache.get(type);
            if (!map.isLoaded()) {
                return;
            }
            if (!type.select(container).findFirst().isPresent()) {
                return;
            }
            map.clear();
        });
    }

    protected void cacheComponents(OWLObject container) {
        if (this.components.isEmpty()) {
            return;
        }
        Map<OWLComponentType, ObjectMap<OWLObject>> cache = this.components.get(this);
        InternalObjectFactory df = this.getObjectFactory();
        OntGraphModelImpl m = this.getSearchModel();
        OWLComponentType.keys().forEach(type -> {
            ObjectMap map = (ObjectMap)cache.get(type);
            if (!map.isLoaded()) {
                return;
            }
            type.select(container, m, df).forEach(map::add);
        });
    }

    public void forceLoad() {
        this.getContentStore().values().forEach(ObjectMap::load);
    }

    protected Stream<ObjectMap<? extends OWLAxiom>> filteredAxiomsCaches(Stream<OWLContentType> keys) {
        Map<OWLContentType, ObjectMap<? extends OWLObject>> map = this.getContentStore();
        return keys.map(x -> (ObjectMap)map.get(x));
    }

    protected ObjectMap<OWLAxiom> getAxiomsCache(OWLContentType key) {
        return this.getContentCache(key);
    }

    protected ObjectMap<OWLAnnotation> getHeaderCache() {
        return this.getContentCache(OWLContentType.ANNOTATION);
    }

    protected <X extends OWLObject> ObjectMap<X> getContentCache(OWLContentType key) {
        return this.getContentStore().get((Object)key);
    }

    protected Map<OWLContentType, ObjectMap<? extends OWLObject>> getContentStore() {
        return this.content.get(this);
    }

    protected Map<OWLContentType, ObjectMap<? extends OWLObject>> createContentStore() {
        return this.createMapStore(OWLContentType.class, OWLContentType.all(), this::createContentObjectMap);
    }

    protected ObjectMap<OWLObject> createContentObjectMap(final OWLContentType key) {
        boolean withMerge;
        InternalObjectFactory df = this.getObjectFactory();
        Supplier<OntModel> m = this::getSearchModel;
        Supplier loader = () -> key.read(m, df, this.getConfig());
        InternalConfig conf = this.getConfig();
        if (!conf.useContentCache()) {
            return new DirectObjectMapImpl<OWLObject>(loader, k -> key.find(m, df, this.getConfig(), (OWLObject)k), k -> key.has(m, df, this.getConfig(), (OWLObject)k));
        }
        boolean parallel = conf.parallel();
        boolean fastIterator = conf.useIteratorCache();
        boolean bl = withMerge = !key.isDistinct();
        if (!LOGGER.isDebugEnabled()) {
            return new CacheObjectMapImpl<OWLObject>(loader, withMerge, parallel, fastIterator);
        }
        final OntID id = this.getID();
        return new CacheObjectMapImpl<OWLObject>(loader, withMerge, parallel, fastIterator){

            @Override
            protected CacheObjectMapImpl.CachedMap<OWLObject, ONTObject<OWLObject>> loadMap() {
                Instant start = Instant.now();
                CacheObjectMapImpl.CachedMap<OWLObject, ONTObject<OWLObject>> res = super.loadMap();
                Duration d = Duration.between(start, Instant.now());
                if (res.size() == 0L) {
                    return res;
                }
                LOGGER.debug("[{}]{}:::{}s{}", new Object[]{id, StringUtils.rightPad((String)("[" + (Object)((Object)key) + "]"), (int)42), String.format(Locale.ENGLISH, "%.3f", (double)d.toMillis() / 1000.0), res.size() != 0L ? "(" + res.size() + ")" : ""});
                return res;
            }
        };
    }

    public class DirectListener
    extends GraphListenerBase {
        protected void invalidate() {
            InternalModel.this.clearCache();
        }

        protected void addEvent(Triple t) {
            this.invalidate();
        }

        protected void deleteEvent(Triple t) {
            this.invalidate();
        }

        public void notifyAddGraph(Graph g, Graph other) {
            this.invalidate();
        }

        public void notifyDeleteGraph(Graph g, Graph other) {
            this.invalidate();
        }
    }
}

