/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.lang.ref.SoftReference;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;

public interface InternalCache<K, V> {
    public void put(K var1, V var2);

    public V get(K var1);

    public void remove(K var1);

    public void clear();

    public boolean isEmpty();

    public long size();

    default public V get(K key, Function<? super K, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        V res = this.get(key);
        if (res != null) {
            return res;
        }
        res = mappingFunction.apply(key);
        if (res != null) {
            this.put(key, res);
        }
        return res;
    }

    default public <Key extends K, Value extends V> Loading<Key, Value> asLoading(final Function<? super Key, ? extends Value> loader) {
        Objects.requireNonNull(loader);
        final InternalCache self = this;
        return new Loading<Key, Value>(){

            @Override
            public Value get(Key key) {
                return self.get(key, loader);
            }

            @Override
            public InternalCache<Key, Value> asCache() {
                return self;
            }
        };
    }

    public static <K, V> InternalCache<K, V> createEmpty() {
        return new InternalCache<K, V>(){

            @Override
            public void put(K key, V value) {
            }

            @Override
            public V get(K key) {
                return null;
            }

            @Override
            public void remove(K key) {
            }

            @Override
            public void clear() {
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public long size() {
                return 0L;
            }

            @Override
            public V get(K key, Function<? super K, ? extends V> mappingFunction) {
                return Objects.requireNonNull(mappingFunction).apply(key);
            }
        };
    }

    public static <K, V> InternalCache<K, V> createBounded(boolean caffeine, final long size) {
        if (caffeine) {
            return new CaffeineWrapper(Caffeine.newBuilder().maximumSize(size).build());
        }
        return InternalCache.fromMap(new LinkedHashMap<K, V>((int)size, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return (long)this.size() > size;
            }
        });
    }

    public static <K, V> Loading<K, V> createBounded(Function<? super K, ? extends V> loader, boolean caffeine, final long size) {
        InternalCache<Object, Object> res = caffeine ? new CaffeineWrapper<K, V>(Caffeine.newBuilder().maximumSize(size).build(loader::apply), loader) : InternalCache.fromMap(new LinkedHashMap<K, V>((int)size, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
                return (long)this.size() > size;
            }
        });
        return res.asLoading(loader);
    }

    public static <K, V> InternalCache<K, V> createSoft(boolean caffeine) {
        if (caffeine) {
            return new CaffeineWrapper(Caffeine.newBuilder().softValues().build());
        }
        return new SoftMapWrapper(new LinkedHashMap(128, 0.75f, true));
    }

    public static <K, V> Loading<K, V> createSoft(Function<? super K, ? extends V> loader, boolean caffeine) {
        InternalCache<Object, Object> res = caffeine ? new CaffeineWrapper<K, V>(Caffeine.newBuilder().softValues().build(loader::apply), loader) : new SoftMapWrapper(new LinkedHashMap(128, 0.75f, true));
        return res.asLoading(loader);
    }

    public static <K, V> Loading<K, V> createSingleton(final Function<? super K, ? extends V> loader) {
        Objects.requireNonNull(loader);
        return new Loading<K, V>(){
            private volatile V value;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V get(K key) {
                if (this.value != null) {
                    return this.value;
                }
                5 var2_2 = this;
                synchronized (var2_2) {
                    if (this.value != null) {
                        return this.value;
                    }
                    Object res = loader.apply(key);
                    this.put(key, res);
                    return res;
                }
            }

            @Override
            public InternalCache<K, V> asCache() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                this.value = null;
            }

            @Override
            public void put(K key, V value) {
                this.value = Objects.requireNonNull(value);
            }

            @Override
            public boolean isEmpty() {
                return this.value == null;
            }
        };
    }

    public static <K, V> Loading<K, V> createSoftSingleton(final Function<? super K, ? extends V> loader) {
        Objects.requireNonNull(loader);
        return new Loading<K, V>(){
            private volatile SoftReference<V> value;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public V get(K key) {
                Object res;
                if (this.value != null && (res = this.value.get()) != null) {
                    return res;
                }
                6 var3_3 = this;
                synchronized (var3_3) {
                    if (this.value != null && (res = this.value.get()) != null) {
                        return res;
                    }
                    res = loader.apply(key);
                    this.put(key, res);
                    return res;
                }
            }

            @Override
            public InternalCache<K, V> asCache() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void clear() {
                this.value = null;
            }

            @Override
            public void put(K key, V value) {
                this.value = new SoftReference(Objects.requireNonNull(value));
            }

            @Override
            public boolean isEmpty() {
                return this.value == null || this.value.get() == null;
            }
        };
    }

    public static <K, V> InternalCache<K, V> fromMap(Map<K, V> map) {
        return new MapWrapper<K, V>(map);
    }

    public static class CaffeineWrapper<K, V>
    implements InternalCache<K, V> {
        protected final Cache<K, V> cache;
        protected final Function<? super K, ? extends V> embeddedLoader;

        protected CaffeineWrapper(LoadingCache<K, V> cache, Function<? super K, ? extends V> loader) {
            this.cache = (Cache)Objects.requireNonNull(cache);
            this.embeddedLoader = Objects.requireNonNull(loader);
        }

        protected CaffeineWrapper(Cache<K, V> cache) {
            this.cache = Objects.requireNonNull(cache);
            this.embeddedLoader = null;
        }

        @Override
        public void put(K key, V value) {
            this.cache.put(key, value);
        }

        @Override
        public V get(K key) {
            return (V)this.cache.getIfPresent(key);
        }

        @Override
        public void remove(K key) {
            this.cache.invalidate(key);
        }

        @Override
        public void clear() {
            this.cache.invalidateAll();
        }

        @Override
        public boolean isEmpty() {
            return this.cache.asMap().isEmpty();
        }

        @Override
        public long size() {
            return this.cache.estimatedSize();
        }

        @Override
        public V get(K key, Function<? super K, ? extends V> mappingFunction) {
            return (V)this.cache.get(key, mappingFunction);
        }

        @Override
        public <Key extends K, Value extends V> Loading<Key, Value> asLoading(final Function<? super Key, ? extends Value> loader) {
            Objects.requireNonNull(loader);
            final CaffeineWrapper self = this;
            if (this.cache instanceof LoadingCache && this.embeddedLoader.equals(loader)) {
                return new Loading<Key, Value>(){

                    @Override
                    public Value get(Key key) {
                        return ((LoadingCache)cache).get(key);
                    }

                    @Override
                    public InternalCache<Key, Value> asCache() {
                        return self;
                    }
                };
            }
            return new Loading<Key, Value>(){

                @Override
                public Value get(Key key) {
                    return self.get(key, loader);
                }

                @Override
                public InternalCache<Key, Value> asCache() {
                    return self;
                }
            };
        }
    }

    public static class MapWrapper<K, V>
    implements InternalCache<K, V> {
        protected final Map<K, V> map;

        protected MapWrapper(Map<K, V> map) {
            this.map = Objects.requireNonNull(map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(K key, V value) {
            Map<K, V> map = this.map;
            synchronized (map) {
                this.map.put(key, value);
            }
        }

        @Override
        public V get(K key) {
            return this.map.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(K key) {
            Map<K, V> map = this.map;
            synchronized (map) {
                this.map.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Map<K, V> map = this.map;
            synchronized (map) {
                this.map.clear();
            }
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public long size() {
            return this.map.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(K key, Function<? super K, ? extends V> mappingFunction) {
            Objects.requireNonNull(mappingFunction);
            V res = this.get(key);
            if (res != null) {
                return res;
            }
            Map<K, V> map = this.map;
            synchronized (map) {
                res = this.get(key);
                if (res != null) {
                    return res;
                }
                res = mappingFunction.apply(key);
                if (res != null) {
                    this.put(key, res);
                }
            }
            return res;
        }
    }

    public static class SoftMapWrapper<K, V>
    implements InternalCache<K, V> {
        protected final Map<K, SoftReference<V>> map;

        protected SoftMapWrapper(Map<K, SoftReference<V>> map) {
            this.map = Objects.requireNonNull(map);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void put(K key, V value) {
            Map<K, SoftReference<V>> map = this.map;
            synchronized (map) {
                this.map.put(key, new SoftReference<V>(value));
            }
        }

        @Override
        public V get(K key) {
            SoftReference<V> res = this.map.get(key);
            return res == null ? null : (V)res.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(K key) {
            Map<K, SoftReference<V>> map = this.map;
            synchronized (map) {
                this.map.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Map<K, SoftReference<V>> map = this.map;
            synchronized (map) {
                this.map.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            if (this.map.isEmpty()) {
                return true;
            }
            Map<K, SoftReference<V>> map = this.map;
            synchronized (map) {
                if (this.map.isEmpty()) {
                    return true;
                }
                for (K k : this.map.keySet()) {
                    if (this.get(k) == null) continue;
                    return false;
                }
                return true;
            }
        }

        @Override
        public long size() {
            return this.map.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(K key, Function<? super K, ? extends V> mappingFunction) {
            Objects.requireNonNull(mappingFunction);
            V res = this.get(key);
            if (res != null) {
                return res;
            }
            Map<K, SoftReference<V>> map = this.map;
            synchronized (map) {
                res = this.get(key);
                if (res != null) {
                    return res;
                }
                res = mappingFunction.apply(key);
                if (res != null) {
                    this.put(key, res);
                }
            }
            return res;
        }
    }

    public static interface Loading<K, V> {
        public V get(K var1);

        public InternalCache<K, V> asCache();

        default public void clear() {
            this.asCache().clear();
        }

        default public void put(K key, V value) {
            this.asCache().put(key, value);
        }

        default public boolean isEmpty() {
            return this.asCache().isEmpty();
        }
    }
}

