/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.internal.HasConfig;
import com.github.owlcs.ontapi.internal.HasObjectFactory;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.WithMerge;
import com.github.owlcs.ontapi.jena.impl.PersonalityModel;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.shared.JenaException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAxiom;

public abstract class AxiomTranslator<Axiom extends OWLAxiom> {
    public static InternalConfig getConfig(OntModel model) {
        return model instanceof HasConfig ? ((HasConfig)((Object)model)).getConfig().snapshot() : InternalConfig.DEFAULT;
    }

    public static InternalObjectFactory getObjectFactory(OntModel model) {
        return model instanceof HasObjectFactory ? ((HasObjectFactory)((Object)model)).getObjectFactory() : InternalObjectFactory.DEFAULT;
    }

    protected static Set<Node> getSystemResources(OntModel model) {
        if (model instanceof PersonalityModel) {
            return ((PersonalityModel)((Object)model)).getSystemResources(OntClass.Named.class);
        }
        return Collections.emptySet();
    }

    public final Stream<ONTObject<Axiom>> axioms(OntModel model) throws JenaException {
        return Iter.asStream(this.listAxioms(model));
    }

    public final ExtendedIterator<ONTObject<Axiom>> listAxioms(OntModel model) throws JenaException {
        Objects.requireNonNull(model, "Null model.");
        InternalObjectFactory factory = AxiomTranslator.getObjectFactory(model);
        InternalConfig config = AxiomTranslator.getConfig(model);
        return this.translate(this.listStatements(model, config), () -> model, factory, config);
    }

    public final Stream<OntStatement> statements(OntModel model) {
        return Iter.asStream(this.listStatements(model, AxiomTranslator.getConfig(model)));
    }

    public final boolean testStatement(OntStatement statement) {
        return this.testStatement(statement, AxiomTranslator.getConfig(statement.getModel()));
    }

    public final ONTObject<Axiom> toAxiom(OntStatement statement) throws JenaException {
        OntModel m = statement.getModel();
        if (m instanceof HasConfig && m instanceof HasObjectFactory) {
            return this.toAxiomImpl(statement, () -> m, ((HasObjectFactory)((Object)m)).getObjectFactory(), ((HasConfig)((Object)m)).getConfig());
        }
        return this.toAxiomWrap(statement, AxiomTranslator.getObjectFactory(statement.getModel()), AxiomTranslator.getConfig(statement.getModel()));
    }

    protected ExtendedIterator<ONTObject<Axiom>> listAxioms(Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) throws JenaException {
        return this.translate(this.listStatements(model.get(), config), model, factory, config);
    }

    protected ExtendedIterator<ONTObject<Axiom>> translate(ExtendedIterator<OntStatement> statements, Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config) {
        boolean hasDefault;
        boolean bl = hasDefault = factory == InternalObjectFactory.DEFAULT || config == InternalConfig.DEFAULT;
        if (config.isSplitAxiomAnnotations()) {
            return Iter.flatMap(statements, s -> {
                if (hasDefault) {
                    return OntModels.listSplitStatements(s).mapWith(x -> this.toAxiomWrap((OntStatement)x, factory, config));
                }
                List sts = OntModels.listSplitStatements(s).toList();
                if (sts.size() == 1) {
                    return Iter.of(this.toAxiomImpl((OntStatement)s, model, factory, config));
                }
                return Iter.create(sts).mapWith(x -> this.toAxiomWrap((OntStatement)x, factory, config));
            });
        }
        return statements.mapWith(s -> hasDefault ? this.toAxiomWrap((OntStatement)s, factory, config) : this.toAxiomImpl((OntStatement)s, model, factory, config));
    }

    protected boolean containsAxiom(Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config, Axiom key) {
        Objects.requireNonNull(key);
        return Iter.anyMatch(this.listAxioms(model, factory, config), x -> ((OWLAxiom)x.getOWLObject()).equals(key));
    }

    protected Optional<ONTObject<Axiom>> findAxiom(Supplier<OntModel> model, InternalObjectFactory factory, InternalConfig config, Axiom key) {
        Objects.requireNonNull(key);
        List list = this.listAxioms(model, factory, config).filterKeep(x -> ((OWLAxiom)x.getOWLObject()).equals(key)).toList();
        if (list.isEmpty()) {
            return Optional.empty();
        }
        ONTObject res = (ONTObject)list.remove(0);
        for (ONTObject a : list) {
            res = ((WithMerge)((Object)res)).merge(a);
        }
        return Optional.of(res);
    }

    public abstract void write(Axiom var1, OntModel var2);

    public abstract ExtendedIterator<OntStatement> listStatements(OntModel var1, InternalConfig var2);

    public abstract boolean testStatement(OntStatement var1, InternalConfig var2);

    protected abstract ONTObject<Axiom> toAxiomWrap(OntStatement var1, InternalObjectFactory var2, InternalConfig var3) throws JenaException;

    protected abstract ONTObject<Axiom> toAxiomImpl(OntStatement var1, Supplier<OntModel> var2, InternalObjectFactory var3, InternalConfig var4) throws JenaException;
}

