/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.axioms.AnnotationAssertionTranslator;
import com.github.owlcs.ontapi.internal.axioms.AnnotationPropertyDomainTranslator;
import com.github.owlcs.ontapi.internal.axioms.AnnotationPropertyRangeTranslator;
import com.github.owlcs.ontapi.internal.axioms.AsymmetricObjectPropertyTranslator;
import com.github.owlcs.ontapi.internal.axioms.ClassAssertionTranslator;
import com.github.owlcs.ontapi.internal.axioms.DataPropertyAssertionTranslator;
import com.github.owlcs.ontapi.internal.axioms.DataPropertyDomainTranslator;
import com.github.owlcs.ontapi.internal.axioms.DataPropertyRangeTranslator;
import com.github.owlcs.ontapi.internal.axioms.DatatypeDefinitionTranslator;
import com.github.owlcs.ontapi.internal.axioms.DeclarationTranslator;
import com.github.owlcs.ontapi.internal.axioms.DifferentIndividualsTranslator;
import com.github.owlcs.ontapi.internal.axioms.DisjointClassesTranslator;
import com.github.owlcs.ontapi.internal.axioms.DisjointDataPropertiesTranslator;
import com.github.owlcs.ontapi.internal.axioms.DisjointObjectPropertiesTranslator;
import com.github.owlcs.ontapi.internal.axioms.DisjointUnionTranslator;
import com.github.owlcs.ontapi.internal.axioms.EquivalentClassesTranslator;
import com.github.owlcs.ontapi.internal.axioms.EquivalentDataPropertiesTranslator;
import com.github.owlcs.ontapi.internal.axioms.EquivalentObjectPropertiesTranslator;
import com.github.owlcs.ontapi.internal.axioms.FunctionalDataPropertyTranslator;
import com.github.owlcs.ontapi.internal.axioms.FunctionalObjectPropertyTranslator;
import com.github.owlcs.ontapi.internal.axioms.HasKeyTranslator;
import com.github.owlcs.ontapi.internal.axioms.InverseFunctionalObjectPropertyTranslator;
import com.github.owlcs.ontapi.internal.axioms.InverseObjectPropertiesTranslator;
import com.github.owlcs.ontapi.internal.axioms.IrreflexiveObjectPropertyTranslator;
import com.github.owlcs.ontapi.internal.axioms.NegativeDataPropertyAssertionTranslator;
import com.github.owlcs.ontapi.internal.axioms.NegativeObjectPropertyAssertionTranslator;
import com.github.owlcs.ontapi.internal.axioms.ObjectPropertyAssertionTranslator;
import com.github.owlcs.ontapi.internal.axioms.ObjectPropertyDomainTranslator;
import com.github.owlcs.ontapi.internal.axioms.ObjectPropertyRangeTranslator;
import com.github.owlcs.ontapi.internal.axioms.ReflexiveObjectPropertyTranslator;
import com.github.owlcs.ontapi.internal.axioms.SWRLRuleTranslator;
import com.github.owlcs.ontapi.internal.axioms.SameIndividualTranslator;
import com.github.owlcs.ontapi.internal.axioms.SubAnnotationPropertyOfTranslator;
import com.github.owlcs.ontapi.internal.axioms.SubClassOfTranslator;
import com.github.owlcs.ontapi.internal.axioms.SubDataPropertyOfTranslator;
import com.github.owlcs.ontapi.internal.axioms.SubObjectPropertyOfTranslator;
import com.github.owlcs.ontapi.internal.axioms.SubPropertyChainOfTranslator;
import com.github.owlcs.ontapi.internal.axioms.SymmetricObjectPropertyTranslator;
import com.github.owlcs.ontapi.internal.axioms.TransitiveObjectPropertyTranslator;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AxiomParserProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AxiomParserProvider.class);

    public static Map<AxiomType<?>, AxiomTranslator<? extends OWLAxiom>> getParsers() {
        return ParserHolder.PARSERS;
    }

    public static <A extends OWLAxiom> AxiomTranslator<A> get(Class<A> type) {
        return AxiomParserProvider.get(AxiomType.getTypeForClass(type));
    }

    public static <A extends OWLAxiom> AxiomTranslator<A> get(A axiom) {
        return AxiomParserProvider.get(Objects.requireNonNull(axiom, "Null axiom.").getAxiomType());
    }

    public static <A extends OWLAxiom> AxiomTranslator<A> get(AxiomType<A> type) {
        return Objects.requireNonNull(AxiomParserProvider.getParsers().get(Objects.requireNonNull(type, "Null axiom type")), "Can't find parser for axiom " + type.getActualClass());
    }

    private static class ParserHolder {
        private static final List<Class<? extends AxiomTranslator<?>>> TRANSLATORS = Arrays.asList(DataPropertyDomainTranslator.class, SameIndividualTranslator.class, SubObjectPropertyOfTranslator.class, AsymmetricObjectPropertyTranslator.class, FunctionalObjectPropertyTranslator.class, AnnotationAssertionTranslator.class, DisjointUnionTranslator.class, SWRLRuleTranslator.class, EquivalentClassesTranslator.class, AnnotationPropertyRangeTranslator.class, DatatypeDefinitionTranslator.class, DisjointObjectPropertiesTranslator.class, InverseFunctionalObjectPropertyTranslator.class, DataPropertyAssertionTranslator.class, InverseObjectPropertiesTranslator.class, ReflexiveObjectPropertyTranslator.class, DifferentIndividualsTranslator.class, FunctionalDataPropertyTranslator.class, DataPropertyRangeTranslator.class, EquivalentObjectPropertiesTranslator.class, ObjectPropertyRangeTranslator.class, NegativeDataPropertyAssertionTranslator.class, SubPropertyChainOfTranslator.class, AnnotationPropertyDomainTranslator.class, TransitiveObjectPropertyTranslator.class, EquivalentDataPropertiesTranslator.class, DisjointDataPropertiesTranslator.class, ObjectPropertyDomainTranslator.class, SubAnnotationPropertyOfTranslator.class, SubClassOfTranslator.class, DisjointClassesTranslator.class, SymmetricObjectPropertyTranslator.class, SubDataPropertyOfTranslator.class, DeclarationTranslator.class, ObjectPropertyAssertionTranslator.class, ClassAssertionTranslator.class, HasKeyTranslator.class, IrreflexiveObjectPropertyTranslator.class, NegativeObjectPropertyAssertionTranslator.class);
        private static final Map<AxiomType<?>, AxiomTranslator<? extends OWLAxiom>> PARSERS = ParserHolder.init();

        private ParserHolder() {
        }

        private static Map<AxiomType<?>, AxiomTranslator<? extends OWLAxiom>> init() {
            HashMap res = new HashMap();
            AxiomType.AXIOM_TYPES.forEach(type -> {
                Class<AxiomTranslator<?>> parserClass = ParserHolder.findParserClass((AxiomType<? extends OWLAxiom>)type);
                try {
                    res.put((AxiomType<?>)type, (AxiomTranslator<? extends OWLAxiom>)parserClass.newInstance());
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalStateException("Can't instance parser for type: " + type, e);
                }
            });
            return res;
        }

        private static Class<? extends AxiomTranslator<?>> findParserClass(AxiomType<? extends OWLAxiom> type) {
            return TRANSLATORS.stream().filter(p -> ParserHolder.isRelatedToAxiom(p, type.getActualClass())).findFirst().orElseThrow(() -> new IllegalStateException("Can't find parser class for type '" + type + "'"));
        }

        private static boolean isRelatedToAxiom(Class<? extends AxiomTranslator<?>> parserClass, Class<? extends OWLAxiom> actualClass) {
            ParameterizedType type = (ParameterizedType)parserClass.getGenericSuperclass();
            if (type == null) {
                return false;
            }
            for (Type t : type.getActualTypeArguments()) {
                if (!actualClass.getName().equals(t.getTypeName())) continue;
                return true;
            }
            return false;
        }

        static {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.trace("There are following axiom-parsers (" + PARSERS.size() + "): ");
                PARSERS.forEach((t, p) -> LOGGER.trace("{} ::: {}", t, p.getClass()));
            }
        }
    }
}

