/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.config;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.config.ExtendedProperties;
import com.github.owlcs.ontapi.config.OntConfig;
import com.github.owlcs.ontapi.jena.impl.conf.OntModelConfig;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import com.github.owlcs.ontapi.transforms.GraphTransformers;
import com.github.owlcs.ontapi.transforms.OWLCommonTransform;
import com.github.owlcs.ontapi.transforms.OWLDeclarationTransform;
import com.github.owlcs.ontapi.transforms.OWLIDTransform;
import com.github.owlcs.ontapi.transforms.RDFSTransform;
import com.github.owlcs.ontapi.transforms.SWRLTransform;
import com.github.owlcs.ontapi.transforms.Transform;
import com.github.owlcs.ontapi.transforms.TransformationModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.jena.vocabulary.RDFS;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingOntologyHeaderStrategy;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;

public enum OntSettings {
    OWL_API_LOAD_CONF_IGNORED_IMPORTS(new Serializable[]{"http://www.w3.org/2002/07/owl#", RDF.getURI(), RDFS.getURI(), "http://www.w3.org/2003/11/swrl#", "http://www.w3.org/2003/11/swrlb#", "http://www.w3.org/XML/1998/namespace", "http://www.w3.org/2001/XMLSchema#"}),
    ONT_API_LOAD_CONF_SUPPORTED_SCHEMES(OntConfig.DefaultScheme.HTTP, OntConfig.DefaultScheme.HTTPS, OntConfig.DefaultScheme.FTP, OntConfig.DefaultScheme.FILE),
    ONT_API_LOAD_CONF_PERFORM_TRANSFORMATIONS((Serializable)Boolean.valueOf(true)),
    ONT_API_LOAD_CONF_ALLOW_BULK_ANNOTATION_ASSERTIONS((Serializable)Boolean.valueOf(true)),
    ONT_API_LOAD_CONF_ALLOW_READ_DECLARATIONS((Serializable)Boolean.valueOf(true)),
    ONT_API_LOAD_CONF_IGNORE_ANNOTATION_AXIOM_OVERLAPS((Serializable)Boolean.valueOf(true)),
    ONT_API_LOAD_CONF_USE_OWL_PARSERS_TO_LOAD((Serializable)Boolean.valueOf(false)),
    ONT_API_LOAD_CONF_IGNORE_AXIOMS_READ_ERRORS((Serializable)Boolean.valueOf(false)),
    ONT_API_LOAD_CONF_SPLIT_AXIOM_ANNOTATIONS((Serializable)Boolean.valueOf(false)),
    ONT_API_LOAD_CONF_CACHE_MODEL((Serializable)Integer.valueOf(22)),
    ONT_API_LOAD_CONF_CACHE_OBJECTS((Serializable)Integer.valueOf(2048)),
    ONT_API_LOAD_CONF_CACHE_NODES((Serializable)Integer.valueOf(50000)),
    ONT_API_MANAGER_CACHE_IRIS((Serializable)Integer.valueOf(2048)),
    ONT_API_LOAD_CONF_PROCESS_IMPORTS((Serializable)Boolean.valueOf(true)),
    OWL_API_LOAD_CONF_ACCEPT_HTTP_COMPRESSION((Serializable)Boolean.valueOf(true)),
    OWL_API_LOAD_CONF_CONNECTION_TIMEOUT((Serializable)Integer.valueOf(20000)),
    OWL_API_LOAD_CONF_FOLLOW_REDIRECTS((Serializable)Boolean.valueOf(true)),
    OWL_API_LOAD_CONF_LOAD_ANNOTATIONS((Serializable)Boolean.valueOf(true)),
    OWL_API_LOAD_CONF_MISSING_IMPORT_HANDLING_STRATEGY((Serializable)MissingImportHandlingStrategy.THROW_EXCEPTION),
    OWL_API_LOAD_CONF_MISSING_ONTOLOGY_HEADER_STRATEGY((Serializable)MissingOntologyHeaderStrategy.INCLUDE_GRAPH),
    OWL_API_LOAD_CONF_REPORT_STACK_TRACES((Serializable)Boolean.valueOf(true)),
    OWL_API_LOAD_CONF_RETRIES_TO_ATTEMPT((Serializable)Integer.valueOf(5)),
    OWL_API_LOAD_CONF_PARSE_WITH_STRICT_CONFIGURATION((Serializable)Boolean.valueOf(false)),
    OWL_API_LOAD_CONF_TREAT_DUBLINCORE_AS_BUILTIN((Serializable)Boolean.valueOf(true)),
    OWL_API_LOAD_CONF_PRIORITY_COLLECTION_SORTING((Serializable)PriorityCollectionSorting.ON_SET_INJECTION_ONLY),
    OWL_API_LOAD_CONF_BANNED_PARSERS((Serializable)((Object)"")),
    OWL_API_LOAD_CONF_ENTITY_EXPANSION_LIMIT((Serializable)((Object)"100000000")),
    OWL_API_AUTHORIZATION_VALUE((Serializable)((Object)"")),
    ONT_API_WRITE_CONF_CONTROL_IMPORTS((Serializable)Boolean.valueOf(false)),
    OWL_API_WRITE_CONF_SAVE_IDS((Serializable)Boolean.valueOf(false)),
    OWL_API_WRITE_CONF_REMAP_IDS((Serializable)Boolean.valueOf(true)),
    OWL_API_WRITE_CONF_USE_NAMESPACE_ENTITIES((Serializable)Boolean.valueOf(false)),
    OWL_API_WRITE_CONF_INDENTING((Serializable)Boolean.valueOf(true)),
    OWL_API_WRITE_CONF_LABEL_AS_BANNER((Serializable)Boolean.valueOf(false)),
    OWL_API_WRITE_CONF_BANNERS_ENABLED((Serializable)Boolean.valueOf(true)),
    OWL_API_WRITE_CONF_INDENT_SIZE((Serializable)Integer.valueOf(4)),
    ONT_API_LOAD_CONF_PERSONALITY_MODE((Serializable)((Object)OntModelConfig.StdMode.MEDIUM)){

        @Override
        public Object getDefaultValue() {
            OntModelConfig.StdMode mode = this.getPersonalityMode();
            switch (mode) {
                case LAX: {
                    return OntModelConfig.ONT_PERSONALITY_LAX;
                }
                case MEDIUM: {
                    return OntModelConfig.ONT_PERSONALITY_MEDIUM;
                }
                case STRICT: {
                    return OntModelConfig.ONT_PERSONALITY_STRICT;
                }
            }
            throw new OntApiException.Unsupported("Unsupported personality mode " + (Object)((Object)mode));
        }

        OntModelConfig.StdMode getPersonalityMode() {
            OntModelConfig.StdMode res = (OntModelConfig.StdMode)PROPERTIES.getEnumProperty(this.key);
            if (res == null) {
                res = (OntModelConfig.StdMode)((Object)this.secondary);
            }
            return res;
        }
    }
    ,
    ONT_API_LOAD_CONF_TRANSFORMERS(new Serializable[]{OWLIDTransform.class, RDFSTransform.class, OWLCommonTransform.class, OWLDeclarationTransform.class, SWRLTransform.class}){

        @Override
        public Object getDefaultValue() {
            GraphTransformers res = new GraphTransformers();
            for (Class<? extends TransformationModel> c : this.getTransformTypes()) {
                res = res.addLast(Transform.Factory.create(c));
            }
            return res;
        }

        List<Class<? extends TransformationModel>> getTransformTypes() {
            List res = PROPERTIES.getListProperty(this.key);
            if (res == null) {
                res = (List)((Object)this.secondary);
            }
            return res;
        }
    };

    public static final ExtendedProperties PROPERTIES;
    static final OntSettings[] LOAD_CONFIG_KEYS;
    static final OntSettings[] WRITE_CONFIG_KEYS;
    protected final Serializable secondary;
    protected final String key;
    private final boolean isONT;
    private final boolean isLoad;
    private final boolean isWrite;

    private OntSettings(Serializable ... values) {
        this((Serializable)Arrays.stream(values).collect(Collectors.toCollection(ArrayList::new)));
    }

    private OntSettings(Serializable value) {
        this.secondary = value;
        this.key = this.name().toLowerCase().replace("_", ".");
        this.isONT = this.key.startsWith("ont.api");
        this.isLoad = this.key.contains(".load.conf.");
        this.isWrite = this.key.contains(".write.conf.");
    }

    public Object getDefaultValue() {
        Object primary;
        String k = this.key();
        if (this.secondary instanceof Enum) {
            primary = PROPERTIES.getEnumProperty(k);
        } else if (this.secondary instanceof Class) {
            primary = PROPERTIES.getClassProperty(k);
        } else {
            if (this.secondary instanceof List) {
                List list = PROPERTIES.getListProperty(k);
                if (list == null) {
                    list = (List)((Object)this.secondary);
                }
                return Collections.unmodifiableList(list);
            }
            if (this.secondary instanceof Boolean) {
                primary = PROPERTIES.getBooleanProperty(k);
            } else if (this.secondary instanceof Integer) {
                primary = PROPERTIES.getIntegerProperty(k);
            } else if (this.secondary instanceof Long) {
                primary = PROPERTIES.getLongProperty(k);
            } else if (this.secondary instanceof Double) {
                primary = PROPERTIES.getDoubleProperty(k);
            } else if (this.secondary instanceof String) {
                primary = PROPERTIES.getProperty(k);
            } else {
                throw new OntApiException("Unsupported value " + this.secondary.getClass());
            }
        }
        return primary == null ? this.secondary : primary;
    }

    public boolean isLoad() {
        return this.isLoad;
    }

    public boolean isWrite() {
        return this.isWrite;
    }

    public boolean isONT() {
        return this.isONT;
    }

    public String key() {
        return this.key;
    }

    private static ExtendedProperties loadProperties() {
        ExtendedProperties res = new ExtendedProperties();
        try (InputStream io = OntApiException.notNull(OntSettings.class.getResourceAsStream("/ontapi.properties"), "Null properties");){
            res.load(io);
        }
        catch (IOException e) {
            throw new OntApiException("No ontapi.properties found.", e);
        }
        return res;
    }

    private static OntSettings[] filter(Predicate<OntSettings> filter) {
        return (OntSettings[])Arrays.stream(OntSettings.values()).filter(filter).toArray(OntSettings[]::new);
    }

    static {
        PROPERTIES = OntSettings.loadProperties();
        LOAD_CONFIG_KEYS = OntSettings.filter(OntSettings::isLoad);
        WRITE_CONFIG_KEYS = OntSettings.filter(OntSettings::isWrite);
    }
}

