/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.config;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;

public class ExtendedProperties
extends Properties {
    public ExtendedProperties() {
    }

    public ExtendedProperties(Properties defaults) {
        super(defaults);
    }

    public <T> List<T> getListProperty(String key, Class<T> type) {
        ArrayList<Object> res = new ArrayList<Object>();
        MapType map = this.getMapType(type);
        for (int i = 0; i < this.size(); ++i) {
            Object obj;
            String v = this.getProperty(map.toListKey(key, i));
            if (v == null) continue;
            try {
                obj = map.toObject(v);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to get list property [" + key + ":" + i + "]", e);
            }
            res.add(obj);
        }
        return res;
    }

    protected MapType getMapType(Class<?> type) {
        return Stream.of(MapType.values()).filter(m -> m.isSupported(type)).findFirst().orElseThrow(() -> new RuntimeException(type + " is not supported."));
    }

    public <T> T getTypedProperty(String key, Class<T> type) {
        MapType map = this.getMapType(type);
        String res = this.getProperty(map.toKey(key));
        if (res == null) {
            return null;
        }
        try {
            return (T)map.toObject(res);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get property '" + key + "'", e);
        }
    }

    public <T> void setTypedProperty(String key, T value) {
        if (value instanceof List) {
            this.setListProperty(key, (List)value);
            return;
        }
        MapType map = this.getMapType(value.getClass());
        try {
            this.setProperty(map.toKey(key), map.toString(value));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to set property '" + key + "'", e);
        }
    }

    public <T> void setListProperty(String key, List<T> values) {
        if (values.isEmpty()) {
            return;
        }
        MapType map = this.getMapType(values.get(0).getClass());
        for (int i = 0; i < values.size(); ++i) {
            String val;
            try {
                val = map.toString(values.get(i));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to set list property [" + key + ":" + i + "]", e);
            }
            this.setProperty(map.toListKey(key, i), val);
        }
    }

    public List<?> getListProperty(String key) {
        for (MapType map : MapType.values()) {
            if (!this.containsKey(map.toListKey(key, 0))) continue;
            return this.getListProperty(key, map.type);
        }
        return null;
    }

    public List<String> getStringListProperty(String key) {
        return this.getListProperty(key, String.class);
    }

    public Class<?> getClassProperty(String key) {
        return this.getTypedProperty(key, Class.class);
    }

    public Enum<?> getEnumProperty(String key) {
        return this.getTypedProperty(key, Enum.class);
    }

    public Boolean getBooleanProperty(String key) {
        return this.getTypedProperty(key, Boolean.class);
    }

    public Integer getIntegerProperty(String key) {
        return this.getTypedProperty(key, Integer.class);
    }

    public Long getLongProperty(String key) {
        return this.getTypedProperty(key, Long.class);
    }

    public Double getDoubleProperty(String key) {
        return this.getTypedProperty(key, Double.class);
    }

    protected static enum MapType {
        CLASS((Class)Class.class){

            @Override
            public Object toObject(String value) throws Exception {
                return Class.forName(value);
            }

            @Override
            public String toString(Object value) {
                return ((Class)value).getName();
            }
        }
        ,
        ENUM((Class)Enum.class){

            @Override
            public Object toObject(String value) throws Exception {
                String path = value.replaceAll("^(.+)#.+$", "$1");
                String name = value.replaceAll("^.+#(.+)$", "$1");
                Class<?> clazz = this.getEnumHolderClass(path);
                for (Object o : clazz.getEnumConstants()) {
                    if (!String.valueOf(o).equals(name)) continue;
                    return o;
                }
                throw new RuntimeException(value + " is not enum.");
            }

            private Class<?> getEnumHolderClass(String path) throws ClassNotFoundException {
                try {
                    return Class.forName(path);
                }
                catch (ClassNotFoundException e) {
                    if (!path.contains("$")) {
                        throw e;
                    }
                    String outer = path.replaceAll("\\$.+$", "");
                    String inner = path.replaceAll("^.+\\$", "");
                    Class<?> clazz = Class.forName(outer);
                    for (Class<?> c : this.getInterfaces(clazz)) {
                        try {
                            return Class.forName(c.getName() + "$" + inner);
                        }
                        catch (ClassNotFoundException x) {
                            e.addSuppressed(x);
                        }
                    }
                    throw e;
                }
            }

            private Set<Class<?>> getInterfaces(Class<?> clazz) {
                HashSet res = new HashSet();
                for (Class<?> c : clazz.getInterfaces()) {
                    if (!res.add(c)) continue;
                    res.addAll(this.getInterfaces(c));
                }
                return res;
            }

            @Override
            public String toString(Object value) {
                Enum val = (Enum)value;
                return val.getDeclaringClass().getName() + "#" + val.name();
            }

            @Override
            public boolean isSupported(Class<?> clazz) {
                return this.type.isAssignableFrom(clazz);
            }
        }
        ,
        BOOLEAN((Class)Boolean.class){

            @Override
            public Object toObject(String value) {
                return Boolean.parseBoolean(value);
            }
        }
        ,
        INTEGER((Class)Integer.class){

            @Override
            public Object toObject(String value) {
                return Integer.valueOf(value);
            }
        }
        ,
        LONG((Class)Long.class){

            @Override
            public Object toObject(String value) {
                return Long.valueOf(value);
            }
        }
        ,
        DOUBLE((Class)Double.class){

            @Override
            public Object toObject(String value) {
                return Double.valueOf(value);
            }
        }
        ,
        STRING((Class)String.class){

            @Override
            public Object toObject(String value) {
                return value;
            }

            @Override
            public String toKey(String key) {
                return key;
            }
        };

        protected final Class<?> type;

        private MapType(Class<?> t) {
            this.type = t;
        }

        public abstract Object toObject(String var1) throws Exception;

        public String toString(Object value) {
            return String.valueOf(value);
        }

        public String typeName() {
            return this.type.getSimpleName().toLowerCase();
        }

        public String toKey(String key) {
            return key + "." + this.typeName();
        }

        public String toListKey(String key, int index) {
            return this.toKey(key + ".list") + "." + index;
        }

        public boolean isSupported(Class<?> clazz) {
            return Objects.equals(this.type, clazz);
        }
    }
}

