/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.BaseModel;
import com.github.owlcs.ontapi.HasAdapter;
import com.github.owlcs.ontapi.ModelConfig;
import com.github.owlcs.ontapi.OWLAdapter;
import com.github.owlcs.ontapi.OWLOntologyWrapper;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.OntBaseModelImpl;
import com.github.owlcs.ontapi.Ontology;
import com.github.owlcs.ontapi.OntologyManager;
import com.github.owlcs.ontapi.OntologyManagerImpl;
import com.github.owlcs.ontapi.internal.InternalModel;
import com.github.owlcs.ontapi.jena.UnionGraph;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.utils.Graphs;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.jena.graph.Graph;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitorEx;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;

public class OntologyModelImpl
extends OntBaseModelImpl
implements Ontology,
OWLMutableOntology {
    private static final long serialVersionUID = -2882895355499914294L;
    protected final OWLOntologyChangeVisitorEx<ChangeApplied> changer = this.createChangeProcessor();

    protected OntologyModelImpl(Graph graph, ModelConfig config) {
        super(graph, config);
    }

    public ChangeApplied applyDirectChange(OWLOntologyChange change) {
        return (ChangeApplied)change.accept(this.changer);
    }

    @Override
    public OntologyManagerImpl getOWLOntologyManager() {
        return (OntologyManagerImpl)super.getOWLOntologyManager();
    }

    protected OWLOntologyChangeVisitorEx<ChangeApplied> createChangeProcessor() {
        return new ChangeProcessor();
    }

    @Override
    public void clearCache() {
        this.getBase().clearCache();
    }

    @Override
    public OntModel asGraphModel() {
        return this.getBase();
    }

    public void setLock(ReadWriteLock lock) {
        throw new OntApiException.Unsupported("Model's lock cannot be changed in ONT-API");
    }

    public static class ModificationDeniedException
    extends OntApiException.Unsupported {
        public ModificationDeniedException(String message) {
            super(message);
        }
    }

    public static class Concurrent
    extends OWLOntologyWrapper
    implements Ontology,
    BaseModel {
        private static final long serialVersionUID = 5823394836022970162L;

        protected Concurrent(OntologyModelImpl delegate, ReadWriteLock lock) {
            super(delegate, lock);
        }

        public OntologyModelImpl delegate() {
            return (OntologyModelImpl)this.delegate;
        }

        @Override
        public OntModel asGraphModel() {
            this.lock.readLock().lock();
            try {
                InternalModel base = this.getBase();
                OntGraphModelImpl ontGraphModelImpl = Concurrent.asConcurrent(base.getGraph(), base.getOntPersonality(), this.lock);
                return ontGraphModelImpl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public void clearCache() {
            this.lock.readLock().lock();
            try {
                this.delegate().clearCache();
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public OntologyManager getOWLOntologyManager() {
            return (OntologyManager)super.getOWLOntologyManager();
        }

        @Override
        public InternalModel getBase() {
            return this.delegate().getBase();
        }

        @Override
        public void setBase(InternalModel m) {
            this.delegate().setBase(m);
        }

        @Override
        public ModelConfig getConfig() {
            return this.delegate().getConfig();
        }

        @Override
        public void setConfig(ModelConfig conf) {
            this.delegate().setConfig(conf);
        }

        public static OntGraphModelImpl asConcurrent(UnionGraph graph, OntPersonality personality, final ReadWriteLock lock) {
            final Graph base = graph.getBaseGraph();
            UnionGraph copy = Concurrent.withBase(graph, Graphs.asConcurrent(base, lock));
            return new OntGraphModelImpl((Graph)copy, personality){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                protected void addImportModel(Graph g, String u) {
                    lock.writeLock().lock();
                    try {
                        UnionGraph from = 1.asUnionGraph(g);
                        Graph base2 = Graphs.asNonConcurrent(from.getBaseGraph());
                        UnionGraph res = Concurrent.withBase(from, base2);
                        super.addImportModel((Graph)res, u);
                    }
                    finally {
                        lock.writeLock().unlock();
                    }
                }

                @Override
                protected void removeImportModel(Graph g, String u) {
                    lock.writeLock().lock();
                    try {
                        super.removeImportModel(g, u);
                    }
                    finally {
                        lock.writeLock().unlock();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Stream<OntModel> imports() {
                    lock.readLock().lock();
                    try {
                        OntPersonality p = this.getOntPersonality();
                        List res = this.listImportGraphs().mapWith(x -> Concurrent.asConcurrent(x, p, lock)).toList();
                        Stream<OntModel> stream = res.stream();
                        return stream;
                    }
                    finally {
                        lock.readLock().unlock();
                    }
                }

                @Override
                protected Optional<OntGraphModelImpl> findImport(Predicate<OntGraphModelImpl> filter) {
                    lock.readLock().lock();
                    try {
                        Optional<OntGraphModelImpl> optional = super.findImport(filter);
                        return optional;
                    }
                    finally {
                        lock.readLock().unlock();
                    }
                }

                @Override
                public String toString() {
                    return String.format("ConcurrentOntGraphModel{%s}", Graphs.getName(base));
                }
            };
        }

        public static UnionGraph withBase(UnionGraph from, Graph base) {
            if (Objects.requireNonNull(from).getBaseGraph().equals(Objects.requireNonNull(base))) {
                return from;
            }
            if (from instanceof U) {
                return Concurrent.withBase(((U)from).from, base);
            }
            class U
            extends UnionGraph {
                private final UnionGraph from;

                U(Graph base, UnionGraph from) {
                    super(base, from.getUnderlying(), from.getEventManager(), from.isDistinct());
                    this.from = from;
                }

                @Override
                public UnionGraph addGraph(Graph graph) {
                    this.from.addGraph(graph);
                    this.addParent(graph);
                    this.resetGraphsCache();
                    return this;
                }

                @Override
                public UnionGraph removeGraph(Graph graph) {
                    this.from.removeGraph(graph);
                    this.removeParent(graph);
                    this.resetGraphsCache();
                    return this;
                }

                @Override
                protected Set<Graph> collectBaseGraphs() {
                    Set<Graph> res = super.collectBaseGraphs();
                    res.remove(this.from.getBaseGraph());
                    return res;
                }
            }
            return new U(base, from);
        }
    }

    protected class ChangeProcessor
    implements OWLOntologyChangeVisitorEx<ChangeApplied>,
    HasAdapter,
    Serializable {
        private static final long serialVersionUID = 1150135725506037485L;

        protected ChangeProcessor() {
        }

        public ChangeApplied visit(@Nonnull AddAxiom change) {
            this.beforeChange();
            OWLAxiom axiom = change.getAxiom();
            if (OntologyModelImpl.this.containsAxiom(axiom)) {
                return ChangeApplied.NO_OPERATION;
            }
            OntologyModelImpl.this.getBase().add(axiom);
            return ChangeApplied.SUCCESSFULLY;
        }

        public ChangeApplied visit(@Nonnull RemoveAxiom change) {
            this.beforeChange();
            OWLAxiom axiom = change.getAxiom();
            if (OntologyModelImpl.this.containsAxiom(axiom)) {
                OntologyModelImpl.this.getBase().remove(axiom);
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        public ChangeApplied visit(@Nonnull AddImport change) {
            OWLImportsDeclaration importDeclaration = change.getImportDeclaration();
            if (OntologyModelImpl.this.importsDeclarations().noneMatch(importDeclaration::equals)) {
                this.addImport(importDeclaration);
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        public ChangeApplied visit(@Nonnull RemoveImport change) {
            OWLImportsDeclaration importDeclaration = change.getImportDeclaration();
            if (OntologyModelImpl.this.importsDeclarations().anyMatch(importDeclaration::equals)) {
                this.removeImport(importDeclaration);
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        public ChangeApplied visit(@Nonnull AddOntologyAnnotation change) {
            this.beforeChange();
            OWLAnnotation annotation = change.getAnnotation();
            if (OntologyModelImpl.this.getBase().contains(annotation)) {
                return ChangeApplied.NO_OPERATION;
            }
            OntologyModelImpl.this.getBase().add(annotation);
            return ChangeApplied.SUCCESSFULLY;
        }

        public ChangeApplied visit(@Nonnull RemoveOntologyAnnotation change) {
            this.beforeChange();
            OWLAnnotation annotation = change.getAnnotation();
            if (OntologyModelImpl.this.annotations().anyMatch(annotation::equals)) {
                OntologyModelImpl.this.getBase().remove(annotation);
                return ChangeApplied.SUCCESSFULLY;
            }
            return ChangeApplied.NO_OPERATION;
        }

        public ChangeApplied visit(@Nonnull SetOntologyID change) {
            OWLOntologyID id = change.getNewOntologyID();
            if (OntologyModelImpl.this.getOntologyID().equals(id)) {
                return ChangeApplied.NO_OPERATION;
            }
            OntologyModelImpl.this.setOntologyID(id);
            return ChangeApplied.SUCCESSFULLY;
        }

        protected void beforeChange() {
            if (!OntologyModelImpl.this.getConfig().useContentCache()) {
                throw new ModificationDeniedException("Direct mutations through OWL-API interface are not allowed");
            }
            OntologyModelImpl.this.getBase().forceLoad();
        }

        protected void addImport(OWLImportsDeclaration declaration) {
            Ontology ont = OntologyModelImpl.this.getOWLOntologyManager().getImportedOntology(declaration);
            if (ont == null) {
                OntologyModelImpl.this.getBase().getID().addImport(declaration.getIRI().getIRIString());
                return;
            }
            OntologyModelImpl.this.getBase().addImport(this.getAdapter().asBaseModel(ont).getBase());
        }

        protected void removeImport(OWLImportsDeclaration declaration) {
            Ontology ont = OntologyModelImpl.this.getOWLOntologyManager().getImportedOntology(declaration);
            OntologyModelImpl.this.getBase().getID().removeImport(declaration.getIRI().getIRIString());
            if (ont == null) {
                return;
            }
            OntologyModelImpl.this.getBase().removeImport(this.getAdapter().asBaseModel(ont).getBase());
        }

        @Override
        public OWLAdapter getAdapter() {
            return OWLAdapter.get();
        }
    }
}

