/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.ID;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.Ontology;
import com.github.owlcs.ontapi.RWLockedCollection;
import com.github.owlcs.ontapi.config.OntConfig;
import com.github.owlcs.ontapi.config.OntLoaderConfiguration;
import com.github.owlcs.ontapi.config.OntWriterConfiguration;
import com.github.owlcs.ontapi.jena.model.OntModel;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.jena.graph.Graph;
import org.semanticweb.owlapi.io.FileDocumentSource;
import org.semanticweb.owlapi.io.IRIDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.io.StreamDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyWriterConfiguration;
import org.semanticweb.owlapi.model.OWLStorerFactory;
import org.semanticweb.owlapi.model.OntologyConfigurator;
import org.semanticweb.owlapi.model.parameters.OntologyCopy;

@ParametersAreNonnullByDefault
public interface OntologyManager
extends OWLOntologyManager {
    public DataFactory getOWLDataFactory();

    public OntConfig getOntologyConfigurator();

    public void setOntologyConfigurator(@Nullable OntologyConfigurator var1);

    public OntLoaderConfiguration getOntologyLoaderConfiguration();

    public void setOntologyLoaderConfiguration(@Nullable OWLOntologyLoaderConfiguration var1);

    public OntWriterConfiguration getOntologyWriterConfiguration();

    public void setOntologyWriterConfiguration(@Nullable OWLOntologyWriterConfiguration var1);

    public RWLockedCollection<OWLOntologyFactory> getOntologyFactories();

    @Deprecated
    default public void setOntologyFactories(Set<OWLOntologyFactory> factories) throws OntApiException {
        this.getOntologyFactories().set(factories);
    }

    public RWLockedCollection<OWLOntologyIRIMapper> getIRIMappers();

    @Deprecated
    default public void setIRIMappers(Set<OWLOntologyIRIMapper> mappers) {
        this.getIRIMappers().set(mappers);
    }

    public RWLockedCollection<DocumentSourceMapping> getDocumentSourceMappers();

    public RWLockedCollection<OWLParserFactory> getOntologyParsers();

    @Deprecated
    default public void setOntologyParsers(Set<OWLParserFactory> parsers) {
        this.getOntologyParsers().set(parsers);
    }

    public RWLockedCollection<OWLStorerFactory> getOntologyStorers();

    @Deprecated
    default public void setOntologyStorers(Set<OWLStorerFactory> storers) {
        this.getOntologyStorers().set(storers);
    }

    public Ontology getOntology(IRI var1);

    public Ontology getOntology(OWLOntologyID var1);

    public boolean contains(IRI var1);

    public boolean contains(OWLOntologyID var1);

    @Nullable
    public Ontology getImportedOntology(OWLImportsDeclaration var1);

    public Stream<OWLOntology> ontologies();

    public Ontology createOntology(OWLOntologyID var1);

    public Ontology addOntology(Graph var1, OntLoaderConfiguration var2);

    public Ontology copyOntology(OWLOntology var1, OntologyCopy var2);

    public Ontology loadOntology(IRI var1) throws OWLOntologyCreationException;

    public Ontology loadOntologyFromOntologyDocument(OWLOntologyDocumentSource var1, OWLOntologyLoaderConfiguration var2) throws OWLOntologyCreationException;

    @Nullable
    default public Ontology getImportedOntology(IRI iri) {
        return this.getImportedOntology(this.getOWLDataFactory().getOWLImportsDeclaration(iri));
    }

    @Deprecated
    default public void addIRIMapper(OWLOntologyIRIMapper mapper) {
        this.getIRIMappers().add(mapper);
    }

    @Deprecated
    default public void removeIRIMapper(OWLOntologyIRIMapper mapper) {
        this.getIRIMappers().remove(mapper);
    }

    @Deprecated
    default public void clearIRIMappers() {
        this.getIRIMappers().clear();
    }

    @Deprecated
    default public void addOntologyStorer(OWLStorerFactory storer) {
        this.getOntologyStorers().add(storer);
    }

    @Deprecated
    default public void removeOntologyStorer(OWLStorerFactory storer) {
        this.getOntologyStorers().remove(storer);
    }

    @Deprecated
    default public void clearOntologyStorers() {
        this.getOntologyStorers().clear();
    }

    default public Ontology addOntology(Graph graph) {
        return this.addOntology(graph, this.getOntologyLoaderConfiguration().setPerformTransformation(false));
    }

    default public Ontology createOntology() {
        return this.createOntology(new ID());
    }

    default public Ontology createOntology(@Nullable IRI iri) {
        return this.createOntology(ID.create(iri));
    }

    default public Ontology loadOntologyFromOntologyDocument(OWLOntologyDocumentSource source) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument(source, this.getOntologyLoaderConfiguration());
    }

    default public Ontology loadOntologyFromOntologyDocument(IRI iri) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)new IRIDocumentSource(iri));
    }

    default public Ontology loadOntologyFromOntologyDocument(File file) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)new FileDocumentSource(file));
    }

    default public Ontology loadOntologyFromOntologyDocument(InputStream input) throws OWLOntologyCreationException {
        return this.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)new StreamDocumentSource(input));
    }

    default public OntModel getGraphModel(@Nullable String iri, @Nullable String version) {
        ID id = ID.create(iri, version);
        Ontology res = this.getOntology(id);
        return res == null ? null : res.asGraphModel();
    }

    default public OntModel getGraphModel(@Nullable String iri) {
        return this.getGraphModel(iri, null);
    }

    default public OntModel createGraphModel(@Nullable String iri, @Nullable String version) {
        return this.createOntology(ID.create(iri, version)).asGraphModel();
    }

    default public OntModel createGraphModel(@Nullable String iri) {
        return this.createGraphModel(iri, null);
    }

    default public Stream<OntModel> models() {
        return this.ontologies().map(Ontology.class::cast).map(Ontology::asGraphModel);
    }

    @FunctionalInterface
    public static interface DocumentSourceMapping
    extends Serializable {
        public OWLOntologyDocumentSource map(OWLOntologyID var1);

        default public OWLOntologyDocumentSource map(IRI iri) {
            return this.map(ID.create(iri));
        }
    }
}

