/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.OWLAdapter;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.OntFormat;
import com.github.owlcs.ontapi.Ontology;
import com.github.owlcs.ontapi.OntologyFactory;
import com.github.owlcs.ontapi.OntologyManager;
import com.github.owlcs.ontapi.jena.utils.Models;
import com.github.owlcs.ontapi.transforms.TransformException;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.ErrorHandlerFactory;
import org.apache.jena.shared.PrefixMapping;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;

@ParametersAreNonnullByDefault
public class OntologyFactoryImpl
implements OntologyFactory {
    protected final OntologyFactory.Builder builder;
    protected final OntologyFactory.Loader loader;

    public OntologyFactoryImpl(OntologyFactory.Builder builder, OntologyFactory.Loader loader) {
        this.builder = Objects.requireNonNull(builder, "Null builder");
        this.loader = Objects.requireNonNull(loader, "Null loader");
    }

    @Override
    public OntologyFactory.Builder getBuilder() {
        return this.builder;
    }

    @Override
    public OWLAdapter getAdapter() {
        return OWLAdapter.get();
    }

    @Override
    public OntologyFactory.Loader getLoader() {
        return this.loader;
    }

    @Override
    public void includeOntology(OntologyManager manager, Ontology model) {
        if (model.getOWLOntologyManager() != manager) {
            throw new OntApiException.IllegalState("The specified ontology is attached to another manager: " + model);
        }
        OWLOntologyFactory.OWLOntologyCreationHandler handler = this.getAdapter().asHandler(manager);
        handler.ontologyCreated((OWLOntology)model);
        OWLDocumentFormat format = OntFormat.TURTLE.createOwlFormat();
        Models.setNsPrefixes((PrefixMapping)model.asGraphModel(), format.asPrefixOWLDocumentFormat().getPrefixName2PrefixMap());
        handler.setOntologyFormat((OWLOntology)model, format);
    }

    static {
        ErrorHandlerFactory.setDefaultErrorHandler((ErrorHandler)ErrorHandlerFactory.errorHandlerNoLogging);
    }

    public static class OWLTransformException
    extends OWLOntologyCreationException {
        public OWLTransformException(TransformException cause) {
            super(cause.getMessage(), (Throwable)(cause.getCause() == null ? cause : cause.getCause()));
        }
    }

    public static class BadRecursionException
    extends OWLOntologyCreationException {
        public BadRecursionException(String message) {
            super(message);
        }
    }

    public static class UnsupportedFormatException
    extends OWLOntologyCreationException {
        private OntFormat format;
        private IRI source;

        public UnsupportedFormatException(String message) {
            super(message);
        }

        public UnsupportedFormatException(Throwable cause) {
            super(cause);
        }

        public UnsupportedFormatException putFormat(OntFormat format) {
            this.format = OntApiException.notNull(format, "Null format");
            return this;
        }

        public UnsupportedFormatException putSource(IRI iri) {
            this.source = OntApiException.notNull(iri, "Null source");
            return this;
        }

        public String getMessage() {
            Throwable cause = this.getCause();
            String msg = super.getMessage();
            if (this.format != null && this.source != null && cause != null) {
                String suffix = String.format("Format: %s. IRI: <%s>. Cause: '%s'", new Object[]{this.format, this.source, cause.getMessage()});
                msg = StringUtils.isEmpty((CharSequence)msg) ? suffix : msg + ". " + suffix;
            }
            return msg;
        }
    }

    public static class ConfigMismatchException
    extends OWLOntologyCreationException {
        public ConfigMismatchException(String s) {
            super(s);
        }
    }
}

