/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.ID;
import com.github.owlcs.ontapi.ModelConfig;
import com.github.owlcs.ontapi.NoOpReadWriteLock;
import com.github.owlcs.ontapi.OWLAdapter;
import com.github.owlcs.ontapi.Ontology;
import com.github.owlcs.ontapi.OntologyFactory;
import com.github.owlcs.ontapi.OntologyManager;
import com.github.owlcs.ontapi.OntologyManagerImpl;
import com.github.owlcs.ontapi.OntologyModelImpl;
import com.github.owlcs.ontapi.config.OntLoaderConfiguration;
import com.github.owlcs.ontapi.jena.OntModelFactory;
import com.github.owlcs.ontapi.jena.UnionGraph;
import java.util.concurrent.locks.ReadWriteLock;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.jena.graph.Graph;

@ParametersAreNonnullByDefault
public class OntologyBuilderImpl
implements OntologyFactory.Builder {
    @Override
    public OWLAdapter getAdapter() {
        return OWLAdapter.get();
    }

    @Override
    public Ontology createOntology(ID id, OntologyManager manager, OntLoaderConfiguration config) {
        OntologyManagerImpl m = this.getAdapter().asIMPL(manager);
        OntologyModelImpl res = this.createOntologyImpl(this.createGraph(), m, config);
        res.setOntologyID(id);
        return this.withLock(res, m.getLock());
    }

    @Override
    public Ontology createOntology(Graph graph, OntologyManager manager, OntLoaderConfiguration config) {
        OntologyManagerImpl m = this.getAdapter().asIMPL(manager);
        return this.withLock(this.createOntologyImpl(graph, m, config), m.getLock());
    }

    public OntologyModelImpl createOntologyImpl(Graph graph, OntologyManagerImpl manager, OntLoaderConfiguration config) {
        return new OntologyModelImpl((Graph)this.wrap(graph, config), this.createModelConfig(manager, config));
    }

    protected ModelConfig createModelConfig(OntologyManagerImpl manager, OntLoaderConfiguration config) {
        ModelConfig res = manager.createModelConfig();
        res.setLoaderConf(config);
        return res;
    }

    protected Ontology withLock(OntologyModelImpl ont, ReadWriteLock lock) {
        if (!NoOpReadWriteLock.isConcurrent(lock)) {
            return ont;
        }
        return new OntologyModelImpl.Concurrent(ont, lock);
    }

    @Override
    public Graph createGraph() {
        return OntModelFactory.createDefaultGraph();
    }

    public UnionGraph wrap(Graph g, OntLoaderConfiguration config) {
        return g instanceof UnionGraph ? (UnionGraph)g : this.createUnionGraph(g, config);
    }
}

