/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.DataFactoryImpl;
import com.github.owlcs.ontapi.NoOpReadWriteLock;
import com.github.owlcs.ontapi.OWLFactoryWrapper;
import com.github.owlcs.ontapi.OWLLangRegistry;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.OntologyBuilderImpl;
import com.github.owlcs.ontapi.OntologyFactory;
import com.github.owlcs.ontapi.OntologyLoaderImpl;
import com.github.owlcs.ontapi.OntologyManager;
import com.github.owlcs.ontapi.OntologyManagerImpl;
import com.github.owlcs.ontapi.ReflectionUtils;
import com.github.owlcs.ontapi.jena.OntModelFactory;
import com.google.common.collect.LinkedListMultimap;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyBuilder;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyManagerFactory;

public class OntManagers
implements OWLOntologyManagerFactory {
    public static final ONTAPIProfile DEFAULT_PROFILE;
    private static OWLOntologyManagerFactory managerFactory;

    public static DataFactory getDataFactory() {
        return DEFAULT_PROFILE.dataFactory();
    }

    public static OntologyManager createONT() {
        return DEFAULT_PROFILE.create(false);
    }

    public static OntologyManager createConcurrentONT() {
        return DEFAULT_PROFILE.create(true);
    }

    public static OWLOntologyManager createOWL() throws OntApiException {
        return OntManagers.createOWLProfile().create(false);
    }

    public static OWLOntologyManager createConcurrentOWL() throws OntApiException {
        return OntManagers.createOWLProfile().create(true);
    }

    public static OWLOntologyManagerFactory getFactory() {
        return managerFactory;
    }

    public static void setFactory(OWLOntologyManagerFactory p) {
        managerFactory = OntApiException.notNull(p, "Null manager profile specified.");
    }

    public OWLOntologyManager get() {
        return managerFactory.get();
    }

    public static Profile createOWLProfile() throws OntApiException {
        return new OWLAPIImplProfile();
    }

    static {
        OntModelFactory.init();
        DEFAULT_PROFILE = new ONTAPIProfile();
        managerFactory = (OWLOntologyManagerFactory & Serializable)() -> DEFAULT_PROFILE.create(false);
    }

    public static class OWLAPIImplProfile
    implements Profile {
        private final Class<OWLOntologyManager> managerClass = ReflectionUtils.getClass(OWLOntologyManager.class, "uk.ac.manchester.cs.owl.owlapi.OWLOntologyManagerImpl");

        public OWLOntologyBuilder createOWLOntologyBuilder(ReadWriteLock lock) throws OntApiException {
            OWLOntologyBuilder res = ReflectionUtils.newInstance(OWLOntologyBuilder.class, "uk.ac.manchester.cs.owl.owlapi.concurrent.NonConcurrentOWLOntologyBuilder", LinkedListMultimap.create());
            if (!NoOpReadWriteLock.isConcurrent(lock)) {
                return res;
            }
            LinkedListMultimap concurrentParams = LinkedListMultimap.create();
            concurrentParams.put(OWLOntologyBuilder.class, (Object)res);
            concurrentParams.put(ReadWriteLock.class, (Object)lock);
            return ReflectionUtils.newInstance(OWLOntologyBuilder.class, "uk.ac.manchester.cs.owl.owlapi.concurrent.ConcurrentOWLOntologyBuilder", concurrentParams);
        }

        public OWLOntology createOWLOntologyImpl(OWLOntologyManager manager, OWLOntologyID id) {
            LinkedListMultimap params = LinkedListMultimap.create();
            params.put(OWLOntologyManager.class, (Object)manager);
            params.put(OWLOntologyID.class, (Object)id);
            return ReflectionUtils.newInstance(OWLOntology.class, "uk.ac.manchester.cs.owl.owlapi.OWLOntologyImpl", params);
        }

        @Override
        public OWLOntologyManager create(boolean concurrent) {
            ReadWriteLock lock = concurrent ? new ReentrantReadWriteLock() : NoOpReadWriteLock.NO_OP_RW_LOCK;
            OWLDataFactory dataFactory = this.createDataFactory();
            OWLOntologyFactory loadFactory = this.createOntologyFactory(this.createOWLOntologyBuilder(lock));
            OWLOntologyManager res = this.createManager(dataFactory, lock);
            Set storers = OWLLangRegistry.storerFactories().collect(Collectors.toSet());
            Set parsers = OWLLangRegistry.parserFactories().collect(Collectors.toSet());
            res.getOntologyStorers().set(storers);
            res.getOntologyParsers().set(parsers);
            res.getOntologyFactories().add((Serializable)loadFactory);
            return res;
        }

        public OWLOntologyManager createManager(OWLDataFactory dataFactory, ReadWriteLock lock) {
            Constructor<OWLOntologyManager> constructor;
            try {
                constructor = this.managerClass.getConstructor(OWLDataFactory.class, ReadWriteLock.class);
            }
            catch (NoSuchMethodException e) {
                throw new OntApiException(this.managerClass.getName() + ": can't find constructor", e);
            }
            try {
                return constructor.newInstance(dataFactory, lock);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new OntApiException(this.managerClass.getName() + ": can't create new instance", e);
            }
        }

        @Override
        public OWLDataFactory dataFactory() {
            return this.createDataFactory();
        }

        public OWLDataFactory createDataFactory() {
            return ReflectionUtils.newInstance(OWLDataFactory.class, "uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl", LinkedListMultimap.create());
        }

        public OWLOntologyFactory createOntologyFactory(OWLOntologyBuilder builder) {
            LinkedListMultimap params = LinkedListMultimap.create();
            params.put(OWLOntologyBuilder.class, (Object)builder);
            return ReflectionUtils.newInstance(OWLOntologyFactory.class, "uk.ac.manchester.cs.owl.owlapi.OWLOntologyFactoryImpl", params);
        }
    }

    public static class ONTAPIProfile
    implements Profile {
        public static final DataFactory DEFAULT_DATA_FACTORY = new DataFactoryImpl();

        @Override
        public OntologyManager create(boolean concurrent) {
            ReadWriteLock lock = concurrent ? new ReentrantReadWriteLock() : NoOpReadWriteLock.NO_OP_RW_LOCK;
            Set storers = OWLLangRegistry.storerFactories().collect(Collectors.toSet());
            Set parsers = OWLLangRegistry.parserFactories().collect(Collectors.toSet());
            OntologyManager res = this.createManager(this.dataFactory(), lock);
            res.getOntologyStorers().set(storers);
            res.getOntologyParsers().set(parsers);
            return res;
        }

        public OntologyManager createManager(DataFactory dataFactory, ReadWriteLock lock) {
            return this.createManager(dataFactory, this.createOntologyFactory(), lock);
        }

        public OntologyManager createManager(DataFactory dataFactory, OntologyFactory factory, ReadWriteLock lock) {
            return new OntologyManagerImpl(dataFactory, factory, lock);
        }

        @Override
        public DataFactory dataFactory() {
            return DEFAULT_DATA_FACTORY;
        }

        public OntologyFactory.Builder createOntologyBuilder() {
            return new OntologyBuilderImpl();
        }

        public OntologyFactory.Loader createOntologyLoader() {
            return new OntologyLoaderImpl(new OWLFactoryWrapper());
        }

        public OntologyFactory createOntologyFactory() {
            return this.createOntologyFactory(this.createOntologyBuilder());
        }

        public OntologyFactory createOntologyFactory(OntologyFactory.Builder builder) {
            return this.createOntologyFactory(builder, this.createOntologyLoader());
        }

        public OntologyFactory createOntologyFactory(OntologyFactory.Builder builder, OntologyFactory.Loader loader) {
            return loader.asOntologyFactory(builder);
        }
    }

    public static interface Profile {
        public OWLOntologyManager create(boolean var1);

        public OWLDataFactory dataFactory();
    }
}

