/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.OntFormat;
import com.github.owlcs.ontapi.OntGraphUtils;
import com.github.owlcs.ontapi.jena.utils.Graphs;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.PrefixMapping;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.PrefixManager;

public abstract class OntGraphDocumentSource
implements OWLOntologyDocumentSource {
    protected AtomicReference<Exception> exception = new AtomicReference();

    public abstract Graph getGraph();

    public boolean withTransforms() {
        return true;
    }

    public IRI getDocumentIRI() {
        return IRI.create((String)("graph:" + OntGraphUtils.toString(this.getGraph())));
    }

    public Optional<Reader> getReader() {
        return this.getInputStream().map(is -> new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
    }

    public Optional<InputStream> getInputStream() {
        return this.format().map(OntFormat::getLang).map(lang -> OntGraphDocumentSource.toInputStream(this.getGraph(), lang, this.exception));
    }

    protected static InputStream toInputStream(final Graph graph, final Lang lang, final AtomicReference<Exception> error) {
        Objects.requireNonNull(graph);
        Objects.requireNonNull(lang);
        Objects.requireNonNull(error);
        PipedInputStream in = new PipedInputStream();
        CountDownLatch complete = new CountDownLatch(1);
        FilterInputStream res = new FilterInputStream(in){
            private volatile boolean closed;

            @Override
            public void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                try {
                    super.close();
                }
                catch (IOException e) {
                    IOException x = OntGraphDocumentSource.findIOException((Exception)error.get(), graph, lang);
                    if (x == null) {
                        error.set(e);
                    }
                    x.addSuppressed(e);
                }
                IOException ex = OntGraphDocumentSource.findIOException((Exception)error.get(), graph, lang);
                if (ex != null) {
                    throw ex;
                }
            }
        };
        new Thread(() -> {
            PipedOutputStream out;
            try {
                out = new PipedOutputStream(in);
            }
            catch (IOException e) {
                error.set(e);
                return;
            }
            finally {
                complete.countDown();
            }
            try {
                RDFDataMgr.write((OutputStream)out, (Graph)graph, (Lang)lang);
            }
            catch (Exception ex) {
                error.set(ex);
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException e) {
                    Exception x = (Exception)error.get();
                    if (x == null) {
                        error.set(e);
                    }
                    x.addSuppressed(e);
                }
            }
        }).start();
        try {
            complete.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return res;
    }

    private static IOException findIOException(Exception from, Graph graph, Lang lang) {
        String name;
        if (from == null) {
            return null;
        }
        if (from instanceof IOException) {
            return (IOException)from;
        }
        try {
            name = Graphs.getName(graph);
        }
        catch (Exception e) {
            name = "{unknown: '" + e.getMessage() + "'}";
        }
        return new IOException(String.format("Convert output->input. Graph: %s, %s.", name, lang), from);
    }

    public Optional<OWLDocumentFormat> getFormat() {
        PrefixMapping pm = this.getGraph().getPrefixMapping();
        return this.format().map(OntFormat::createOwlFormat).map(f -> {
            if (f.isPrefixOWLDocumentFormat()) {
                PrefixDocumentFormat res = f.asPrefixOWLDocumentFormat();
                pm.getNsPrefixMap().forEach((arg_0, arg_1) -> ((PrefixManager)res).setPrefix(arg_0, arg_1));
            }
            return f;
        });
    }

    public OntFormat getOntFormat() {
        return OntFormat.TURTLE;
    }

    private Optional<OntFormat> format() {
        return Optional.of(this.getOntFormat());
    }

    public Optional<String> getMIMEType() {
        return this.format().map(OntFormat::getLang).map(Lang::getContentType).map(ContentType::getContentType);
    }

    public boolean hasAlredyFailedOnStreams() {
        return this.exception.get() != null;
    }

    public boolean hasAlredyFailedOnIRIResolution() {
        return false;
    }

    public void setIRIResolutionFailed(boolean value) {
        throw new OntApiException.Unsupported("#setIRIResolutionFailed is not supported.");
    }

    public static OntGraphDocumentSource wrap(final Graph graph) {
        Objects.requireNonNull(graph, "Null graph");
        return new OntGraphDocumentSource(){

            @Override
            public Graph getGraph() {
                return graph;
            }
        };
    }
}

