/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.BaseModel;
import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.ID;
import com.github.owlcs.ontapi.ModelConfig;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.OntFormat;
import com.github.owlcs.ontapi.Ontology;
import com.github.owlcs.ontapi.OntologyManager;
import com.github.owlcs.ontapi.internal.InternalModel;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.owlapi.OWLObjectImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.jena.graph.Graph;
import org.apache.jena.mem.GraphMem;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasImportsClosure;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationObject;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomCollection;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNaryAxiom;
import org.semanticweb.owlapi.model.OWLNaryClassAxiom;
import org.semanticweb.owlapi.model.OWLNaryIndividualAxiom;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLUnaryPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.search.Filters;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;
import org.semanticweb.owlapi.util.OWLClassExpressionCollector;

@ParametersAreNonnullByDefault
public abstract class OntBaseModelImpl
implements OWLOntology,
BaseModel {
    public static final OntFormat DEFAULT_SERIALIZATION_FORMAT = OntFormat.RDF_THRIFT;
    private static final long serialVersionUID = 7605836729147058594L;
    protected transient InternalModel base;
    protected transient ModelConfig config;
    protected int hashCode;

    protected OntBaseModelImpl(Graph graph, ModelConfig conf) {
        this.config = Objects.requireNonNull(conf);
        this.base = conf.createInternalModel(Objects.requireNonNull(graph));
    }

    @Override
    public InternalModel getBase() {
        return this.base;
    }

    @Override
    public void setBase(InternalModel m) {
        this.base = Objects.requireNonNull(m);
    }

    @Override
    public ModelConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(ModelConfig conf) {
        this.config = Objects.requireNonNull(conf);
    }

    public OntologyManager getOWLOntologyManager() {
        return this.getConfig().getManager();
    }

    public DataFactory getDataFactory() {
        return this.getOWLOntologyManager().getOWLDataFactory();
    }

    public void setOWLOntologyManager(@Nullable OWLOntologyManager manager) {
        throw new OntApiException.Unsupported("Misuse: attempt to set new manager: " + manager);
    }

    public ID getOntologyID() {
        return this.base.getOntologyID();
    }

    protected void setOntologyID(OWLOntologyID id) {
        this.base.setOntologyID(id);
        this.hashCode = 0;
    }

    public boolean isAnonymous() {
        return this.base.getID().isAnon();
    }

    public boolean isEmpty() {
        return this.base.isOntologyEmpty();
    }

    public Stream<OWLAnnotation> annotations() {
        return this.base.listOWLAnnotations();
    }

    public Stream<OWLOntology> imports() {
        return this.getOWLOntologyManager().imports(this);
    }

    public Stream<OWLImportsDeclaration> importsDeclarations() {
        return this.base.listOWLImportDeclarations();
    }

    public Stream<IRI> directImportsDocuments() {
        return this.importsDeclarations().map(OWLImportsDeclaration::getIRI);
    }

    public Stream<OWLOntology> directImports() {
        return this.getOWLOntologyManager().directImports(this);
    }

    public Stream<OWLOntology> importsClosure() {
        return this.getOWLOntologyManager().importsClosure(this);
    }

    public Stream<OWLClass> classesInSignature() {
        return this.base.listOWLClasses();
    }

    public Stream<OWLClassExpression> nestedClassExpressions() {
        return ((Collection)this.accept((OWLObjectVisitorEx)new OWLClassExpressionCollector())).stream();
    }

    public Stream<OWLAnonymousIndividual> anonymousIndividuals() {
        return this.base.listOWLAnonymousIndividuals();
    }

    public Stream<OWLAnonymousIndividual> referencedAnonymousIndividuals() {
        return this.anonymousIndividuals();
    }

    public Stream<OWLNamedIndividual> individualsInSignature() {
        return this.base.listOWLNamedIndividuals();
    }

    public Stream<OWLDataProperty> dataPropertiesInSignature() {
        return this.base.listOWLDataProperties();
    }

    public Stream<OWLObjectProperty> objectPropertiesInSignature() {
        return this.base.listOWLObjectProperties();
    }

    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature() {
        return this.base.listOWLAnnotationProperties();
    }

    public Stream<OWLDatatype> datatypesInSignature() {
        return this.base.listOWLDatatypes();
    }

    public Stream<OWLEntity> signature() {
        return Stream.of(this.classesInSignature(), this.objectPropertiesInSignature(), this.dataPropertiesInSignature(), this.individualsInSignature(), this.datatypesInSignature(), this.annotationPropertiesInSignature()).flatMap(Function.identity());
    }

    public Stream<OWLEntity> entitiesInSignature(@Nullable IRI iri) {
        return this.base.listOWLEntities(iri);
    }

    public Set<IRI> getPunnedIRIs(Imports imports) {
        return this.base.ambiguousEntities(Imports.INCLUDED == imports).map(Resource::getURI).map(IRI::create).collect(Collectors.toSet());
    }

    public boolean isDeclared(OWLEntity entity) {
        return this.base.containsOWLDeclaration(entity);
    }

    public boolean containsReference(OWLEntity entity) {
        return this.referencingAxioms((OWLPrimitive)entity).findFirst().isPresent();
    }

    public boolean containsClassInSignature(IRI iri) {
        return this.base.containsOWLEntity(this.getDataFactory().getOWLClass(iri));
    }

    public boolean containsObjectPropertyInSignature(IRI iri) {
        return this.base.containsOWLEntity(this.getDataFactory().getOWLObjectProperty(iri));
    }

    public boolean containsDataPropertyInSignature(IRI iri) {
        return this.base.containsOWLEntity(this.getDataFactory().getOWLDataProperty(iri));
    }

    public boolean containsAnnotationPropertyInSignature(IRI iri) {
        return this.base.containsOWLEntity(this.getDataFactory().getOWLAnnotationProperty(iri));
    }

    public boolean containsDatatypeInSignature(IRI iri) {
        return this.base.containsOWLEntity(this.getDataFactory().getOWLDatatype(iri));
    }

    public boolean containsIndividualInSignature(IRI iri) {
        return this.base.containsOWLEntity(this.getDataFactory().getOWLNamedIndividual(iri));
    }

    public boolean containsEntityInSignature(IRI iri) {
        return this.containsClassInSignature(iri) || this.containsObjectPropertyInSignature(iri) || this.containsDataPropertyInSignature(iri) || this.containsIndividualInSignature(iri) || this.containsDatatypeInSignature(iri) || this.containsAnnotationPropertyInSignature(iri);
    }

    public boolean containsEntityInSignature(OWLEntity entity) {
        if (entity.isOWLClass()) {
            return this.containsClassInSignature(entity.getIRI());
        }
        if (entity.isOWLDatatype()) {
            return this.containsDatatypeInSignature(entity.getIRI());
        }
        if (entity.isOWLNamedIndividual()) {
            return this.containsIndividualInSignature(entity.getIRI());
        }
        if (entity.isOWLAnnotationProperty()) {
            return this.containsAnnotationPropertyInSignature(entity.getIRI());
        }
        if (entity.isOWLObjectProperty()) {
            return this.containsObjectPropertyInSignature(entity.getIRI());
        }
        if (entity.isOWLDataProperty()) {
            return this.containsDataPropertyInSignature(entity.getIRI());
        }
        throw new OntApiException.IllegalArgument("Unsupported entity: " + entity);
    }

    public boolean containsEntitiesOfTypeInSignature(EntityType<?> type) {
        if (EntityType.CLASS.equals(type)) {
            return this.classesInSignature().findFirst().isPresent();
        }
        if (EntityType.DATA_PROPERTY.equals(type)) {
            return this.dataPropertiesInSignature().findFirst().isPresent();
        }
        if (EntityType.OBJECT_PROPERTY.equals(type)) {
            return this.objectPropertiesInSignature().findFirst().isPresent();
        }
        if (EntityType.ANNOTATION_PROPERTY.equals(type)) {
            return this.annotationPropertiesInSignature().findFirst().isPresent();
        }
        if (EntityType.DATATYPE.equals(type)) {
            return this.datatypesInSignature().findFirst().isPresent();
        }
        if (EntityType.NAMED_INDIVIDUAL.equals(type)) {
            return this.individualsInSignature().findFirst().isPresent();
        }
        throw new IllegalArgumentException("Entity type " + type + " is not valid for entity presence check");
    }

    public Stream<OWLAxiom> axioms() {
        return this.base.listOWLAxioms();
    }

    public <T extends OWLAxiom> Stream<T> axioms(AxiomType<T> axiomType) {
        return this.base.listOWLAxioms(axiomType);
    }

    public Stream<OWLClassAxiom> axioms(OWLClass clazz) {
        Stream<OWLSubClassOfAxiom> subClassOf = this.base.listOWLSubClassOfAxioms(clazz);
        Stream<OWLDisjointUnionAxiom> disjointUnion = this.base.listOWLAxioms(OWLDisjointUnionAxiom.class).filter(a -> Objects.equals(a.getOWLClass(), clazz));
        Stream<OWLDisjointClassesAxiom> disjoint = this.base.listOWLAxioms(OWLDisjointClassesAxiom.class).filter(a -> a.operands().anyMatch(clazz::equals));
        Stream<OWLEquivalentClassesAxiom> equivalent = this.base.listOWLEquivalentClassesAxioms(clazz);
        return Stream.of(subClassOf, disjointUnion, disjoint, equivalent).flatMap(Function.identity());
    }

    public Stream<OWLObjectPropertyAxiom> axioms(OWLObjectPropertyExpression property) {
        Stream<OWLSubObjectPropertyOfAxiom> subPropertyOf = this.base.listOWLAxioms(OWLSubObjectPropertyOfAxiom.class).filter(a -> Objects.equals(a.getSubProperty(), property));
        Stream<OWLObjectPropertyAxiom> nary = Stream.of(OWLEquivalentObjectPropertiesAxiom.class, OWLDisjointObjectPropertiesAxiom.class, OWLInverseObjectPropertiesAxiom.class).flatMap(c -> this.base.listOWLAxioms(c)).map(arg_0 -> OntBaseModelImpl.lambda$axioms$4(OWLNaryPropertyAxiom.class, arg_0)).filter(a -> a.operands().anyMatch(o -> Objects.equals(o, property))).map(OWLObjectPropertyAxiom.class::cast);
        Stream<OWLObjectPropertyAxiom> unary = Stream.of(OWLObjectPropertyDomainAxiom.class, OWLObjectPropertyRangeAxiom.class, OWLTransitiveObjectPropertyAxiom.class, OWLIrreflexiveObjectPropertyAxiom.class, OWLReflexiveObjectPropertyAxiom.class, OWLSymmetricObjectPropertyAxiom.class, OWLFunctionalObjectPropertyAxiom.class, OWLInverseFunctionalObjectPropertyAxiom.class, OWLAsymmetricObjectPropertyAxiom.class).flatMap(c -> this.base.listOWLAxioms(c)).map(arg_0 -> OntBaseModelImpl.lambda$axioms$8(OWLUnaryPropertyAxiom.class, arg_0)).filter(a -> Objects.equals(a.getProperty(), property)).map(OWLObjectPropertyAxiom.class::cast);
        return Stream.of(subPropertyOf, nary, unary).flatMap(Function.identity());
    }

    public Stream<OWLDataPropertyAxiom> axioms(OWLDataProperty property) {
        Stream<OWLSubDataPropertyOfAxiom> subPropertyOf = this.base.listOWLAxioms(OWLSubDataPropertyOfAxiom.class).filter(a -> Objects.equals(a.getSubProperty(), property));
        Stream<OWLDataPropertyAxiom> nary = Stream.of(OWLEquivalentDataPropertiesAxiom.class, OWLDisjointDataPropertiesAxiom.class, OWLInverseObjectPropertiesAxiom.class).flatMap(c -> this.base.listOWLAxioms(c)).map(OWLNaryPropertyAxiom.class::cast).filter(a -> a.operands().anyMatch(o -> Objects.equals(o, property))).map(OWLDataPropertyAxiom.class::cast);
        Stream<OWLDataPropertyAxiom> unary = Stream.of(OWLDataPropertyDomainAxiom.class, OWLDataPropertyRangeAxiom.class, OWLFunctionalDataPropertyAxiom.class).flatMap(c -> this.base.listOWLAxioms(c)).map(arg_0 -> OntBaseModelImpl.lambda$axioms$15(OWLUnaryPropertyAxiom.class, arg_0)).filter(a -> Objects.equals(a.getProperty(), property)).map(OWLDataPropertyAxiom.class::cast);
        return Stream.of(subPropertyOf, nary, unary).flatMap(Function.identity());
    }

    public Stream<OWLAnnotationAxiom> axioms(OWLAnnotationProperty property) {
        return Stream.of(this.axioms(AxiomType.SUB_ANNOTATION_PROPERTY_OF).filter(a -> a.getSubProperty().equals(property)), this.axioms(AxiomType.ANNOTATION_PROPERTY_RANGE).filter(a -> ((OWLAnnotationProperty)a.getProperty()).equals(property)), this.axioms(AxiomType.ANNOTATION_PROPERTY_DOMAIN).filter(a -> ((OWLAnnotationProperty)a.getProperty()).equals(property))).flatMap(Function.identity());
    }

    public Stream<OWLIndividualAxiom> axioms(OWLIndividual individual) {
        Stream<OWLClassAssertionAxiom> classAssertion = this.base.listOWLAxioms(OWLClassAssertionAxiom.class).filter(a -> Objects.equals(a.getIndividual(), individual));
        Stream<OWLNaryIndividualAxiom> nary = Stream.of(OWLSameIndividualAxiom.class, OWLDifferentIndividualsAxiom.class).flatMap(c -> this.base.listOWLAxioms(c)).map(OWLNaryIndividualAxiom.class::cast).filter(a -> a.operands().anyMatch(o -> Objects.equals(o, individual)));
        Stream<OWLPropertyAssertionAxiom> propertyAssertion = Stream.of(OWLObjectPropertyAssertionAxiom.class, OWLDataPropertyAssertionAxiom.class, OWLNegativeObjectPropertyAssertionAxiom.class, OWLNegativeDataPropertyAssertionAxiom.class).flatMap(c -> this.base.listOWLAxioms(c)).map(OWLPropertyAssertionAxiom.class::cast).filter(a -> Objects.equals(a.getSubject(), individual));
        return Stream.of(classAssertion, nary, propertyAssertion).flatMap(Function.identity());
    }

    public Stream<OWLDatatypeDefinitionAxiom> axioms(OWLDatatype datatype) {
        return this.base.listOWLAxioms(OWLDatatypeDefinitionAxiom.class).filter(a -> datatype.equals(a.getDatatype()));
    }

    public <A extends OWLAxiom> Stream<A> axioms(OWLAxiomSearchFilter filter, Object key) {
        return this.base.listOWLAxioms(filter.getAxiomTypes()).filter(a -> filter.pass(a, key)).map(x -> x);
    }

    public <A extends OWLAxiom> Stream<A> axioms(Class<A> type, @Nullable Class<? extends OWLObject> view, OWLObject object, @Nullable Navigation position) {
        return this.axioms(type, object, Navigation.IN_SUB_POSITION == position);
    }

    public <A extends OWLAxiom> Stream<A> axioms(Class<A> type, OWLObject object, boolean sub) {
        if (sub && OWLDeclarationAxiom.class.equals(type) && object instanceof OWLEntity) {
            return this.base.listOWLDeclarationAxioms((OWLEntity)object);
        }
        if (OWLSubObjectPropertyOfAxiom.class.equals(type) && object instanceof OWLObjectPropertyExpression) {
            return this.base.listOWLAxioms(OWLSubObjectPropertyOfAxiom.class).filter(a -> object.equals(sub ? a.getSubProperty() : a.getSuperProperty()));
        }
        if (OWLSubDataPropertyOfAxiom.class.equals(type) && object instanceof OWLDataPropertyExpression) {
            return this.base.listOWLAxioms(OWLSubDataPropertyOfAxiom.class).filter(a -> object.equals(sub ? a.getSubProperty() : a.getSuperProperty()));
        }
        if (OWLSubAnnotationPropertyOfAxiom.class.equals(type) && object instanceof OWLAnnotationProperty) {
            return this.base.listOWLAxioms(OWLSubAnnotationPropertyOfAxiom.class).filter(a -> object.equals(sub ? a.getSubProperty() : a.getSuperProperty()));
        }
        if (OWLSubClassOfAxiom.class.equals(type) && object instanceof OWLClassExpression) {
            OWLClassExpression c = (OWLClassExpression)object;
            if (c.isOWLClass() && sub) {
                return this.base.listOWLSubClassOfAxioms(c.asOWLClass());
            }
            return this.base.listOWLAxioms(OWLSubClassOfAxiom.class).filter(a -> c.equals(sub ? a.getSubClass() : a.getSuperClass()));
        }
        if (OWLEquivalentClassesAxiom.class.equals(type) && sub && object instanceof OWLClassExpression) {
            OWLClassExpression c = (OWLClassExpression)object;
            if (c.isOWLClass()) {
                return this.base.listOWLEquivalentClassesAxioms(c.asOWLClass());
            }
            return this.base.listOWLAxioms(OWLEquivalentClassesAxiom.class).filter(a -> a.contains(c));
        }
        if (OWLInverseObjectPropertiesAxiom.class.equals(type) && object instanceof OWLObjectPropertyExpression) {
            return this.base.listOWLAxioms(OWLInverseObjectPropertiesAxiom.class).filter(a -> object.equals(sub ? a.getFirstProperty() : a.getSecondProperty()));
        }
        if (OWLObjectPropertyAssertionAxiom.class.equals(type) && object instanceof OWLIndividual) {
            return this.base.listOWLAxioms(OWLObjectPropertyAssertionAxiom.class).filter(a -> object.equals(sub ? a.getSubject() : a.getObject()));
        }
        if (OWLNegativeObjectPropertyAssertionAxiom.class.equals(type) && object instanceof OWLIndividual) {
            return this.base.listOWLAxioms(OWLNegativeObjectPropertyAssertionAxiom.class).filter(a -> object.equals(sub ? a.getSubject() : a.getObject()));
        }
        if (OWLAnnotationAssertionAxiom.class.equals(type)) {
            if (!sub && object instanceof OWLAnnotationObject) {
                return this.base.listOWLAxioms(OWLAnnotationAssertionAxiom.class).filter(a -> object.equals(a.getValue()));
            }
            if (sub && object instanceof OWLAnnotationSubject) {
                return this.base.listOWLAnnotationAssertionAxioms((OWLAnnotationSubject)object);
            }
        }
        if (OWLDisjointUnionAxiom.class.equals(type) && object instanceof OWLClassExpression) {
            return this.base.listOWLAxioms(OWLDisjointUnionAxiom.class).filter(a -> sub ? object.equals(a.getOWLClass()) : a.classExpressions().anyMatch(object::equals));
        }
        if (OWLSubPropertyChainOfAxiom.class.equals(type) && object instanceof OWLObjectPropertyExpression) {
            return this.base.listOWLAxioms(OWLSubPropertyChainOfAxiom.class).filter(a -> sub ? object.equals(a.getSuperProperty()) : a.getPropertyChain().stream().anyMatch(object::equals));
        }
        if (OWLClassAxiom.class.equals(type) && object instanceof OWLClass) {
            return this.axioms((OWLClass)object);
        }
        if (OWLObjectPropertyAxiom.class.equals(type) && object instanceof OWLObjectPropertyExpression) {
            return this.axioms((OWLObjectPropertyExpression)object);
        }
        if (OWLDataPropertyAxiom.class.equals(type) && object instanceof OWLDataProperty) {
            return this.axioms((OWLDataProperty)object);
        }
        if (OWLIndividualAxiom.class.equals(type) && object instanceof OWLIndividual) {
            return this.axioms((OWLIndividual)object);
        }
        if (OWLNaryAxiom.class.isAssignableFrom(type)) {
            return this.base.listOWLAxioms(type).filter(a -> ((OWLNaryAxiom)a).operands().anyMatch(o -> Objects.equals(o, object)));
        }
        return this.base.listOWLAxioms(type, object);
    }

    public Stream<OWLAxiom> tboxAxioms(Imports imports) {
        return AxiomType.TBoxAxiomTypes.stream().flatMap(t -> this.axioms((AxiomType)t, imports));
    }

    public Stream<OWLAxiom> aboxAxioms(Imports imports) {
        return AxiomType.ABoxAxiomTypes.stream().flatMap(t -> this.axioms((AxiomType)t, imports));
    }

    public Stream<OWLAxiom> rboxAxioms(Imports imports) {
        return AxiomType.RBoxAxiomTypes.stream().flatMap(t -> this.axioms((AxiomType)t, imports));
    }

    public Stream<OWLLogicalAxiom> logicalAxioms() {
        return this.base.listOWLLogicalAxioms();
    }

    public Stream<OWLClassAxiom> generalClassAxioms() {
        Stream<OWLSubClassOfAxiom> subClassOfAxioms = this.base.listOWLAxioms(OWLSubClassOfAxiom.class).filter(a -> a.getSubClass().isAnonymous());
        Stream<OWLNaryClassAxiom> naryClassAxioms = Stream.of(OWLEquivalentClassesAxiom.class, OWLDisjointClassesAxiom.class).flatMap(this.base::listOWLAxioms).filter(a -> a.classExpressions().allMatch(IsAnonymous::isAnonymous));
        return Stream.concat(subClassOfAxioms, naryClassAxioms);
    }

    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom axiom) {
        return this.axioms(axiom.getAxiomType()).map(OWLAxiom.class::cast).filter(ax -> ax.equalsIgnoreAnnotations(axiom));
    }

    public Stream<OWLAxiom> referencingAxioms(OWLPrimitive primitive) {
        return this.base.listOWLAxioms(primitive);
    }

    public Stream<OWLSubAnnotationPropertyOfAxiom> subAnnotationPropertyOfAxioms(OWLAnnotationProperty property) {
        return this.axioms(Filters.subAnnotationWithSub, property);
    }

    public Stream<OWLAnnotationPropertyDomainAxiom> annotationPropertyDomainAxioms(OWLAnnotationProperty property) {
        return this.axioms(Filters.apDomainFilter, property);
    }

    public Stream<OWLAnnotationPropertyRangeAxiom> annotationPropertyRangeAxioms(OWLAnnotationProperty property) {
        return this.axioms(Filters.apRangeFilter, property);
    }

    public Stream<OWLDatatypeDefinitionAxiom> datatypeDefinitions(OWLDatatype datatype) {
        return this.axioms(Filters.datatypeDefFilter, datatype);
    }

    public int getAxiomCount() {
        return (int)this.base.getOWLAxiomCount();
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        return (int)this.axioms(axiomType).count();
    }

    public int getLogicalAxiomCount() {
        return (int)this.logicalAxioms().count();
    }

    public boolean containsAxiom(OWLAxiom axiom) {
        return this.base.contains(axiom);
    }

    public boolean containsAxiomIgnoreAnnotations(OWLAxiom axiom) {
        return this.containsAxiom(axiom) || this.axioms(axiom.getAxiomType()).anyMatch(ax -> ax.equalsIgnoreAnnotations(axiom));
    }

    public boolean contains(OWLAxiomSearchFilter filter, Object key) {
        return this.base.listOWLAxioms(filter.getAxiomTypes()).anyMatch(a -> filter.pass(a, key));
    }

    public boolean containsClassInSignature(IRI iri, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsClassInSignature(iri));
    }

    public boolean containsObjectPropertyInSignature(IRI iri, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsObjectPropertyInSignature(iri));
    }

    public boolean containsDataPropertyInSignature(IRI iri, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsDataPropertyInSignature(iri));
    }

    public boolean containsAnnotationPropertyInSignature(IRI iri, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsAnnotationPropertyInSignature(iri));
    }

    public boolean containsDatatypeInSignature(IRI iri, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsDatatypeInSignature(iri));
    }

    public boolean containsIndividualInSignature(IRI iri, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsIndividualInSignature(iri));
    }

    public boolean containsAxiom(OWLAxiom axiom, Imports imports, AxiomAnnotations ignoreAnnotations) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> ignoreAnnotations.contains(o, axiom));
    }

    public boolean contains(OWLAxiomSearchFilter filter, Object key, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.contains(filter, key));
    }

    public <T extends OWLAxiom> Stream<T> axioms(OWLAxiomSearchFilter filter, Object key, Imports imports) {
        if (Imports.EXCLUDED == imports) {
            return this.axioms(filter, key);
        }
        return imports.stream((HasImportsClosure)this).flatMap(o -> o.axioms(filter, key));
    }

    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom axiom, Imports imports) {
        if (Imports.EXCLUDED == imports) {
            return this.axiomsIgnoreAnnotations(axiom);
        }
        return imports.stream((HasImportsClosure)this).flatMap(o -> o.axiomsIgnoreAnnotations(axiom));
    }

    public int getAxiomCount(Imports imports) {
        return imports.stream((HasImportsClosure)this).mapToInt(OWLAxiomCollection::getAxiomCount).sum();
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, Imports imports) {
        return imports.stream((HasImportsClosure)this).mapToInt(o -> o.getAxiomCount(axiomType)).sum();
    }

    public int getLogicalAxiomCount(Imports imports) {
        return imports.stream((HasImportsClosure)this).mapToInt(OWLAxiomCollection::getLogicalAxiomCount).sum();
    }

    public Stream<OWLDeclarationAxiom> declarationAxioms(OWLEntity subject) {
        return this.axioms(OWLDeclarationAxiom.class, (OWLObject)subject, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLAnnotationAssertionAxiom> annotationAssertionAxioms(OWLAnnotationSubject entity) {
        return this.axioms(OWLAnnotationAssertionAxiom.class, OWLAnnotationSubject.class, (OWLObject)entity, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLSubClassOfAxiom> subClassAxiomsForSubClass(OWLClass clazz) {
        return this.axioms(OWLSubClassOfAxiom.class, OWLClass.class, (OWLObject)clazz, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLSubClassOfAxiom> subClassAxiomsForSuperClass(OWLClass clazz) {
        return this.axioms(OWLSubClassOfAxiom.class, OWLClass.class, (OWLObject)clazz, Navigation.IN_SUPER_POSITION);
    }

    public Stream<OWLEquivalentClassesAxiom> equivalentClassesAxioms(OWLClass clazz) {
        return this.axioms(OWLEquivalentClassesAxiom.class, OWLClass.class, (OWLObject)clazz, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLDisjointClassesAxiom> disjointClassesAxioms(OWLClass clazz) {
        return this.axioms(OWLDisjointClassesAxiom.class, OWLClass.class, (OWLObject)clazz, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLDisjointUnionAxiom> disjointUnionAxioms(OWLClass clazz) {
        return this.axioms(OWLDisjointUnionAxiom.class, OWLClass.class, (OWLObject)clazz, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLHasKeyAxiom> hasKeyAxioms(OWLClass clazz) {
        return this.axioms(OWLHasKeyAxiom.class, OWLClass.class, (OWLObject)clazz, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsForSubProperty(OWLObjectPropertyExpression property) {
        return this.axioms(OWLSubObjectPropertyOfAxiom.class, OWLObjectPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsForSuperProperty(OWLObjectPropertyExpression property) {
        return this.axioms(OWLSubObjectPropertyOfAxiom.class, OWLObjectPropertyExpression.class, (OWLObject)property, Navigation.IN_SUPER_POSITION);
    }

    public Stream<OWLObjectPropertyDomainAxiom> objectPropertyDomainAxioms(OWLObjectPropertyExpression property) {
        return this.axioms(OWLObjectPropertyDomainAxiom.class, OWLObjectPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLObjectPropertyRangeAxiom> objectPropertyRangeAxioms(OWLObjectPropertyExpression property) {
        return this.axioms(OWLObjectPropertyRangeAxiom.class, OWLObjectPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLInverseObjectPropertiesAxiom> inverseObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.axioms(OWLInverseObjectPropertiesAxiom.class, OWLObjectPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLEquivalentObjectPropertiesAxiom> equivalentObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        return this.axioms(OWLEquivalentObjectPropertiesAxiom.class, OWLObjectPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLDisjointObjectPropertiesAxiom> disjointObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        return this.axioms(OWLDisjointObjectPropertiesAxiom.class, OWLObjectPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLFunctionalObjectPropertyAxiom> functionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.axioms(OWLFunctionalObjectPropertyAxiom.class, OWLObjectPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLInverseFunctionalObjectPropertyAxiom> inverseFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.axioms(OWLInverseFunctionalObjectPropertyAxiom.class, OWLObjectPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLSymmetricObjectPropertyAxiom> symmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.axioms(OWLSymmetricObjectPropertyAxiom.class, OWLObjectPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLAsymmetricObjectPropertyAxiom> asymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.axioms(OWLAsymmetricObjectPropertyAxiom.class, OWLObjectPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLReflexiveObjectPropertyAxiom> reflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.axioms(OWLReflexiveObjectPropertyAxiom.class, OWLObjectPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLIrreflexiveObjectPropertyAxiom> irreflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.axioms(OWLIrreflexiveObjectPropertyAxiom.class, OWLObjectPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLTransitiveObjectPropertyAxiom> transitiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.axioms(OWLTransitiveObjectPropertyAxiom.class, OWLObjectPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsForSubProperty(OWLDataProperty property) {
        return this.axioms(OWLSubDataPropertyOfAxiom.class, OWLDataPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsForSuperProperty(OWLDataPropertyExpression property) {
        return this.axioms(OWLSubDataPropertyOfAxiom.class, OWLDataPropertyExpression.class, (OWLObject)property, Navigation.IN_SUPER_POSITION);
    }

    public Stream<OWLDataPropertyDomainAxiom> dataPropertyDomainAxioms(OWLDataProperty property) {
        return this.axioms(OWLDataPropertyDomainAxiom.class, OWLDataPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLDataPropertyRangeAxiom> dataPropertyRangeAxioms(OWLDataProperty property) {
        return this.axioms(OWLDataPropertyRangeAxiom.class, OWLDataPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLEquivalentDataPropertiesAxiom> equivalentDataPropertiesAxioms(OWLDataProperty property) {
        return this.axioms(OWLEquivalentDataPropertiesAxiom.class, OWLDataPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLDisjointDataPropertiesAxiom> disjointDataPropertiesAxioms(OWLDataProperty property) {
        return this.axioms(OWLDisjointDataPropertiesAxiom.class, OWLDataPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLFunctionalDataPropertyAxiom> functionalDataPropertyAxioms(OWLDataPropertyExpression property) {
        return this.axioms(OWLFunctionalDataPropertyAxiom.class, OWLDataPropertyExpression.class, (OWLObject)property, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLClassAssertionAxiom> classAssertionAxioms(OWLIndividual individual) {
        return this.axioms(OWLClassAssertionAxiom.class, OWLIndividual.class, (OWLObject)individual, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLClassAssertionAxiom> classAssertionAxioms(OWLClassExpression ce) {
        return this.axioms(OWLClassAssertionAxiom.class, OWLClassExpression.class, (OWLObject)ce, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLDataPropertyAssertionAxiom> dataPropertyAssertionAxioms(OWLIndividual individual) {
        return this.axioms(OWLDataPropertyAssertionAxiom.class, OWLIndividual.class, (OWLObject)individual, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLObjectPropertyAssertionAxiom> objectPropertyAssertionAxioms(OWLIndividual individual) {
        return this.axioms(OWLObjectPropertyAssertionAxiom.class, OWLIndividual.class, (OWLObject)individual, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLNegativeObjectPropertyAssertionAxiom> negativeObjectPropertyAssertionAxioms(OWLIndividual individual) {
        return this.axioms(OWLNegativeObjectPropertyAssertionAxiom.class, OWLIndividual.class, (OWLObject)individual, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLNegativeDataPropertyAssertionAxiom> negativeDataPropertyAssertionAxioms(OWLIndividual individual) {
        return this.axioms(OWLNegativeDataPropertyAssertionAxiom.class, OWLIndividual.class, (OWLObject)individual, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLSameIndividualAxiom> sameIndividualAxioms(OWLIndividual individual) {
        return this.axioms(OWLSameIndividualAxiom.class, OWLIndividual.class, (OWLObject)individual, Navigation.IN_SUB_POSITION);
    }

    public Stream<OWLDifferentIndividualsAxiom> differentIndividualAxioms(OWLIndividual individual) {
        return this.axioms(OWLDifferentIndividualsAxiom.class, OWLIndividual.class, (OWLObject)individual, Navigation.IN_SUB_POSITION);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        GraphMem base = new GraphMem();
        RDFDataMgr.read((Graph)base, (InputStream)in, (Lang)DEFAULT_SERIALIZATION_FORMAT.getLang());
        this.setBase(BaseModel.createInternalModel((Graph)base));
    }

    private void writeObject(ObjectOutputStream out) throws IOException, OntApiException {
        Graph g = this.base.getBaseGraph();
        if (!(g instanceof GraphMem)) {
            throw new OntApiException(this.getOntologyID() + ":: Serialization is not supported for " + g.getClass());
        }
        out.defaultWriteObject();
        RDFDataMgr.write((OutputStream)out, (Graph)g, (Lang)DEFAULT_SERIALIZATION_FORMAT.getLang());
    }

    public String toString() {
        return String.format("Ontology(%s)", this.getOntologyID());
    }

    public int hashCode() {
        return this.hashCode == 0 ? (this.hashCode = this.initHashCode()) : this.hashCode;
    }

    public int compareTo(@Nullable OWLObject o) {
        return OWLObjectImpl.DEFAULT_COMPARATOR.compare((OWLObject)this, Objects.requireNonNull(o));
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Ontology)) {
            return false;
        }
        OntModel right = ((Ontology)obj).asGraphModel();
        InternalModel left = this.getBase();
        return left.getID().sameAs(right.getID());
    }

    private static /* synthetic */ OWLUnaryPropertyAxiom lambda$axioms$15(Class rec$, Object x$0) {
        return (OWLUnaryPropertyAxiom)rec$.cast(x$0);
    }

    private static /* synthetic */ OWLUnaryPropertyAxiom lambda$axioms$8(Class rec$, Object x$0) {
        return (OWLUnaryPropertyAxiom)rec$.cast(x$0);
    }

    private static /* synthetic */ OWLNaryPropertyAxiom lambda$axioms$4(Class rec$, Object x$0) {
        return (OWLNaryPropertyAxiom)rec$.cast(x$0);
    }
}

