/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.HasAdapter;
import com.github.owlcs.ontapi.ID;
import com.github.owlcs.ontapi.OWLAdapter;
import com.github.owlcs.ontapi.OntFormat;
import com.github.owlcs.ontapi.Ontology;
import com.github.owlcs.ontapi.OntologyBuilderImpl;
import com.github.owlcs.ontapi.OntologyCreator;
import com.github.owlcs.ontapi.OntologyFactory;
import com.github.owlcs.ontapi.OntologyFactoryImpl;
import com.github.owlcs.ontapi.OntologyManager;
import com.github.owlcs.ontapi.OntologyManagerImpl;
import com.github.owlcs.ontapi.OntologyModelImpl;
import com.github.owlcs.ontapi.config.OntLoaderConfiguration;
import com.github.owlcs.ontapi.jena.UnionGraph;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.jena.graph.Graph;
import org.semanticweb.owlapi.io.OWLOntologyCreationIOException;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.io.OWLParser;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.io.OWLParserFactory;
import org.semanticweb.owlapi.io.UnparsableOntologyException;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyBuilder;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitorEx;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.model.RemoveOntologyAnnotation;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.model.UnloadableImportException;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import org.semanticweb.owlapi.util.PriorityCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class OWLFactoryWrapper
implements OntologyFactory.Loader {
    private static final Logger LOGGER = LoggerFactory.getLogger(OWLFactoryWrapper.class);
    protected Set<IRI> sources = new HashSet<IRI>();

    @Override
    public OWLAdapter getAdapter() {
        return OWLAdapter.get();
    }

    @Override
    public OntologyFactory asOntologyFactory(OntologyCreator builder) {
        return new OntologyFactoryImpl(this.getAdapter().asBuilder(builder), this);
    }

    public void clear() {
        this.sources.clear();
    }

    public OntologyCreator optimize(OntologyCreator builder) {
        return OWLFactoryWrapper.createLoadingBuilder(builder);
    }

    public OntLoaderConfiguration optimize(OntLoaderConfiguration config) {
        return (OntLoaderConfiguration)config.setLoadNodesCacheSize(-1).setModelCacheLevel(2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ontology loadOntology(OntologyCreator builder, OntologyManager manager, OWLOntologyDocumentSource source, OntLoaderConfiguration conf) throws OWLOntologyCreationException {
        OWLAdapter adapter = this.getAdapter();
        FactoryImpl factory = new FactoryImpl(builder);
        try {
            IRI doc = source.getDocumentIRI();
            if (this.sources.contains(doc)) {
                throw new OntologyFactoryImpl.BadRecursionException("Cycle loading for source " + doc);
            }
            this.sources.add(doc);
            Ontology res = this.getAdapter().asONT(factory.loadOWLOntology(manager, source, adapter.asHandler(manager), conf));
            if (LOGGER.isDebugEnabled()) {
                OntFormat format = OntFormat.get(manager.getOntologyFormat(res));
                LOGGER.debug("The ontology <{}> is loaded. Format: {}[{}]", new Object[]{res.getOntologyID(), format, source.getClass().getSimpleName()});
            }
            res.clearCache();
            Ontology ontology = res;
            return ontology;
        }
        finally {
            this.clear();
        }
    }

    public static OntologyBuilderImpl createLoadingBuilder(final OntologyCreator base) {
        Objects.requireNonNull(base);
        return new OntologyBuilderImpl(){

            @Override
            public OntologyModelImpl createOntologyImpl(Graph graph, OntologyManagerImpl manager, OntLoaderConfiguration config) {
                return new OntologyModelImpl((Graph)this.wrap(graph, config), this.createModelConfig(manager, config)){

                    @Override
                    protected OWLOntologyChangeVisitorEx<ChangeApplied> createChangeProcessor() {
                        return new OntologyModelImpl.ChangeProcessor(){

                            @Override
                            public ChangeApplied visit(SetOntologyID change) {
                                ChangeApplied res = super.visit(change);
                                this.getBase().forceLoad();
                                return res;
                            }

                            @Override
                            public ChangeApplied visit(AddAxiom change) {
                                return this.of(this.getBase().add(change.getAxiom()));
                            }

                            @Override
                            public ChangeApplied visit(AddOntologyAnnotation change) {
                                return this.of(this.getBase().add(change.getAnnotation()));
                            }

                            @Override
                            public ChangeApplied visit(RemoveAxiom change) {
                                LOGGER.warn("Suspicious: {}", (Object)change);
                                return this.of(this.getBase().remove(change.getAxiom()));
                            }

                            @Override
                            public ChangeApplied visit(RemoveOntologyAnnotation change) {
                                LOGGER.warn("Suspicious: {}", (Object)change);
                                return this.of(this.getBase().remove(change.getAnnotation()));
                            }

                            private ChangeApplied of(boolean res) {
                                return res ? ChangeApplied.SUCCESSFULLY : ChangeApplied.NO_OPERATION;
                            }
                        };
                    }
                };
            }

            @Override
            public Graph createGraph() {
                return base.createGraph();
            }

            @Override
            public UnionGraph createUnionGraph(Graph g, OntLoaderConfiguration c) {
                return base.createUnionGraph(g, c);
            }
        };
    }

    public static class AcceptHeaderBuilder {
        public static String headersFromParsers(Iterable<OWLParserFactory> parsers) {
            HashMap map = new HashMap();
            parsers.forEach(p -> AcceptHeaderBuilder.addToMap(map, p.getMIMETypes()));
            return map.entrySet().stream().sorted(AcceptHeaderBuilder::compare).map(AcceptHeaderBuilder::asString).collect(Collectors.joining(", "));
        }

        private static void addToMap(Map<String, TreeSet<Integer>> map, List<String> mimes) {
            for (int i = 0; i < mimes.size(); ++i) {
                map.computeIfAbsent(mimes.get(i), k -> new TreeSet()).add(i + 1);
            }
        }

        private static String asString(Map.Entry<String, TreeSet<Integer>> e) {
            return String.format("%s; q=%.1f", e.getKey(), 1.0 / (double)e.getValue().first().intValue());
        }

        private static int compare(Map.Entry<String, TreeSet<Integer>> a, Map.Entry<String, TreeSet<Integer>> b) {
            return a.getValue().first().compareTo(b.getValue().first());
        }
    }

    public static class FactoryImpl
    implements OWLOntologyFactory,
    HasAdapter {
        private final Builder builder;

        public FactoryImpl(OWLOntologyBuilder builder) {
            Objects.requireNonNull(builder);
            this.builder = (i, m, c) -> builder.createOWLOntology(m, i);
        }

        public FactoryImpl(OntologyCreator builder) {
            Objects.requireNonNull(builder);
            OWLAdapter adapter = this.getAdapter();
            this.builder = (i, m, c) -> builder.createOntology(adapter.asONT(i), adapter.asONT(m), adapter.asONT(c));
        }

        public static Iterable<OWLParserFactory> select(OWLOntologyDocumentSource source, PriorityCollection<OWLParserFactory> parsers) {
            if (parsers.isEmpty()) {
                return parsers;
            }
            Optional format = source.getFormat();
            Optional mimeType = source.getMIMEType();
            if (!format.isPresent() && !mimeType.isPresent()) {
                return parsers;
            }
            PriorityCollection res = parsers;
            if (format.isPresent()) {
                res = new PriorityCollection(PriorityCollectionSorting.NEVER);
                for (OWLParserFactory p : parsers) {
                    if (!format.map(OWLDocumentFormat::getKey).filter(s -> s.equals(p.getSupportedFormat().getKey())).isPresent()) continue;
                    res.add((Serializable)p);
                }
            }
            if (mimeType.isPresent() && res.isEmpty()) {
                res = parsers.getByMIMEType((String)mimeType.get());
            }
            if (res.isEmpty()) {
                return parsers;
            }
            return res;
        }

        @Override
        public OWLAdapter getAdapter() {
            return OWLAdapter.get();
        }

        public boolean canCreateFromDocumentIRI(IRI documentIRI) {
            return true;
        }

        public boolean canAttemptLoading(OWLOntologyDocumentSource source) {
            return !source.hasAlredyFailedOnStreams() || !source.hasAlredyFailedOnIRIResolution();
        }

        @Deprecated
        public OWLOntology createOWLOntology(OWLOntologyManager manager, OWLOntologyID id, IRI documentIRI, OWLOntologyFactory.OWLOntologyCreationHandler handler) {
            OWLOntology res = this.createOWLOntology(id, manager, manager.getOntologyLoaderConfiguration());
            handler.setOntologyFormat(res, OntFormat.RDF_XML.createOwlFormat());
            return res;
        }

        public OWLOntology createOWLOntology(OWLOntologyID id, OWLOntologyManager manager, OWLOntologyLoaderConfiguration conf) {
            OWLOntology res = this.builder.apply(id, manager, conf);
            this.getAdapter().asHandler(manager).ontologyCreated(res);
            return res;
        }

        public OWLOntology loadOWLOntology(OWLOntologyManager manager, OWLOntologyDocumentSource source, OWLOntologyFactory.OWLOntologyCreationHandler handler, OWLOntologyLoaderConfiguration config) throws OWLOntologyCreationException {
            LinkedHashMap<OWLParser, OWLParserException> exceptions = new LinkedHashMap<OWLParser, OWLParserException>();
            OWLOntology existingOntology = null;
            IRI iri = source.getDocumentIRI();
            if (manager.contains(iri)) {
                existingOntology = manager.getOntology(iri);
            }
            ID id = new ID();
            OWLOntology ont = this.createOWLOntology(id, manager, config);
            Set bannedParsers = Arrays.stream(config.getBannedParsers().split(" ")).collect(Collectors.toSet());
            Iterable<OWLParserFactory> parsers = FactoryImpl.select(source, (PriorityCollection<OWLParserFactory>)manager.getOntologyParsers());
            if (source.getAcceptHeaders().isPresent()) {
                source.setAcceptHeaders(AcceptHeaderBuilder.headersFromParsers(parsers));
            }
            for (OWLParserFactory parserFactory : parsers) {
                if (bannedParsers.contains(parserFactory.getClass().getName())) continue;
                OWLParser parser = parserFactory.createParser();
                try {
                    if (existingOntology == null && !ont.isEmpty()) {
                        manager.removeOntology(ont);
                        ont = this.createOWLOntology(id, manager, config);
                    }
                    OWLDocumentFormat format = parser.parse(source, ont, config);
                    handler.setOntologyFormat(ont, format);
                    return ont;
                }
                catch (UnloadableImportException e) {
                    manager.removeOntology(ont);
                    throw e;
                }
                catch (OWLParserException e) {
                    if (e.getCause() instanceof IOException || e.getCause() instanceof OWLOntologyInputSourceException) {
                        manager.removeOntology(ont);
                        throw new OWLOntologyCreationIOException(e.getCause());
                    }
                    exceptions.put(parser, e);
                }
                catch (RuntimeException e) {
                    exceptions.put(parser, new OWLParserException((Throwable)e));
                    manager.removeOntology(ont);
                    throw e;
                }
            }
            if (existingOntology == null) {
                manager.removeOntology(ont);
            }
            throw new UnparsableOntologyException(source.getDocumentIRI(), exceptions, config);
        }

        public static interface Builder {
            public OWLOntology apply(OWLOntologyID var1, OWLOntologyManager var2, OWLOntologyLoaderConfiguration var3);
        }
    }
}

