/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.cam.cares.jps.base.http;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import uk.ac.cam.cares.jps.base.config.AgentLocator;
import uk.ac.cam.cares.jps.base.config.KeyValueManager;
import uk.ac.cam.cares.jps.base.exception.JPSRuntimeException;
import uk.ac.cam.cares.jps.base.util.FileUtil;

public class Http {
    private static final Logger LOGGER = LogManager.getLogger(Http.class);
    private static final String JSON_PARAMETER_KEY = "query";
    private static String hostPort = null;

    private static synchronized String getHostPort() {
        if (hostPort == null) {
            hostPort = AgentLocator.getProperty("host") + ":" + AgentLocator.getProperty("port");
        }
        return hostPort;
    }

    private static URIBuilder getUriBuilderForPath(String path) {
        return new URIBuilder().setScheme("http").setHost(Http.getHostPort()).setPath(path);
    }

    public static URI createURI(String url, String ... keyOrValue) {
        int j = url.indexOf(58);
        String scheme = url.substring(0, j);
        URIBuilder builder = new URIBuilder().setScheme(scheme);
        url = url.substring(j + 3);
        j = url.indexOf(47);
        String path = url.substring(j);
        builder.setPath(path);
        String host = url.substring(0, j);
        j = host.indexOf(58);
        if (j == -1) {
            builder.setHost(host);
        } else {
            String[] split = host.split(":");
            builder.setHost(split[0]);
            int port = Integer.valueOf(split[1]);
            builder.setPort(port);
        }
        if (keyOrValue != null) {
            for (int i = 0; i < keyOrValue.length; i += 2) {
                String key = keyOrValue[i];
                String value = keyOrValue[i + 1];
                builder.setParameter(key, value);
            }
        }
        try {
            return builder.build();
        }
        catch (URISyntaxException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public static JSONObject readJsonParameter(HttpServletRequest request) {
        try {
            String json = request.getParameter(JSON_PARAMETER_KEY);
            if (json != null) {
                return new JSONObject(json);
            }
            JSONObject jsonobject = new JSONObject();
            Enumeration keys = request.getParameterNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = request.getParameter(key);
                jsonobject.put(key, (Object)value);
            }
            return jsonobject;
        }
        catch (JSONException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public static void writeJsonParameter(HttpServletResponse response, JSONObject json) throws IOException {
        response.setContentType("application/json");
        PrintWriter out = response.getWriter();
        String message = json.toString();
        out.print(message);
    }

    public static String getRequestBody(HttpServletRequest req) {
        try {
            ServletInputStream inputStream = req.getInputStream();
            return FileUtil.inputStreamToString((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public static void printToResponse(Object body, HttpServletResponse resp) {
        if (body == null) {
            return;
        }
        String bodyAsString = Http.toString(body);
        resp.setContentType("text/plain");
        resp.setCharacterEncoding("UTF-8");
        try {
            resp.getWriter().print(bodyAsString);
        }
        catch (IOException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    private static String toString(Object object) {
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof JSONObject) {
            return ((JSONObject)object).toString();
        }
        return new Gson().toJson(object);
    }

    public static String encodePercentage(String s) {
        Charset charset = Charset.forName("UTF-8");
        List<BasicNameValuePair> params = Arrays.asList(new BasicNameValuePair(JSON_PARAMETER_KEY, s));
        String encoded = URLEncodedUtils.format(params, (Charset)charset);
        return encoded.substring(6);
    }

    public static String decodePercentage(String s) {
        Charset charset = Charset.forName("UTF-8");
        List pair = URLEncodedUtils.parse((String)("query=" + s), (Charset)charset);
        return ((NameValuePair)pair.get(0)).getValue();
    }

    public static URI createURIFlex(String urlOrPathOrKey, Object ... params) throws URISyntaxException {
        URI result = null;
        String url = null;
        if (urlOrPathOrKey.startsWith("http")) {
            url = urlOrPathOrKey;
        } else if (urlOrPathOrKey.startsWith("\\") || urlOrPathOrKey.startsWith("/")) {
            URIBuilder builder = Http.getUriBuilderForPath(urlOrPathOrKey);
            url = builder.build().toString();
        } else {
            url = KeyValueManager.get(urlOrPathOrKey);
        }
        if (params.length == 0) {
            result = Http.createURI(url, new String[0]);
        } else if (params.length == 1) {
            if (params[0] == null) {
                result = Http.createURI(url, new String[0]);
            } else {
                String paramAsString = Http.toString(params[0]);
                result = Http.createURI(url, JSON_PARAMETER_KEY, paramAsString);
            }
        } else {
            String[] paramsAsString = new String[params.length];
            for (int i = 0; i < params.length; ++i) {
                paramsAsString[i] = params[i].toString();
            }
            result = Http.createURI(url, paramsAsString);
        }
        return result;
    }

    public static String execute(HttpRequestBase request) {
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        try {
            String code;
            LOGGER.info("request = " + request);
            httpClient = HttpClientBuilder.create().build();
            response = httpClient.execute((HttpUriRequest)request);
            String body = null;
            HttpEntity rsp_entity = response.getEntity();
            if (rsp_entity != null) {
                body = EntityUtils.toString((HttpEntity)rsp_entity, (String)"UTF-8");
            }
            if ((code = "" + response.getStatusLine().getStatusCode()).startsWith("2")) {
                String string = body;
                return string;
            }
            try {
                String message = "response with status = " + code;
                message = message + "\noriginal request = " + request;
                message = message + "\n" + body;
                LOGGER.error(message);
                throw new JPSRuntimeException(message);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new JPSRuntimeException(e.getMessage(), e);
            }
        }
        finally {
            try {
                if (httpClient != null) {
                    httpClient.close();
                }
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static HttpGet get(String urlOrPathOrKey, String accept, Object ... params) {
        try {
            URI uri = Http.createURIFlex(urlOrPathOrKey, params);
            HttpGet request = new HttpGet(uri);
            if (accept != null) {
                request.setHeader("Accept", accept);
            }
            return request;
        }
        catch (URISyntaxException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    public static HttpPut put(String urlOrPathOrKey, Object body, String contentType, String accept, Object ... params) {
        return (HttpPut)Http.putOrPost((HttpEntityEnclosingRequestBase)new HttpPut(), urlOrPathOrKey, body, contentType, accept, params);
    }

    public static HttpPost post(String urlOrPathOrKey, Object body, String contentType, String accept, Object ... params) {
        return (HttpPost)Http.putOrPost((HttpEntityEnclosingRequestBase)new HttpPost(), urlOrPathOrKey, body, contentType, accept, params);
    }

    public static HttpDelete delete(String urlOrPathOrKey, Object ... params) {
        try {
            URI uri = Http.createURIFlex(urlOrPathOrKey, params);
            HttpDelete request = new HttpDelete(uri);
            return request;
        }
        catch (URISyntaxException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }

    private static HttpEntityEnclosingRequestBase putOrPost(HttpEntityEnclosingRequestBase request, String urlOrPathOrKey, Object body, String contentType, String accept, Object ... params) {
        try {
            URI uri = Http.createURIFlex(urlOrPathOrKey, params);
            request.setURI(uri);
            if (body != null) {
                String bodyAsString = Http.toString(body);
                StringEntity entity = new StringEntity(bodyAsString);
                request.setEntity((HttpEntity)entity);
            }
            if (contentType != null) {
                request.setHeader("Content-Type", contentType);
            }
            if (accept != null) {
                request.setHeader("Accept", accept);
            }
            return request;
        }
        catch (UnsupportedEncodingException | URISyntaxException e) {
            throw new JPSRuntimeException(e.getMessage(), e);
        }
    }
}

