/*
 * Decompiled with CFR 0.152.
 */
package net.jini.discovery;

import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public final class DiscoveryPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = -3036978025008149170L;

    public DiscoveryPermission(String group) {
        super(group == null ? "" : group);
        if (group == null) {
            group = "";
        } else if (group.startsWith("*") && group.length() != 1 && (group.length() <= 2 || !group.startsWith("*."))) {
            throw new IllegalArgumentException("invalid group wildcard specification");
        }
    }

    public DiscoveryPermission(String group, String action) {
        this(group);
    }

    public boolean implies(Permission p) {
        if (!(p instanceof DiscoveryPermission)) {
            return false;
        }
        String grp = p.getName();
        String group = this.getName();
        if (group.startsWith("*")) {
            if (group.length() == 1) {
                return true;
            }
            if (grp.length() == 1) {
                return false;
            }
            return grp.length() >= group.length() && group.regionMatches(false, 2, grp, grp.length() - group.length() + 2, group.length() - 2);
        }
        if (grp.startsWith("*")) {
            return false;
        }
        return group.equals(grp);
    }

    public boolean equals(Object obj) {
        return this == obj || obj instanceof DiscoveryPermission && this.getName().equals(((DiscoveryPermission)obj).getName());
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return new Collection();
    }

    private static class Collection
    extends PermissionCollection {
        private static final long serialVersionUID = -6656227831159479611L;
        private final ArrayList perms = new ArrayList(3);

        private Collection() {
        }

        public synchronized void add(Permission p) {
            if (this.isReadOnly()) {
                throw new SecurityException("collection is read-only");
            }
            if (this.perms.indexOf(p) < 0) {
                this.perms.add(p);
            }
        }

        public synchronized boolean implies(Permission p) {
            int i = this.perms.size();
            while (--i >= 0) {
                if (!((Permission)this.perms.get(i)).implies(p)) continue;
                return true;
            }
            return false;
        }

        public Enumeration elements() {
            return Collections.enumeration(this.perms);
        }
    }
}

