# Generated by Django 4.2.16 on 2024-11-28 09:02

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('keywords', '0001_initial'),
        ('executions', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Resource',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True, verbose_name='Name')),
                ('documentation', models.TextField(verbose_name='Dokumentation')),
            ],
            options={
                'verbose_name': 'Ressource',
                'verbose_name_plural': 'Ressourcen',
            },
        ),
        migrations.CreateModel(
            name='ResourceKeyword',
            fields=[
            ],
            options={
                'verbose_name': 'Ressource-Schlüsselwort',
                'verbose_name_plural': 'Ressource-Schlüsselwörter',
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('keywords.keyword',),
        ),
        migrations.CreateModel(
            name='ResourceImport',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('FROM_EXECUTION', 'Aus einer Ausführung'), ('FROM_SEQUENCE', 'Aus einer Sequenz')], max_length=255)),
                ('execution', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='resource_imports', to='executions.execution')),
                ('keyword', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='resource_imports', to='keywords.keyword')),
                ('resource', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='resources.resource', verbose_name='Ressource')),
            ],
            options={
                'verbose_name': 'Ressource-Import',
                'verbose_name_plural': 'Ressource-Imports',
            },
        ),
        migrations.CreateModel(
            name='ResourceKeywordDocumentation',
            fields=[
            ],
            options={
                'verbose_name': 'Dokumentation des Ressource-Schlüsselworts',
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('resources.resourcekeyword',),
        ),
        migrations.AddConstraint(
            model_name='resourceimport',
            constraint=models.CheckConstraint(check=models.Q(models.Q(('type', 'FROM_EXECUTION'), ('execution__isnull', False), ('keyword__isnull', True)), models.Q(('type', 'FROM_SEQUENCE'), ('execution__isnull', True), ('keyword__isnull', False)), _connector='OR'), name='resource_import_sum_type'),
        ),
        migrations.AddConstraint(
            model_name='resourceimport',
            constraint=models.UniqueConstraint(condition=models.Q(('execution__isnull', False)), fields=('execution', 'resource'), name='unique_execution_resource_import'),
        ),
        migrations.AddConstraint(
            model_name='resourceimport',
            constraint=models.UniqueConstraint(condition=models.Q(('keyword__isnull', False)), fields=('keyword', 'resource'), name='unique_keyword_resource_import'),
        ),
    ]
