# Generated by Django 4.2.16 on 2024-11-28 09:02

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('keywords', '0001_initial'),
        ('executions', '0001_initial'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Library',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, unique=True, verbose_name='Name')),
                ('version', models.CharField(max_length=255)),
                ('init_doc', models.TextField(verbose_name='Einrichtung')),
                ('documentation', models.TextField(verbose_name='Dokumentation')),
            ],
            options={
                'verbose_name': 'Bibliothek',
                'verbose_name_plural': 'Bibliotheken',
            },
        ),
        migrations.CreateModel(
            name='LibraryImport',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('FROM_EXECUTION', 'Aus einer Ausführung'), ('FROM_ACTION', 'Aus einer Aktion')], max_length=255)),
                ('execution', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='library_imports', to='executions.execution')),
                ('keyword', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='library_imports', to='keywords.keyword')),
                ('library', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='libraries.library', verbose_name='Bibliothek')),
            ],
            options={
                'verbose_name': 'Bibliothek-Import',
                'verbose_name_plural': 'Bibliothek-Imports',
            },
        ),
        migrations.CreateModel(
            name='LibraryKeyword',
            fields=[
            ],
            options={
                'verbose_name': 'Bibliothek-Schlüsselwort',
                'verbose_name_plural': 'Bibliothek-Schlüsselwörter',
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('keywords.keyword',),
        ),
        migrations.CreateModel(
            name='LibraryParameter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('default_value', models.CharField(max_length=255, verbose_name='Standardwert')),
                ('orig_default_value', models.CharField(max_length=255)),
                ('library', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='kwargs', to='libraries.library')),
            ],
            options={
                'verbose_name': 'Einstellung',
                'verbose_name_plural': 'Einstellungen',
            },
        ),
        migrations.CreateModel(
            name='LibraryImportParameter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.CharField(max_length=255)),
                ('library_import', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='kwargs', to='libraries.libraryimport')),
                ('library_parameter', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='libraries.libraryparameter')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'Parameter',
                'verbose_name_plural': 'Parameter',
            },
        ),
        migrations.CreateModel(
            name='LibraryInitDocumentation',
            fields=[
            ],
            options={
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('libraries.library',),
        ),
        migrations.CreateModel(
            name='LibraryKeywordDocumentation',
            fields=[
            ],
            options={
                'verbose_name': 'Dokumentation des Bibliothek-Schlüsselworts',
                'proxy': True,
                'indexes': [],
                'constraints': [],
            },
            bases=('libraries.librarykeyword',),
        ),
        migrations.AddConstraint(
            model_name='libraryparameter',
            constraint=models.UniqueConstraint(fields=('library', 'name'), name='unique_library_parameter'),
        ),
        migrations.AddConstraint(
            model_name='libraryimport',
            constraint=models.CheckConstraint(check=models.Q(models.Q(('type', 'FROM_EXECUTION'), ('execution__isnull', False), ('keyword__isnull', True)), models.Q(('type', 'FROM_ACTION'), ('execution__isnull', True), ('keyword__isnull', False)), _connector='OR'), name='library_import_sum_type'),
        ),
        migrations.AddConstraint(
            model_name='libraryimport',
            constraint=models.UniqueConstraint(condition=models.Q(('execution__isnull', False)), fields=('execution', 'library'), name='unique_execution_library_import'),
        ),
        migrations.AddConstraint(
            model_name='libraryimport',
            constraint=models.UniqueConstraint(condition=models.Q(('keyword__isnull', False)), fields=('keyword', 'library'), name='unique_keyword_library_import'),
        ),
    ]
