# Generated by Django 4.2.16 on 2024-11-28 09:02

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Keyword',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('short_doc', models.CharField(blank=True, max_length=255, verbose_name='Beschreibung')),
                ('args_doc', models.TextField(blank=True, verbose_name='Parameter')),
                ('documentation', models.TextField(blank=True, verbose_name='Dokumentation')),
                ('type', models.CharField(choices=[('LIBRARY', 'Schlüsselwort aus Bibliothek'), ('RESOURCE', 'Schlüsselwort aus Ressource'), ('ACTION', 'Aktion'), ('SEQUENCE', 'Sequenz')], max_length=255)),
                ('everywhere', models.BooleanField(default=False, verbose_name='In allen Masken')),
                ('setup_teardown', models.BooleanField(default=False, verbose_name='Vor-/Nachbereitung')),
            ],
        ),
        migrations.CreateModel(
            name='KeywordCall',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('enabled', models.BooleanField(default=True, verbose_name='')),
                ('index', models.PositiveSmallIntegerField(db_index=True, default=0)),
                ('type', models.CharField(choices=[('KEYWORD_CALL', 'Schlüsselwort-Aufruf'), ('KEYWORD_EXECUTION', 'Schlüsselwort Ausführung'), ('TEST_STEP', 'Testschritt'), ('TEST_SETUP', 'Testvorbereitung'), ('TEST_TEARDOWN', 'Testnachbereitung'), ('SUITE_SETUP', 'Suitevorbereitung'), ('SUITE_TEARDOWN', 'Suitenachbereitung')], max_length=255)),
            ],
            options={
                'verbose_name': 'Schritt',
                'verbose_name_plural': 'Schritte',
                'ordering': ['index'],
            },
        ),
        migrations.CreateModel(
            name='KeywordCallParameter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('value', models.CharField(max_length=255, verbose_name='Wert')),
            ],
            options={
                'verbose_name': 'Aufrufparameter',
                'verbose_name_plural': 'Aufrufparameter',
            },
        ),
        migrations.CreateModel(
            name='KeywordCallReturnValue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(blank=True, default=None, max_length=255, null=True)),
                ('keyword_call', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='return_value', to='keywords.keywordcall')),
                ('return_value', models.ForeignKey(blank=True, default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='keywords.keywordcallreturnvalue')),
            ],
            options={
                'verbose_name': 'Rückgabewert',
            },
        ),
        migrations.CreateModel(
            name='KeywordReturnValue',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('keyword', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='return_value', to='keywords.keyword')),
                ('kw_call_return_value', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='keywords.keywordcallreturnvalue', verbose_name='Rückgabewert')),
            ],
            options={
                'verbose_name': 'Rückgabewert',
                'verbose_name_plural': 'Rückgabewert',
            },
        ),
        migrations.CreateModel(
            name='KeywordParameter',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('position', models.PositiveIntegerField(default=None, null=True)),
                ('default_value', models.CharField(blank=True, default=None, max_length=255, null=True, verbose_name='Standardwert')),
                ('is_list', models.BooleanField(default=False)),
                ('type', models.CharField(choices=[('ARG', 'Positional Argument'), ('KWARG', 'Optional Argument')], max_length=255)),
                ('keyword', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='parameters', to='keywords.keyword')),
            ],
            options={
                'verbose_name': 'Parameter',
                'verbose_name_plural': 'Parameter',
                'ordering': ['position'],
            },
        ),
        migrations.CreateModel(
            name='KeywordCallParameterSource',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('type', models.CharField(choices=[('KEYWORD_PARAMETER', 'Schlüsselwort-Parameter'), ('KW_CALL_RETURN_VALUE', 'Aufrufs-Rückgabewert'), ('VARIABLE_VALUE', 'Referenzwert')], max_length=255)),
                ('kw_call_ret_val', models.OneToOneField(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='keywords.keywordcallreturnvalue')),
                ('kw_param', models.OneToOneField(default=None, null=True, on_delete=django.db.models.deletion.CASCADE, to='keywords.keywordparameter')),
            ],
            options={
                'verbose_name': 'Parameter-Referenz',
                'verbose_name_plural': 'Parameter-Referenzen',
            },
        ),
    ]
