/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.executor;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.delegation.Executor;
import org.apache.flink.table.delegation.ExecutorFactory;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.executor.StreamExecutor;

@Internal
public class StreamExecutorFactory
implements ExecutorFactory {
    public Executor create(Map<String, String> properties, StreamExecutionEnvironment executionEnvironment) {
        return new StreamExecutor(executionEnvironment);
    }

    @Override
    public Executor create(Map<String, String> properties) {
        return new StreamExecutor(StreamExecutionEnvironment.getExecutionEnvironment());
    }

    @Override
    public Map<String, String> requiredContext() {
        DescriptorProperties properties = new DescriptorProperties();
        properties.putBoolean("streaming-mode", true);
        return properties.asMap();
    }

    @Override
    public List<String> supportedProperties() {
        return Collections.singletonList("class-name");
    }

    @Override
    public Map<String, String> optionalContext() {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("class-name", this.getClass().getCanonicalName());
        return context;
    }
}

