/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public class ObjectPath
implements Serializable {
    private final String databaseName;
    private final String objectName;

    public ObjectPath(String databaseName, String objectName) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)databaseName) ? 1 : 0) != 0, (Object)"databaseName cannot be null or empty");
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)objectName) ? 1 : 0) != 0, (Object)"objectName cannot be null or empty");
        this.databaseName = databaseName;
        this.objectName = objectName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getFullName() {
        return String.format("%s.%s", this.databaseName, this.objectName);
    }

    public static ObjectPath fromString(String fullName) {
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)fullName) ? 1 : 0) != 0, (Object)"fullName cannot be null or empty");
        String[] paths = fullName.split("\\.");
        if (paths.length != 2) {
            throw new IllegalArgumentException(String.format("Cannot get split '%s' to get databaseName and objectName", fullName));
        }
        return new ObjectPath(paths[0], paths[1]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectPath that = (ObjectPath)o;
        return Objects.equals(this.databaseName, that.databaseName) && Objects.equals(this.objectName, that.objectName);
    }

    public int hashCode() {
        return Objects.hash(this.databaseName, this.objectName);
    }

    public String toString() {
        return String.format("%s.%s", this.databaseName, this.objectName);
    }
}

