/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.logical;

import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Spool;
import org.apache.calcite.rel.core.TableSpool;
import org.apache.calcite.rel.metadata.RelMetadataQuery;

public class LogicalTableSpool
extends TableSpool {
    public LogicalTableSpool(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, Spool.Type readType, Spool.Type writeType, String tableName) {
        super(cluster, traitSet, input, readType, writeType, tableName);
    }

    public static LogicalTableSpool create(RelNode input, Spool.Type readType, Spool.Type writeType, String tableName) {
        RelOptCluster cluster = input.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)Convention.NONE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> mq.collations(input)).replaceIf(RelDistributionTraitDef.INSTANCE, () -> mq.distribution(input));
        return new LogicalTableSpool(cluster, traitSet, input, readType, writeType, tableName);
    }

    @Override
    protected Spool copy(RelTraitSet traitSet, RelNode input, Spool.Type readType, Spool.Type writeType) {
        return new LogicalTableSpool(input.getCluster(), traitSet, input, readType, writeType, this.tableName);
    }
}

