/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.types.inference.validators;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.types.inference.ArgumentCount;
import org.apache.flink.table.types.inference.CallContext;
import org.apache.flink.table.types.inference.InputTypeValidator;
import org.apache.flink.table.types.inference.Signature;

@Internal
public class PassingTypeValidator
implements InputTypeValidator {
    private static final PassingArgumentCount PASSING_ARGUMENT_COUNT = new PassingArgumentCount();

    @Override
    public ArgumentCount getArgumentCount() {
        return PASSING_ARGUMENT_COUNT;
    }

    @Override
    public boolean validate(CallContext callContext, boolean throwOnFailure) {
        return true;
    }

    @Override
    public List<Signature> getExpectedSignatures(FunctionDefinition definition) {
        return Collections.singletonList(Signature.of(Signature.Argument.of("*")));
    }

    private static class PassingArgumentCount
    implements ArgumentCount {
        private PassingArgumentCount() {
        }

        @Override
        public boolean isValidCount(int count) {
            return true;
        }

        @Override
        public Optional<Integer> getMinCount() {
            return Optional.empty();
        }

        @Override
        public Optional<Integer> getMaxCount() {
            return Optional.empty();
        }
    }
}

