/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.typeutils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.table.dataformat.BaseMap;
import org.apache.flink.table.dataformat.BinaryArray;
import org.apache.flink.table.dataformat.BinaryArrayWriter;
import org.apache.flink.table.dataformat.BinaryMap;
import org.apache.flink.table.dataformat.BinaryWriter;
import org.apache.flink.table.dataformat.GenericMap;
import org.apache.flink.table.runtime.types.InternalSerializers;
import org.apache.flink.table.runtime.util.SegmentsUtil;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.util.InstantiationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseMapSerializer
extends TypeSerializer<BaseMap> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseMapSerializer.class);
    private final LogicalType keyType;
    private final LogicalType valueType;
    private final TypeSerializer keySerializer;
    private final TypeSerializer valueSerializer;
    private transient BinaryArray reuseKeyArray;
    private transient BinaryArray reuseValueArray;
    private transient BinaryArrayWriter reuseKeyWriter;
    private transient BinaryArrayWriter reuseValueWriter;

    public BaseMapSerializer(LogicalType keyType, LogicalType valueType, ExecutionConfig conf) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.keySerializer = InternalSerializers.create(keyType, conf);
        this.valueSerializer = InternalSerializers.create(valueType, conf);
    }

    private BaseMapSerializer(LogicalType keyType, LogicalType valueType, TypeSerializer keySerializer, TypeSerializer valueSerializer) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<BaseMap> duplicate() {
        return new BaseMapSerializer(this.keyType, this.valueType, this.keySerializer.duplicate(), this.valueSerializer.duplicate());
    }

    public BaseMap createInstance() {
        return new BinaryMap();
    }

    public BaseMap copy(BaseMap from) {
        if (from instanceof GenericMap) {
            Map<Object, Object> fromMap = ((GenericMap)from).getMap();
            if (!(fromMap instanceof HashMap) && LOG.isDebugEnabled()) {
                LOG.debug("It is dangerous to copy a non-HashMap to a HashMap.");
            }
            HashMap<Object, Object> toMap = new HashMap<Object, Object>();
            for (Map.Entry<Object, Object> entry : fromMap.entrySet()) {
                toMap.put(this.keySerializer.copy(entry.getKey()), this.valueSerializer.copy(entry.getValue()));
            }
            return new GenericMap(toMap);
        }
        return ((BinaryMap)from).copy();
    }

    public BaseMap copy(BaseMap from, BaseMap reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(BaseMap record, DataOutputView target) throws IOException {
        BinaryMap binaryMap = this.toBinaryMap(record);
        target.writeInt(binaryMap.getSizeInBytes());
        SegmentsUtil.copyToView(binaryMap.getSegments(), binaryMap.getOffset(), binaryMap.getSizeInBytes(), target);
    }

    public BinaryMap toBinaryMap(BaseMap from) {
        if (from instanceof BinaryMap) {
            return (BinaryMap)from;
        }
        Map<Object, Object> javaMap = ((GenericMap)from).getMap();
        int numElements = javaMap.size();
        if (this.reuseKeyArray == null) {
            this.reuseKeyArray = new BinaryArray();
        }
        if (this.reuseValueArray == null) {
            this.reuseValueArray = new BinaryArray();
        }
        if (this.reuseKeyWriter == null || this.reuseKeyWriter.getNumElements() != numElements) {
            this.reuseKeyWriter = new BinaryArrayWriter(this.reuseKeyArray, numElements, BinaryArray.calculateFixLengthPartSize(this.keyType));
        } else {
            this.reuseKeyWriter.reset();
        }
        if (this.reuseValueWriter == null || this.reuseValueWriter.getNumElements() != numElements) {
            this.reuseValueWriter = new BinaryArrayWriter(this.reuseValueArray, numElements, BinaryArray.calculateFixLengthPartSize(this.valueType));
        } else {
            this.reuseValueWriter.reset();
        }
        int i = 0;
        for (Map.Entry<Object, Object> entry : javaMap.entrySet()) {
            if (entry.getKey() == null) {
                this.reuseKeyWriter.setNullAt(i, this.keyType);
            } else {
                BinaryWriter.write(this.reuseKeyWriter, i, entry.getKey(), this.keyType, this.keySerializer);
            }
            if (entry.getValue() == null) {
                this.reuseValueWriter.setNullAt(i, this.valueType);
            } else {
                BinaryWriter.write(this.reuseValueWriter, i, entry.getValue(), this.valueType, this.valueSerializer);
            }
            ++i;
        }
        this.reuseKeyWriter.complete();
        this.reuseValueWriter.complete();
        return BinaryMap.valueOf(this.reuseKeyArray, this.reuseValueArray);
    }

    public BaseMap deserialize(DataInputView source) throws IOException {
        return this.deserializeReuse(new BinaryMap(), source);
    }

    public BaseMap deserialize(BaseMap reuse, DataInputView source) throws IOException {
        return this.deserializeReuse(reuse instanceof GenericMap ? new BinaryMap() : (BinaryMap)reuse, source);
    }

    private BinaryMap deserializeReuse(BinaryMap reuse, DataInputView source) throws IOException {
        int length = source.readInt();
        byte[] bytes = new byte[length];
        source.readFully(bytes);
        reuse.pointTo(MemorySegmentFactory.wrap((byte[])bytes), 0, bytes.length);
        return reuse;
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        int length = source.readInt();
        target.writeInt(length);
        target.write(source, length);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        BaseMapSerializer that = (BaseMapSerializer)((Object)o);
        return this.keyType.equals(that.keyType) && this.valueType.equals(that.valueType);
    }

    public int hashCode() {
        int result = this.keyType.hashCode();
        result = 31 * result + this.valueType.hashCode();
        return result;
    }

    @VisibleForTesting
    public TypeSerializer getKeySerializer() {
        return this.keySerializer;
    }

    @VisibleForTesting
    public TypeSerializer getValueSerializer() {
        return this.valueSerializer;
    }

    public TypeSerializerSnapshot<BaseMap> snapshotConfiguration() {
        return new BaseMapSerializerSnapshot(this.keyType, this.valueType, this.keySerializer, this.valueSerializer);
    }

    public static final class BaseMapSerializerSnapshot
    implements TypeSerializerSnapshot<BaseMap> {
        private static final int CURRENT_VERSION = 3;
        private LogicalType previousKeyType;
        private LogicalType previousValueType;
        private TypeSerializer previousKeySerializer;
        private TypeSerializer previousValueSerializer;

        public BaseMapSerializerSnapshot() {
        }

        BaseMapSerializerSnapshot(LogicalType keyT, LogicalType valueT, TypeSerializer keySer, TypeSerializer valueSer) {
            this.previousKeyType = keyT;
            this.previousValueType = valueT;
            this.previousKeySerializer = keySer;
            this.previousValueSerializer = valueSer;
        }

        public int getCurrentVersion() {
            return 3;
        }

        public void writeSnapshot(DataOutputView out) throws IOException {
            DataOutputViewStream outStream = new DataOutputViewStream(out);
            InstantiationUtil.serializeObject((OutputStream)outStream, (Object)this.previousKeyType);
            InstantiationUtil.serializeObject((OutputStream)outStream, (Object)this.previousValueType);
            InstantiationUtil.serializeObject((OutputStream)outStream, (Object)this.previousKeySerializer);
            InstantiationUtil.serializeObject((OutputStream)outStream, (Object)this.previousValueSerializer);
        }

        public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
            try {
                DataInputViewStream inStream = new DataInputViewStream(in);
                this.previousKeyType = (LogicalType)InstantiationUtil.deserializeObject((InputStream)inStream, (ClassLoader)userCodeClassLoader);
                this.previousValueType = (LogicalType)InstantiationUtil.deserializeObject((InputStream)inStream, (ClassLoader)userCodeClassLoader);
                this.previousKeySerializer = (TypeSerializer)InstantiationUtil.deserializeObject((InputStream)inStream, (ClassLoader)userCodeClassLoader);
                this.previousValueSerializer = (TypeSerializer)InstantiationUtil.deserializeObject((InputStream)inStream, (ClassLoader)userCodeClassLoader);
            }
            catch (ClassNotFoundException e) {
                throw new IOException(e);
            }
        }

        public TypeSerializer<BaseMap> restoreSerializer() {
            return new BaseMapSerializer(this.previousKeyType, this.previousValueType, this.previousKeySerializer, this.previousValueSerializer);
        }

        public TypeSerializerSchemaCompatibility<BaseMap> resolveSchemaCompatibility(TypeSerializer<BaseMap> newSerializer) {
            if (!(newSerializer instanceof BaseMapSerializer)) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            BaseMapSerializer newBaseMapSerializer = (BaseMapSerializer)newSerializer;
            if (!(this.previousKeyType.equals(newBaseMapSerializer.keyType) && this.previousValueType.equals(newBaseMapSerializer.valueType) && this.previousKeySerializer.equals((Object)newBaseMapSerializer.keySerializer) && this.previousValueSerializer.equals((Object)newBaseMapSerializer.valueSerializer))) {
                return TypeSerializerSchemaCompatibility.incompatible();
            }
            return TypeSerializerSchemaCompatibility.compatibleAsIs();
        }
    }
}

