/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.types;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.api.common.typeinfo.BasicArrayTypeInfo;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.CompositeType;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.dataformat.Decimal;
import org.apache.flink.table.runtime.types.TypeInfoLogicalTypeConverter;
import org.apache.flink.table.runtime.typeutils.BigDecimalTypeInfo;
import org.apache.flink.table.runtime.typeutils.BinaryStringTypeInfo;
import org.apache.flink.table.runtime.typeutils.DecimalTypeInfo;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.LegacyTypeInformationType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TypeInformationAnyType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;
import org.apache.flink.table.types.utils.TypeConversions;

@Deprecated
public class LogicalTypeDataTypeConverter {
    public static DataType fromLogicalTypeToDataType(LogicalType logicalType) {
        return TypeConversions.fromLogicalToDataType(logicalType);
    }

    public static LogicalType fromDataTypeToLogicalType(DataType dataType2) {
        return dataType2.getLogicalType().accept(new LegacyTypeToPlannerTypeConverter());
    }

    private static class LegacyTypeToPlannerTypeConverter
    extends LogicalTypeDefaultVisitor<LogicalType> {
        private LegacyTypeToPlannerTypeConverter() {
        }

        @Override
        protected LogicalType defaultMethod(LogicalType logicalType) {
            if (logicalType instanceof LegacyTypeInformationType) {
                TypeInformation typeInfo = ((LegacyTypeInformationType)logicalType).getTypeInformation();
                if (typeInfo.equals((Object)BasicTypeInfo.BIG_DEC_TYPE_INFO)) {
                    return Decimal.DECIMAL_SYSTEM_DEFAULT;
                }
                if (typeInfo.equals((Object)BinaryStringTypeInfo.INSTANCE)) {
                    return DataTypes.STRING().getLogicalType();
                }
                if (typeInfo instanceof BasicArrayTypeInfo) {
                    return new ArrayType(TypeInfoLogicalTypeConverter.fromTypeInfoToLogicalType(((BasicArrayTypeInfo)typeInfo).getComponentInfo()));
                }
                if (typeInfo instanceof CompositeType) {
                    CompositeType compositeType = (CompositeType)typeInfo;
                    return RowType.of((LogicalType[])Stream.iterate(0, x -> x + 1).limit(compositeType.getArity()).map(arg_0 -> ((CompositeType)compositeType).getTypeAt(arg_0)).map(TypeInfoLogicalTypeConverter::fromTypeInfoToLogicalType).toArray(LogicalType[]::new), compositeType.getFieldNames());
                }
                if (typeInfo instanceof DecimalTypeInfo) {
                    DecimalTypeInfo decimalType = (DecimalTypeInfo)typeInfo;
                    return new DecimalType(decimalType.precision(), decimalType.scale());
                }
                if (typeInfo instanceof BigDecimalTypeInfo) {
                    BigDecimalTypeInfo decimalType = (BigDecimalTypeInfo)typeInfo;
                    return new DecimalType(decimalType.precision(), decimalType.scale());
                }
                return new TypeInformationAnyType(typeInfo);
            }
            return logicalType;
        }

        @Override
        public LogicalType visit(ArrayType arrayType) {
            return new ArrayType(arrayType.isNullable(), arrayType.getElementType().accept(this));
        }

        @Override
        public LogicalType visit(MultisetType multisetType) {
            return new MultisetType(multisetType.isNullable(), multisetType.getElementType().accept(this));
        }

        @Override
        public LogicalType visit(MapType mapType) {
            return new MapType(mapType.isNullable(), mapType.getKeyType().accept(this), mapType.getValueType().accept(this));
        }

        @Override
        public LogicalType visit(RowType rowType) {
            return new RowType(rowType.isNullable(), rowType.getFields().stream().map(field -> new RowType.RowField(field.getName(), field.getType().accept(this))).collect(Collectors.toList()));
        }
    }
}

