/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.sort;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.io.disk.ChannelReaderInputViewIterator;
import org.apache.flink.runtime.io.disk.iomanager.AbstractChannelReaderInputView;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.memory.AbstractPagedOutputView;
import org.apache.flink.table.dataformat.BinaryRow;
import org.apache.flink.table.runtime.compression.BlockCompressionFactory;
import org.apache.flink.table.runtime.generated.RecordComparator;
import org.apache.flink.table.runtime.operators.sort.AbstractBinaryExternalMerger;
import org.apache.flink.table.runtime.operators.sort.SpillChannelManager;
import org.apache.flink.table.runtime.typeutils.BinaryRowSerializer;
import org.apache.flink.util.MutableObjectIterator;

public class BinaryExternalMerger
extends AbstractBinaryExternalMerger<BinaryRow> {
    private final BinaryRowSerializer serializer;
    private final RecordComparator comparator;

    public BinaryExternalMerger(IOManager ioManager, int pageSize, int maxFanIn, SpillChannelManager channelManager, BinaryRowSerializer serializer, RecordComparator comparator, boolean compressionEnable, BlockCompressionFactory compressionCodecFactory, int compressionBlockSize) {
        super(ioManager, pageSize, maxFanIn, channelManager, compressionEnable, compressionCodecFactory, compressionBlockSize);
        this.serializer = serializer;
        this.comparator = comparator;
    }

    @Override
    protected MutableObjectIterator<BinaryRow> channelReaderInputViewIterator(AbstractChannelReaderInputView inView) {
        return new ChannelReaderInputViewIterator(inView, null, this.serializer.duplicate());
    }

    @Override
    protected Comparator<BinaryRow> mergeComparator() {
        return this.comparator::compare;
    }

    @Override
    protected List<BinaryRow> mergeReusedEntries(int size) {
        ArrayList<BinaryRow> reused = new ArrayList<BinaryRow>(size);
        for (int i = 0; i < size; ++i) {
            reused.add(this.serializer.createInstance());
        }
        return reused;
    }

    @Override
    protected void writeMergingOutput(MutableObjectIterator<BinaryRow> mergeIterator, AbstractPagedOutputView output) throws IOException {
        BinaryRow rec = this.serializer.createInstance();
        while ((rec = (BinaryRow)mergeIterator.next((Object)rec)) != null) {
            this.serializer.serialize(rec, (DataOutputView)output);
        }
    }
}

