/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.join.lookup;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.async.AsyncFunction;
import org.apache.flink.streaming.api.functions.async.ResultFuture;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.collector.TableFunctionResultFuture;
import org.apache.flink.table.runtime.generated.GeneratedFunction;
import org.apache.flink.table.runtime.generated.GeneratedResultFuture;
import org.apache.flink.table.runtime.operators.join.lookup.AsyncLookupJoinRunner;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.util.Collector;

public class AsyncLookupJoinWithCalcRunner
extends AsyncLookupJoinRunner {
    private static final long serialVersionUID = 8758670006385551407L;
    private final GeneratedFunction<FlatMapFunction<BaseRow, BaseRow>> generatedCalc;
    private final BaseRowTypeInfo rightRowTypeInfo;
    private transient TypeSerializer<BaseRow> rightSerializer;

    public AsyncLookupJoinWithCalcRunner(GeneratedFunction<AsyncFunction<BaseRow, Object>> generatedFetcher, GeneratedFunction<FlatMapFunction<BaseRow, BaseRow>> generatedCalc, GeneratedResultFuture<TableFunctionResultFuture<BaseRow>> generatedResultFuture, TypeInformation<?> fetcherReturnType, BaseRowTypeInfo rightRowTypeInfo, boolean isLeftOuterJoin, int asyncBufferCapacity) {
        super(generatedFetcher, generatedResultFuture, fetcherReturnType, rightRowTypeInfo, isLeftOuterJoin, asyncBufferCapacity);
        this.rightRowTypeInfo = rightRowTypeInfo;
        this.generatedCalc = generatedCalc;
    }

    @Override
    public void open(Configuration parameters) throws Exception {
        super.open(parameters);
        this.generatedCalc.compile(this.getRuntimeContext().getUserCodeClassLoader());
        this.rightSerializer = this.rightRowTypeInfo.createSerializer(this.getRuntimeContext().getExecutionConfig());
    }

    @Override
    public TableFunctionResultFuture<BaseRow> createFetcherResultFuture(Configuration parameters) throws Exception {
        TableFunctionResultFuture<BaseRow> joinConditionCollector = super.createFetcherResultFuture(parameters);
        FlatMapFunction calc = (FlatMapFunction)this.generatedCalc.newInstance(this.getRuntimeContext().getUserCodeClassLoader());
        FunctionUtils.setFunctionRuntimeContext((Function)calc, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction((Function)calc, (Configuration)parameters);
        return new TemporalTableCalcResultFuture(calc, joinConditionCollector);
    }

    @Override
    public void close() throws Exception {
        super.close();
    }

    private class CalcCollectionCollector
    implements Collector<BaseRow> {
        Collection<BaseRow> collection;

        private CalcCollectionCollector() {
        }

        public void reset() {
            this.collection = new ArrayList<BaseRow>();
        }

        public void collect(BaseRow record) {
            this.collection.add((BaseRow)AsyncLookupJoinWithCalcRunner.this.rightSerializer.copy((Object)record));
        }

        public void close() {
        }
    }

    private class TemporalTableCalcResultFuture
    extends TableFunctionResultFuture<BaseRow> {
        private static final long serialVersionUID = -6360673852888872924L;
        private final FlatMapFunction<BaseRow, BaseRow> calc;
        private final TableFunctionResultFuture<BaseRow> joinConditionResultFuture;
        private final CalcCollectionCollector calcCollector;

        private TemporalTableCalcResultFuture(FlatMapFunction<BaseRow, BaseRow> calc, TableFunctionResultFuture<BaseRow> joinConditionResultFuture) {
            this.calcCollector = new CalcCollectionCollector();
            this.calc = calc;
            this.joinConditionResultFuture = joinConditionResultFuture;
        }

        @Override
        public void setInput(Object input) {
            this.joinConditionResultFuture.setInput(input);
            this.calcCollector.reset();
        }

        @Override
        public void setResultFuture(ResultFuture<?> resultFuture) {
            this.joinConditionResultFuture.setResultFuture(resultFuture);
        }

        public void complete(Collection<BaseRow> result) {
            if (result == null || result.size() == 0) {
                this.joinConditionResultFuture.complete(result);
            } else {
                for (BaseRow row : result) {
                    try {
                        this.calc.flatMap((Object)row, (Collector)this.calcCollector);
                    }
                    catch (Exception e) {
                        this.joinConditionResultFuture.completeExceptionally(e);
                    }
                }
                this.joinConditionResultFuture.complete(this.calcCollector.collection);
            }
        }

        public void close() throws Exception {
            super.close();
            this.joinConditionResultFuture.close();
            FunctionUtils.closeFunction(this.calc);
        }
    }
}

