/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import java.util.Map;
import javax.annotation.Nullable;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.runtime.context.ExecutionContext;
import org.apache.flink.table.runtime.operators.bundle.MapBundleFunction;
import org.apache.flink.table.runtime.operators.deduplicate.DeduplicateFunctionHelper;
import org.apache.flink.table.runtime.typeutils.BaseRowTypeInfo;
import org.apache.flink.util.Collector;

public class MiniBatchDeduplicateKeepLastRowFunction
extends MapBundleFunction<BaseRow, BaseRow, BaseRow, BaseRow> {
    private static final long serialVersionUID = -8981813609115029119L;
    private final BaseRowTypeInfo rowTypeInfo;
    private final boolean generateRetraction;
    private final TypeSerializer<BaseRow> typeSerializer;
    private ValueState<BaseRow> state;

    public MiniBatchDeduplicateKeepLastRowFunction(BaseRowTypeInfo rowTypeInfo, boolean generateRetraction, TypeSerializer<BaseRow> typeSerializer) {
        this.rowTypeInfo = rowTypeInfo;
        this.generateRetraction = generateRetraction;
        this.typeSerializer = typeSerializer;
    }

    @Override
    public void open(ExecutionContext ctx) throws Exception {
        super.open(ctx);
        ValueStateDescriptor stateDesc = new ValueStateDescriptor("preRowState", (TypeInformation)this.rowTypeInfo);
        this.state = ctx.getRuntimeContext().getState(stateDesc);
    }

    @Override
    public BaseRow addInput(@Nullable BaseRow value, BaseRow input) {
        return (BaseRow)this.typeSerializer.copy((Object)input);
    }

    @Override
    public void finishBundle(Map<BaseRow, BaseRow> buffer, Collector<BaseRow> out) throws Exception {
        for (Map.Entry<BaseRow, BaseRow> entry : buffer.entrySet()) {
            BaseRow currentKey = entry.getKey();
            BaseRow currentRow2 = entry.getValue();
            this.ctx.setCurrentKey(currentKey);
            DeduplicateFunctionHelper.processLastRow(currentRow2, this.generateRetraction, this.state, out);
        }
    }
}

