/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.deduplicate;

import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.table.dataformat.BaseRow;
import org.apache.flink.table.dataformat.util.BaseRowUtil;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;

class DeduplicateFunctionHelper {
    static void processLastRow(BaseRow currentRow2, boolean generateRetraction, ValueState<BaseRow> state, Collector<BaseRow> out) throws Exception {
        Preconditions.checkArgument((boolean)BaseRowUtil.isAccumulateMsg(currentRow2));
        if (generateRetraction) {
            BaseRow preRow = (BaseRow)state.value();
            state.update((Object)currentRow2);
            if (preRow != null) {
                preRow.setHeader((byte)1);
                out.collect((Object)preRow);
            }
        }
        out.collect((Object)currentRow2);
    }

    static void processFirstRow(BaseRow currentRow2, ValueState<Boolean> state, Collector<BaseRow> out) throws Exception {
        Preconditions.checkArgument((boolean)BaseRowUtil.isAccumulateMsg(currentRow2));
        if (state.value() != null) {
            return;
        }
        state.update((Object)true);
        out.collect((Object)currentRow2);
    }

    private DeduplicateFunctionHelper() {
    }
}

